/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea.command.mq;

import com.intellij.openapi.project.Project;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.zmlx.hg4idea.action.HgCommandResultNotifier;
import org.zmlx.hg4idea.execution.HgCommandExecutor;
import org.zmlx.hg4idea.execution.HgCommandResult;
import org.zmlx.hg4idea.execution.HgCommandResultHandler;
import org.zmlx.hg4idea.repo.HgRepository;
import org.zmlx.hg4idea.util.HgErrorUtil;

public class HgQPushCommand {
    @NotNull
    private final HgRepository myRepository;

    public HgQPushCommand(@NotNull HgRepository repository) {
        if (repository == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repository", "org/zmlx/hg4idea/command/mq/HgQPushCommand", "<init>"));
        }
        this.myRepository = repository;
    }

    public void execute(final @NotNull String patchName) {
        if (patchName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "patchName", "org/zmlx/hg4idea/command/mq/HgQPushCommand", "execute"));
        }
        final Project project = this.myRepository.getProject();
        new HgCommandExecutor(project).execute(this.myRepository.getRoot(), "qpush", Arrays.asList("--move", patchName), new HgCommandResultHandler(){

            @Override
            public void process(@Nullable HgCommandResult result) {
                if (HgErrorUtil.hasErrorsInCommandExecution(result)) {
                    new HgCommandResultNotifier(project).notifyError(result, "QPush command failed", "Could not apply selected patch " + patchName);
                }
                HgQPushCommand.this.myRepository.update();
            }
        });
    }
}

