/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.avdmanager;

import com.android.sdklib.AndroidVersion;
import com.android.sdklib.IAndroidTarget;
import com.android.sdklib.ISystemImage;
import com.android.sdklib.SdkVersionInfo;
import com.android.sdklib.SystemImage;
import com.android.sdklib.devices.Abi;
import com.android.sdklib.repository.MajorRevision;
import com.android.sdklib.repository.descriptors.IPkgDesc;
import com.android.sdklib.repository.descriptors.IdDisplay;
import com.android.sdklib.repository.descriptors.PkgDesc;
import com.android.sdklib.repository.descriptors.PkgType;
import com.android.tools.idea.avdmanager.ApiLevelComparator;
import com.android.tools.idea.avdmanager.AvdWizardConstants;
import com.android.tools.idea.avdmanager.SystemImageDescription;
import com.android.tools.idea.sdk.SdkState;
import com.android.tools.idea.sdk.remote.RemotePkgInfo;
import com.android.tools.idea.sdk.wizard.SdkQuickfixWizard;
import com.android.tools.idea.wizard.DialogWrapperHost;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.Comparing;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.JBColor;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.table.TableView;
import com.intellij.util.ui.AbstractTableCellEditor;
import com.intellij.util.ui.AsyncProcessIcon;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.ListTableModel;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.RowFilter;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableRowSorter;
import org.jetbrains.android.sdk.AndroidSdkData;
import org.jetbrains.android.sdk.AndroidSdkUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SystemImageList
extends JPanel
implements ListSelectionListener {
    private final JButton myRefreshButton = new JButton(AllIcons.Actions.Refresh);
    private final JBCheckBox myShowRemoteCheckbox = new JBCheckBox("Show downloadable system images", false);
    private final JButton myInstallLatestVersionButton = new JButton("Install Latest Version...");
    private final Project myProject;
    private final JPanel myRemoteStatusPanel = new JPanel(new CardLayout());
    private final SdkState mySdkState;
    private TableView<SystemImageDescription> myTable = new TableView();
    private ListTableModel<SystemImageDescription> myModel = new ListTableModel(new ColumnInfo[0]);
    private Set<SystemImageSelectionListener> myListeners = Sets.newHashSet();
    private Predicate<SystemImageDescription> myFilter;
    private static final String ERROR_KEY = "error";
    private static final String LOADING_KEY = "loading";
    private final MouseAdapter editorListener = new MouseAdapter(){

        @Override
        public void mouseMoved(MouseEvent e) {
            SystemImageList.this.possiblySwitchEditors(e);
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            SystemImageList.this.possiblySwitchEditors(e);
        }

        @Override
        public void mouseExited(MouseEvent e) {
            SystemImageList.this.possiblySwitchEditors(e);
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            SystemImageList.this.possiblySwitchEditors(e);
        }
    };
    private final ColumnInfo[] ourColumnInfos = new ColumnInfo[]{new SystemImageColumnInfo("Release Name"){

        @Nullable
        public String valueOf(SystemImageDescription systemImage) {
            AndroidVersion version = systemImage.getVersion();
            if (version == null) {
                return "Unknown";
            }
            String codeName = version.isPreview() ? version.getCodename() : SdkVersionInfo.getCodeName((int)version.getApiLevel());
            String maybeDeprecated = version.getApiLevel() < 8 ? " (Deprecated)" : "";
            return codeName + maybeDeprecated;
        }
    }, new SystemImageColumnInfo("API Level", 100){

        @Nullable
        public String valueOf(SystemImageDescription systemImage) {
            AndroidVersion version = systemImage.getVersion();
            if (version != null) {
                return version.getApiString();
            }
            return "Unknown";
        }

        @Override
        @Nullable
        public Comparator<SystemImageDescription> getComparator() {
            return new Comparator<SystemImageDescription>(){

                @Override
                public int compare(SystemImageDescription o1, SystemImageDescription o2) {
                    return o1.getVersion().getApiLevel() - o2.getVersion().getApiLevel();
                }
            };
        }
    }, new SystemImageColumnInfo("ABI", 100){

        @Nullable
        public String valueOf(SystemImageDescription systemImage) {
            return systemImage.getAbiType();
        }
    }, new SystemImageColumnInfo("Target"){

        @Nullable
        public String valueOf(SystemImageDescription systemImage) {
            IdDisplay tag = systemImage.getTag();
            String name = systemImage.getName();
            return tag == null || tag.equals((Object)SystemImage.DEFAULT_TAG) ? name : String.format("%1$s - %2$s", name, tag);
        }
    }};

    public SystemImageList(@Nullable Project project) {
        this.myProject = project;
        this.mySdkState = SdkState.getInstance(AndroidSdkUtils.tryToChooseAndroidSdk());
        this.myModel.setColumnInfos(this.ourColumnInfos);
        this.myModel.setSortable(true);
        this.myTable.setModelAndUpdateColumns(this.myModel);
        DefaultListSelectionModel selectionModel = new DefaultListSelectionModel(){

            @Override
            public void setSelectionInterval(int index0, int index1) {
                super.setSelectionInterval(index0, index1);
                TableCellEditor editor = SystemImageList.this.myTable.getCellEditor();
                if (editor != null) {
                    editor.cancelCellEditing();
                }
                SystemImageList.this.myTable.repaint();
                SystemImageList.this.possiblySwitchEditors(index0, 0);
            }
        };
        selectionModel.setSelectionMode(0);
        this.myTable.setSelectionModel((ListSelectionModel)selectionModel);
        this.myTable.setRowSelectionAllowed(true);
        this.myTable.addMouseListener((MouseListener)this.editorListener);
        this.myTable.addMouseMotionListener((MouseMotionListener)this.editorListener);
        this.setLayout(new BorderLayout());
        this.add((Component)ScrollPaneFactory.createScrollPane(this.myTable), "Center");
        JPanel southPanel = new JPanel(new BorderLayout());
        JPanel refreshMessageAndButton = new JPanel(new FlowLayout());
        AsyncProcessIcon refreshIcon = new AsyncProcessIcon("refresh images");
        JLabel refreshingLabel = new JLabel("Refreshing...");
        refreshingLabel.setForeground((Color)JBColor.GRAY);
        JPanel refreshPanel = new JPanel(new FlowLayout());
        refreshPanel.add((Component)refreshIcon);
        refreshPanel.add(refreshingLabel);
        refreshPanel.setVisible(false);
        this.myRemoteStatusPanel.add((Component)refreshPanel, LOADING_KEY);
        JLabel errorLabel = new JLabel("Error loading remote images");
        errorLabel.setForeground((Color)JBColor.GRAY);
        JPanel errorPanel = new JPanel(new FlowLayout());
        errorPanel.add(errorLabel);
        this.myRemoteStatusPanel.add((Component)errorPanel, ERROR_KEY);
        refreshMessageAndButton.add(this.myRemoteStatusPanel);
        refreshMessageAndButton.add(this.myRefreshButton);
        southPanel.add((Component)refreshMessageAndButton, "East");
        southPanel.add((Component)this.myShowRemoteCheckbox, "West");
        this.myShowRemoteCheckbox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SystemImageList.this.myModel.fireTableDataChanged();
            }
        });
        this.myRefreshButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SystemImageList.this.refreshImages(true);
            }
        });
        this.myInstallLatestVersionButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SystemImageList.this.installForDevice();
            }
        });
        this.add((Component)southPanel, "South");
        this.myTable.getSelectionModel().addListSelectionListener(this);
        TableRowSorter<ListTableModel<SystemImageDescription>> sorter = new TableRowSorter<ListTableModel<SystemImageDescription>>(this.myModel){

            @Override
            public Comparator<?> getComparator(int column) {
                if (column == 1) {
                    return new ApiLevelComparator();
                }
                return super.getComparator(column);
            }
        };
        sorter.setSortKeys(Collections.singletonList(new RowSorter.SortKey(1, SortOrder.DESCENDING)));
        sorter.setRowFilter(new RowFilter<ListTableModel<SystemImageDescription>, Integer>(){

            @Override
            public boolean include(RowFilter.Entry<? extends ListTableModel<SystemImageDescription>, ? extends Integer> entry) {
                return !((SystemImageDescription)SystemImageList.this.myModel.getRowValue(entry.getIdentifier().intValue())).isRemote() || SystemImageList.this.myShowRemoteCheckbox.isSelected();
            }
        });
        this.myTable.setRowSorter((RowSorter)sorter);
    }

    private void possiblySwitchEditors(MouseEvent e) {
        Point p = e.getPoint();
        int row = this.myTable.rowAtPoint(p);
        int col = this.myTable.columnAtPoint(p);
        this.possiblySwitchEditors(row, col);
    }

    private void possiblySwitchEditors(int row, int col) {
        if ((row != this.myTable.getEditingRow() || col != this.myTable.getEditingColumn()) && row != -1 && col != -1 && this.myTable.isCellEditable(row, col)) {
            this.myTable.editCellAt(row, col);
        }
    }

    public void refreshImages(boolean forceRefresh) {
        ((CardLayout)this.myRemoteStatusPanel.getLayout()).show(this.myRemoteStatusPanel, LOADING_KEY);
        this.myRemoteStatusPanel.setVisible(true);
        this.myRefreshButton.setEnabled(false);
        final ArrayList items = Lists.newArrayList();
        Runnable localComplete = new Runnable(){

            @Override
            public void run() {
                ApplicationManager.getApplication().invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        items.addAll(SystemImageList.this.getLocalImages());
                        SystemImageList.this.updateListModel(items);
                        if (items.isEmpty()) {
                            SystemImageList.this.myShowRemoteCheckbox.setSelected(true);
                        }
                    }
                });
            }
        };
        Runnable remoteComplete = new Runnable(){

            @Override
            public void run() {
                ApplicationManager.getApplication().invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        List remotes = SystemImageList.this.getRemoteImages();
                        if (remotes != null) {
                            items.addAll(remotes);
                            SystemImageList.this.updateListModel(items);
                            SystemImageList.this.myRemoteStatusPanel.setVisible(false);
                            SystemImageList.this.myRefreshButton.setEnabled(true);
                        } else {
                            SystemImageList.this.myShowRemoteCheckbox.setEnabled(false);
                            SystemImageList.this.myShowRemoteCheckbox.setSelected(false);
                            SystemImageList.this.myRemoteStatusPanel.setVisible(false);
                        }
                    }
                });
            }
        };
        Runnable error = new Runnable(){

            @Override
            public void run() {
                ApplicationManager.getApplication().invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ((CardLayout)SystemImageList.this.myRemoteStatusPanel.getLayout()).show(SystemImageList.this.myRemoteStatusPanel, SystemImageList.ERROR_KEY);
                        SystemImageList.this.myRefreshButton.setEnabled(true);
                    }
                });
            }
        };
        this.mySdkState.loadAsync(SdkState.DEFAULT_EXPIRATION_PERIOD_MS, false, localComplete, remoteComplete, error, forceRefresh);
    }

    @Nullable
    private List<SystemImageDescription> getRemoteImages() {
        ArrayList items = Lists.newArrayList();
        Set<RemotePkgInfo> infos = this.mySdkState.getPackages().getNewPkgs();
        if (infos.isEmpty()) {
            return null;
        }
        for (RemotePkgInfo info : infos) {
            if (!info.getPkgDesc().getType().equals((Object)PkgType.PKG_SYS_IMAGE)) continue;
            IAndroidTarget target = this.findTarget(info);
            SystemImageDescription desc = new SystemImageDescription(info.getPkgDesc(), target);
            if (this.myFilter != null && !this.myFilter.apply((Object)desc)) continue;
            items.add(desc);
        }
        return items;
    }

    private IAndroidTarget findTarget(RemotePkgInfo info) {
        IAndroidTarget[] targets;
        AndroidSdkData data = this.mySdkState.getSdkData();
        assert (data != null);
        for (IAndroidTarget target : targets = data.getLocalSdk().getTargets()) {
            IdDisplay imageVendor = info.getPkgDesc().getVendor();
            if ((imageVendor != null || !target.isPlatform()) && (imageVendor == null || !imageVendor.getId().equals(target.getVendor())) || !info.getPkgDesc().getAndroidVersion().equals((Object)target.getVersion())) continue;
            return target;
        }
        return null;
    }

    public void refreshLocalImagesSynchronously() {
        this.myModel.setItems(this.getLocalImages());
    }

    private List<SystemImageDescription> getLocalImages() {
        ArrayList items = Lists.newArrayList();
        AndroidSdkData data = this.mySdkState.getSdkData();
        assert (data != null);
        for (IAndroidTarget target : data.getLocalSdk().getTargets(true)) {
            ISystemImage[] systemImages = target.getSystemImages();
            if (systemImages == null) continue;
            for (ISystemImage image : systemImages) {
                SystemImageDescription desc = new SystemImageDescription(target, image);
                if (this.myFilter != null && !this.myFilter.apply((Object)desc)) continue;
                items.add(desc);
            }
        }
        return items;
    }

    private void updateListModel(@NotNull List<SystemImageDescription> items) {
        if (items == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "items", "com/android/tools/idea/avdmanager/SystemImageList", "updateListModel"));
        }
        SystemImageDescription selected = (SystemImageDescription)this.myTable.getSelectedObject();
        this.myModel.setItems(items);
        if (selected == null || !items.contains(selected)) {
            this.selectDefaultImage();
        } else {
            this.setSelectedImage(selected);
        }
    }

    public void setFilter(Predicate<SystemImageDescription> filter) {
        this.myFilter = filter;
    }

    public void addSelectionListener(SystemImageSelectionListener listener) {
        this.myListeners.add(listener);
    }

    public void selectDefaultImage() {
        AndroidVersion maxVersion = null;
        SystemImageDescription best = null;
        for (SystemImageDescription desc : this.myModel.getItems()) {
            AndroidVersion version = desc.getVersion();
            if (desc.isRemote() || maxVersion != null && (version == null || version.compareTo(maxVersion) <= 0 && (!version.equals((Object)maxVersion) || !desc.getAbiType().equals(Abi.X86.getCpuArch())))) continue;
            best = desc;
            maxVersion = best.getVersion();
        }
        this.setSelectedImage(best);
    }

    public void setSelectedImage(@Nullable SystemImageDescription selectedImage) {
        if (selectedImage != null) {
            for (SystemImageDescription listItem : this.myModel.getItems()) {
                if (!selectedImage.getVersion().equals((Object)listItem.getVersion()) || !selectedImage.getAbiType().equals(listItem.getAbiType())) continue;
                this.myTable.setSelection((Collection)ImmutableSet.of((Object)listItem));
                return;
            }
        } else {
            this.myTable.clearSelection();
        }
    }

    private void installForDevice() {
        int apiLevel = 22;
        ArrayList requestedPackages = Lists.newArrayListWithCapacity((int)3);
        requestedPackages.add(PkgDesc.Builder.newSysImg((AndroidVersion)new AndroidVersion(apiLevel, null), (IdDisplay)SystemImage.DEFAULT_TAG, (String)Abi.X86.toString(), (MajorRevision)new MajorRevision(1)).create());
        requestedPackages.add(PkgDesc.Builder.newSysImg((AndroidVersion)new AndroidVersion(apiLevel, null), (IdDisplay)AvdWizardConstants.WEAR_TAG, (String)Abi.X86.toString(), (MajorRevision)new MajorRevision(1)).create());
        requestedPackages.add(PkgDesc.Builder.newSysImg((AndroidVersion)new AndroidVersion(apiLevel, null), (IdDisplay)AvdWizardConstants.TV_TAG, (String)Abi.X86.toString(), (MajorRevision)new MajorRevision(1)).create());
        SdkQuickfixWizard sdkQuickfixWizard = new SdkQuickfixWizard(null, null, requestedPackages);
        sdkQuickfixWizard.init();
        sdkQuickfixWizard.show();
        this.refreshImages(true);
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        SystemImageDescription selected = (SystemImageDescription)this.myTable.getSelectedObject();
        for (SystemImageSelectionListener listener : this.myListeners) {
            listener.onSystemImageSelected(selected);
        }
    }

    public abstract class SystemImageColumnInfo
    extends ColumnInfo<SystemImageDescription, String> {
        private final Border myBorder;
        private final int myWidth;
        final /* synthetic */ SystemImageList this$0;

        public SystemImageColumnInfo(@NotNull SystemImageList this$0, String name, int width) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/android/tools/idea/avdmanager/SystemImageList$SystemImageColumnInfo", "<init>"));
            }
            this.this$0 = this$0;
            super(name);
            this.myBorder = IdeBorderFactory.createEmptyBorder((int)10, (int)10, (int)10, (int)10);
            this.myWidth = width;
        }

        public SystemImageColumnInfo(@NotNull SystemImageList this$0, String name) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/android/tools/idea/avdmanager/SystemImageList$SystemImageColumnInfo", "<init>"));
            }
            this(this$0, name, -1);
        }

        public boolean isCellEditable(SystemImageDescription systemImageDescription) {
            return systemImageDescription.isRemote();
        }

        @Nullable
        public TableCellEditor getEditor(SystemImageDescription o) {
            return new SystemImageDescriptionRenderer(o);
        }

        @Nullable
        public TableCellRenderer getRenderer(SystemImageDescription o) {
            return new SystemImageDescriptionRenderer(o);
        }

        private void downloadImage(SystemImageDescription image) {
            IPkgDesc request = image.getRemotePackage();
            ArrayList requestedPackages = Lists.newArrayList((Object[])new IPkgDesc[]{request});
            SdkQuickfixWizard sdkQuickfixWizard = new SdkQuickfixWizard(null, null, requestedPackages, new DialogWrapperHost(null, DialogWrapper.IdeModalityType.PROJECT));
            sdkQuickfixWizard.init();
            sdkQuickfixWizard.show();
            this.this$0.refreshImages(true);
        }

        @Nullable
        public Comparator<SystemImageDescription> getComparator() {
            return new Comparator<SystemImageDescription>(){

                @Override
                public int compare(SystemImageDescription o1, SystemImageDescription o2) {
                    String s1 = (String)SystemImageColumnInfo.this.valueOf(o1);
                    String s2 = (String)SystemImageColumnInfo.this.valueOf(o2);
                    return Comparing.compare((Comparable)((Object)s1), (Comparable)((Object)s2));
                }
            };
        }

        public int getWidth(JTable table) {
            return this.myWidth;
        }

        private class SystemImageDescriptionRenderer
        extends AbstractTableCellEditor
        implements TableCellRenderer {
            private SystemImageDescription image;

            SystemImageDescriptionRenderer(SystemImageDescription o) {
                this.image = o;
            }

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                JPanel panel = new JPanel(new FlowLayout(0));
                if (isSelected) {
                    if (this.image.isRemote()) {
                        panel.setBackground(UIUtil.getListUnfocusedSelectionBackground());
                    } else {
                        panel.setBackground(table.getSelectionBackground());
                    }
                    panel.setForeground(table.getSelectionForeground());
                    panel.setOpaque(true);
                } else {
                    panel.setBackground(table.getBackground());
                    panel.setForeground(table.getForeground());
                    panel.setOpaque(true);
                }
                JBLabel label = new JBLabel((String)value);
                Font labelFont = UIUtil.getLabelFont();
                if (column == 0) {
                    label.setFont(labelFont.deriveFont(1));
                }
                if (this.image.isRemote()) {
                    Font font = labelFont.deriveFont(label.getFont().getStyle() | 2);
                    label.setFont(font);
                    label.setForeground(UIUtil.getLabelDisabledForeground());
                    if (!label.getText().isEmpty()) {
                        int fontMetricsWidth = label.getFontMetrics(label.getFont()).stringWidth(label.getText());
                        TextLayout l = new TextLayout(label.getText(), label.getFont(), label.getFontMetrics(label.getFont()).getFontRenderContext());
                        int offset = (int)Math.ceil(l.getBounds().getWidth()) - fontMetricsWidth;
                        if (offset > 0) {
                            label.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, offset));
                        }
                    }
                    panel.addKeyListener(new KeyAdapter(){

                        @Override
                        public void keyTyped(KeyEvent e) {
                            if (e.getKeyChar() == '\n' || e.getKeyChar() == ' ') {
                                SystemImageColumnInfo.this.downloadImage(SystemImageDescriptionRenderer.this.image);
                            }
                        }
                    });
                }
                panel.add((Component)label);
                if (this.image.isRemote() && column == 0) {
                    JBLabel link = new JBLabel("Download");
                    link.setBackground(table.getBackground());
                    link.setCursor(Cursor.getPredefinedCursor(12));
                    link.setForeground((Color)JBColor.BLUE);
                    Font font = link.getFont();
                    if (isSelected) {
                        HashMap attrs = Maps.newHashMap();
                        attrs.put(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_ON);
                        font = font.deriveFont(attrs);
                    }
                    link.setFont(font);
                    link.addMouseListener((MouseListener)new MouseAdapter(){

                        @Override
                        public void mouseClicked(MouseEvent e) {
                            SystemImageColumnInfo.this.downloadImage(SystemImageDescriptionRenderer.this.image);
                        }
                    });
                    panel.add((Component)link);
                }
                return panel;
            }

            public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
                return this.getTableCellRendererComponent(table, value, isSelected, false, row, column);
            }

            public Object getCellEditorValue() {
                return null;
            }

            public boolean isCellEditable(EventObject e) {
                return true;
            }
        }
    }

    public static interface SystemImageSelectionListener {
        public void onSystemImageSelected(@Nullable SystemImageDescription var1);
    }
}

