/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.application;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.CachedSingletonsRegistry;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Getter;
import org.jetbrains.annotations.NotNull;

public class ApplicationManager {
    protected static Application ourApplication = null;

    public static Application getApplication() {
        return ourApplication;
    }

    private static void setApplication(@NotNull Application instance) {
        if (instance == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "instance", "com/intellij/openapi/application/ApplicationManager", "setApplication"));
        }
        ourApplication = instance;
        CachedSingletonsRegistry.cleanupCachedFields();
    }

    public static void setApplication(@NotNull Application instance, @NotNull Getter<FileTypeRegistry> fileTypeRegistryGetter, @NotNull Disposable parent) {
        if (instance == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "instance", "com/intellij/openapi/application/ApplicationManager", "setApplication"));
        }
        if (fileTypeRegistryGetter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileTypeRegistryGetter", "com/intellij/openapi/application/ApplicationManager", "setApplication"));
        }
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/openapi/application/ApplicationManager", "setApplication"));
        }
        final Application old = ourApplication;
        final Getter<FileTypeRegistry> oldFileTypeRegistry = FileTypeRegistry.ourInstanceGetter;
        Disposer.register(parent, new Disposable(){

            @Override
            public void dispose() {
                if (old != null) {
                    ApplicationManager.setApplication(old);
                    FileTypeRegistry.ourInstanceGetter = oldFileTypeRegistry;
                }
            }
        });
        ApplicationManager.setApplication(instance);
        FileTypeRegistry.ourInstanceGetter = fileTypeRegistryGetter;
    }
}

