/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util;

import com.intellij.openapi.diagnostic.Logger;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class ShutDownTracker
implements Runnable {
    private static final Logger LOG = Logger.getInstance("#com.intellij.openapi.util.ShutDownTracker");
    private final List<Thread> myThreads = new ArrayList<Thread>();
    private final LinkedList<Thread> myShutdownThreads = new LinkedList();
    private final LinkedList<Runnable> myShutdownTasks = new LinkedList();
    private volatile boolean myIsShutdownHookRunning = false;

    private ShutDownTracker() {
        Runtime.getRuntime().addShutdownHook(new Thread((Runnable)this, "Shutdown tracker"));
    }

    @NotNull
    public static ShutDownTracker getInstance() {
        ShutDownTracker shutDownTracker = ShutDownTrackerHolder.ourInstance;
        if (shutDownTracker == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/ShutDownTracker", "getInstance"));
        }
        return shutDownTracker;
    }

    public static boolean isShutdownHookRunning() {
        return ShutDownTracker.getInstance().myIsShutdownHookRunning;
    }

    @Override
    public void run() {
        this.myIsShutdownHookRunning = true;
        this.ensureStopperThreadsFinished();
        Runnable task = this.removeLast(this.myShutdownTasks);
        while (task != null) {
            try {
                task.run();
            }
            catch (Throwable e) {
                LOG.error(e);
            }
            task = this.removeLast(this.myShutdownTasks);
        }
        Thread thread = this.removeLast(this.myShutdownThreads);
        while (thread != null) {
            thread.start();
            try {
                thread.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            thread = this.removeLast(this.myShutdownThreads);
        }
    }

    public final void ensureStopperThreadsFinished() {
        Thread[] threads = this.getStopperThreads();
        long started = System.currentTimeMillis();
        while (threads.length > 0) {
            Thread thread = threads[0];
            if (!thread.isAlive()) {
                if (this.isRegistered(thread)) {
                    LOG.error("Thread '" + thread.getName() + "' did not unregister itself from ShutDownTracker.");
                    this.unregisterStopperThread(thread);
                }
            } else {
                long totalTimeWaited = System.currentTimeMillis() - started;
                if (totalTimeWaited > 3000L) {
                    thread.interrupt();
                }
                try {
                    thread.join(100L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            threads = this.getStopperThreads();
        }
    }

    private synchronized boolean isRegistered(@NotNull Thread thread) {
        if (thread == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "thread", "com/intellij/openapi/util/ShutDownTracker", "isRegistered"));
        }
        return this.myThreads.contains(thread);
    }

    @NotNull
    private synchronized Thread[] getStopperThreads() {
        Thread[] threadArray = this.myThreads.toArray(new Thread[this.myThreads.size()]);
        if (threadArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/ShutDownTracker", "getStopperThreads"));
        }
        return threadArray;
    }

    public synchronized void unregisterStopperThread(@NotNull Thread thread) {
        if (thread == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "thread", "com/intellij/openapi/util/ShutDownTracker", "unregisterStopperThread"));
        }
        this.myThreads.remove(thread);
    }

    public synchronized void registerShutdownTask(@NotNull Runnable task) {
        if (task == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "com/intellij/openapi/util/ShutDownTracker", "registerShutdownTask"));
        }
        this.myShutdownTasks.addLast(task);
    }

    private synchronized <T> T removeLast(@NotNull LinkedList<T> list) {
        if (list == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/openapi/util/ShutDownTracker", "removeLast"));
        }
        return list.isEmpty() ? null : (T)list.removeLast();
    }

    private static class ShutDownTrackerHolder {
        private static final ShutDownTracker ourInstance = new ShutDownTracker();
    }
}

