/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.jvm;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;

public class JvmClassName {
    private final String internalName;
    private FqName fqName;

    @NotNull
    public static JvmClassName byInternalName(@NotNull String internalName) {
        if (internalName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "internalName", "org/jetbrains/kotlin/resolve/jvm/JvmClassName", "byInternalName"));
        }
        JvmClassName jvmClassName = new JvmClassName(internalName);
        if (jvmClassName == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/jvm/JvmClassName", "byInternalName"));
        }
        return jvmClassName;
    }

    @NotNull
    public static JvmClassName byClassId(@NotNull ClassId classId) {
        if (classId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classId", "org/jetbrains/kotlin/resolve/jvm/JvmClassName", "byClassId"));
        }
        FqName packageFqName = classId.getPackageFqName();
        String relativeClassName = classId.getRelativeClassName().asString().replace('.', '$');
        JvmClassName jvmClassName = packageFqName.isRoot() ? new JvmClassName(relativeClassName) : new JvmClassName(packageFqName.asString().replace('.', '/') + "/" + relativeClassName);
        if (jvmClassName == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/jvm/JvmClassName", "byClassId"));
        }
        return jvmClassName;
    }

    @NotNull
    public static JvmClassName byFqNameWithoutInnerClasses(@NotNull FqName fqName2) {
        if (fqName2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fqName", "org/jetbrains/kotlin/resolve/jvm/JvmClassName", "byFqNameWithoutInnerClasses"));
        }
        JvmClassName r = new JvmClassName(fqName2.asString().replace('.', '/'));
        r.fqName = fqName2;
        JvmClassName jvmClassName = r;
        if (jvmClassName == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/jvm/JvmClassName", "byFqNameWithoutInnerClasses"));
        }
        return jvmClassName;
    }

    @NotNull
    public static JvmClassName byFqNameWithoutInnerClasses(@NotNull String fqName2) {
        if (fqName2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fqName", "org/jetbrains/kotlin/resolve/jvm/JvmClassName", "byFqNameWithoutInnerClasses"));
        }
        JvmClassName jvmClassName = JvmClassName.byFqNameWithoutInnerClasses(new FqName(fqName2));
        if (jvmClassName == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/jvm/JvmClassName", "byFqNameWithoutInnerClasses"));
        }
        return jvmClassName;
    }

    private JvmClassName(@NotNull String internalName) {
        if (internalName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "internalName", "org/jetbrains/kotlin/resolve/jvm/JvmClassName", "<init>"));
        }
        this.internalName = internalName;
    }

    @NotNull
    public FqName getFqNameForClassNameWithoutDollars() {
        if (this.fqName == null) {
            String fqName2 = this.internalName.replace("$TImpl", "<trait_impl>").replace('$', '.').replace('/', '.').replace("<trait_impl>", "$TImpl");
            this.fqName = new FqName(fqName2);
        }
        FqName fqName3 = this.fqName;
        if (fqName3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/jvm/JvmClassName", "getFqNameForClassNameWithoutDollars"));
        }
        return fqName3;
    }

    @NotNull
    public FqName getPackageFqName() {
        int lastSlash = this.internalName.lastIndexOf("/");
        if (lastSlash == -1) {
            FqName fqName2 = FqName.ROOT;
            if (fqName2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/jvm/JvmClassName", "getPackageFqName"));
            }
            return fqName2;
        }
        FqName fqName3 = new FqName(this.internalName.substring(0, lastSlash).replace('/', '.'));
        if (fqName3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/jvm/JvmClassName", "getPackageFqName"));
        }
        return fqName3;
    }

    @NotNull
    public String getInternalName() {
        String string = this.internalName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/jvm/JvmClassName", "getInternalName"));
        }
        return string;
    }

    public String toString() {
        return this.internalName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return this.internalName.equals(((JvmClassName)o).internalName);
    }

    public int hashCode() {
        return this.internalName.hashCode();
    }
}

