/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.testAssistant;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.execution.lineMarker.RunLineMarkerContributor;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiConstantEvaluationHelper;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.util.PsiUtilCore;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.devkit.testAssistant.GotoTestDataAction;
import org.jetbrains.idea.devkit.util.PsiUtil;

public class TestDataLineMarkerProvider
extends RunLineMarkerContributor {
    public static final String TEST_DATA_PATH_ANNOTATION_QUALIFIED_NAME = "com.intellij.testFramework.TestDataPath";
    public static final String CONTENT_ROOT_VARIABLE = "$CONTENT_ROOT";
    public static final String PROJECT_ROOT_VARIABLE = "$PROJECT_ROOT";

    public RunLineMarkerContributor.Info getInfo(@NotNull PsiElement e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "org/jetbrains/idea/devkit/testAssistant/TestDataLineMarkerProvider", "getInfo"));
        }
        PsiElement element = e.getParent();
        if (!(e instanceof PsiIdentifier) || !(element instanceof PsiMethod) && !(element instanceof PsiClass)) {
            return null;
        }
        if (!PsiUtil.isPluginProject(element.getProject())) {
            return null;
        }
        VirtualFile file = PsiUtilCore.getVirtualFile((PsiElement)element);
        if (file == null || !ProjectFileIndex.SERVICE.getInstance((Project)element.getProject()).isInTestSourceContent(file)) {
            return null;
        }
        if (element instanceof PsiMethod) {
            return new RunLineMarkerContributor.Info(ActionManager.getInstance().getAction("TestData.Navigate"));
        }
        PsiClass psiClass = (PsiClass)element;
        String basePath = TestDataLineMarkerProvider.getTestDataBasePath(psiClass);
        if (basePath != null) {
            return new RunLineMarkerContributor.Info((AnAction)new GotoTestDataAction(basePath, psiClass.getProject(), AllIcons.Nodes.Folder));
        }
        return null;
    }

    @Nullable
    public static String getTestDataBasePath(@Nullable PsiClass psiClass) {
        Project project;
        PsiConstantEvaluationHelper evaluationHelper;
        Object constantValue;
        PsiAnnotationMemberValue value;
        if (psiClass == null) {
            return null;
        }
        PsiAnnotation annotation = AnnotationUtil.findAnnotationInHierarchy((PsiModifierListOwner)psiClass, Collections.singleton(TEST_DATA_PATH_ANNOTATION_QUALIFIED_NAME));
        if (annotation != null && (value = annotation.findAttributeValue("value")) instanceof PsiExpression && (constantValue = (evaluationHelper = JavaPsiFacade.getInstance((Project)(project = value.getProject())).getConstantEvaluationHelper()).computeConstantExpression((PsiElement)value, false)) instanceof String) {
            String path = (String)constantValue;
            if (path.contains(CONTENT_ROOT_VARIABLE)) {
                ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)project).getFileIndex();
                VirtualFile file = psiClass.getContainingFile().getVirtualFile();
                if (file == null) {
                    return null;
                }
                VirtualFile contentRoot = fileIndex.getContentRootForFile(file);
                if (contentRoot == null) {
                    return null;
                }
                path = path.replace(CONTENT_ROOT_VARIABLE, contentRoot.getPath());
            }
            if (path.contains(PROJECT_ROOT_VARIABLE)) {
                VirtualFile baseDir = project.getBaseDir();
                if (baseDir == null) {
                    return null;
                }
                path = path.replace(PROJECT_ROOT_VARIABLE, baseDir.getPath());
            }
            return path;
        }
        return null;
    }
}

