/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl;

import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.RecursionGuard;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.PsiManagerEx;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.Function;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.impl.GrPsiTypeStub;
import org.jetbrains.plugins.groovy.lang.resolve.ResolveUtil;

public class GroovyPsiManager {
    private static final Logger LOG = Logger.getInstance((String)"org.jetbrains.plugins.groovy.lang.psi.impl.GroovyPsiManager");
    private static final Set<String> ourPopularClasses = ContainerUtil.newHashSet((Object[])new String[]{"groovy.lang.Closure", "groovy.lang.GroovyObject", "groovy.lang.GroovyObjectSupport", "groovy.lang.Script", "java.util.List", "java.util.Collection", "java.lang.String"});
    private final Project myProject;
    private final Map<String, GrTypeDefinition> myArrayClass = new HashMap();
    private final ConcurrentMap<GroovyPsiElement, PsiType> myCalculatedTypes = ContainerUtil.createConcurrentWeakMap();
    private final ConcurrentMap<PsiMember, Boolean> myCompileStatic = ContainerUtil.newConcurrentMap();
    private static final RecursionGuard ourGuard = RecursionManager.createGuard((String)"groovyPsiManager");
    private static final PsiType UNKNOWN_TYPE = new GrPsiTypeStub();

    public GroovyPsiManager(Project project) {
        this.myProject = project;
        ((PsiManagerEx)PsiManager.getInstance((Project)this.myProject)).registerRunnableToRunOnAnyChange(new Runnable(){

            @Override
            public void run() {
                GroovyPsiManager.this.dropTypesCache();
            }
        });
    }

    public void dropTypesCache() {
        this.myCalculatedTypes.clear();
        this.myCompileStatic.clear();
    }

    public static boolean isInheritorCached(@Nullable PsiClass aClass, @NotNull String baseClassName) {
        if (baseClassName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseClassName", "org/jetbrains/plugins/groovy/lang/psi/impl/GroovyPsiManager", "isInheritorCached"));
        }
        if (aClass == null) {
            return false;
        }
        return InheritanceUtil.isInheritorOrSelf((PsiClass)aClass, (PsiClass)GroovyPsiManager.getInstance(aClass.getProject()).findClassWithCache(baseClassName, aClass.getResolveScope()), (boolean)true);
    }

    public static boolean isInheritorCached(@Nullable PsiType type, @NotNull String baseClassName) {
        if (baseClassName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseClassName", "org/jetbrains/plugins/groovy/lang/psi/impl/GroovyPsiManager", "isInheritorCached"));
        }
        if (type instanceof PsiClassType) {
            return GroovyPsiManager.isInheritorCached(((PsiClassType)type).resolve(), baseClassName);
        }
        return false;
    }

    public static GroovyPsiManager getInstance(Project project) {
        return (GroovyPsiManager)ServiceManager.getService((Project)project, GroovyPsiManager.class);
    }

    public PsiClassType createTypeByFQClassName(@NotNull String fqName, @NotNull GlobalSearchScope resolveScope) {
        PsiClass result;
        if (fqName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fqName", "org/jetbrains/plugins/groovy/lang/psi/impl/GroovyPsiManager", "createTypeByFQClassName"));
        }
        if (resolveScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolveScope", "org/jetbrains/plugins/groovy/lang/psi/impl/GroovyPsiManager", "createTypeByFQClassName"));
        }
        if (ourPopularClasses.contains(fqName) && (result = this.findClassWithCache(fqName, resolveScope)) != null) {
            return JavaPsiFacade.getElementFactory((Project)this.myProject).createType(result);
        }
        return JavaPsiFacade.getElementFactory((Project)this.myProject).createTypeByFQClassName(fqName, resolveScope);
    }

    public boolean isCompileStatic(@NotNull PsiMember member) {
        if (member == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "member", "org/jetbrains/plugins/groovy/lang/psi/impl/GroovyPsiManager", "isCompileStatic"));
        }
        Boolean aBoolean = (Boolean)this.myCompileStatic.get(member);
        if (aBoolean == null) {
            aBoolean = (Boolean)ConcurrencyUtil.cacheOrGet(this.myCompileStatic, (Object)member, (Object)this.isCompileStaticInner(member));
        }
        return aBoolean;
    }

    private boolean isCompileStaticInner(@NotNull PsiMember member) {
        PsiClass aClass;
        if (member == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "member", "org/jetbrains/plugins/groovy/lang/psi/impl/GroovyPsiManager", "isCompileStaticInner"));
        }
        PsiModifierList list = member.getModifierList();
        if (list != null) {
            PsiAnnotation compileStatic = list.findAnnotation("groovy.transform.CompileStatic");
            if (compileStatic != null) {
                return GroovyPsiManager.checkForPass(compileStatic);
            }
            PsiAnnotation typeChecked = list.findAnnotation("groovy.transform.TypeChecked");
            if (typeChecked != null) {
                return GroovyPsiManager.checkForPass(typeChecked);
            }
        }
        if ((aClass = member.getContainingClass()) != null) {
            return this.isCompileStatic((PsiMember)aClass);
        }
        return false;
    }

    private static boolean checkForPass(@NotNull PsiAnnotation annotation) {
        if (annotation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotation", "org/jetbrains/plugins/groovy/lang/psi/impl/GroovyPsiManager", "checkForPass"));
        }
        PsiAnnotationMemberValue value = annotation.findAttributeValue("value");
        return value == null || value instanceof PsiReference && ResolveUtil.isEnumConstant((PsiReference)value, "PASS", "groovy.transform.TypeCheckingMode");
    }

    @Nullable
    public PsiClass findClassWithCache(@NotNull String fqName, @NotNull GlobalSearchScope resolveScope) {
        if (fqName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fqName", "org/jetbrains/plugins/groovy/lang/psi/impl/GroovyPsiManager", "findClassWithCache"));
        }
        if (resolveScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolveScope", "org/jetbrains/plugins/groovy/lang/psi/impl/GroovyPsiManager", "findClassWithCache"));
        }
        return JavaPsiFacade.getInstance((Project)this.myProject).findClass(fqName, resolveScope);
    }

    @Nullable
    public <T extends GroovyPsiElement> PsiType getType(@NotNull T element, @NotNull Function<T, PsiType> calculator) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/plugins/groovy/lang/psi/impl/GroovyPsiManager", "getType"));
        }
        if (calculator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "calculator", "org/jetbrains/plugins/groovy/lang/psi/impl/GroovyPsiManager", "getType"));
        }
        PsiType type = (PsiType)this.myCalculatedTypes.get(element);
        if (type == null) {
            RecursionGuard.StackStamp stamp = ourGuard.markStack();
            type = (PsiType)calculator.fun(element);
            if (type == null) {
                type = UNKNOWN_TYPE;
            }
            if (stamp.mayCacheNow()) {
                type = (PsiType)ConcurrencyUtil.cacheOrGet(this.myCalculatedTypes, element, (Object)type);
            } else {
                PsiType alreadyInferred = (PsiType)this.myCalculatedTypes.get(element);
                if (alreadyInferred != null) {
                    type = alreadyInferred;
                }
            }
        }
        if (!type.isValid()) {
            GroovyPsiManager.error(element, type);
        }
        return UNKNOWN_TYPE == type ? null : type;
    }

    private static void error(PsiElement element, PsiType type) {
        LOG.error("Type is invalid: " + type + "; element: " + element + " of class " + element.getClass());
    }

    @Nullable
    public GrTypeDefinition getArrayClass(@NotNull PsiType type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/plugins/groovy/lang/psi/impl/GroovyPsiManager", "getArrayClass"));
        }
        String typeText = type.getCanonicalText();
        GrTypeDefinition definition = this.myArrayClass.get(typeText);
        if (definition == null) {
            try {
                definition = GroovyPsiElementFactory.getInstance(this.myProject).createTypeDefinition("class __ARRAY__ { public int length; public " + typeText + "[] clone(){} }");
                this.myArrayClass.put(typeText, definition);
            }
            catch (IncorrectOperationException e) {
                LOG.error((Throwable)e);
                return null;
            }
        }
        return definition;
    }

    @Nullable
    public static PsiType inferType(@NotNull PsiElement element, @NotNull Computable<PsiType> computable) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/plugins/groovy/lang/psi/impl/GroovyPsiManager", "inferType"));
        }
        if (computable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "computable", "org/jetbrains/plugins/groovy/lang/psi/impl/GroovyPsiManager", "inferType"));
        }
        List stack = ourGuard.currentStack();
        if (stack.size() > 7) {
            ourGuard.prohibitResultCaching(stack.get(0));
            return null;
        }
        return (PsiType)ourGuard.doPreventingRecursion((Object)element, true, computable);
    }
}

