/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.resolve.ast.builder.strategy;

import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrField;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.impl.PsiImplUtil;
import org.jetbrains.plugins.groovy.lang.resolve.ast.Members;
import org.jetbrains.plugins.groovy.lang.resolve.ast.builder.BuilderAnnotationContributor;
import org.jetbrains.plugins.groovy.lang.resolve.ast.builder.strategy.DefaultBuilderStrategySupport;

public class ExternalBuilderStrategySupport
extends BuilderAnnotationContributor {
    public static final String EXTERNAL_STRATEGY_NAME = "ExternalStrategy";

    @Override
    @NotNull
    public Members collect(@NotNull GrTypeDefinition builderClass) {
        if (builderClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builderClass", "org/jetbrains/plugins/groovy/lang/resolve/ast/builder/strategy/ExternalBuilderStrategySupport", "collect"));
        }
        Pair<PsiAnnotation, GrTypeDefinition> definitionPair = ExternalBuilderStrategySupport.getConstructedClass(builderClass);
        if (definitionPair == null) {
            Members members = Members.EMPTY;
            if (members == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/resolve/ast/builder/strategy/ExternalBuilderStrategySupport", "collect"));
            }
            return members;
        }
        PsiAnnotation annotation = (PsiAnnotation)definitionPair.first;
        GrTypeDefinition typeDefinition = (GrTypeDefinition)definitionPair.second;
        Members result = Members.create();
        for (GrField field : typeDefinition.getCodeFields()) {
            result.getMethods().add((PsiMethod)DefaultBuilderStrategySupport.createFieldSetter(builderClass, field, annotation));
        }
        result.getMethods().add((PsiMethod)DefaultBuilderStrategySupport.createBuildMethod(annotation, ExternalBuilderStrategySupport.createType(typeDefinition), builderClass));
        Members members = result;
        if (members == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/resolve/ast/builder/strategy/ExternalBuilderStrategySupport", "collect"));
        }
        return members;
    }

    private static Pair<PsiAnnotation, GrTypeDefinition> getConstructedClass(GrTypeDefinition builderClass) {
        PsiAnnotation annotation = PsiImplUtil.getAnnotation((PsiModifierListOwner)builderClass, "groovy.transform.builder.Builder");
        if (!ExternalBuilderStrategySupport.isApplicable(annotation, EXTERNAL_STRATEGY_NAME)) {
            return null;
        }
        PsiClass constructedClass = ExternalBuilderStrategySupport.getClassAttributeValue(annotation, "forClass");
        if (!(constructedClass instanceof GrTypeDefinition)) {
            return null;
        }
        return Pair.create((Object)annotation, (Object)((GrTypeDefinition)constructedClass));
    }
}

