/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.js.rhino;

import com.google.gwt.dev.js.rhino.CodePosition;
import com.google.gwt.dev.js.rhino.Context;
import com.google.gwt.dev.js.rhino.LineBuffer;
import com.google.gwt.dev.js.rhino.ScriptRuntime;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;

public class TokenStream {
    private static final Map<String, Integer> KEYWORDS = new HashMap<String, Integer>();
    static final int TSF_NEWLINES = 1;
    static final int TSF_FUNCTION = 2;
    static final int TSF_RETURN_EXPR = 4;
    static final int TSF_RETURN_VOID = 8;
    static final int TSF_REGEXP = 16;
    static final int TSF_DIRTYLINE = 32;
    private static final int EOF_CHAR = -1;
    public static final int ERROR = -1;
    public static final int EOF = 0;
    public static final int EOL = 1;
    public static final int POPV = 2;
    public static final int ENTERWITH = 3;
    public static final int LEAVEWITH = 4;
    public static final int RETURN = 5;
    public static final int GOTO = 6;
    public static final int IFEQ = 7;
    public static final int IFNE = 8;
    public static final int DUP = 9;
    public static final int SETNAME = 10;
    public static final int BITOR = 11;
    public static final int BITXOR = 12;
    public static final int BITAND = 13;
    public static final int EQ = 14;
    public static final int NE = 15;
    public static final int LT = 16;
    public static final int LE = 17;
    public static final int GT = 18;
    public static final int GE = 19;
    public static final int LSH = 20;
    public static final int RSH = 21;
    public static final int URSH = 22;
    public static final int ADD = 23;
    public static final int SUB = 24;
    public static final int MUL = 25;
    public static final int DIV = 26;
    public static final int MOD = 27;
    public static final int BITNOT = 28;
    public static final int NEG = 29;
    public static final int NEW = 30;
    public static final int DELPROP = 31;
    public static final int TYPEOF = 32;
    public static final int NAMEINC = 33;
    public static final int PROPINC = 34;
    public static final int ELEMINC = 35;
    public static final int NAMEDEC = 36;
    public static final int PROPDEC = 37;
    public static final int ELEMDEC = 38;
    public static final int GETPROP = 39;
    public static final int SETPROP = 40;
    public static final int GETELEM = 41;
    public static final int SETELEM = 42;
    public static final int CALL = 43;
    public static final int NAME = 44;
    public static final int NUMBER = 45;
    public static final int STRING = 46;
    public static final int ZERO = 47;
    public static final int ONE = 48;
    public static final int NULL = 49;
    public static final int THIS = 50;
    public static final int FALSE = 51;
    public static final int TRUE = 52;
    public static final int SHEQ = 53;
    public static final int SHNE = 54;
    public static final int CLOSURE = 55;
    public static final int REGEXP = 56;
    public static final int POP = 57;
    public static final int POS = 58;
    public static final int VARINC = 59;
    public static final int VARDEC = 60;
    public static final int BINDNAME = 61;
    public static final int THROW = 62;
    public static final int IN = 63;
    public static final int INSTANCEOF = 64;
    public static final int GOSUB = 65;
    public static final int RETSUB = 66;
    public static final int CALLSPECIAL = 67;
    public static final int GETTHIS = 68;
    public static final int NEWTEMP = 69;
    public static final int USETEMP = 70;
    public static final int GETBASE = 71;
    public static final int GETVAR = 72;
    public static final int SETVAR = 73;
    public static final int UNDEFINED = 74;
    public static final int TRY = 75;
    public static final int ENDTRY = 76;
    public static final int NEWSCOPE = 77;
    public static final int TYPEOFNAME = 78;
    public static final int ENUMINIT = 79;
    public static final int ENUMNEXT = 80;
    public static final int GETPROTO = 81;
    public static final int GETPARENT = 82;
    public static final int SETPROTO = 83;
    public static final int SETPARENT = 84;
    public static final int SCOPE = 85;
    public static final int GETSCOPEPARENT = 86;
    public static final int THISFN = 87;
    public static final int JTHROW = 88;
    public static final int SEMI = 89;
    public static final int LB = 90;
    public static final int RB = 91;
    public static final int LC = 92;
    public static final int RC = 93;
    public static final int LP = 94;
    public static final int GWT = 95;
    public static final int COMMA = 96;
    public static final int ASSIGN = 97;
    public static final int HOOK = 98;
    public static final int COLON = 99;
    public static final int OR = 100;
    public static final int AND = 101;
    public static final int EQOP = 102;
    public static final int RELOP = 103;
    public static final int SHOP = 104;
    public static final int UNARYOP = 105;
    public static final int INC = 106;
    public static final int DEC = 107;
    public static final int DOT = 108;
    public static final int PRIMARY = 109;
    public static final int FUNCTION = 110;
    public static final int EXPORT = 111;
    public static final int IMPORT = 112;
    public static final int IF = 113;
    public static final int ELSE = 114;
    public static final int SWITCH = 115;
    public static final int CASE = 116;
    public static final int DEFAULT = 117;
    public static final int WHILE = 118;
    public static final int DO = 119;
    public static final int FOR = 120;
    public static final int BREAK = 121;
    public static final int CONTINUE = 122;
    public static final int VAR = 123;
    public static final int WITH = 124;
    public static final int CATCH = 125;
    public static final int FINALLY = 126;
    public static final int NOP = 128;
    public static final int NOT = 129;
    public static final int PRE = 130;
    public static final int POST = 131;
    public static final int VOID = 132;
    public static final int BLOCK = 133;
    public static final int ARRAYLIT = 134;
    public static final int OBJLIT = 135;
    public static final int LABEL = 136;
    public static final int TARGET = 137;
    public static final int LOOP = 138;
    public static final int ENUMDONE = 139;
    public static final int EXPRSTMT = 140;
    public static final int PARENT = 141;
    public static final int CONVERT = 142;
    public static final int JSR = 143;
    public static final int NEWLOCAL = 144;
    public static final int USELOCAL = 145;
    public static final int DEBUGGER = 146;
    public static final int SCRIPT = 147;
    public static final int LAST_TOKEN = 147;
    public static final int NUMBER_INT = 148;
    public static final int RETRY_TOKEN = 65535;
    private LineBuffer in;
    int flags;
    String regExpFlags;
    private String sourceName;
    private int pushbackToken;
    private int tokenno;
    CodePosition secondToLastPosition;
    CodePosition lastPosition;
    private int op;
    private String string = "";
    private double number;
    private char[] stringBuffer = new char[128];
    private int stringBufferTop;

    public static String tokenToName(int token) {
        switch (token) {
            case -1: {
                return "error";
            }
            case 0: {
                return "eof";
            }
            case 1: {
                return "eol";
            }
            case 2: {
                return "popv";
            }
            case 3: {
                return "enterwith";
            }
            case 4: {
                return "leavewith";
            }
            case 5: {
                return "return";
            }
            case 6: {
                return "goto";
            }
            case 7: {
                return "ifeq";
            }
            case 8: {
                return "ifne";
            }
            case 9: {
                return "dup";
            }
            case 10: {
                return "setname";
            }
            case 11: {
                return "bitor";
            }
            case 12: {
                return "bitxor";
            }
            case 13: {
                return "bitand";
            }
            case 14: {
                return "eq";
            }
            case 15: {
                return "ne";
            }
            case 16: {
                return "lt";
            }
            case 17: {
                return "le";
            }
            case 18: {
                return "gt";
            }
            case 19: {
                return "ge";
            }
            case 20: {
                return "lsh";
            }
            case 21: {
                return "rsh";
            }
            case 22: {
                return "ursh";
            }
            case 23: {
                return "add";
            }
            case 24: {
                return "sub";
            }
            case 25: {
                return "mul";
            }
            case 26: {
                return "div";
            }
            case 27: {
                return "mod";
            }
            case 28: {
                return "bitnot";
            }
            case 29: {
                return "neg";
            }
            case 30: {
                return "new";
            }
            case 31: {
                return "delprop";
            }
            case 32: {
                return "typeof";
            }
            case 33: {
                return "nameinc";
            }
            case 34: {
                return "propinc";
            }
            case 35: {
                return "eleminc";
            }
            case 36: {
                return "namedec";
            }
            case 37: {
                return "propdec";
            }
            case 38: {
                return "elemdec";
            }
            case 39: {
                return "getprop";
            }
            case 40: {
                return "setprop";
            }
            case 41: {
                return "getelem";
            }
            case 42: {
                return "setelem";
            }
            case 43: {
                return "call";
            }
            case 44: {
                return "name";
            }
            case 148: {
                return "integer";
            }
            case 45: {
                return "double";
            }
            case 46: {
                return "string";
            }
            case 47: {
                return "zero";
            }
            case 48: {
                return "one";
            }
            case 49: {
                return "null";
            }
            case 50: {
                return "this";
            }
            case 51: {
                return "false";
            }
            case 52: {
                return "true";
            }
            case 53: {
                return "sheq";
            }
            case 54: {
                return "shne";
            }
            case 55: {
                return "closure";
            }
            case 56: {
                return "object";
            }
            case 57: {
                return "pop";
            }
            case 58: {
                return "pos";
            }
            case 59: {
                return "varinc";
            }
            case 60: {
                return "vardec";
            }
            case 61: {
                return "bindname";
            }
            case 62: {
                return "throw";
            }
            case 63: {
                return "in";
            }
            case 64: {
                return "instanceof";
            }
            case 65: {
                return "gosub";
            }
            case 66: {
                return "retsub";
            }
            case 67: {
                return "callspecial";
            }
            case 68: {
                return "getthis";
            }
            case 69: {
                return "newtemp";
            }
            case 70: {
                return "usetemp";
            }
            case 71: {
                return "getbase";
            }
            case 72: {
                return "getvar";
            }
            case 73: {
                return "setvar";
            }
            case 74: {
                return "undefined";
            }
            case 75: {
                return "try";
            }
            case 76: {
                return "endtry";
            }
            case 77: {
                return "newscope";
            }
            case 78: {
                return "typeofname";
            }
            case 79: {
                return "enuminit";
            }
            case 80: {
                return "enumnext";
            }
            case 81: {
                return "getproto";
            }
            case 82: {
                return "getparent";
            }
            case 83: {
                return "setproto";
            }
            case 84: {
                return "setparent";
            }
            case 85: {
                return "scope";
            }
            case 86: {
                return "getscopeparent";
            }
            case 87: {
                return "thisfn";
            }
            case 88: {
                return "jthrow";
            }
            case 89: {
                return "semi";
            }
            case 90: {
                return "lb";
            }
            case 91: {
                return "rb";
            }
            case 92: {
                return "lc";
            }
            case 93: {
                return "rc";
            }
            case 94: {
                return "lp";
            }
            case 95: {
                return "gwt";
            }
            case 96: {
                return "comma";
            }
            case 97: {
                return "assign";
            }
            case 98: {
                return "hook";
            }
            case 99: {
                return "colon";
            }
            case 100: {
                return "or";
            }
            case 101: {
                return "and";
            }
            case 102: {
                return "eqop";
            }
            case 103: {
                return "relop";
            }
            case 104: {
                return "shop";
            }
            case 105: {
                return "unaryop";
            }
            case 106: {
                return "inc";
            }
            case 107: {
                return "dec";
            }
            case 108: {
                return "dot";
            }
            case 109: {
                return "primary";
            }
            case 110: {
                return "function";
            }
            case 111: {
                return "export";
            }
            case 112: {
                return "import";
            }
            case 113: {
                return "if";
            }
            case 114: {
                return "else";
            }
            case 115: {
                return "switch";
            }
            case 116: {
                return "case";
            }
            case 117: {
                return "default";
            }
            case 118: {
                return "while";
            }
            case 119: {
                return "do";
            }
            case 120: {
                return "for";
            }
            case 121: {
                return "break";
            }
            case 122: {
                return "continue";
            }
            case 123: {
                return "var";
            }
            case 124: {
                return "with";
            }
            case 125: {
                return "catch";
            }
            case 126: {
                return "finally";
            }
            case 128: {
                return "nop";
            }
            case 129: {
                return "not";
            }
            case 130: {
                return "pre";
            }
            case 131: {
                return "post";
            }
            case 132: {
                return "void";
            }
            case 133: {
                return "block";
            }
            case 134: {
                return "arraylit";
            }
            case 135: {
                return "objlit";
            }
            case 136: {
                return "label";
            }
            case 137: {
                return "target";
            }
            case 138: {
                return "loop";
            }
            case 139: {
                return "enumdone";
            }
            case 140: {
                return "exprstmt";
            }
            case 141: {
                return "parent";
            }
            case 142: {
                return "convert";
            }
            case 143: {
                return "jsr";
            }
            case 144: {
                return "newlocal";
            }
            case 145: {
                return "uselocal";
            }
            case 147: {
                return "script";
            }
        }
        return "<unknown=" + token + ">";
    }

    public String tokenToString(int token) {
        String name2 = TokenStream.tokenToName(token);
        switch (token) {
            case 97: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 109: {
                return name2 + " " + TokenStream.tokenToName(this.op);
            }
            case 44: 
            case 46: 
            case 56: {
                return name2 + " `" + this.string + "'";
            }
            case 148: {
                return "NUMBER_INT " + (int)this.number;
            }
            case 45: {
                return "NUMBER " + this.number;
            }
        }
        return name2;
    }

    private int stringToKeyword(String name2) {
        Integer id = KEYWORDS.get(name2);
        if (id == null) {
            return 0;
        }
        this.op = id >> 8;
        return id & 0xFF;
    }

    public TokenStream(Reader in, String sourceName, int lineno) {
        this.in = new LineBuffer(in, lineno);
        this.pushbackToken = 0;
        this.sourceName = sourceName;
        this.flags = 0;
        this.secondToLastPosition = new CodePosition(lineno, 0);
        this.lastPosition = new CodePosition(lineno, 0);
    }

    public boolean matchToken(int toMatch) throws IOException {
        int token = this.getToken();
        if (token == toMatch) {
            return true;
        }
        --this.tokenno;
        this.pushbackToken = token;
        return false;
    }

    public void ungetToken(int tt) {
        if (this.pushbackToken != 0 && tt != -1) {
            String message = Context.getMessage2("msg.token.replaces.pushback", this.tokenToString(tt), this.tokenToString(this.pushbackToken));
            throw new RuntimeException(message);
        }
        this.pushbackToken = tt;
        --this.tokenno;
    }

    public int peekToken() throws IOException {
        int result2;
        this.pushbackToken = result2 = this.getToken();
        --this.tokenno;
        return result2;
    }

    public int peekTokenSameLine() throws IOException {
        this.flags |= 1;
        int result2 = this.peekToken();
        this.flags &= 0xFFFFFFFE;
        if (this.pushbackToken == 1) {
            this.pushbackToken = 0;
        }
        return result2;
    }

    private static boolean isAlpha(int c) {
        return c >= 97 && c <= 122 || c >= 65 && c <= 90;
    }

    static boolean isDigit(int c) {
        return c >= 48 && c <= 57;
    }

    static int xDigitToInt(int c) {
        if (48 <= c && c <= 57) {
            return c - 48;
        }
        if (97 <= c && c <= 102) {
            return c - 87;
        }
        if (65 <= c && c <= 70) {
            return c - 55;
        }
        return -1;
    }

    public static boolean isJSSpace(int c) {
        return c == 32 || c == 9 || c == 12 || c == 11 || c == 160 || Character.getType((char)c) == 12;
    }

    private void skipLine() throws IOException {
        int c;
        while ((c = this.in.read()) != -1 && c != 10) {
        }
        this.in.unread();
    }

    public int getToken() throws IOException {
        int c;
        while ((c = this.getTokenHelper()) == 65535) {
        }
        this.updatePosition();
        return c;
    }

    private int getTokenHelper() throws IOException {
        boolean identifierStart;
        int c;
        ++this.tokenno;
        if (this.pushbackToken != 0) {
            int result2 = this.pushbackToken;
            this.pushbackToken = 0;
            return result2;
        }
        do {
            if ((c = this.in.read()) != 10) continue;
            this.flags &= 0xFFFFFFDF;
            if ((this.flags & 1) != 0) break;
        } while (TokenStream.isJSSpace(c) || c == 10);
        if (c == -1) {
            return 0;
        }
        if (c != 45 && c != 10) {
            this.flags |= 0x20;
        }
        boolean isUnicodeEscapeStart = false;
        if (c == 92) {
            c = this.in.read();
            if (c == 117) {
                identifierStart = true;
                isUnicodeEscapeStart = true;
                this.stringBufferTop = 0;
            } else {
                identifierStart = false;
                c = 92;
                this.in.unread();
            }
        } else {
            identifierStart = Character.isJavaIdentifierStart((char)c);
            if (identifierStart) {
                this.stringBufferTop = 0;
                this.addToString(c);
            }
            if (c == 64) {
                this.stringBufferTop = 0;
                this.addToString(c);
                return this.jsniMatchReference();
            }
        }
        if (identifierStart) {
            int result3;
            boolean containsEscape = isUnicodeEscapeStart;
            while (true) {
                if (isUnicodeEscapeStart) {
                    int escapeVal = 0;
                    for (int i = 0; i != 4 && (escapeVal = escapeVal << 4 | TokenStream.xDigitToInt(c = this.in.read())) >= 0; ++i) {
                    }
                    if (escapeVal < 0) {
                        this.reportTokenError("msg.invalid.escape", null);
                        return -1;
                    }
                    this.addToString(escapeVal);
                    isUnicodeEscapeStart = false;
                    continue;
                }
                c = this.in.read();
                if (c == 92) {
                    c = this.in.read();
                    if (c == 117) {
                        isUnicodeEscapeStart = true;
                        containsEscape = true;
                        continue;
                    }
                    this.reportTokenError("msg.illegal.character", null);
                    return -1;
                }
                if (!Character.isJavaIdentifierPart((char)c)) break;
                this.addToString(c);
            }
            this.in.unread();
            String str = this.getStringFromBuffer();
            if (!containsEscape && (result3 = this.stringToKeyword(str)) != 0) {
                return result3;
            }
            this.string = str;
            return 44;
        }
        if (TokenStream.isDigit(c) || c == 46 && TokenStream.isDigit(this.in.peek())) {
            double dval;
            this.stringBufferTop = 0;
            int base = 10;
            if (c == 48) {
                c = this.in.read();
                if (c == 120 || c == 88) {
                    base = 16;
                    c = this.in.read();
                } else if (TokenStream.isDigit(c)) {
                    base = 8;
                } else {
                    this.addToString(48);
                }
            }
            if (base == 16) {
                while (0 <= TokenStream.xDigitToInt(c)) {
                    this.addToString(c);
                    c = this.in.read();
                }
            } else {
                while (48 <= c && c <= 57) {
                    if (base == 8 && c >= 56) {
                        Object[] errArgs = new Object[]{c == 56 ? "8" : "9"};
                        this.reportTokenWarning("msg.bad.octal.literal", errArgs);
                        base = 10;
                    }
                    this.addToString(c);
                    c = this.in.read();
                }
            }
            boolean isInteger = true;
            if (base == 10 && (c == 46 || c == 101 || c == 69)) {
                isInteger = false;
                if (c == 46) {
                    do {
                        this.addToString(c);
                    } while (TokenStream.isDigit(c = this.in.read()));
                }
                if (c == 101 || c == 69) {
                    this.addToString(c);
                    c = this.in.read();
                    if (c == 43 || c == 45) {
                        this.addToString(c);
                        c = this.in.read();
                    }
                    if (!TokenStream.isDigit(c)) {
                        this.reportTokenError("msg.missing.exponent", null);
                        return -1;
                    }
                    do {
                        this.addToString(c);
                    } while (TokenStream.isDigit(c = this.in.read()));
                }
            }
            this.in.unread();
            String numString = this.getStringFromBuffer();
            if (base == 10 && !isInteger) {
                try {
                    dval = Double.valueOf(numString);
                }
                catch (NumberFormatException ex) {
                    Object[] errArgs = new Object[]{ex.getMessage()};
                    this.reportTokenError("msg.caught.nfe", errArgs);
                    return -1;
                }
            } else {
                dval = ScriptRuntime.stringToNumber(numString, 0, base);
            }
            this.number = dval;
            if (isInteger) {
                return 148;
            }
            return 45;
        }
        if (c == 34 || c == 39) {
            int quoteChar = c;
            int val = 0;
            this.stringBufferTop = 0;
            c = this.in.read();
            block47: while (c != quoteChar) {
                if (c == 10 || c == -1) {
                    this.in.unread();
                    this.reportTokenError("msg.unterminated.string.lit", null);
                    return -1;
                }
                if (c == 92) {
                    c = this.in.read();
                    switch (c) {
                        case 98: {
                            c = 8;
                            break;
                        }
                        case 102: {
                            c = 12;
                            break;
                        }
                        case 110: {
                            c = 10;
                            break;
                        }
                        case 114: {
                            c = 13;
                            break;
                        }
                        case 116: {
                            c = 9;
                            break;
                        }
                        case 118: {
                            c = 11;
                            break;
                        }
                        case 117: {
                            int escapeStart = this.stringBufferTop;
                            this.addToString(117);
                            int escapeVal = 0;
                            for (int i = 0; i != 4; ++i) {
                                c = this.in.read();
                                if ((escapeVal = escapeVal << 4 | TokenStream.xDigitToInt(c)) < 0) continue block47;
                                this.addToString(c);
                            }
                            this.stringBufferTop = escapeStart;
                            c = escapeVal;
                            break;
                        }
                        case 120: {
                            c = this.in.read();
                            int escapeVal = TokenStream.xDigitToInt(c);
                            if (escapeVal < 0) {
                                this.addToString(120);
                                continue block47;
                            }
                            int c1 = c;
                            c = this.in.read();
                            if ((escapeVal = escapeVal << 4 | TokenStream.xDigitToInt(c)) < 0) {
                                this.addToString(120);
                                this.addToString(c1);
                                continue block47;
                            }
                            c = escapeVal;
                            break;
                        }
                        case 10: {
                            c = this.in.read();
                            continue block47;
                        }
                        default: {
                            if (48 > c || c >= 56) break;
                            val = c - 48;
                            c = this.in.read();
                            if (48 <= c && c < 56) {
                                val = 8 * val + c - 48;
                                c = this.in.read();
                                if (48 <= c && c < 56 && val <= 31) {
                                    val = 8 * val + c - 48;
                                    c = this.in.read();
                                }
                            }
                            this.in.unread();
                            c = val;
                        }
                    }
                }
                this.addToString(c);
                c = this.in.read();
            }
            this.string = this.getStringFromBuffer();
            return 46;
        }
        switch (c) {
            case 10: {
                return 1;
            }
            case 59: {
                return 89;
            }
            case 91: {
                return 90;
            }
            case 93: {
                return 91;
            }
            case 123: {
                return 92;
            }
            case 125: {
                return 93;
            }
            case 40: {
                return 94;
            }
            case 41: {
                return 95;
            }
            case 44: {
                return 96;
            }
            case 63: {
                return 98;
            }
            case 58: {
                return 99;
            }
            case 46: {
                return 108;
            }
            case 124: {
                if (this.in.match(124)) {
                    return 100;
                }
                if (this.in.match(61)) {
                    this.op = 11;
                    return 97;
                }
                return 11;
            }
            case 94: {
                if (this.in.match(61)) {
                    this.op = 12;
                    return 97;
                }
                return 12;
            }
            case 38: {
                if (this.in.match(38)) {
                    return 101;
                }
                if (this.in.match(61)) {
                    this.op = 13;
                    return 97;
                }
                return 13;
            }
            case 61: {
                if (this.in.match(61)) {
                    this.op = this.in.match(61) ? 53 : 14;
                    return 102;
                }
                this.op = 128;
                return 97;
            }
            case 33: {
                if (this.in.match(61)) {
                    this.op = this.in.match(61) ? 54 : 15;
                    return 102;
                }
                this.op = 129;
                return 105;
            }
            case 60: {
                if (this.in.match(33)) {
                    if (this.in.match(45)) {
                        if (this.in.match(45)) {
                            this.skipLine();
                            return 65535;
                        }
                        this.in.unread();
                    }
                    this.in.unread();
                }
                if (this.in.match(60)) {
                    if (this.in.match(61)) {
                        this.op = 20;
                        return 97;
                    }
                    this.op = 20;
                    return 104;
                }
                if (this.in.match(61)) {
                    this.op = 17;
                    return 103;
                }
                this.op = 16;
                return 103;
            }
            case 62: {
                if (this.in.match(62)) {
                    if (this.in.match(62)) {
                        if (this.in.match(61)) {
                            this.op = 22;
                            return 97;
                        }
                        this.op = 22;
                        return 104;
                    }
                    if (this.in.match(61)) {
                        this.op = 21;
                        return 97;
                    }
                    this.op = 21;
                    return 104;
                }
                if (this.in.match(61)) {
                    this.op = 19;
                    return 103;
                }
                this.op = 18;
                return 103;
            }
            case 42: {
                if (this.in.match(61)) {
                    this.op = 25;
                    return 97;
                }
                return 25;
            }
            case 47: {
                if (this.in.match(47)) {
                    this.skipLine();
                    return 65535;
                }
                if (this.in.match(42)) {
                    while (!((c = this.in.read()) == -1 || c == 42 && this.in.match(47))) {
                    }
                    if (c == -1) {
                        this.reportTokenError("msg.unterminated.comment", null);
                        return -1;
                    }
                    return 65535;
                }
                if ((this.flags & 0x10) != 0) {
                    this.stringBufferTop = 0;
                    while ((c = this.in.read()) != 47) {
                        if (c == 10 || c == -1) {
                            this.in.unread();
                            this.reportTokenError("msg.unterminated.re.lit", null);
                            return -1;
                        }
                        if (c == 92) {
                            this.addToString(c);
                            c = this.in.read();
                        }
                        this.addToString(c);
                    }
                    int reEnd = this.stringBufferTop;
                    while (true) {
                        if (this.in.match(103)) {
                            this.addToString(103);
                            continue;
                        }
                        if (this.in.match(105)) {
                            this.addToString(105);
                            continue;
                        }
                        if (!this.in.match(109)) break;
                        this.addToString(109);
                    }
                    if (TokenStream.isAlpha(this.in.peek())) {
                        this.reportTokenError("msg.invalid.re.flag", null);
                        return -1;
                    }
                    this.string = new String(this.stringBuffer, 0, reEnd);
                    this.regExpFlags = new String(this.stringBuffer, reEnd, this.stringBufferTop - reEnd);
                    return 56;
                }
                if (this.in.match(61)) {
                    this.op = 26;
                    return 97;
                }
                return 26;
            }
            case 37: {
                this.op = 27;
                if (this.in.match(61)) {
                    return 97;
                }
                return 27;
            }
            case 126: {
                this.op = 28;
                return 105;
            }
            case 43: {
                if (this.in.match(61)) {
                    this.op = 23;
                    return 97;
                }
                if (this.in.match(43)) {
                    return 106;
                }
                return 23;
            }
            case 45: {
                if (this.in.match(61)) {
                    this.op = 24;
                    c = 97;
                } else if (this.in.match(45)) {
                    if (0 == (this.flags & 0x20) && this.in.match(62)) {
                        this.skipLine();
                        return 65535;
                    }
                    c = 107;
                } else {
                    c = 24;
                }
                this.flags |= 0x20;
                return c;
            }
        }
        this.reportTokenError("msg.illegal.character", null);
        return -1;
    }

    private void skipWhitespace() throws IOException {
        int tmp;
        while (TokenStream.isJSSpace(tmp = this.in.read()) || tmp == 10) {
        }
        this.in.unread();
    }

    private int jsniMatchReference() throws IOException {
        if (!this.jsniMatchQualifiedTypeName('.', ':')) {
            return -1;
        }
        int c = this.in.read();
        if (c != 58) {
            this.in.unread();
            this.reportTokenError("msg.jsni.expected.char", new String[]{":"});
            return -1;
        }
        this.addToString(c);
        this.skipWhitespace();
        if (!this.jsniMatchMethodSignatureOrFieldName()) {
            return -1;
        }
        this.string = new String(this.stringBuffer, 0, this.stringBufferTop);
        return 44;
    }

    private boolean jsniMatchParamListSignature() throws IOException {
        this.skipWhitespace();
        if (this.in.peek() == 42) {
            this.addToString(this.in.read());
            if (this.in.peek() != 41) {
                this.reportTokenError("msg.jsni.expected.char", new String[]{")"});
            }
            this.addToString(this.in.read());
            return true;
        }
        do {
            this.skipWhitespace();
            int c = this.in.read();
            if (c == 41) {
                this.addToString(c);
                return true;
            }
            this.in.unread();
        } while (this.jsniMatchParamTypeSignature());
        return false;
    }

    private boolean jsniMatchParamTypeSignature() throws IOException {
        int c = this.in.read();
        switch (c) {
            case 66: 
            case 67: 
            case 68: 
            case 70: 
            case 73: 
            case 74: 
            case 83: 
            case 90: {
                this.addToString(c);
                return true;
            }
            case 76: {
                this.addToString(c);
                return this.jsniMatchQualifiedTypeName('/', ';');
            }
            case 91: {
                this.addToString(c);
                return this.jsniMatchParamArrayTypeSignature();
            }
        }
        this.in.unread();
        this.reportTokenError("msg.jsni.expected.param.type", null);
        return false;
    }

    private boolean jsniMatchParamArrayTypeSignature() throws IOException {
        return this.jsniMatchParamTypeSignature();
    }

    private boolean jsniMatchMethodSignatureOrFieldName() throws IOException {
        int c = this.in.read();
        if (!Character.isJavaIdentifierStart((char)c)) {
            this.in.unread();
            this.reportTokenError("msg.jsni.expected.identifier", null);
            return false;
        }
        this.addToString(c);
        while (Character.isJavaIdentifierPart((char)(c = this.in.read()))) {
            this.addToString(c);
        }
        if (c == 40) {
            this.addToString(c);
            return this.jsniMatchParamListSignature();
        }
        this.in.unread();
        return true;
    }

    private boolean jsniMatchQualifiedTypeName(char sepChar, char endChar) throws IOException {
        int c = this.in.read();
        if (!Character.isJavaIdentifierStart((char)c)) {
            this.in.unread();
            this.reportTokenError("msg.jsni.expected.identifier", null);
            return false;
        }
        this.addToString(c);
        while (Character.isJavaIdentifierPart((char)(c = this.in.read()))) {
            this.addToString(c);
        }
        while (c == 91 && 93 == this.in.peek()) {
            this.addToString(91);
            this.addToString(this.in.read());
            c = this.in.read();
        }
        if (c == sepChar) {
            this.addToString(c);
            return this.jsniMatchQualifiedTypeName(sepChar, endChar);
        }
        if (c == endChar) {
            this.addToString(c);
            return true;
        }
        this.in.unread();
        return true;
    }

    private String getStringFromBuffer() {
        return new String(this.stringBuffer, 0, this.stringBufferTop);
    }

    private void addToString(int c) {
        if (this.stringBufferTop == this.stringBuffer.length) {
            char[] tmp = new char[this.stringBuffer.length * 2];
            System.arraycopy(this.stringBuffer, 0, tmp, 0, this.stringBufferTop);
            this.stringBuffer = tmp;
        }
        this.stringBuffer[this.stringBufferTop++] = (char)c;
    }

    public void reportSyntaxError(String messageProperty, Object[] args) {
        String message = Context.getMessage(messageProperty, args);
        Context.reportError(message, this.secondToLastPosition, this.lastPosition);
    }

    private void reportTokenError(String messageProperty, Object[] args) {
        String message = Context.getMessage(messageProperty, args);
        Context.reportError(message, this.lastPosition, new CodePosition(this.getLineno(), this.getOffset()));
    }

    private void reportTokenWarning(String messageProperty, Object[] args) {
        String message = Context.getMessage(messageProperty, args);
        Context.reportWarning(message, this.lastPosition, new CodePosition(this.getLineno(), this.getOffset()));
    }

    private void updatePosition() {
        CodePosition currentPosition = new CodePosition(this.getLineno(), this.getOffset());
        if (currentPosition.compareTo(this.lastPosition) > 0) {
            this.secondToLastPosition = this.lastPosition;
            this.lastPosition = currentPosition;
        }
    }

    public String getSourceName() {
        return this.sourceName;
    }

    public int getLineno() {
        return this.in.getLineno();
    }

    public int getOp() {
        return this.op;
    }

    public String getString() {
        return this.string;
    }

    public double getNumber() {
        return this.number;
    }

    public String getLine() {
        return this.in.getLine();
    }

    public int getOffset() {
        return this.in.getOffset();
    }

    public int getTokenno() {
        return this.tokenno;
    }

    public boolean eof() {
        return this.in.eof();
    }

    static {
        KEYWORDS.put("break", 121);
        KEYWORDS.put("case", 116);
        KEYWORDS.put("continue", 122);
        KEYWORDS.put("default", 117);
        KEYWORDS.put("delete", 31);
        KEYWORDS.put("do", 119);
        KEYWORDS.put("else", 114);
        KEYWORDS.put("export", 111);
        KEYWORDS.put("false", 13165);
        KEYWORDS.put("for", 120);
        KEYWORDS.put("function", 110);
        KEYWORDS.put("if", 113);
        KEYWORDS.put("in", 16231);
        KEYWORDS.put("new", 30);
        KEYWORDS.put("null", 12653);
        KEYWORDS.put("return", 5);
        KEYWORDS.put("switch", 115);
        KEYWORDS.put("this", 12909);
        KEYWORDS.put("true", 13421);
        KEYWORDS.put("typeof", 8297);
        KEYWORDS.put("var", 123);
        KEYWORDS.put("void", 33897);
        KEYWORDS.put("while", 118);
        KEYWORDS.put("with", 124);
        KEYWORDS.put("catch", 125);
        KEYWORDS.put("debugger", 146);
        KEYWORDS.put("finally", 126);
        KEYWORDS.put("import", 112);
        KEYWORDS.put("instanceof", 16487);
        KEYWORDS.put("throw", 62);
        KEYWORDS.put("try", 75);
    }
}

