/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.common.messages;

import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageLocation;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageSeverity;
import org.jetbrains.kotlin.cli.common.messages.MessageCollector;

public class GroupingMessageCollector
implements MessageCollector {
    private final MessageCollector delegate;
    private final Multimap<String, Message> groupedMessages;

    public GroupingMessageCollector(@NotNull MessageCollector delegate2) {
        if (delegate2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delegate", "org/jetbrains/kotlin/cli/common/messages/GroupingMessageCollector", "<init>"));
        }
        this.groupedMessages = LinkedHashMultimap.create();
        this.delegate = delegate2;
    }

    @Override
    public void report(@NotNull CompilerMessageSeverity severity, @NotNull String message, @NotNull CompilerMessageLocation location) {
        if (severity == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "severity", "org/jetbrains/kotlin/cli/common/messages/GroupingMessageCollector", "report"));
        }
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "org/jetbrains/kotlin/cli/common/messages/GroupingMessageCollector", "report"));
        }
        if (location == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "location", "org/jetbrains/kotlin/cli/common/messages/GroupingMessageCollector", "report"));
        }
        if (CompilerMessageSeverity.VERBOSE.contains((Object)severity)) {
            this.delegate.report(severity, message, location);
        } else {
            this.groupedMessages.put((Object)location.getPath(), (Object)new Message(severity, message, location));
        }
    }

    public void flush() {
        for (String path : this.groupedMessages.keySet()) {
            Collection messages = this.groupedMessages.get((Object)path);
            for (Message message : messages) {
                this.delegate.report(message.severity, message.message, message.location);
            }
        }
        this.groupedMessages.clear();
    }

    private static class Message {
        private final CompilerMessageSeverity severity;
        private final String message;
        private final CompilerMessageLocation location;

        private Message(@NotNull CompilerMessageSeverity severity, @NotNull String message, @NotNull CompilerMessageLocation location) {
            if (severity == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "severity", "org/jetbrains/kotlin/cli/common/messages/GroupingMessageCollector$Message", "<init>"));
            }
            if (message == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "org/jetbrains/kotlin/cli/common/messages/GroupingMessageCollector$Message", "<init>"));
            }
            if (location == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "location", "org/jetbrains/kotlin/cli/common/messages/GroupingMessageCollector$Message", "<init>"));
            }
            this.severity = severity;
            this.message = message;
            this.location = location;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Message message1 = (Message)o;
            if (!this.location.equals(message1.location)) {
                return false;
            }
            if (!this.message.equals(message1.message)) {
                return false;
            }
            return this.severity == message1.severity;
        }

        public int hashCode() {
            int result2 = this.severity.hashCode();
            result2 = 31 * result2 + this.message.hashCode();
            result2 = 31 * result2 + this.location.hashCode();
            return result2;
        }
    }
}

