/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.common.messages;

import java.io.PrintStream;
import java.util.EnumSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageLocation;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageSeverity;
import org.jetbrains.kotlin.cli.common.messages.MessageCollector;
import org.jetbrains.kotlin.cli.common.messages.MessageRenderer;

public class MessageCollectorPlainTextToStream
implements MessageCollector {
    public static final EnumSet<CompilerMessageSeverity> NON_VERBOSE = EnumSet.complementOf(CompilerMessageSeverity.VERBOSE);
    public static final MessageCollector PLAIN_TEXT_TO_SYSTEM_ERR = new MessageCollectorPlainTextToStream(System.err, NON_VERBOSE);
    private final PrintStream stream;
    private final Set<CompilerMessageSeverity> severitiesToPrint;

    public MessageCollectorPlainTextToStream(@NotNull PrintStream stream, @NotNull Set<CompilerMessageSeverity> severities) {
        if (stream == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stream", "org/jetbrains/kotlin/cli/common/messages/MessageCollectorPlainTextToStream", "<init>"));
        }
        if (severities == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "severities", "org/jetbrains/kotlin/cli/common/messages/MessageCollectorPlainTextToStream", "<init>"));
        }
        this.stream = stream;
        this.severitiesToPrint = severities;
    }

    @Override
    public void report(@NotNull CompilerMessageSeverity severity, @NotNull String message, @NotNull CompilerMessageLocation location) {
        if (severity == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "severity", "org/jetbrains/kotlin/cli/common/messages/MessageCollectorPlainTextToStream", "report"));
        }
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "org/jetbrains/kotlin/cli/common/messages/MessageCollectorPlainTextToStream", "report"));
        }
        if (location == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "location", "org/jetbrains/kotlin/cli/common/messages/MessageCollectorPlainTextToStream", "report"));
        }
        if (this.severitiesToPrint.contains((Object)severity)) {
            this.stream.println(MessageRenderer.PLAIN_FULL_PATHS.render(severity, message, location));
        }
    }
}

