/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen;

import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import java.io.File;
import kotlin.KotlinPackage;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.codegen.OwnerKind;
import org.jetbrains.kotlin.codegen.binding.CalculatedClosure;
import org.jetbrains.kotlin.codegen.context.CodegenContext;
import org.jetbrains.kotlin.codegen.context.MethodContext;
import org.jetbrains.kotlin.codegen.context.PackageContext;
import org.jetbrains.kotlin.codegen.state.JetTypeMapper;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyAccessorDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.load.java.lazy.descriptors.LazyJavaPackageFragment;
import org.jetbrains.kotlin.load.kotlin.KotlinJvmBinaryClass;
import org.jetbrains.kotlin.load.kotlin.VirtualFileKotlinClass;
import org.jetbrains.kotlin.load.kotlin.incremental.IncrementalPackageFragmentProvider;
import org.jetbrains.kotlin.psi.JetFile;
import org.jetbrains.kotlin.psi.JetFunction;
import org.jetbrains.kotlin.psi.codeFragmentUtil.CodeFragmentUtilPackage;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.inline.InlineUtil;
import org.jetbrains.kotlin.serialization.deserialization.descriptors.DeserializedCallableMemberDescriptor;
import org.jetbrains.kotlin.types.JetType;

public class JvmCodegenUtil {
    private JvmCodegenUtil() {
    }

    public static boolean isInterface(DeclarationDescriptor descriptor2) {
        if (descriptor2 instanceof ClassDescriptor) {
            ClassKind kind2 = ((ClassDescriptor)descriptor2).getKind();
            return kind2 == ClassKind.INTERFACE || kind2 == ClassKind.ANNOTATION_CLASS;
        }
        return false;
    }

    public static boolean isInterface(JetType type2) {
        return JvmCodegenUtil.isInterface(type2.getConstructor().getDeclarationDescriptor());
    }

    public static boolean isConst(@NotNull CalculatedClosure closure) {
        if (closure == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "closure", "org/jetbrains/kotlin/codegen/JvmCodegenUtil", "isConst"));
        }
        return closure.getCaptureThis() == null && closure.getCaptureReceiverType() == null && closure.getCaptureVariables().isEmpty();
    }

    private static boolean isCallInsideSameClassAsDeclared(@NotNull CallableMemberDescriptor descriptor2, @NotNull CodegenContext context2) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/codegen/JvmCodegenUtil", "isCallInsideSameClassAsDeclared"));
        }
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/codegen/JvmCodegenUtil", "isCallInsideSameClassAsDeclared"));
        }
        boolean isFakeOverride = descriptor2.getKind() == CallableMemberDescriptor.Kind.FAKE_OVERRIDE;
        boolean isDelegate = descriptor2.getKind() == CallableMemberDescriptor.Kind.DELEGATION;
        DeclarationDescriptor containingDeclaration = descriptor2.getContainingDeclaration().getOriginal();
        return !isFakeOverride && !isDelegate && (context2.hasThisDescriptor() && containingDeclaration == context2.getThisDescriptor() || context2.getParentContext() instanceof PackageContext && JvmCodegenUtil.isSamePackageInSameModule(context2.getParentContext().getContextDescriptor(), containingDeclaration)) && context2.getContextKind() != OwnerKind.TRAIT_IMPL;
    }

    private static boolean isSamePackageInSameModule(@NotNull DeclarationDescriptor callerOwner, @NotNull DeclarationDescriptor calleeOwner) {
        if (callerOwner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callerOwner", "org/jetbrains/kotlin/codegen/JvmCodegenUtil", "isSamePackageInSameModule"));
        }
        if (calleeOwner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "calleeOwner", "org/jetbrains/kotlin/codegen/JvmCodegenUtil", "isSamePackageInSameModule"));
        }
        if (callerOwner instanceof PackageFragmentDescriptor && calleeOwner instanceof PackageFragmentDescriptor) {
            PackageFragmentDescriptor callerFragment = (PackageFragmentDescriptor)callerOwner;
            PackageFragmentDescriptor calleeFragment = (PackageFragmentDescriptor)calleeOwner;
            if (callerFragment == calleeFragment) {
                return true;
            }
            return callerFragment.getFqName().equals(calleeFragment.getFqName()) && calleeFragment instanceof IncrementalPackageFragmentProvider.IncrementalPackageFragment;
        }
        return false;
    }

    public static boolean isCallInsideSameModuleAsDeclared(@NotNull CallableMemberDescriptor declarationDescriptor, @NotNull CodegenContext context2, @Nullable File outDirectory) {
        if (declarationDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declarationDescriptor", "org/jetbrains/kotlin/codegen/JvmCodegenUtil", "isCallInsideSameModuleAsDeclared"));
        }
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/codegen/JvmCodegenUtil", "isCallInsideSameModuleAsDeclared"));
        }
        if (context2 == CodegenContext.STATIC) {
            return true;
        }
        Object contextDescriptor = context2.getContextDescriptor();
        CallableMemberDescriptor directMember = JvmCodegenUtil.getDirectMember(declarationDescriptor);
        if (directMember instanceof DeserializedCallableMemberDescriptor) {
            return JvmCodegenUtil.isContainedByCompiledPartOfOurModule((DeserializedCallableMemberDescriptor)directMember, outDirectory);
        }
        return DescriptorUtils.areInSameModule(directMember, contextDescriptor);
    }

    private static boolean isContainedByCompiledPartOfOurModule(@NotNull DeserializedCallableMemberDescriptor descriptor2, @Nullable File outDirectory) {
        VirtualFile file;
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/codegen/JvmCodegenUtil", "isContainedByCompiledPartOfOurModule"));
        }
        DeclarationDescriptor packageFragment = descriptor2.getContainingDeclaration();
        if (packageFragment instanceof IncrementalPackageFragmentProvider.IncrementalPackageFragment) {
            return true;
        }
        if (outDirectory == null) {
            return false;
        }
        if (!(packageFragment instanceof LazyJavaPackageFragment)) {
            return false;
        }
        KotlinJvmBinaryClass binaryClass = ((LazyJavaPackageFragment)packageFragment).getMemberScope().getKotlinBinaryClass();
        if (binaryClass instanceof VirtualFileKotlinClass && (file = ((VirtualFileKotlinClass)binaryClass).getFile()).getFileSystem().getProtocol() == "file") {
            File ioFile = VfsUtilCore.virtualToIoFile((VirtualFile)file);
            return ioFile.getAbsolutePath().startsWith(outDirectory.getAbsolutePath() + File.separator);
        }
        return false;
    }

    public static boolean hasAbstractMembers(@NotNull ClassDescriptor classDescriptor) {
        if (classDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classDescriptor", "org/jetbrains/kotlin/codegen/JvmCodegenUtil", "hasAbstractMembers"));
        }
        return KotlinPackage.any(classDescriptor.getDefaultType().getMemberScope().getAllDescriptors(), (Function1)new Function1<DeclarationDescriptor, Boolean>(){

            public Boolean invoke(DeclarationDescriptor descriptor2) {
                return descriptor2 instanceof CallableMemberDescriptor && ((CallableMemberDescriptor)descriptor2).getModality() == Modality.ABSTRACT;
            }
        });
    }

    public static boolean couldUseDirectAccessToProperty(@NotNull PropertyDescriptor property, boolean forGetter, boolean isDelegated, @NotNull MethodContext context2) {
        PropertyAccessorDescriptor accessor;
        if (property == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "org/jetbrains/kotlin/codegen/JvmCodegenUtil", "couldUseDirectAccessToProperty"));
        }
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/codegen/JvmCodegenUtil", "couldUseDirectAccessToProperty"));
        }
        if (JetTypeMapper.isAccessor(property)) {
            return false;
        }
        if (context2.isInlineFunction() && (!Visibilities.isPrivate(property.getVisibility()) || DescriptorUtils.isTopLevelDeclaration(property))) {
            return false;
        }
        if (!JvmCodegenUtil.isCallInsideSameClassAsDeclared(property, context2) && !JvmCodegenUtil.isDebuggerContext(context2)) {
            return false;
        }
        if (isDelegated || property.getExtensionReceiverParameter() != null) {
            return false;
        }
        if (DescriptorUtils.isCompanionObject(property.getContainingDeclaration())) {
            return false;
        }
        PropertyAccessorDescriptor propertyAccessorDescriptor = accessor = forGetter ? property.getGetter() : property.getSetter();
        if (accessor == null) {
            return true;
        }
        if (accessor.hasBody()) {
            return false;
        }
        return Visibilities.isPrivate(property.getVisibility()) || accessor.getModality() == Modality.FINAL;
    }

    private static boolean isDebuggerContext(@NotNull MethodContext context2) {
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/codegen/JvmCodegenUtil", "isDebuggerContext"));
        }
        JetFile file = DescriptorToSourceUtils.getContainingFile(context2.getContextDescriptor());
        return file != null && CodeFragmentUtilPackage.getSuppressDiagnosticsInDebugMode(file);
    }

    @Nullable
    public static ClassDescriptor getDispatchReceiverParameterForConstructorCall(@NotNull ConstructorDescriptor descriptor2, @Nullable CalculatedClosure closure) {
        ClassDescriptor expectedThisClass;
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/codegen/JvmCodegenUtil", "getDispatchReceiverParameterForConstructorCall"));
        }
        if (closure != null) {
            return closure.getCaptureThis();
        }
        ReceiverParameterDescriptor dispatchReceiver = descriptor2.getDispatchReceiverParameter();
        if (dispatchReceiver != null && !(expectedThisClass = (ClassDescriptor)dispatchReceiver.getContainingDeclaration()).getKind().isSingleton()) {
            return expectedThisClass;
        }
        return null;
    }

    @NotNull
    public static CallableMemberDescriptor getDirectMember(@NotNull CallableMemberDescriptor descriptor2) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/codegen/JvmCodegenUtil", "getDirectMember"));
        }
        CallableMemberDescriptor callableMemberDescriptor = descriptor2 instanceof PropertyAccessorDescriptor ? ((PropertyAccessorDescriptor)descriptor2).getCorrespondingProperty() : descriptor2;
        if (callableMemberDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/JvmCodegenUtil", "getDirectMember"));
        }
        return callableMemberDescriptor;
    }

    public static boolean isArgumentWhichWillBeInlined(@NotNull BindingContext bindingContext2, @NotNull DeclarationDescriptor descriptor2) {
        if (bindingContext2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bindingContext", "org/jetbrains/kotlin/codegen/JvmCodegenUtil", "isArgumentWhichWillBeInlined"));
        }
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/codegen/JvmCodegenUtil", "isArgumentWhichWillBeInlined"));
        }
        PsiElement declaration = DescriptorToSourceUtils.descriptorToDeclaration(descriptor2);
        return InlineUtil.canBeInlineArgument(declaration) && InlineUtil.isInlinedArgument((JetFunction)declaration, bindingContext2, false);
    }
}

