/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.caches.resolve;

import com.intellij.ide.highlighter.JavaClassFileType;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.libraries.LibraryUtil;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.ClassFileViewProvider;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.PsiManagerImpl;
import com.intellij.psi.impl.compiled.ClsClassImpl;
import com.intellij.psi.impl.compiled.ClsFileImpl;
import com.intellij.psi.impl.java.stubs.PsiJavaFileStub;
import com.intellij.psi.impl.java.stubs.impl.PsiJavaFileStubImpl;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.stubs.PsiClassHolderFileStub;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.cls.ClsFormatException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.KotlinPackage;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.asJava.FakeLightClassForFileOfPackage;
import org.jetbrains.kotlin.asJava.JavaElementFinder;
import org.jetbrains.kotlin.asJava.KotlinLightClassForExplicitDeclaration;
import org.jetbrains.kotlin.asJava.KotlinLightClassForPackage;
import org.jetbrains.kotlin.asJava.LightClassConstructionContext;
import org.jetbrains.kotlin.asJava.LightClassGenerationSupport;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.PackageViewDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.idea.caches.resolve.IdeaModuleInfo;
import org.jetbrains.kotlin.idea.caches.resolve.KotlinCacheService;
import org.jetbrains.kotlin.idea.caches.resolve.KotlinLightClassForDecompiledDeclaration;
import org.jetbrains.kotlin.idea.caches.resolve.ModuleSourceInfo;
import org.jetbrains.kotlin.idea.caches.resolve.ResolvePackage;
import org.jetbrains.kotlin.idea.decompiler.navigation.JetSourceNavigationHelper;
import org.jetbrains.kotlin.idea.project.ResolveSessionForBodies;
import org.jetbrains.kotlin.idea.stubindex.JetFullClassNameIndex;
import org.jetbrains.kotlin.idea.stubindex.JetSourceFilterScope;
import org.jetbrains.kotlin.idea.stubindex.JetTopLevelClassByPackageIndex;
import org.jetbrains.kotlin.idea.stubindex.PackageIndexUtil;
import org.jetbrains.kotlin.idea.util.ProjectRootsUtil;
import org.jetbrains.kotlin.load.kotlin.PackagePartClassUtils;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.JetClassOrObject;
import org.jetbrains.kotlin.psi.JetDeclaration;
import org.jetbrains.kotlin.psi.JetFile;
import org.jetbrains.kotlin.psi.JetFunction;
import org.jetbrains.kotlin.psi.JetProperty;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilPackage;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;
import org.jetbrains.kotlin.resolve.lazy.ForceResolveUtil;
import org.jetbrains.kotlin.resolve.lazy.KotlinCodeAnalyzer;

public class IDELightClassGenerationSupport
extends LightClassGenerationSupport {
    private static final Logger LOG = Logger.getInstance(IDELightClassGenerationSupport.class);
    private final Project project;
    private final Comparator<PsiElement> scopeFileComparator;
    private final PsiManager psiManager;
    private static final Key<CachedJavaStub> cachedJavaStubKey = Key.create((String)"CACHED_JAVA_STUB");

    public IDELightClassGenerationSupport(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/kotlin/idea/caches/resolve/IDELightClassGenerationSupport", "<init>"));
        }
        this.project = project;
        this.scopeFileComparator = JavaElementFinder.byClasspathComparator(GlobalSearchScope.allScope((Project)project));
        this.psiManager = PsiManager.getInstance((Project)project);
    }

    @Override
    @NotNull
    public LightClassConstructionContext getContextForPackage(@NotNull Collection<JetFile> files) {
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "org/jetbrains/kotlin/idea/caches/resolve/IDELightClassGenerationSupport", "getContextForPackage"));
        }
        assert (!files.isEmpty()) : "No files in package";
        ArrayList<JetFile> sortedFiles = new ArrayList<JetFile>(files);
        Collections.sort(sortedFiles, this.scopeFileComparator);
        JetFile file = (JetFile)sortedFiles.get(0);
        ResolveSessionForBodies session = KotlinCacheService.getInstance(file.getProject()).getLazyResolveSession(file);
        IDELightClassGenerationSupport.forceResolvePackageDeclarations(files, session);
        LightClassConstructionContext lightClassConstructionContext = new LightClassConstructionContext(session.getBindingContext(), session.getModuleDescriptor());
        if (lightClassConstructionContext == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/caches/resolve/IDELightClassGenerationSupport", "getContextForPackage"));
        }
        return lightClassConstructionContext;
    }

    @Override
    @NotNull
    public LightClassConstructionContext getContextForClassOrObject(@NotNull JetClassOrObject classOrObject) {
        if (classOrObject == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classOrObject", "org/jetbrains/kotlin/idea/caches/resolve/IDELightClassGenerationSupport", "getContextForClassOrObject"));
        }
        ResolveSessionForBodies session = KotlinCacheService.getInstance(classOrObject.getProject()).getLazyResolveSession(classOrObject);
        if (classOrObject.isLocal()) {
            BindingContext bindingContext2 = session.resolveToElement(classOrObject, BodyResolveMode.FULL);
            ClassDescriptor descriptor2 = bindingContext2.get(BindingContext.CLASS, classOrObject);
            if (descriptor2 == null) {
                LOG.warn("No class descriptor in context for class: " + PsiUtilPackage.getElementTextWithContext(classOrObject));
                LightClassConstructionContext lightClassConstructionContext = new LightClassConstructionContext(bindingContext2, session.getModuleDescriptor());
                if (lightClassConstructionContext == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/caches/resolve/IDELightClassGenerationSupport", "getContextForClassOrObject"));
                }
                return lightClassConstructionContext;
            }
            ForceResolveUtil.forceResolveAllContents(descriptor2);
            LightClassConstructionContext lightClassConstructionContext = new LightClassConstructionContext(bindingContext2, session.getModuleDescriptor());
            if (lightClassConstructionContext == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/caches/resolve/IDELightClassGenerationSupport", "getContextForClassOrObject"));
            }
            return lightClassConstructionContext;
        }
        ForceResolveUtil.forceResolveAllContents(session.getClassDescriptor(classOrObject));
        LightClassConstructionContext lightClassConstructionContext = new LightClassConstructionContext(session.getBindingContext(), session.getModuleDescriptor());
        if (lightClassConstructionContext == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/caches/resolve/IDELightClassGenerationSupport", "getContextForClassOrObject"));
        }
        return lightClassConstructionContext;
    }

    private static void forceResolvePackageDeclarations(@NotNull Collection<JetFile> files, @NotNull KotlinCodeAnalyzer session) {
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "org/jetbrains/kotlin/idea/caches/resolve/IDELightClassGenerationSupport", "forceResolvePackageDeclarations"));
        }
        if (session == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "org/jetbrains/kotlin/idea/caches/resolve/IDELightClassGenerationSupport", "forceResolvePackageDeclarations"));
        }
        for (JetFile file : files) {
            if (file.isScript()) continue;
            FqName packageFqName = file.getPackageFqName();
            PackageViewDescriptor packageDescriptor = session.getModuleDescriptor().getPackage(packageFqName);
            if (packageDescriptor == null) {
                LOG.warn("No descriptor found for package " + packageFqName + " in file " + file.getName() + "\n" + file.getText());
                session.forceResolveAll();
                continue;
            }
            for (JetDeclaration declaration : file.getDeclarations()) {
                if (declaration instanceof JetFunction) {
                    JetFunction jetFunction = (JetFunction)declaration;
                    Name name2 = jetFunction.getNameAsSafeName();
                    Collection<FunctionDescriptor> functions2 = packageDescriptor.getMemberScope().getFunctions(name2);
                    for (FunctionDescriptor functionDescriptor : functions2) {
                        ForceResolveUtil.forceResolveAllContents(functionDescriptor);
                    }
                    continue;
                }
                if (declaration instanceof JetProperty) {
                    JetProperty jetProperty = (JetProperty)declaration;
                    Name name2 = jetProperty.getNameAsSafeName();
                    Collection<VariableDescriptor> properties2 = packageDescriptor.getMemberScope().getProperties(name2);
                    for (VariableDescriptor variableDescriptor : properties2) {
                        ForceResolveUtil.forceResolveAllContents(variableDescriptor);
                    }
                    continue;
                }
                if (declaration instanceof JetClassOrObject) continue;
                LOG.error("Unsupported declaration kind: " + declaration + " in file " + file.getName() + "\n" + file.getText());
            }
        }
    }

    @Override
    @NotNull
    public Collection<JetClassOrObject> findClassOrObjectDeclarations(@NotNull FqName fqName2, @NotNull GlobalSearchScope searchScope2) {
        if (fqName2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fqName", "org/jetbrains/kotlin/idea/caches/resolve/IDELightClassGenerationSupport", "findClassOrObjectDeclarations"));
        }
        if (searchScope2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "searchScope", "org/jetbrains/kotlin/idea/caches/resolve/IDELightClassGenerationSupport", "findClassOrObjectDeclarations"));
        }
        Collection<JetClassOrObject> collection = JetFullClassNameIndex.getInstance().get(fqName2.asString(), this.project, JetSourceFilterScope.kotlinSourceAndClassFiles(searchScope2, this.project));
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/caches/resolve/IDELightClassGenerationSupport", "findClassOrObjectDeclarations"));
        }
        return collection;
    }

    @Override
    @NotNull
    public Collection<JetFile> findFilesForPackage(@NotNull FqName fqName2, @NotNull GlobalSearchScope searchScope2) {
        if (fqName2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fqName", "org/jetbrains/kotlin/idea/caches/resolve/IDELightClassGenerationSupport", "findFilesForPackage"));
        }
        if (searchScope2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "searchScope", "org/jetbrains/kotlin/idea/caches/resolve/IDELightClassGenerationSupport", "findFilesForPackage"));
        }
        Collection<JetFile> collection = PackageIndexUtil.findFilesWithExactPackage(fqName2, JetSourceFilterScope.kotlinSourceAndClassFiles(searchScope2, this.project), this.project);
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/caches/resolve/IDELightClassGenerationSupport", "findFilesForPackage"));
        }
        return collection;
    }

    @NotNull
    private static Map<IdeaModuleInfo, List<JetFile>> groupByModuleInfo(@NotNull Collection<JetFile> allFiles2) {
        if (allFiles2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "allFiles", "org/jetbrains/kotlin/idea/caches/resolve/IDELightClassGenerationSupport", "groupByModuleInfo"));
        }
        Map map2 = KotlinPackage.groupByTo(allFiles2, new LinkedHashMap(), (Function1)new Function1<JetFile, IdeaModuleInfo>(){

            public IdeaModuleInfo invoke(JetFile file) {
                return ResolvePackage.getModuleInfo((PsiElement)file);
            }
        });
        if (map2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/caches/resolve/IDELightClassGenerationSupport", "groupByModuleInfo"));
        }
        return map2;
    }

    @Override
    @NotNull
    public Collection<JetClassOrObject> findClassOrObjectDeclarationsInPackage(@NotNull FqName packageFqName, @NotNull GlobalSearchScope searchScope2) {
        if (packageFqName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageFqName", "org/jetbrains/kotlin/idea/caches/resolve/IDELightClassGenerationSupport", "findClassOrObjectDeclarationsInPackage"));
        }
        if (searchScope2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "searchScope", "org/jetbrains/kotlin/idea/caches/resolve/IDELightClassGenerationSupport", "findClassOrObjectDeclarationsInPackage"));
        }
        Collection<JetClassOrObject> collection = JetTopLevelClassByPackageIndex.getInstance().get(packageFqName.asString(), this.project, JetSourceFilterScope.kotlinSourceAndClassFiles(searchScope2, this.project));
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/caches/resolve/IDELightClassGenerationSupport", "findClassOrObjectDeclarationsInPackage"));
        }
        return collection;
    }

    @Override
    public boolean packageExists(@NotNull FqName fqName2, @NotNull GlobalSearchScope scope2) {
        if (fqName2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fqName", "org/jetbrains/kotlin/idea/caches/resolve/IDELightClassGenerationSupport", "packageExists"));
        }
        if (scope2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/kotlin/idea/caches/resolve/IDELightClassGenerationSupport", "packageExists"));
        }
        return PackageIndexUtil.packageExists(fqName2, JetSourceFilterScope.kotlinSourceAndClassFiles(scope2, this.project), this.project);
    }

    @Override
    @NotNull
    public Collection<FqName> getSubPackages(@NotNull FqName fqn, @NotNull GlobalSearchScope scope2) {
        if (fqn == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fqn", "org/jetbrains/kotlin/idea/caches/resolve/IDELightClassGenerationSupport", "getSubPackages"));
        }
        if (scope2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/kotlin/idea/caches/resolve/IDELightClassGenerationSupport", "getSubPackages"));
        }
        Collection<FqName> collection = PackageIndexUtil.getSubPackageFqNames(fqn, JetSourceFilterScope.kotlinSourceAndClassFiles(scope2, this.project), this.project);
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/caches/resolve/IDELightClassGenerationSupport", "getSubPackages"));
        }
        return collection;
    }

    @Override
    @Nullable
    public PsiClass getPsiClass(@NotNull JetClassOrObject classOrObject) {
        if (classOrObject == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classOrObject", "org/jetbrains/kotlin/idea/caches/resolve/IDELightClassGenerationSupport", "getPsiClass"));
        }
        VirtualFile virtualFile = classOrObject.getContainingFile().getVirtualFile();
        if (virtualFile != null && LibraryUtil.findLibraryEntry((VirtualFile)virtualFile, (Project)classOrObject.getProject()) != null) {
            if (ProjectRootsUtil.isLibraryClassFile(this.project, virtualFile)) {
                return IDELightClassGenerationSupport.getLightClassForDecompiledClassOrObject(classOrObject);
            }
            return JetSourceNavigationHelper.getOriginalClass(classOrObject);
        }
        return KotlinLightClassForExplicitDeclaration.create(this.psiManager, classOrObject);
    }

    @Nullable
    private static PsiClass getLightClassForDecompiledClassOrObject(@NotNull JetClassOrObject decompiledClassOrObject) {
        if (decompiledClassOrObject == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "decompiledClassOrObject", "org/jetbrains/kotlin/idea/caches/resolve/IDELightClassGenerationSupport", "getLightClassForDecompiledClassOrObject"));
        }
        JetFile containingJetFile = decompiledClassOrObject.getContainingJetFile();
        if (!containingJetFile.isCompiled()) {
            return null;
        }
        KotlinLightClassForDecompiledDeclaration rootLightClassForDecompiledFile = IDELightClassGenerationSupport.createLightClassForDecompiledKotlinFile(containingJetFile);
        if (rootLightClassForDecompiledFile == null) {
            return null;
        }
        return IDELightClassGenerationSupport.findCorrespondingLightClass(decompiledClassOrObject, rootLightClassForDecompiledFile);
    }

    @NotNull
    private static PsiClass findCorrespondingLightClass(@NotNull JetClassOrObject decompiledClassOrObject, @NotNull PsiClass rootLightClassForDecompiledFile) {
        if (decompiledClassOrObject == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "decompiledClassOrObject", "org/jetbrains/kotlin/idea/caches/resolve/IDELightClassGenerationSupport", "findCorrespondingLightClass"));
        }
        if (rootLightClassForDecompiledFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootLightClassForDecompiledFile", "org/jetbrains/kotlin/idea/caches/resolve/IDELightClassGenerationSupport", "findCorrespondingLightClass"));
        }
        List<Name> relativeClassNameSegments = IDELightClassGenerationSupport.getClassRelativeName(decompiledClassOrObject).pathSegments();
        Iterator<Name> iterator2 = relativeClassNameSegments.iterator();
        Name base = iterator2.next();
        assert (rootLightClassForDecompiledFile.getName().equals(base.asString())) : "Light class for file:\n" + decompiledClassOrObject.getContainingJetFile().getVirtualFile().getCanonicalPath() + "\nwas expected to have name: " + base.asString() + "\n Actual: " + rootLightClassForDecompiledFile.getName();
        PsiClass current = rootLightClassForDecompiledFile;
        while (iterator2.hasNext()) {
            Name name2 = iterator2.next();
            PsiClass innerClass = current.findInnerClassByName(name2.asString(), false);
            assert (innerClass != null) : "Inner class should be found";
            current = innerClass;
        }
        PsiClass psiClass = current;
        if (psiClass == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/caches/resolve/IDELightClassGenerationSupport", "findCorrespondingLightClass"));
        }
        return psiClass;
    }

    @NotNull
    private static FqName getClassRelativeName(@NotNull JetClassOrObject decompiledClassOrObject) {
        if (decompiledClassOrObject == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "decompiledClassOrObject", "org/jetbrains/kotlin/idea/caches/resolve/IDELightClassGenerationSupport", "getClassRelativeName"));
        }
        Name name2 = decompiledClassOrObject.getNameAsName();
        assert (name2 != null);
        JetClassOrObject parent = (JetClassOrObject)PsiTreeUtil.getParentOfType((PsiElement)decompiledClassOrObject, JetClassOrObject.class, (boolean)true);
        if (parent == null) {
            assert (decompiledClassOrObject.isTopLevel());
            FqName fqName2 = FqName.topLevel(name2);
            if (fqName2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/caches/resolve/IDELightClassGenerationSupport", "getClassRelativeName"));
            }
            return fqName2;
        }
        FqName fqName3 = IDELightClassGenerationSupport.getClassRelativeName(parent).child(name2);
        if (fqName3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/caches/resolve/IDELightClassGenerationSupport", "getClassRelativeName"));
        }
        return fqName3;
    }

    @Override
    @NotNull
    public Collection<PsiClass> getPackageClasses(@NotNull FqName packageFqName, @NotNull GlobalSearchScope scope2) {
        if (packageFqName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageFqName", "org/jetbrains/kotlin/idea/caches/resolve/IDELightClassGenerationSupport", "getPackageClasses"));
        }
        if (scope2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/kotlin/idea/caches/resolve/IDELightClassGenerationSupport", "getPackageClasses"));
        }
        ArrayList<PsiClass> result2 = new ArrayList<PsiClass>();
        List<KotlinLightPackageClassInfo> packageClassesInfos = this.findPackageClassesInfos(packageFqName, scope2);
        for (KotlinLightPackageClassInfo info : packageClassesInfos) {
            List<JetFile> files = PackagePartClassUtils.getPackageFilesWithCallables(info.getFiles());
            if (files.isEmpty()) continue;
            IdeaModuleInfo moduleInfo = info.getModuleInfo();
            if (moduleInfo instanceof ModuleSourceInfo) {
                KotlinLightClassForPackage lightClass = KotlinLightClassForPackage.Factory.create(this.psiManager, packageFqName, moduleInfo.contentScope(), files);
                if (lightClass == null) continue;
                result2.add(lightClass);
                if (files.size() <= 1) continue;
                for (JetFile file : files) {
                    result2.add(new FakeLightClassForFileOfPackage(this.psiManager, lightClass, file));
                }
                continue;
            }
            PsiClass clsClass = IDELightClassGenerationSupport.getLightClassForDecompiledPackage(packageFqName, files);
            if (clsClass == null) continue;
            result2.add(clsClass);
        }
        ArrayList<PsiClass> arrayList = result2;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/caches/resolve/IDELightClassGenerationSupport", "getPackageClasses"));
        }
        return arrayList;
    }

    @Nullable
    private static PsiClass getLightClassForDecompiledPackage(@NotNull FqName packageFqName, @NotNull List<JetFile> filesWithCallables) {
        if (packageFqName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageFqName", "org/jetbrains/kotlin/idea/caches/resolve/IDELightClassGenerationSupport", "getLightClassForDecompiledPackage"));
        }
        if (filesWithCallables == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filesWithCallables", "org/jetbrains/kotlin/idea/caches/resolve/IDELightClassGenerationSupport", "getLightClassForDecompiledPackage"));
        }
        JetFile firstFile = filesWithCallables.iterator().next();
        if (firstFile.isCompiled()) {
            if (filesWithCallables.size() > 1) {
                LOG.error("Several files with callables for package: " + packageFqName);
            }
            return IDELightClassGenerationSupport.createLightClassForDecompiledKotlinFile(firstFile);
        }
        return null;
    }

    @NotNull
    private List<KotlinLightPackageClassInfo> findPackageClassesInfos(@NotNull FqName fqName2, @NotNull GlobalSearchScope wholeScope) {
        if (fqName2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fqName", "org/jetbrains/kotlin/idea/caches/resolve/IDELightClassGenerationSupport", "findPackageClassesInfos"));
        }
        if (wholeScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "wholeScope", "org/jetbrains/kotlin/idea/caches/resolve/IDELightClassGenerationSupport", "findPackageClassesInfos"));
        }
        Collection<JetFile> allFiles2 = this.findFilesForPackage(fqName2, wholeScope);
        Map<IdeaModuleInfo, List<JetFile>> filesByInfo = IDELightClassGenerationSupport.groupByModuleInfo(allFiles2);
        ArrayList<KotlinLightPackageClassInfo> result2 = new ArrayList<KotlinLightPackageClassInfo>();
        for (Map.Entry<IdeaModuleInfo, List<JetFile>> entry : filesByInfo.entrySet()) {
            result2.add(new KotlinLightPackageClassInfo((Collection<JetFile>)entry.getValue(), entry.getKey()));
        }
        ArrayList<KotlinLightPackageClassInfo> arrayList = result2;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/caches/resolve/IDELightClassGenerationSupport", "findPackageClassesInfos"));
        }
        return arrayList;
    }

    @Nullable
    private static KotlinLightClassForDecompiledDeclaration createLightClassForDecompiledKotlinFile(@NotNull JetFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/kotlin/idea/caches/resolve/IDELightClassGenerationSupport", "createLightClassForDecompiledKotlinFile"));
        }
        VirtualFile virtualFile = file.getVirtualFile();
        if (virtualFile == null) {
            return null;
        }
        ClsClassImpl javaClsClass = IDELightClassGenerationSupport.createClsJavaClassFromVirtualFile(file, virtualFile);
        if (javaClsClass == null) {
            return null;
        }
        JetClassOrObject declaration = (JetClassOrObject)KotlinPackage.singleOrNull((List)KotlinPackage.filterIsInstance(file.getDeclarations(), JetClassOrObject.class));
        return new KotlinLightClassForDecompiledDeclaration(javaClsClass, declaration);
    }

    @Nullable
    private static ClsClassImpl createClsJavaClassFromVirtualFile(final @NotNull JetFile decompiledKotlinFile, @NotNull VirtualFile virtualFile) {
        if (decompiledKotlinFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "decompiledKotlinFile", "org/jetbrains/kotlin/idea/caches/resolve/IDELightClassGenerationSupport", "createClsJavaClassFromVirtualFile"));
        }
        if (virtualFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFile", "org/jetbrains/kotlin/idea/caches/resolve/IDELightClassGenerationSupport", "createClsJavaClassFromVirtualFile"));
        }
        final PsiJavaFileStubImpl javaFileStub = IDELightClassGenerationSupport.getOrCreateJavaFileStub(virtualFile);
        if (javaFileStub == null) {
            return null;
        }
        PsiManager manager = PsiManager.getInstance((Project)decompiledKotlinFile.getProject());
        ClsFileImpl fakeFile = new ClsFileImpl((PsiManager)((PsiManagerImpl)manager), (FileViewProvider)new ClassFileViewProvider(manager, virtualFile)){

            @NotNull
            public PsiClassHolderFileStub getStub() {
                PsiJavaFileStubImpl psiJavaFileStubImpl = javaFileStub;
                if (psiJavaFileStubImpl == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/caches/resolve/IDELightClassGenerationSupport$2", "getStub"));
                }
                return psiJavaFileStubImpl;
            }

            public PsiElement getMirror() {
                return decompiledKotlinFile;
            }
        };
        fakeFile.setPhysical(false);
        javaFileStub.setPsi((PsiFile)fakeFile);
        return (ClsClassImpl)KotlinPackage.single((Object[])fakeFile.getClasses());
    }

    @Nullable
    private static PsiJavaFileStubImpl getOrCreateJavaFileStub(@NotNull VirtualFile virtualFile) {
        if (virtualFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFile", "org/jetbrains/kotlin/idea/caches/resolve/IDELightClassGenerationSupport", "getOrCreateJavaFileStub"));
        }
        CachedJavaStub cachedJavaStub = (CachedJavaStub)virtualFile.getUserData(cachedJavaStubKey);
        long fileModificationStamp = virtualFile.getModificationStamp();
        if (cachedJavaStub != null && cachedJavaStub.modificationStamp == fileModificationStamp) {
            return cachedJavaStub.javaFileStub;
        }
        PsiJavaFileStubImpl stub = (PsiJavaFileStubImpl)IDELightClassGenerationSupport.createStub(virtualFile);
        if (stub != null) {
            virtualFile.putUserData(cachedJavaStubKey, (Object)new CachedJavaStub(fileModificationStamp, stub));
        }
        return stub;
    }

    @Nullable
    private static PsiJavaFileStub createStub(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/kotlin/idea/caches/resolve/IDELightClassGenerationSupport", "createStub"));
        }
        if (file.getFileType() != JavaClassFileType.INSTANCE) {
            return null;
        }
        try {
            return ClsFileImpl.buildFileStub((VirtualFile)file, (byte[])file.contentsToByteArray());
        }
        catch (ClsFormatException e) {
            LOG.debug((Throwable)e);
        }
        catch (IOException e) {
            LOG.debug((Throwable)e);
        }
        LOG.error("Failed to build java cls class for " + file.getCanonicalPath());
        return null;
    }

    private static class CachedJavaStub {
        public long modificationStamp;
        public PsiJavaFileStubImpl javaFileStub;

        /*
         * WARNING - void declaration
         */
        public CachedJavaStub(long modificationStamp, @NotNull PsiJavaFileStubImpl psiJavaFileStubImpl) {
            void javaFileStub;
            if (psiJavaFileStubImpl == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "javaFileStub", "org/jetbrains/kotlin/idea/caches/resolve/IDELightClassGenerationSupport$CachedJavaStub", "<init>"));
            }
            this.modificationStamp = modificationStamp;
            this.javaFileStub = javaFileStub;
        }
    }

    private static final class KotlinLightPackageClassInfo {
        private final Collection<JetFile> files;
        private final IdeaModuleInfo moduleInfo;

        public KotlinLightPackageClassInfo(@NotNull Collection<JetFile> files, @NotNull IdeaModuleInfo moduleInfo) {
            if (files == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "org/jetbrains/kotlin/idea/caches/resolve/IDELightClassGenerationSupport$KotlinLightPackageClassInfo", "<init>"));
            }
            if (moduleInfo == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleInfo", "org/jetbrains/kotlin/idea/caches/resolve/IDELightClassGenerationSupport$KotlinLightPackageClassInfo", "<init>"));
            }
            this.files = files;
            this.moduleInfo = moduleInfo;
        }

        @NotNull
        public Collection<JetFile> getFiles() {
            Collection<JetFile> collection = this.files;
            if (collection == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/caches/resolve/IDELightClassGenerationSupport$KotlinLightPackageClassInfo", "getFiles"));
            }
            return collection;
        }

        @NotNull
        public IdeaModuleInfo getModuleInfo() {
            IdeaModuleInfo ideaModuleInfo = this.moduleInfo;
            if (ideaModuleInfo == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/caches/resolve/IDELightClassGenerationSupport$KotlinLightPackageClassInfo", "getModuleInfo"));
            }
            return ideaModuleInfo;
        }
    }
}

