/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger;

import com.intellij.debugger.MultiRequestPositionManager;
import com.intellij.debugger.NoDataException;
import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.engine.DebugProcess;
import com.intellij.debugger.requests.ClassPrepareRequestor;
import com.intellij.find.findUsages.FindUsagesOptions;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.libraries.LibraryUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.compiled.ClsFileImpl;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTreeUtil;
import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.Location;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.request.ClassPrepareRequest;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.WeakHashMap;
import jet.runtime.typeinfo.JetValueParameter;
import kotlin.KotlinPackage;
import kotlin.TypeCastException;
import kotlin.deprecated;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analyzer.AnalysisResult;
import org.jetbrains.kotlin.codegen.AsmUtil;
import org.jetbrains.kotlin.codegen.ClassBuilderFactories;
import org.jetbrains.kotlin.codegen.binding.CodegenBinding;
import org.jetbrains.kotlin.codegen.state.GenerationState;
import org.jetbrains.kotlin.codegen.state.JetTypeMapper;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.idea.caches.resolve.ResolvePackage;
import org.jetbrains.kotlin.idea.codeInsight.CodeInsightUtils;
import org.jetbrains.kotlin.idea.debugger.DebuggerPackage$PositionManagerLibraryClassFileSearcher$0f82e0ec;
import org.jetbrains.kotlin.idea.debugger.PositionedElement;
import org.jetbrains.kotlin.idea.decompiler.JetClsFile;
import org.jetbrains.kotlin.idea.findUsages.FindUsagesPackage$findUsagesOptions$063e0ee1;
import org.jetbrains.kotlin.idea.search.usagesSearch.FunctionUsagesSearchHelper;
import org.jetbrains.kotlin.idea.search.usagesSearch.UsagesSearchPackage;
import org.jetbrains.kotlin.idea.search.usagesSearch.UsagesSearchRequest;
import org.jetbrains.kotlin.idea.search.usagesSearch.UsagesSearchTarget;
import org.jetbrains.kotlin.idea.util.DebuggerUtils;
import org.jetbrains.kotlin.idea.util.ProjectRootsUtil;
import org.jetbrains.kotlin.idea.util.application.ApplicationPackage;
import org.jetbrains.kotlin.load.kotlin.PackageClassUtils;
import org.jetbrains.kotlin.load.kotlin.PackagePartClassUtils;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.JetClass;
import org.jetbrains.kotlin.psi.JetClassInitializer;
import org.jetbrains.kotlin.psi.JetClassOrObject;
import org.jetbrains.kotlin.psi.JetDeclaration;
import org.jetbrains.kotlin.psi.JetElement;
import org.jetbrains.kotlin.psi.JetExpression;
import org.jetbrains.kotlin.psi.JetFile;
import org.jetbrains.kotlin.psi.JetFunction;
import org.jetbrains.kotlin.psi.JetFunctionLiteral;
import org.jetbrains.kotlin.psi.JetNamedFunction;
import org.jetbrains.kotlin.psi.JetObjectDeclaration;
import org.jetbrains.kotlin.psi.JetProperty;
import org.jetbrains.kotlin.psi.JetPropertyAccessor;
import org.jetbrains.kotlin.psi.JetPsiUtil;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilPackage;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.inline.InlineUtil;
import org.jetbrains.kotlin.resolve.jvm.JvmClassName;
import org.jetbrains.org.objectweb.asm.Type;

@KotlinClass(abiVersion=23, kind=KotlinClass.Kind.CLASS, data={"D\u000e)\u0011\"*\u001a;Q_NLG/[8o\u001b\u0006t\u0017mZ3s\u0015\ry'o\u001a\u0006\nU\u0016$(M]1j]NTaa[8uY&t'\u0002B5eK\u0006T\u0001\u0002Z3ck\u001e<WM\u001d\u0006\u001c\u001bVdG/\u001b*fcV,7\u000f\u001e)pg&$\u0018n\u001c8NC:\fw-\u001a:\u000b\u0007\r|WN\u0003\u0005j]R,G\u000e\\5k\u0015\u0019a\u0014N\\5u})qQ.\u001f#fEV<\u0007K]8dKN\u001c(\u0002\u0004#fEV<\u0007K]8dKN\u001c(BB3oO&tWMC\u0007nsRK\b/Z'baB,'o\u001d\u0006\f/\u0016\f7\u000eS1tQ6\u000b\u0007O\u0003\u0003kCZ\f'\u0002B;uS2Taa\u0015;sS:<'bC\"bG\",GMV1mk\u0016T1\u0001]:j\u00155QU\r\u001e+za\u0016l\u0015\r\u001d9fe*91m\u001c3fO\u0016t'\"B:uCR,'\"D1eIRK\b/Z'baB,'O\u0003\u0003gS2,'b\u0002&fi\u001aKG.\u001a\u0006\u000bif\u0004X-T1qa\u0016\u0014(\u0002B+oSRTAc\u00197bgNt\u0015-\\3G_J\u0004vn]5uS>t'BD:pkJ\u001cW\rU8tSRLwN\u001c\u0006\u000f'>,(oY3Q_NLG/[8o\u0015\u0011a\u0017M\\4\u000b\u000f\u0015dW-\\3oi*Q\u0001k]5FY\u0016lWM\u001c;\u000bE\rd\u0017m]:OC6,gi\u001c:Q_NLG/[8o\u0003:$\u0017J\u001c7j]\u0016$wJ\\3t\u0015\u0011a\u0015n\u001d;\u000b)\r\u0014X-\u0019;f!J,\u0007/\u0019:f%\u0016\fX/Z:u\u0015U\u0019G.Y:t!J,\u0007/\u0019:f%\u0016\fX/Z:u_JTQc\u00117bgN\u0004&/\u001a9be\u0016\u0014V-];fgR|'O\u0003\u0005sKF,Xm\u001d;t\u0015M\u0019E.Y:t!J,\u0007/\u0019:f%\u0016\fX/Z:u\u0015\r\u0019XO\u001c\u0006\u0004U\u0012L'b\u0002:fcV,7\u000f\u001e\u0006\u0016GJ,\u0017\r^3Qe\u0016\u0004\u0018M]3SKF,Xm\u001d;t\u0015%\u0011X-];fgR|'O\u0003\u0005q_NLG/[8o\u0015M!WMZ1vYRLe\u000e^3s]\u0006dg*Y7f\u0015!awnY1uS>t'\u0002\u0003'pG\u0006$\u0018n\u001c8\u000b!\u0019Lg\u000eZ%oY&tW\rZ\"bY2\u001c(b\u00026fi\u001aKG.\u001a\u0006\b!NLg)\u001b7f\u001559W\r^!mY\u000ec\u0017m]:fg*i!+\u001a4fe\u0016t7-\u001a+za\u0016TacZ3u\u0019\u0006l'\rZ1Pe\u001a+h.\u00134J]NLG-\u001a\u0006\u000bY&tWMT;nE\u0016\u0014(bA%oi*Y!*\u001a;Gk:\u001cG/[8o\u0015Q9W\r\u001e)tS\u001aKG.\u001a\"z\u0019>\u001c\u0017\r^5p]*\tr-\u001a;T_V\u00148-\u001a)pg&$\u0018n\u001c8\u000b\u001f1|7-\u0019;j_:\u001cxJ\u001a'j]\u0016TA\u0001^=qK*\t\u0002O]3qCJ,G+\u001f9f\u001b\u0006\u0004\b/\u001a:\u000b\u0013\r{W\u000e]1oS>t\u0007^\u0001\u0006\u0003!\u0005QA\u0001\u0003\u0001\u0011\u0005)!\u0001\"\u0001\t\u0004\u0015\u0011A!\u0001\u0005\u0003\u000b\t!\u0019\u0001#\u0002\u0006\u0007\u0011\u0011\u0001\u0002\u0001\u0007\u0001\u000b\u0005A9!\u0002\u0002\u0005\u0007!!QA\u0001C\u0004\u0011\u000b)1\u0001\u0002\u0003\t\u00071\u0001QA\u0001\u0003\u0005\u0011\u0019)1\u0001B\u0003\t\f1\u0001QA\u0001\u0003\u0006\u0011\u0017)\u0011\u0001c\u0004\u0006\u0005\u00115\u0001\u0002C\u0003\u0004\t\u001dAq\u0001\u0004\u0001\u0006\u0003!\rQa\u0001\u0003\t\u0011#a\u0001!\u0002\u0002\u0005\b!MQA\u0001\u0003\n\u0011!)1\u0001b\u0005\t\u00131\u0001QA\u0001\u0003\u0002\u0011+)!\u0001\"\u0006\t\u0017\u0015\u0019Aa\u0003\u0005\u000b\u0019\u0001)!\u0001B\u0004\t\u000f\u0015\u0011A!\u0001E\n\u000b\r!I\u0002#\u0007\r\u0001\u0015\u0019A\u0001\u0003E\u000e\u0019\u0001)!\u0001\"\u0007\t\u001a\u0015\u0011Aa\u0003\u0005\u000b\u000b\r!A\u0001C\b\r\u0001\u0015\u0011AQ\u0002E\u0010\u000b\t!y\u0002#\u0005\u0006\u0005\u0011!\u0001bD\u0003\u0004\t%A\t\u0003\u0004\u0001\u0006\u0005\u0011I\u0001\u0012E\u0003\u0004\t!A\u0019\u0003\u0004\u0001\u0006\u0005\u00119\u00012E\u0003\u0003\t\u0011A9#B\u0002\u0005'!\u0019B\u0002A\u0003\u0003\t\rAI#\u0002\u0002\u0005)!)RA\u0001C\u0015\u0011W)1\u0001B\u000b\t)1\u0001QA\u0001\u0003\u0016\u0011Q)!\u0001B\n\t'\u0015\u0019A\u0011\u0006E\u0019\u0019\u0001)!\u0001\"\u000b\t2\u0015\u0019A!\u0003\u0005\u001b\u0019\u0001)!\u0001B\u0005\t5\u0015\u0019A\u0011\u0006\u0005\u001c\u0019\u0001)1\u0001\u0002\u0005\t:1\u0001Qa\u0001C\r\u0011ua\u0001!\u0002\u0002\u0005\u001a!iRA\u0001C\u0015\u0011m!1\u0001$\u0002\u0011Ae\u0011Q!\u0001E\u00059\u0001j3\u0002B1\u00051\u0015\t#!B\u0001\t\fU\u001bA!B\u0002\u0005\u000b%\t\u0001BB\u0017\u0018\t\u0005$\u0001TB\u0011\u000f\u000b\u0005Ay!C\u0002\n\u0005\u0015\t\u0001\u0012C\u0005\b\u0013\u0019)\u0011\u0001\u0003\u0006\n\u0007%\u0011Q!\u0001E\f+\u000e!Qa\u0001C\u0007\u0013\u0005AA\",\u000f\u0005\ba]QT\u0002\u0003\u0001\u00111i!!B\u0001\t\u001bA\u001b\u0001!(\u0004\u0005\u0001!iQBA\u0003\u0002\u0011/\u00016\u0011A\u0011\u0003\u000b\u0005AY\"U\u0002\b\t/I\u0011\u0001\u0002\u0001\u000e\u0003!qQ\"\u0001E\u000f[Q!1\u0001\u0007\b\u001e\u000e\u0011\u0001\u0001RD\u0007\u0003\u000b\u0005Aq\u0002U\u0002\u0001C\r)\u0011\u0001#\u0005\r\u0002E\u001bQ\u0001\u0002\b\n\u0003!\u0001R\"\u0001E\u0011[Q!\u0011\u0001\u0007\b\u001e\u000e\u0011\u0001\u0001\u0002E\u0007\u0003\u000b\u0005A\u0011\u0003U\u0002\u0001C\r)\u0011\u0001#\u0005\r\u0002E\u001bQ\u0001\u0002\b\n\u0003!\u0001R\"\u0001E\u0012[]!\u0011\u0001G\t\u001e\u000e\u0011\u0001\u0001RD\u0007\u0003\u000b\u0005Aq\u0002U\u0002\u0001C\u0019)\u0011\u0001\u0003\n\n\u0007%\u0011Q!\u0001E\t#\u000e)A!E\u0005\u0002\u0011Ki\u0011\u0001#\t.<\u0011]\u0001DEO\u0007\t\u0001A)#\u0004\u0002\u0006\u0003!\u001d\u0002k\u0001\u0001\u001e\u000e\u0011\u0001\u0001RD\u0007\u0003\u000b\u0005Aq\u0002UB\u0001C\r)\u0011\u0001c\u000b\r\u0002E\u001bq\u0001\u0002\n\n\u0003!1R\"\u0001E\u0017\u001b\u0005A\t#,\u0011\u0005\u0017a1RT\u0002\u0003\u0001\u0011[i!!B\u0001\t(A\u001b\u0001!(\u0004\u0005\u0001!9RBA\u0003\u0002\u0011=\u00016\u0011A\u0011\u0007\u000b\u0005A!#C\u0002\n\u0005\u0015\t\u00012F)\u0004\u000f\u00111\u0012\"\u0001E\u0013\u001b\u0005Ai#D\u0001\t\"5\u001aB!\u0001M\u0018;\u001b!\u0001\u0001\u0003\r\u000e\u0005\u0015\t\u0001b\u0006)\u0004\u0001\u0005\u0012Q!\u0001E\t#\u000e)AqF\u0005\u0002\u0011Ai\u0011\u0001c\f.F\u0011\t\u0001$GO\b\t\u0001A\u0001#D\u0002\u0006\u0003!\tB\u0012\u0001)\u0004\u0001u=A\u0001\u0001E\u001a\u001b\r)\u0011\u0001\u0003\r\r\u0002A\u001b\t!\t\u0004\u0006\u0003!\u0011\u0012bA\u0005\u0003\u000b\u0005A\t\"U\u0002\b\teI\u0011\u0001#\n\u000e\u0003!\rR\"\u0001E\u0019[]!1\u0002'\u000e\u001e\u000e\u0011\u0001\u0001RD\u0007\u0003\u000b\u0005Aq\u0002U\u0002\u0001C\u0019)\u0011\u0001\u0003\n\n\u0007%\u0011Q!\u0001\u0005\u001a#\u000e)AQG\u0005\u0002\u0011Ki\u0011\u0001#\t.O\u0011\t\u0001tGO\u0007\t\u0001A\u0001$\u0004\u0002\u0006\u0003!9\u0002k\u0001\u0001\u001e\u000e\u0011\u0001\u0001\u0002D\u0007\u0003\u000b\u0005AQ\u0002UB\u0001;\u001b!\u0001\u0001\u0003\u000f\u000e\u0005\u0015\t\u00012\u0007)\u0004\u0003\u0005\u001aQ!\u0001\u0005\u001b\u0019\u0003\t6!\u0003C\u001c\u0013\u0005A)$D\u0001\t05\t\u0001BD\u0007\u0002\t\u000biC\u0003B\u0001\u0019<u5A\u0001\u0001\u0005\u0019\u001b\t)\u0011\u0001C\fQ\u0007\u0001\t3!B\u0001\t11\u0005\u0011kA\u0003\u0005<%\t\u0001\u0012G\u0007\u0002\u0011_iS\u0003B\u0006\u0019=u=A\u0001\u0001\u0005\u0019\u001b\r)\u0011\u0001C\f\r\u0002A\u001b\u0001!I\u0002\u0006\u0003!yA\u0012A)\u0004\u000b\u0011q\u0012\"\u0001E\u0011\u001b\u0005Ay#,\u0011\u0005\u0017auRT\u0002\u0003\u0001\u0011}i!!B\u0001\t3A\u001b\u0001!(\u0004\u0005\u0001!9RBA\u0003\u0002\u0011=\u00016\u0011A\u0011\u0007\u000b\u0005A!#C\u0002\n\u0005\u0015\t\u0001bF)\u0004\u000f\u0011u\u0012\"\u0001E\u0013\u001b\u0005A1$D\u0001\t\"5\u001aB!\u0001M ;\u001b!\u0001\u0001\u0003\u0007\u000e\u0005\u0015\t\u0001\"\u0004)\u0004\u0001\u0005\u0012Q!\u0001E\f#\u000e)AqH\u0005\u0002\u0011;i\u0011\u0001\u0003\b6*\u0015\u001dBa9\u0001\u0019\nu5A\u0001\u0001\u0005\u0006\u001b\t)\u0011\u0001c\u0003Q\u0007\u0001\t#!B\u0001\t\u0006E\u001bQ\u0001\"\u0003\n\u0003\u0011\u0001Q\"\u0001\u0005\u0007"})
public final class JetPositionManager
implements MultiRequestPositionManager {
    public static final /* synthetic */ KClass $kotlinClass;
    private static final Class<? extends JetElement>[] TYPES_TO_CALCULATE_CLASSNAME;
    private final WeakHashMap<String, CachedValue<JetTypeMapper>> myTypeMappers;
    private final DebugProcess myDebugProcess;
    public static final Companion Companion;
    @Deprecated
    public static final Companion OBJECT$;

    static {
        $kotlinClass = Reflection.createKotlinClass(JetPositionManager.class);
        OBJECT$ = Companion = org.jetbrains.kotlin.idea.debugger.JetPositionManager$Companion.access$init$2();
        TYPES_TO_CALCULATE_CLASSNAME = new Class[]{JetClassOrObject.class, JetFunctionLiteral.class, JetNamedFunction.class, JetProperty.class, JetClassInitializer.class};
    }

    @Nullable
    public SourcePosition getSourcePosition(@JetValueParameter(name="location", type="?") @Nullable Location location) {
        int n;
        if (location == null) {
            Throwable throwable = NoDataException.INSTANCE;
            Intrinsics.checkExpressionValueIsNotNull((Object)throwable, (String)"NoDataException.INSTANCE");
            throw throwable;
        }
        PsiFile psiFile = this.getPsiFileByLocation(location);
        if (psiFile == null) {
            Throwable throwable = NoDataException.INSTANCE;
            Intrinsics.checkExpressionValueIsNotNull((Object)throwable, (String)"NoDataException.INSTANCE");
            throw throwable;
        }
        try {
            n = location.lineNumber() - 1;
        }
        catch (InternalError e) {
            n = -1;
        }
        int lineNumber = n;
        if (lineNumber >= 0) {
            PsiFile psiFile2 = psiFile;
            if (psiFile2 == null) {
                throw new TypeCastException("com.intellij.psi.PsiFile? cannot be cast to org.jetbrains.kotlin.psi.JetFile");
            }
            JetFunction lambdaOrFunIfInside = this.getLambdaOrFunIfInside(location, (JetFile)psiFile2, lineNumber);
            if (lambdaOrFunIfInside != null) {
                return SourcePosition.createFromElement((PsiElement)((PsiElement)lambdaOrFunIfInside.getBodyExpression()));
            }
            return SourcePosition.createFromLine((PsiFile)psiFile, (int)lineNumber);
        }
        Throwable throwable = NoDataException.INSTANCE;
        Intrinsics.checkExpressionValueIsNotNull((Object)throwable, (String)"NoDataException.INSTANCE");
        throw throwable;
    }

    /*
     * WARNING - void declaration
     */
    private final JetFunction getLambdaOrFunIfInside(@JetValueParameter(name="location") Location location, @JetValueParameter(name="file") JetFile file, @JetValueParameter(name="lineNumber") int lineNumber) {
        void destination;
        void $receiver;
        void $receiver2;
        String currentLocationFqName = location.declaringType().name();
        if (currentLocationFqName == null) {
            return null;
        }
        Integer start = CodeInsightUtils.getStartLineOffset((PsiFile)file, lineNumber);
        Integer end = CodeInsightUtils.getEndLineOffset((PsiFile)file, lineNumber);
        if (start == null || end == null) {
            return null;
        }
        Iterable iterable = CodeInsightUtils.findElementsOfClassInRange((PsiFile)file, ((Number)start).intValue(), ((Number)end).intValue(), JetFunctionLiteral.class, JetNamedFunction.class);
        void var9_9 = $receiver2;
        Collection collection = new ArrayList();
        for (Object element : $receiver) {
            PsiElement it;
            PsiElement psiElement = it = (PsiElement)element;
            if (psiElement == null) {
                throw new TypeCastException("com.intellij.psi.PsiElement! cannot be cast to org.jetbrains.kotlin.psi.JetExpression");
            }
            if (!(JetPsiUtil.getParentCallIfPresent((JetExpression)psiElement) != null)) continue;
            destination.add(element);
        }
        List literalsOrFunctions = (List)destination;
        if (literalsOrFunctions.isEmpty()) {
            return null;
        }
        boolean isInLibrary = LibraryUtil.findLibraryEntry((VirtualFile)file.getVirtualFile(), (Project)file.getProject()) != null;
        JetTypeMapper typeMapper = !isInLibrary ? this.prepareTypeMapper(file) : JetPositionManager.Companion.createTypeMapperForLibraryFile(file.findElementAt(((Number)start).intValue()), file);
        String currentLocationClassName = JvmClassName.byFqNameWithoutInnerClasses(new FqName(currentLocationFqName)).getInternalName();
        Iterator iterator2 = literalsOrFunctions.iterator();
        while (iterator2.hasNext()) {
            String internalClassName;
            PsiElement literal;
            PsiElement psiElement = literal = (PsiElement)iterator2.next();
            if (psiElement == null) {
                throw new TypeCastException("com.intellij.psi.PsiElement! cannot be cast to org.jetbrains.kotlin.psi.JetFunction");
            }
            JetFunction functionLiteral = (JetFunction)psiElement;
            BindingContext bindingContext2 = typeMapper.getBindingContext();
            Intrinsics.checkExpressionValueIsNotNull((Object)bindingContext2, (String)"typeMapper.getBindingContext()");
            if (Companion.isInlinedLambda(functionLiteral, bindingContext2) || !Intrinsics.areEqual((Object)(internalClassName = Companion.getInternalClassNameForElement(((JetFunction)literal).getFirstChild(), typeMapper, file, isInLibrary).getClassName()), (Object)currentLocationClassName)) continue;
            return functionLiteral;
        }
        return null;
    }

    private final PsiFile getPsiFileByLocation(@JetValueParameter(name="location") Location location) {
        String referenceInternalName;
        String sourceName;
        try {
            String string = location.sourceName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"location.sourceName()");
            sourceName = string;
        }
        catch (AbsentInformationException e) {
            return null;
        }
        try {
            referenceInternalName = location.declaringType().availableStrata().contains("Kotlin") ? KotlinPackage.replace$default((String)location.sourcePath(), (char)'\\', (char)'/', (boolean)false, (int)4) : this.defaultInternalName(location);
        }
        catch (AbsentInformationException e) {
            referenceInternalName = this.defaultInternalName(location);
        }
        JvmClassName className = JvmClassName.byInternalName(referenceInternalName);
        Project project = this.myDebugProcess.getProject();
        if (DumbService.getInstance((Project)project).isDumb()) {
            return null;
        }
        return (PsiFile)DebuggerUtils.findSourceFileForClass(project, GlobalSearchScope.allScope((Project)project), className, sourceName, location.lineNumber() - 1);
    }

    private final String defaultInternalName(@JetValueParameter(name="location") Location location) {
        String referenceFqName = location.declaringType().name();
        return KotlinPackage.replace$default((String)referenceFqName, (char)'.', (char)'/', (boolean)false, (int)4);
    }

    @NotNull
    public List<ReferenceType> getAllClasses(@JetValueParameter(name="sourcePosition") @NotNull SourcePosition sourcePosition) {
        PsiFile decompiledPsiFile2;
        Intrinsics.checkParameterIsNotNull((Object)sourcePosition, (String)"sourcePosition");
        PsiFile psiFile = sourcePosition.getFile();
        if (psiFile instanceof JetFile) {
            ArrayList result2 = new ArrayList();
            if (!ProjectRootsUtil.isInProjectOrLibSource((PsiElement)psiFile)) {
                return result2;
            }
            List<String> names = this.classNameForPositionAndInlinedOnes(sourcePosition);
            for (String name2 : names) {
                result2.addAll(this.myDebugProcess.getVirtualMachineProxy().classesByName(name2));
            }
            return result2;
        }
        if (psiFile instanceof ClsFileImpl && (decompiledPsiFile2 = (PsiFile)ApplicationPackage.runReadAction((Function0)new Function0<PsiFile>(psiFile){
            final /* synthetic */ PsiFile $psiFile;

            public final PsiFile invoke() {
                return ((ClsFileImpl)this.$psiFile).getDecompiledPsiFile();
            }
            {
                this.$psiFile = psiFile;
                super(0);
            }
        })) instanceof JetClsFile && sourcePosition.getLine() == -1) {
            String className = PackageClassUtils.getPackageClassInternalName(((JetClsFile)decompiledPsiFile2).getPackageFqName());
            List list = this.myDebugProcess.getVirtualMachineProxy().classesByName(className);
            Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"myDebugProcess.getVirtua\u2026.classesByName(className)");
            return list;
        }
        Throwable throwable = NoDataException.INSTANCE;
        Intrinsics.checkExpressionValueIsNotNull((Object)throwable, (String)"NoDataException.INSTANCE");
        throw throwable;
    }

    private final List<String> classNameForPositionAndInlinedOnes(@JetValueParameter(name="sourcePosition") SourcePosition sourcePosition) {
        ArrayList result2 = KotlinPackage.arrayListOf((Object[])new String[0]);
        String name2 = this.classNameForPosition(sourcePosition);
        if (name2 != null) {
            result2.add(name2);
        }
        List<String> list = this.findInlinedCalls(sourcePosition.getElementAt(), sourcePosition.getFile());
        result2.addAll((Collection)list);
        return result2;
    }

    @Nullable
    public final String classNameForPosition(@JetValueParameter(name="sourcePosition") @NotNull SourcePosition sourcePosition) {
        Intrinsics.checkParameterIsNotNull((Object)sourcePosition, (String)"sourcePosition");
        PsiElement psiElement = sourcePosition.getElementAt();
        if (psiElement == null) {
            return null;
        }
        return this.classNameForPosition(psiElement);
    }

    private final String classNameForPosition(@JetValueParameter(name="element") PsiElement element) {
        return (String)ApplicationPackage.runReadAction((Function0)new Function0<String>(this, element){
            final /* synthetic */ JetPositionManager this$0;
            final /* synthetic */ PsiElement $element;

            @Nullable
            public final String invoke() {
                String string;
                if (DumbService.getInstance((Project)this.$element.getProject()).isDumb()) {
                    string = null;
                } else {
                    PsiFile psiFile = this.$element.getContainingFile();
                    if (psiFile == null) {
                        throw new TypeCastException("com.intellij.psi.PsiFile! cannot be cast to org.jetbrains.kotlin.psi.JetFile");
                    }
                    JetFile file = (JetFile)psiFile;
                    boolean isInLibrary = LibraryUtil.findLibraryEntry((VirtualFile)file.getVirtualFile(), (Project)file.getProject()) != null;
                    JetTypeMapper typeMapper = !isInLibrary ? JetPositionManager.access$prepareTypeMapper$1(this.this$0, file) : org.jetbrains.kotlin.idea.debugger.JetPositionManager$Companion.access$createTypeMapperForLibraryFile$0(JetPositionManager.Companion, this.$element, file);
                    string = JetPositionManager.Companion.getInternalClassNameForElement(this.$element, typeMapper, file, isInLibrary).getClassName();
                }
                return string;
            }
            {
                this.this$0 = jetPositionManager;
                this.$element = psiElement;
                super(0);
            }
        });
    }

    private final JetTypeMapper prepareTypeMapper(@JetValueParameter(name="file") JetFile file) {
        String key = JetPositionManager.Companion.createKeyForTypeMapper(file);
        CachedValue value2 = this.myTypeMappers.get(key);
        if (value2 == null) {
            value2 = CachedValuesManager.getManager((Project)file.getProject()).createCachedValue(new CachedValueProvider<T>(file){
                final /* synthetic */ JetFile $file;

                @NotNull
                public final CachedValueProvider.Result<JetTypeMapper> compute() {
                    JetTypeMapper typeMapper = JetPositionManager.Companion.createTypeMapper(this.$file);
                    return new CachedValueProvider.Result((Object)typeMapper, new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
                }
                {
                    this.$file = jetFile;
                }
            }, false);
            this.myTypeMappers.put(key, (CachedValue<JetTypeMapper>)value2);
        }
        CachedValue cachedValue2 = value2;
        if (cachedValue2 == null) {
            Intrinsics.throwNpe();
        }
        JetTypeMapper jetTypeMapper = (JetTypeMapper)cachedValue2.getValue();
        Intrinsics.checkExpressionValueIsNotNull((Object)jetTypeMapper, (String)"value!!.getValue()");
        return jetTypeMapper;
    }

    @NotNull
    public List<Location> locationsOfLine(@JetValueParameter(name="type") @NotNull ReferenceType type2, @JetValueParameter(name="position") @NotNull SourcePosition position) {
        Intrinsics.checkParameterIsNotNull((Object)type2, (String)"type");
        Intrinsics.checkParameterIsNotNull((Object)position, (String)"position");
        if (!(position.getFile() instanceof JetFile)) {
            Throwable throwable = NoDataException.INSTANCE;
            Intrinsics.checkExpressionValueIsNotNull((Object)throwable, (String)"NoDataException.INSTANCE");
            throw throwable;
        }
        try {
            List<Location> locations;
            int line = position.getLine() + 1;
            List<Location> list = locations = this.myDebugProcess.getVirtualMachineProxy().versionHigher("1.4") ? type2.locationsOfLine("Kotlin", null, line) : type2.locationsOfLine(line);
            if (locations == null || locations.isEmpty()) {
                Throwable throwable = NoDataException.INSTANCE;
                Intrinsics.checkExpressionValueIsNotNull((Object)throwable, (String)"NoDataException.INSTANCE");
                throw throwable;
            }
            return locations;
        }
        catch (AbsentInformationException e) {
            Throwable throwable = NoDataException.INSTANCE;
            Intrinsics.checkExpressionValueIsNotNull((Object)throwable, (String)"NoDataException.INSTANCE");
            throw throwable;
        }
    }

    @deprecated(value="Since Idea 14.0.3 use createPrepareRequests fun")
    @Nullable
    public ClassPrepareRequest createPrepareRequest(@JetValueParameter(name="classPrepareRequestor") @NotNull ClassPrepareRequestor classPrepareRequestor, @JetValueParameter(name="sourcePosition") @NotNull SourcePosition sourcePosition) {
        Intrinsics.checkParameterIsNotNull((Object)classPrepareRequestor, (String)"classPrepareRequestor");
        Intrinsics.checkParameterIsNotNull((Object)sourcePosition, (String)"sourcePosition");
        if (!(sourcePosition.getFile() instanceof JetFile)) {
            Throwable throwable = NoDataException.INSTANCE;
            Intrinsics.checkExpressionValueIsNotNull((Object)throwable, (String)"NoDataException.INSTANCE");
            throw throwable;
        }
        String className = this.classNameForPosition(sourcePosition);
        if (className == null) {
            return null;
        }
        return this.myDebugProcess.getRequestsManager().createClassPrepareRequest(classPrepareRequestor, KotlinPackage.replace$default((String)className, (char)'/', (char)'.', (boolean)false, (int)4));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<ClassPrepareRequest> createPrepareRequests(@JetValueParameter(name="requestor") @NotNull ClassPrepareRequestor requestor, @JetValueParameter(name="position") @NotNull SourcePosition position) {
        void destination;
        void $receiver;
        Intrinsics.checkParameterIsNotNull((Object)requestor, (String)"requestor");
        Intrinsics.checkParameterIsNotNull((Object)position, (String)"position");
        if (!(position.getFile() instanceof JetFile)) {
            Throwable throwable = NoDataException.INSTANCE;
            Intrinsics.checkExpressionValueIsNotNull((Object)throwable, (String)"NoDataException.INSTANCE");
            throw throwable;
        }
        Iterable $receiver2 = this.classNameForPositionAndInlinedOnes(position);
        Iterable iterable = $receiver2;
        Collection collection = new ArrayList(KotlinPackage.collectionSizeOrDefault((Iterable)$receiver2, (int)10));
        for (Object item : $receiver) {
            void className;
            String string = (String)item;
            void var9_9 = destination;
            ClassPrepareRequest classPrepareRequest = this.myDebugProcess.getRequestsManager().createClassPrepareRequest(requestor, KotlinPackage.replace$default((String)className, (char)'/', (char)'.', (boolean)false, (int)4));
            var9_9.add(classPrepareRequest);
        }
        return (List)destination;
    }

    public final void addTypeMapper(@JetValueParameter(name="file") @NotNull JetFile file, @JetValueParameter(name="typeMapper") @NotNull JetTypeMapper typeMapper) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        Intrinsics.checkParameterIsNotNull((Object)typeMapper, (String)"typeMapper");
        CachedValue value2 = CachedValuesManager.getManager((Project)file.getProject()).createCachedValue(new CachedValueProvider<T>(typeMapper){
            final /* synthetic */ JetTypeMapper $typeMapper;

            @NotNull
            public final CachedValueProvider.Result<JetTypeMapper> compute() {
                return new CachedValueProvider.Result((Object)this.$typeMapper, new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
            }
            {
                this.$typeMapper = jetTypeMapper;
            }
        }, false);
        String key = JetPositionManager.Companion.createKeyForTypeMapper(file);
        this.myTypeMappers.put(key, (CachedValue<JetTypeMapper>)value2);
    }

    private final List<String> findInlinedCalls(@JetValueParameter(name="element", type="?") PsiElement element, @JetValueParameter(name="jetFile", type="?") PsiFile jetFile) {
        if (element == null || !(jetFile instanceof JetFile)) {
            return KotlinPackage.emptyList();
        }
        return (List)ApplicationPackage.runReadAction((Function0)new Function0<ArrayList<String>>(this, jetFile, element){
            final /* synthetic */ JetPositionManager this$0;
            final /* synthetic */ PsiFile $jetFile;
            final /* synthetic */ PsiElement $element;

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final ArrayList<String> invoke() {
                void var1_1;
                ArrayList result2 = KotlinPackage.arrayListOf((Object[])new String[0]);
                boolean isInLibrary = LibraryUtil.findLibraryEntry((VirtualFile)((JetFile)this.$jetFile).getVirtualFile(), (Project)((JetFile)this.$jetFile).getProject()) != null;
                JetTypeMapper typeMapper = !isInLibrary ? JetPositionManager.access$prepareTypeMapper$1(this.this$0, (JetFile)this.$jetFile) : org.jetbrains.kotlin.idea.debugger.JetPositionManager$Companion.access$createTypeMapperForLibraryFile$0(JetPositionManager.Companion, this.$element, (JetFile)this.$jetFile);
                PsiElement psiElement = JetPositionManager.Companion.getInternalClassNameForElement(this.$element, typeMapper, (JetFile)this.$jetFile, isInLibrary).getElement();
                if (psiElement instanceof JetNamedFunction && InlineUtil.isInline(typeMapper.getBindingContext().get(BindingContext.DECLARATION_TO_DESCRIPTOR, psiElement))) {
                    void $receiver;
                    Project project = JetPositionManager.access$getMyDebugProcess$3(this.this$0).getProject();
                    FindUsagesOptions options = new FindUsagesOptions(project);
                    options.isSearchForTextOccurrences = false;
                    UsagesSearchTarget<PsiNamedElement> usagesSearchTarget = FindUsagesPackage$findUsagesOptions$063e0ee1.toSearchTarget(options, (PsiNamedElement)psiElement, true);
                    UsagesSearchRequest usagesSearchRequest = new FunctionUsagesSearchHelper(false, false, false, false, true, 15, null).newRequest(usagesSearchTarget);
                    Iterable iterable = (Iterable)UsagesSearchPackage.search(usagesSearchRequest);
                    for (T element : $receiver) {
                        String name2;
                        PsiReference it = (PsiReference)element;
                        PsiElement psiElement2 = it.getElement();
                        if (psiElement2 instanceof JetElement && (name2 = JetPositionManager.access$classNameForPosition$2(this.this$0, psiElement2)) != null) {
                            result2.add(name2);
                        }
                    }
                }
                return var1_1;
            }
            {
                this.this$0 = jetPositionManager;
                this.$jetFile = psiFile;
                this.$element = psiElement;
                super(0);
            }
        });
    }

    public JetPositionManager(@JetValueParameter(name="myDebugProcess") @NotNull DebugProcess myDebugProcess) {
        Intrinsics.checkParameterIsNotNull((Object)myDebugProcess, (String)"myDebugProcess");
        this.myDebugProcess = myDebugProcess;
        this.myTypeMappers = new WeakHashMap();
    }

    @NotNull
    public static final /* synthetic */ JetTypeMapper access$prepareTypeMapper$1(@JetValueParameter(name="$this", type="?") JetPositionManager $this, @JetValueParameter(name="file") @NotNull JetFile file) {
        return $this.prepareTypeMapper(file);
    }

    @Nullable
    public static final /* synthetic */ String access$classNameForPosition$2(@JetValueParameter(name="$this", type="?") JetPositionManager $this, @JetValueParameter(name="element") @NotNull PsiElement element) {
        return $this.classNameForPosition(element);
    }

    @KotlinClass(abiVersion=23, kind=KotlinClass.Kind.CLASS, data={"0\u000e)I1i\\7qC:LwN\u001c\u0006\u0013\u0015\u0016$\bk\\:ji&|g.T1oC\u001e,'OC\u0002pe\u001eT\u0011B[3uEJ\f\u0017N\\:\u000b\r-|G\u000f\\5o\u0015\u0011IG-Z1\u000b\u0011\u0011,'-^4hKJT1!\u00118z\u0015q!\u0016\fU#T?R{ulQ!M\u0007Vc\u0015\tV#`\u00072\u000b5k\u0015(B\u001b\u0016SQ!\u0011:sCfTQa\u00117bgNTAA[1wC*!A.\u00198h\u0015)QU\r^#mK6,g\u000e\u001e\u0006\u0004aNL'bH4fiRK\u0006+R*`)>{6)\u0011'D+2\u000bE+R0D\u0019\u0006\u001b6KT!N\u000b*12M]3bi\u0016\\U-\u001f$peRK\b/Z'baB,'O\u0003\u0003gS2,'b\u0002&fi\u001aKG.\u001a\u0006\u0007'R\u0014\u0018N\\4\u000b\u000f9{GOT;mY*Y\u0011M\u001c8pi\u0006$\u0018n\u001c8t\u0015]Yw\u000e\u001e7j]:Rg/\u001c\u0018QY\u0006$hm\u001c:n)f\u0004XM\u0003\tde\u0016\fG/\u001a+za\u0016l\u0015\r\u001d9fe*i!*\u001a;UsB,W*\u00199qKJTqaY8eK\u001e,gNC\u0003ti\u0006$XM\u0003\u0010de\u0016\fG/\u001a+za\u0016l\u0015\r\u001d9fe\u001a{'\u000fT5ce\u0006\u0014\u0018PR5mK*!bn\u001c;Q_NLG/[8oK\u0012,E.Z7f]RT!\u0002U:j\u000b2,W.\u001a8u\u0015\r\u0019w.\u001c\u0006\tS:$X\r\u001c7jU*qr-\u001a;FY\u0016lWM\u001c;U_\u000e\u000bGnY;mCR,7\t\\1tg:\u000bW.\u001a\u0006+O\u0016$X\t\\3nK:$Hk\\\"sK\u0006$X\rV=qK6\u000b\u0007\u000f]3s\r>\u0014H*\u001b2sCJLh)\u001b7f\u0015\u001d)G.Z7f]RTadZ3u\u0013:$XM\u001d8bY\u000ec\u0017m]:OC6,gi\u001c:FY\u0016lWM\u001c;\u000b\u0015QL\b/Z'baB,'OC\u0006jg&sG*\u001b2sCJL(b\u0002\"p_2,\u0017M\u001c\u0006\u0012!>\u001c\u0018\u000e^5p]\u0016$W\t\\3nK:$(\"G4fi*3X.\u00138uKJt\u0017\r\u001c(b[\u00164uN]%na2T\u0001B[3u\u00072\f7o\u001d\u0006\u0011\u0015\u0016$8\t\\1tg>\u0013xJ\u00196fGRT!eZ3u\u0015Zl\u0017J\u001c;fe:\fGNT1nK\u001a{'\u000f\u0015:pa\u0016\u0014H/_(x]\u0016\u0014(B\u00033fg\u000e\u0014\u0018\u000e\u001d;pe*\u0011\u0002K]8qKJ$\u0018\u0010R3tGJL\u0007\u000f^8s\u0015-!Wm]2sSB$xN]:\u000b)%\u001c\u0018J\u001c)s_B,'\u000f^=BG\u000e,7o]8s\u0015=I7/\u00138mS:,G\rT1nE\u0012\f'b\u00044v]\u000e$\u0018n\u001c8MSR,'/\u00197\u000b\u0017)+GOR;oGRLwN\u001c\u0006\bG>tG/\u001a=u\u00159\u0011\u0015N\u001c3j]\u001e\u001cuN\u001c;fqRTqA]3t_24X\r+\u0002\u000b\u0005A\u0011!\u0002\u0002\u0005\u0001!\rQA\u0001C\u0001\u0011\t)!\u0001B\u0001\t\u0006\u0015\u0011A1\u0001\u0005\u0004\u000b\r!!\u0001#\u0001\r\u0001\u0015\u0019AQ\u0001\u0005\u0001\u0019\u0001)\u0011\u0001\u0003\u0002\u0006\u0007\u0011\u001d\u0001r\u0001\u0007\u0001\u000b\r!9\u0001#\u0003\r\u0001\u0015\t\u00012B\u0003\u0003\t\u0015Aa!B\u0002\u0005\f!)A\u0002A\u0003\u0003\t\u0005Aq!B\u0002\u0005\u000e!5A\u0002A\u0003\u0003\t\u0017AQ!B\u0002\u0005\u000e!IA\u0002A\u0003\u0004\t\u000fA\u0019\u0002\u0004\u0001\u0006\u0005\u0011\u0005\u0001RC\u0003\u0004\t%A!\u0002\u0004\u0001\u0006\u0005\u0011-\u00012C\u0003\u0003\t\u001bA\u0011\"\u0002\u0002\u0005\u0003!eQA\u0001\u0003\f\u00115)1\u0001b\u0006\t\u00191\u0001QA\u0001C\f\u00111)\u0011\u0001C\b\u0006\u0005\u0011i\u0001rD\u0003\u0003\t7Aq!B\u0002\u0005\u001d!uA\u0002A\u0003\u0003\t9Ai\"\u0002\u0002\u0005\u000e!5Qa\u0001C\u0004\u0011Ma\u0001!B\u0002\u0005\u0005!\u001dB\u0002A\u0003\u0003\t\tA9#B\u0002\u0005\u000e!)B\u0002A\u0003\u0003\t\u001bAQ#\u0002\u0002\u0005\u0003!9Ra\u0001C\u0013\u0011[a\u0001!\u0002\u0002\u0005&!5Ra\u0001C\u0007\u0011ea\u0001!\u0002\u0002\u0005\u0003!URa\u0001C\u0015\u0011ia\u0001!\u0002\u0002\u0005\u000e!IRA\u0001C\u0015\u0011i!19\u0001\u0007\u00043\t)\u0011\u0001\u0003\u0003.7\u0011\tG\u0001\u0007\u0003\"\u0017\u0015\t\u0001\u0012B\u0005\t\u0013\u001d)\u0011\u0001\u0003\u0004\n\t\u0011\u0005\u0011BA\u0003\u0002\u0011\u001d)6aC\u0003\u0006\t\u0011I!\u0001c\u0004\r\u00021\u0005Q\u0002\u0002C\b\u0013\tAy\u0001$\u0001.;\u0011\t\u0001\u0004CO\u0007\t\u0001A\t\"\u0004\u0002\u0006\u0003!A\u0001k\u0001\u0001\"\u0019\u0015\t\u0001\u0012\u0003\t\f+\u0017)\u0011\u0001#\u0005\r\u0002E\u001b\u0011\u0001b\u0005R\u0007\u0005!\u0019\"U\u0002\u0006\t!I\u0011\u0001\u0003\u0006\u000e\u0003!UQf\u0005\u0003\u00041/ij\u0001\u0002\u0001\t\u00125\u0011Q!\u0001\u0005\t!\u000e\u0001\u0011EA\u0003\u0002\u00111\t6!\u0002C\f\u0013\u0005AI\"D\u0001\t\u00165nB!\u0001M\u000e;\u001f!\u0001\u0001\u0003\b\u000e\u0007\u0015\t\u0001R\u0004G\u0001!\u000e\u0001QT\u0002\u0003\u0001\u0011#i!!B\u0001\t\u0011A\u001b\t!\t\u0002\u0006\u0003!a\u0011kA\u0004\u0005\u001c%\t\u0001\u0012D\u0007\u0002\u0011=i\u0011\u0001#\u0006.+\u0011\t\u0001\u0004EO\b\t\u0001Aa\"D\u0002\u0006\u0003!uA\u0012\u0001)\u0004\u0001\u0005\u001aQ!\u0001\u0005\b\u0019\u0003\t6!\u0002\u0003\u0011\u0013\u0005Ay\"D\u0001\t\u001f5JB!\u0001M\u0011;\u001f!\u0001\u0001C\t\u000e\u0007\u0015\t\u0001R\u0004G\u0001!\u000e\u0001\u0011eB\u0003\u0002\u0011\u001d\u00012\"F\u0002\u0006\u0003!9A\u0012A)\u0004\u000b\u0011\u0005\u0012\"\u0001E\u0010\u001b\u0005Aq\",\u0019\u0005\u0007a\rRt\u0002\u0003\u0001\u00119i1!B\u0001\t\u001e1\u0005\u0001k\u0001\u0001\u001e\u000e\u0011\u0001\u0001BE\u0007\u0003\u000b\u0005AA\u0002UB\u0001;\u001b!\u0001\u0001#\u0005\u000e\u0005\u0015\t\u0001\u0002\u0003)\u0004\u0003u5A\u0001\u0001E\u0013\u001b\t)\u0011\u0001\u0003\tQ\u0007\u0007\t#!B\u0001\t\"E\u001b1\u0002b\t\n\u0003!\tR\"\u0001\u0005\u0010\u001b\u0005AI\"D\u0001\t\u00165\tA\u0011AW\u001e\t\u0005AB#(\u0004\u0005\u0001!\u0011RBA\u0003\u0002\u00111\u00016\u0001AO\u0007\t\u0001AI#\u0004\u0002\u0006\u0003!\r\u0002k!\u0001\"\u0007\u0015\t\u0001\u0012\u0003G\u0001#\u000e9A\u0001F\u0005\u0002\u0011)i\u0011\u0001#\u0007\u000e\u0003!\u0011R\u0016\b\u0003\u00041Wij\u0001\u0002\u0001\t%5\u0011Q!\u0001\u0005\r!\u000e\u0001QT\u0002\u0003\u0001\u0011Yi!!B\u0001\t'A\u001b\t!\t\u0002\u0006\u0003!E\u0011kA\u0004\u0005,%\t\u0001BC\u0007\u0002\u00113i\u0011\u0001c\n.)\u0011\t\u0001tFO\b\t\u0001A\u0011#D\u0002\u0006\u0003!uA\u0012\u0001)\u0004\u0001\u0005\u0012Q!\u0001\u0005\u0011#\u000e)AqF\u0005\u0002\t\u0003i\u0011\u0001C\b.:\u0011\u0019\u0001\u0004GO\u0007\t\u0001A\t$\u0004\u0002\u0006\u0003!!\u0002k\u0001\u0001\u001e\u000e\u0011\u0001\u00012G\u0007\u0003\u000b\u0005AQ\u0003UB\u0001C\t)\u0011\u0001\u0003\tR\u0007\u001d!\u0001$C\u0001\u0005\u00025\t\u00012F\u0007\u0002\u0011Y)\u0004\u0001"})
    public static final class Companion {
        public static final /* synthetic */ KClass $kotlinClass;

        static {
            $kotlinClass = Reflection.createKotlinClass(Companion.class);
        }

        @NotNull
        public final JetTypeMapper createTypeMapper(@JetValueParameter(name="file") @NotNull JetFile file) {
            Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
            Project project = file.getProject();
            AnalysisResult analysisResult = ResolvePackage.analyzeFullyAndGetResult(file, new JetFile[0]);
            analysisResult.throwIfError();
            GenerationState state = new GenerationState(project, ClassBuilderFactories.THROW_EXCEPTION, analysisResult.getModuleDescriptor(), analysisResult.getBindingContext(), KotlinPackage.listOf((Object)file));
            state.beforeCompile();
            JetTypeMapper jetTypeMapper = state.getTypeMapper();
            Intrinsics.checkExpressionValueIsNotNull((Object)jetTypeMapper, (String)"state.getTypeMapper()");
            return jetTypeMapper;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final PositionedElement getInternalClassNameForElement(@JetValueParameter(name="notPositionedElement", type="?") @Nullable PsiElement notPositionedElement, @JetValueParameter(name="typeMapper") @NotNull JetTypeMapper typeMapper, @JetValueParameter(name="file") @NotNull JetFile file, @JetValueParameter(name="isInLibrary") boolean isInLibrary) {
            Intrinsics.checkParameterIsNotNull((Object)typeMapper, (String)"typeMapper");
            Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
            JetElement element = this.getElementToCalculateClassName(notPositionedElement);
            if (element instanceof JetClassOrObject) {
                return new PositionedElement(this.getJvmInternalNameForImpl(typeMapper, (JetClassOrObject)element), (PsiElement)element);
            }
            if (element instanceof JetFunctionLiteral) {
                JetFunction jetFunction = (JetFunction)element;
                BindingContext bindingContext2 = typeMapper.getBindingContext();
                Intrinsics.checkExpressionValueIsNotNull((Object)bindingContext2, (String)"typeMapper.getBindingContext()");
                if (this.isInlinedLambda(jetFunction, bindingContext2)) {
                    return this.getInternalClassNameForElement(((JetFunctionLiteral)element).getParent(), typeMapper, file, isInLibrary);
                }
                Type asmType = CodegenBinding.asmTypeForAnonymousClass(typeMapper.getBindingContext(), element);
                return new PositionedElement(asmType.getInternalName(), (PsiElement)element);
            }
            if (element instanceof JetClassInitializer) {
                JetElement parent = this.getElementToCalculateClassName(((JetClassInitializer)element).getParent());
                if (parent instanceof JetObjectDeclaration && ((JetObjectDeclaration)parent).isCompanion()) {
                    return new PositionedElement(this.getInternalClassNameForElement(((JetObjectDeclaration)parent).getParent(), typeMapper, file, isInLibrary).getClassName(), (PsiElement)parent);
                }
                return this.getInternalClassNameForElement(((JetClassInitializer)element).getParent(), typeMapper, file, isInLibrary);
            }
            if (!(!(element instanceof JetProperty) || ((JetProperty)element).isTopLevel() && isInLibrary)) {
                JetClassOrObject classOrObject;
                if (this.isInPropertyAccessor(notPositionedElement) && (classOrObject = (JetClassOrObject)PsiTreeUtil.getParentOfType((PsiElement)((PsiElement)element), JetClassOrObject.class)) != null) {
                    return new PositionedElement(this.getJvmInternalNameForImpl(typeMapper, classOrObject), (PsiElement)element);
                }
                DeclarationDescriptor descriptor2 = typeMapper.getBindingContext().get(BindingContext.DECLARATION_TO_DESCRIPTOR, element);
                if (!(descriptor2 instanceof PropertyDescriptor)) {
                    return this.getInternalClassNameForElement(((JetProperty)element).getParent(), typeMapper, file, isInLibrary);
                }
                PropertyDescriptor propertyDescriptor = (PropertyDescriptor)descriptor2;
                Intrinsics.checkExpressionValueIsNotNull((Object)propertyDescriptor, (String)"descriptor");
                return new PositionedElement(this.getJvmInternalNameForPropertyOwner(typeMapper, propertyDescriptor), (PsiElement)element);
            }
            if (element instanceof JetNamedFunction) {
                JetFunction jetFunction = (JetFunction)element;
                BindingContext bindingContext3 = typeMapper.getBindingContext();
                Intrinsics.checkExpressionValueIsNotNull((Object)bindingContext3, (String)"typeMapper.getBindingContext()");
                if (this.isInlinedLambda(jetFunction, bindingContext3)) {
                    return this.getInternalClassNameForElement(((JetNamedFunction)element).getParent(), typeMapper, file, isInLibrary);
                }
                JetElement parent = this.getElementToCalculateClassName(((JetNamedFunction)element).getParent());
                if (parent instanceof JetClassOrObject) {
                    return new PositionedElement(this.getJvmInternalNameForImpl(typeMapper, (JetClassOrObject)parent), (PsiElement)element);
                }
                if (parent != null) {
                    Type asmType = CodegenBinding.asmTypeForAnonymousClass(typeMapper.getBindingContext(), element);
                    return new PositionedElement(asmType.getInternalName(), (PsiElement)element);
                }
            }
            if (isInLibrary) {
                void value2;
                JetDeclaration elementAtForLibraryFile = element instanceof JetDeclaration ? (JetDeclaration)element : (JetDeclaration)PsiTreeUtil.getParentOfType((PsiElement)((PsiElement)element), JetDeclaration.class);
                boolean asmType = elementAtForLibraryFile != null;
                if (KotlinPackage.getASSERTIONS_ENABLED() && value2 == false) {
                    String message = "Couldn't find element at breakpoint for library file " + file.getName() + (notPositionedElement == null ? "" : ", notPositionedElement = " + PsiUtilPackage.getElementTextWithContext(notPositionedElement));
                    throw (Throwable)((Object)new AssertionError((Object)message));
                }
                JetDeclaration jetDeclaration = elementAtForLibraryFile;
                if (jetDeclaration == null) {
                    Intrinsics.throwNpe();
                }
                return new PositionedElement(DebuggerPackage$PositionManagerLibraryClassFileSearcher$0f82e0ec.findPackagePartInternalNameForLibraryFile(jetDeclaration), elementAtForLibraryFile);
            }
            return new PositionedElement(PackagePartClassUtils.getPackagePartInternalName(file), (PsiElement)element);
        }

        private final Class<? extends JetElement>[] getTYPES_TO_CALCULATE_CLASSNAME() {
            return TYPES_TO_CALCULATE_CLASSNAME;
        }

        private final JetElement getElementToCalculateClassName(@JetValueParameter(name="notPositionedElement", type="?") PsiElement notPositionedElement) {
            PsiElement psiElement = notPositionedElement;
            if (KotlinPackage.contains((Object[])this.getTYPES_TO_CALCULATE_CLASSNAME(), psiElement != null ? psiElement.getClass() : null)) {
                PsiElement psiElement2 = notPositionedElement;
                if (psiElement2 == null) {
                    throw new TypeCastException("com.intellij.psi.PsiElement? cannot be cast to org.jetbrains.kotlin.psi.JetElement");
                }
                return (JetElement)psiElement2;
            }
            return (JetElement)PsiTreeUtil.getParentOfType((PsiElement)notPositionedElement, (Class[])this.getTYPES_TO_CALCULATE_CLASSNAME());
        }

        @NotNull
        public final String getJvmInternalNameForPropertyOwner(@JetValueParameter(name="typeMapper") @NotNull JetTypeMapper typeMapper, @JetValueParameter(name="descriptor") @NotNull PropertyDescriptor descriptor2) {
            Intrinsics.checkParameterIsNotNull((Object)typeMapper, (String)"typeMapper");
            Intrinsics.checkParameterIsNotNull((Object)descriptor2, (String)"descriptor");
            String string = typeMapper.mapOwner(AsmUtil.isPropertyWithBackingFieldInOuterClass(descriptor2) ? descriptor2.getContainingDeclaration() : (DeclarationDescriptor)descriptor2, true).getInternalName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"typeMapper.mapOwner(\n   \u2026  true).getInternalName()");
            return string;
        }

        private final boolean isInPropertyAccessor(@JetValueParameter(name="element", type="?") PsiElement element) {
            return element instanceof JetPropertyAccessor || PsiTreeUtil.getParentOfType((PsiElement)element, (Class[])new Class[]{JetProperty.class, JetPropertyAccessor.class}) instanceof JetPropertyAccessor;
        }

        private final JetElement getElementToCreateTypeMapperForLibraryFile(@JetValueParameter(name="element", type="?") PsiElement element) {
            return element instanceof JetElement ? (JetElement)element : (JetElement)PsiTreeUtil.getParentOfType((PsiElement)element, JetElement.class);
        }

        private final String getJvmInternalNameForImpl(@JetValueParameter(name="typeMapper") JetTypeMapper typeMapper, @JetValueParameter(name="jetClass") JetClassOrObject jetClass) {
            ClassDescriptor classDescriptor = (ClassDescriptor)typeMapper.getBindingContext().get(BindingContext.CLASS, jetClass);
            if (classDescriptor == null) {
                return null;
            }
            if (jetClass instanceof JetClass && ((JetClass)jetClass).isInterface()) {
                return typeMapper.mapTraitImpl(classDescriptor).getInternalName();
            }
            return typeMapper.mapClass(classDescriptor).getInternalName();
        }

        private final JetTypeMapper createTypeMapperForLibraryFile(@JetValueParameter(name="notPositionedElement", type="?") PsiElement notPositionedElement, @JetValueParameter(name="file") JetFile file) {
            JetElement element;
            JetElement jetElement = element = this.getElementToCreateTypeMapperForLibraryFile(notPositionedElement);
            if (jetElement == null) {
                Intrinsics.throwNpe();
            }
            AnalysisResult analysisResult = ResolvePackage.analyzeAndGetResult(jetElement);
            GenerationState state = new GenerationState(file.getProject(), ClassBuilderFactories.THROW_EXCEPTION, analysisResult.getModuleDescriptor(), analysisResult.getBindingContext(), KotlinPackage.listOf((Object)file));
            state.beforeCompile();
            JetTypeMapper jetTypeMapper = state.getTypeMapper();
            Intrinsics.checkExpressionValueIsNotNull((Object)jetTypeMapper, (String)"state.getTypeMapper()");
            return jetTypeMapper;
        }

        public final boolean isInlinedLambda(@JetValueParameter(name="functionLiteral") @NotNull JetFunction functionLiteral, @JetValueParameter(name="context") @NotNull BindingContext context2) {
            Intrinsics.checkParameterIsNotNull((Object)functionLiteral, (String)"functionLiteral");
            Intrinsics.checkParameterIsNotNull((Object)context2, (String)"context");
            return InlineUtil.isInlinedArgument(functionLiteral, context2, false);
        }

        private final String createKeyForTypeMapper(@JetValueParameter(name="file") JetFile file) {
            return PackagePartClassUtils.getPackagePartInternalName(file);
        }

        private Companion() {
        }

        @NotNull
        public static final /* synthetic */ Companion access$init$2() {
            return new Companion();
        }
    }
}

