/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger;

import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.actions.JvmSmartStepIntoHandler;
import com.intellij.debugger.actions.MethodSmartStepTarget;
import com.intellij.debugger.actions.SmartStepTarget;
import com.intellij.debugger.engine.BasicStepMethodFilter;
import com.intellij.debugger.engine.CompoundPositionManager;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.JVMName;
import com.intellij.debugger.engine.MethodFilter;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.util.Range;
import com.intellij.util.containers.OrderedSet;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import java.util.Collections;
import java.util.List;
import jet.runtime.typeinfo.JetValueParameter;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.asJava.LightClassUtil;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyGetterDescriptor;
import org.jetbrains.kotlin.idea.caches.resolve.ResolvePackage;
import org.jetbrains.kotlin.idea.codeInsight.CodeInsightUtils;
import org.jetbrains.kotlin.idea.codeInsight.DescriptorToSourceUtilsIde;
import org.jetbrains.kotlin.idea.debugger.KotlinSmartStepIntoHandler;
import org.jetbrains.kotlin.idea.debugger.MockSourcePosition;
import org.jetbrains.kotlin.idea.util.application.ApplicationPackage;
import org.jetbrains.kotlin.psi.JetArrayAccessExpression;
import org.jetbrains.kotlin.psi.JetBinaryExpression;
import org.jetbrains.kotlin.psi.JetCallExpression;
import org.jetbrains.kotlin.psi.JetDoWhileExpression;
import org.jetbrains.kotlin.psi.JetElement;
import org.jetbrains.kotlin.psi.JetExpression;
import org.jetbrains.kotlin.psi.JetFile;
import org.jetbrains.kotlin.psi.JetForExpression;
import org.jetbrains.kotlin.psi.JetFunction;
import org.jetbrains.kotlin.psi.JetFunctionLiteralExpression;
import org.jetbrains.kotlin.psi.JetIfExpression;
import org.jetbrains.kotlin.psi.JetNamedFunction;
import org.jetbrains.kotlin.psi.JetObjectLiteralExpression;
import org.jetbrains.kotlin.psi.JetPropertyAccessor;
import org.jetbrains.kotlin.psi.JetSecondaryConstructor;
import org.jetbrains.kotlin.psi.JetSimpleNameExpression;
import org.jetbrains.kotlin.psi.JetTreeVisitorVoid;
import org.jetbrains.kotlin.psi.JetUnaryExpression;
import org.jetbrains.kotlin.psi.JetWhenExpression;
import org.jetbrains.kotlin.psi.JetWhileExpression;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilPackage;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;

@KotlinClass(abiVersion=23, kind=KotlinClass.Kind.CLASS, data={"\u0019\b)Q2j\u001c;mS:\u001cV.\u0019:u'R,\u0007/\u00138u_\"\u000bg\u000e\u001a7fe*\u0019qN]4\u000b\u0013),GO\u0019:bS:\u001c(BB6pi2LgN\u0003\u0003jI\u0016\f'\u0002\u00033fEV<w-\u001a:\u000b/)3XnU7beR\u001cF/\u001a9J]R|\u0007*\u00198eY\u0016\u0014(bA2p[*A\u0011N\u001c;fY2L'NC\u0004bGRLwN\\:\u000b\rqJg.\u001b;?\u0015I\u0019'/Z1uK6+G\u000f[8e\r&dG/\u001a:\u000b\u0015M$X\r\u001d+be\u001e,GOC\bT[\u0006\u0014Ho\u0015;faR\u000b'oZ3u\u00151iU\r\u001e5pI\u001aKG\u000e^3s\u0015\u0019)gnZ5oK*!b-\u001b8e'6\f'\u000f^*uKB$\u0016M]4fiNT\u0001\u0002]8tSRLwN\u001c\u0006\u000f'>,(oY3Q_NLG/[8o\u0015\u0011a\u0015n\u001d;\u000b\t)\fg/\u0019\u0006\u0005kRLGNC\rhKR$v\u000e]7pgR,E.Z7f]R\fEo\u00144gg\u0016$(bB3mK6,g\u000e\u001e\u0006\u000b!NLW\t\\3nK:$(b\u00019tS*1qN\u001a4tKRT1!\u00138u\u0015-I7/\u0011<bS2\f'\r\\3\u000b\u000f\t{w\u000e\\3b]*Y2j\u001c;mS:\u0014\u0015m]5d'R,\u0007/T3uQ>$g)\u001b7uKJT1dS8uY&tW*\u001a;i_\u0012\u001cV.\u0019:u'R,\u0007\u000fV1sO\u0016$(7\u0001\u0006\u0003!\u0005QA\u0001\u0003\u0001\u0011\u0005)!\u0001\"\u0001\t\u0004\u0015\u0011A!\u0001\u0005\u0003\u000b\t!\u0019\u0001#\u0002\u0006\u0007\u0011\u0011\u0001\u0002\u0001\u0007\u0001\u000b\u0005A9!\u0002\u0002\u0005\u0007!!QA\u0001C\u0004\u0011\u000b)!\u0001\u0002\u0003\t\n\u0015\u0019A\u0011\u0002\u0005\u0004\u0019\u0001)1\u0001\"\u0003\t\u000e1\u0001QA\u0001\u0003\u0005\u0011\u001f)1\u0001\u0002\u0004\t\u000f1\u0001QA\u0001\u0003\u0007\u0011\u001d)!\u0001\"\u0003\t\u000e\u0015\u0019A\u0001\u0002\u0005\n\u0019\u0001)\u0011\u0001c\u0001\u0006\u0007\u0011E\u00012\u0003\u0007\u0001\u000b\u0005A!\"\u0002\u0002\u0005\u0014!UQA\u0001\u0003\u000b\u0011')!\u0001\u0002\u0003\t\u0013\u0015\u0011Aq\u0001E\r\u000b\r!9\u0002\u0003\u0007\r\u0001\u0015\u0019A\u0011\u0003E\u000e\u0019\u0001)!\u0001b\u0006\t\u0019\u0015\u0019A\u0011\u0003E\u000f\u0019\u0001!1\u0001$\u0002\u001a\u0005\u0015\t\u0001\"\u0002\u000f\u00109?iS\u0003\u0002\u0006\u0019\fu=A\u0001\u0001\u0005\u0007\u001b\r)\u0011\u0001c\u0003\r\u0002A\u001b\u0001!I\u0002\u0006\u0003!5A\u0012A)\u0004\u000b\u0011-\u0011\"\u0001\u0005\b\u001b\u0005Ay!L\f\u0005\u0017aAQT\u0002\u0003\u0001\u0011#i!!B\u0001\t\u0011A\u001b\u0001!\t\u0004\u0006\u0003!I\u0011bA\u0005\u0003\u000b\u0005AY!U\u0002\u0006\t!I\u0011\u0001#\u0006\u000e\u0003!YQ6\b\u0003\u00021-ij\u0001\u0002\u0001\t\u00185\u0011Q!\u0001\u0005\r!\u000e\u0001QT\u0002\u0003\u0001\u00115i!!B\u0001\t\u001aA\u001b\t!I\u0002\u0006\u0003!aA\u0012A)\u0004\u000f\u0011Y\u0011\"\u0001\u0005\u000e\u001b\u0005AQ\"D\u0001\u0005\u00065\"Ba\u0003\r\u000f;\u001f!\u0001\u0001#\u0005\u000e\u0007\u0015\t\u0001\u0002\u0003G\u0001!\u000e\u0001\u0011EA\u0003\u0002\u00117\t6!\u0002\u0003\u000f\u0013\u0005!\t!D\u0001\t\u0017UZQA\u0003\u0003d\u0002a)\u0011EA\u0003\u0002\u0011\u000b\t6a\u0001\u0003\u0006\u0013\u0005!\u0001\u0001"})
public final class KotlinSmartStepIntoHandler
extends JvmSmartStepIntoHandler {
    public static final /* synthetic */ KClass $kotlinClass;

    static {
        $kotlinClass = Reflection.createKotlinClass(KotlinSmartStepIntoHandler.class);
    }

    public boolean isAvailable(@JetValueParameter(name="position", type="?") @Nullable SourcePosition position) {
        SourcePosition sourcePosition = position;
        return (sourcePosition != null ? sourcePosition.getFile() : null) instanceof JetFile;
    }

    @NotNull
    public List<SmartStepTarget> findSmartStepTargets(@JetValueParameter(name="position") @NotNull SourcePosition position) {
        Intrinsics.checkParameterIsNotNull((Object)position, (String)"position");
        if (position.getLine() < 0) {
            List<SmartStepTarget> list = Collections.emptyList();
            Intrinsics.checkExpressionValueIsNotNull(list, (String)"Collections.emptyList()");
            return list;
        }
        PsiFile file = position.getFile();
        Integer lineStart = CodeInsightUtils.getStartLineOffset(file, position.getLine());
        if (lineStart == null) {
            List<SmartStepTarget> list = Collections.emptyList();
            Intrinsics.checkExpressionValueIsNotNull(list, (String)"Collections.emptyList()");
            return list;
        }
        PsiElement elementAtOffset = file.findElementAt(((Number)lineStart).intValue());
        if (elementAtOffset == null) {
            List<SmartStepTarget> list = Collections.emptyList();
            Intrinsics.checkExpressionValueIsNotNull(list, (String)"Collections.emptyList()");
            return list;
        }
        PsiElement element = CodeInsightUtils.getTopmostElementAtOffset(elementAtOffset, ((Number)lineStart).intValue());
        if (!(element instanceof JetElement)) {
            List<SmartStepTarget> list = Collections.emptyList();
            Intrinsics.checkExpressionValueIsNotNull(list, (String)"Collections.emptyList()");
            return list;
        }
        TextRange elementTextRange = ((JetElement)element).getTextRange();
        if (elementTextRange == null) {
            List<SmartStepTarget> list = Collections.emptyList();
            Intrinsics.checkExpressionValueIsNotNull(list, (String)"Collections.emptyList()");
            return list;
        }
        Document doc = PsiDocumentManager.getInstance((Project)file.getProject()).getDocument(file);
        if (doc == null) {
            List<SmartStepTarget> list = Collections.emptyList();
            Intrinsics.checkExpressionValueIsNotNull(list, (String)"Collections.emptyList()");
            return list;
        }
        Range lines = new Range((Comparable)Integer.valueOf(doc.getLineNumber(elementTextRange.getStartOffset())), (Comparable)Integer.valueOf(doc.getLineNumber(elementTextRange.getEndOffset())));
        BindingContext bindingContext2 = ResolvePackage.analyze$default((JetElement)element, null, 1);
        OrderedSet result2 = new OrderedSet();
        ((JetElement)element).accept(new JetTreeVisitorVoid(bindingContext2, file, result2, lines){
            public static final /* synthetic */ KClass $kotlinClass;
            final /* synthetic */ BindingContext $bindingContext;
            final /* synthetic */ PsiFile $file;
            final /* synthetic */ OrderedSet $result;
            final /* synthetic */ Range $lines;

            static {
                $kotlinClass = Reflection.createKotlinClass(findSmartStepTargets.1.class);
            }

            public void visitFunctionLiteralExpression(@JetValueParameter(name="expression") @NotNull JetFunctionLiteralExpression expression2) {
                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            }

            public void visitObjectLiteralExpression(@JetValueParameter(name="expression") @NotNull JetObjectLiteralExpression expression2) {
                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            }

            public void visitIfExpression(@JetValueParameter(name="expression") @NotNull JetIfExpression expression2) {
                Unit unit;
                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                JetExpression jetExpression = expression2.getCondition();
                if (jetExpression != null) {
                    jetExpression.accept(this);
                    unit = Unit.INSTANCE$;
                } else {
                    unit = null;
                }
            }

            public void visitWhileExpression(@JetValueParameter(name="expression") @NotNull JetWhileExpression expression2) {
                Unit unit;
                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                JetExpression jetExpression = expression2.getCondition();
                if (jetExpression != null) {
                    jetExpression.accept(this);
                    unit = Unit.INSTANCE$;
                } else {
                    unit = null;
                }
            }

            public void visitDoWhileExpression(@JetValueParameter(name="expression") @NotNull JetDoWhileExpression expression2) {
                Unit unit;
                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                JetExpression jetExpression = expression2.getCondition();
                if (jetExpression != null) {
                    jetExpression.accept(this);
                    unit = Unit.INSTANCE$;
                } else {
                    unit = null;
                }
            }

            public void visitForExpression(@JetValueParameter(name="expression") @NotNull JetForExpression expression2) {
                Unit unit;
                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                JetExpression jetExpression = expression2.getLoopRange();
                if (jetExpression != null) {
                    jetExpression.accept(this);
                    unit = Unit.INSTANCE$;
                } else {
                    unit = null;
                }
            }

            public void visitWhenExpression(@JetValueParameter(name="expression") @NotNull JetWhenExpression expression2) {
                Unit unit;
                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                JetExpression jetExpression = expression2.getSubjectExpression();
                if (jetExpression != null) {
                    jetExpression.accept(this);
                    unit = Unit.INSTANCE$;
                } else {
                    unit = null;
                }
            }

            public void visitArrayAccessExpression(@JetValueParameter(name="expression") @NotNull JetArrayAccessExpression expression2) {
                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                this.recordFunction(expression2);
                super.visitArrayAccessExpression(expression2);
            }

            public void visitUnaryExpression(@JetValueParameter(name="expression") @NotNull JetUnaryExpression expression2) {
                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                JetExpression jetExpression = expression2.getOperationReference();
                Intrinsics.checkExpressionValueIsNotNull((Object)jetExpression, (String)"expression.getOperationReference()");
                this.recordFunction(jetExpression);
                super.visitUnaryExpression(expression2);
            }

            public void visitBinaryExpression(@JetValueParameter(name="expression") @NotNull JetBinaryExpression expression2) {
                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                JetExpression jetExpression = expression2.getOperationReference();
                Intrinsics.checkExpressionValueIsNotNull((Object)jetExpression, (String)"expression.getOperationReference()");
                this.recordFunction(jetExpression);
                super.visitBinaryExpression(expression2);
            }

            public void visitCallExpression(@JetValueParameter(name="expression") @NotNull JetCallExpression expression2) {
                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                JetExpression calleeExpression = expression2.getCalleeExpression();
                if (calleeExpression != null) {
                    this.recordFunction(calleeExpression);
                }
                super.visitCallExpression(expression2);
            }

            public void visitSimpleNameExpression(@JetValueParameter(name="expression") @NotNull JetSimpleNameExpression expression2) {
                PropertyGetterDescriptor getterDescriptor;
                CallableDescriptor propertyDescriptor;
                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                ResolvedCall<? extends CallableDescriptor> resolvedCall = CallUtilPackage.getResolvedCall(expression2, this.$bindingContext);
                if (resolvedCall != null && (propertyDescriptor = resolvedCall.getResultingDescriptor()) instanceof PropertyDescriptor && (getterDescriptor = ((PropertyDescriptor)propertyDescriptor).getGetter()) != null && !getterDescriptor.isDefault()) {
                    ResolvedCall delegatedResolvedCall = (ResolvedCall)this.$bindingContext.get(BindingContext.DELEGATED_PROPERTY_RESOLVED_CALL, getterDescriptor);
                    if (delegatedResolvedCall == null) {
                        PsiMethod psiMethod;
                        Project project = this.$file.getProject();
                        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"file.getProject()");
                        PsiElement getter = DescriptorToSourceUtilsIde.INSTANCE$.getAnyDeclaration(project, getterDescriptor);
                        if (getter instanceof JetPropertyAccessor && (((JetPropertyAccessor)getter).getBodyExpression() != null || ((JetPropertyAccessor)getter).getEqualsToken() != null) && (psiMethod = LightClassUtil.getLightClassAccessorMethod((JetPropertyAccessor)getter)) != null) {
                            this.$result.add((Object)((Object)new KotlinMethodSmartStepTarget((JetElement)getter, psiMethod, null, (PsiElement)expression2, false, (Range<Integer>)this.$lines)));
                        }
                    } else {
                        FunctionDescriptor delegatedPropertyGetterDescriptor = (FunctionDescriptor)delegatedResolvedCall.getResultingDescriptor();
                        if (delegatedPropertyGetterDescriptor instanceof CallableMemberDescriptor) {
                            Project project = this.$file.getProject();
                            Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"file.getProject()");
                            PsiElement function2 = DescriptorToSourceUtilsIde.INSTANCE$.getAnyDeclaration(project, delegatedPropertyGetterDescriptor);
                            if (function2 instanceof JetNamedFunction || function2 instanceof JetSecondaryConstructor) {
                                PsiElement psiElement = function2;
                                if (psiElement == null) {
                                    throw new TypeCastException("com.intellij.psi.PsiElement? cannot be cast to org.jetbrains.kotlin.psi.JetFunction");
                                }
                                PsiMethod psiMethod = LightClassUtil.getLightClassMethod((JetFunction)psiElement);
                                if (psiMethod != null) {
                                    this.$result.add((Object)((Object)new KotlinMethodSmartStepTarget((JetElement)function2, psiMethod, ((PropertyDescriptor)propertyDescriptor).getName() + ".", (PsiElement)expression2, false, (Range<Integer>)this.$lines)));
                                }
                            }
                        }
                    }
                }
                super.visitSimpleNameExpression(expression2);
            }

            private final void recordFunction(@JetValueParameter(name="expression") JetExpression expression2) {
                ResolvedCall<? extends CallableDescriptor> resolvedCall = CallUtilPackage.getResolvedCall(expression2, this.$bindingContext);
                if (resolvedCall == null) {
                    return;
                }
                CallableDescriptor descriptor2 = resolvedCall.getResultingDescriptor();
                if (descriptor2 instanceof CallableMemberDescriptor) {
                    Project project = this.$file.getProject();
                    Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"file.getProject()");
                    PsiElement function2 = DescriptorToSourceUtilsIde.INSTANCE$.getAnyDeclaration(project, descriptor2);
                    if (function2 instanceof JetNamedFunction || function2 instanceof JetSecondaryConstructor) {
                        PsiElement psiElement = function2;
                        if (psiElement == null) {
                            throw new TypeCastException("com.intellij.psi.PsiElement? cannot be cast to org.jetbrains.kotlin.psi.JetFunction");
                        }
                        PsiMethod psiMethod = LightClassUtil.getLightClassMethod((JetFunction)psiElement);
                        if (psiMethod != null) {
                            this.$result.add((Object)((Object)new KotlinMethodSmartStepTarget((JetElement)function2, psiMethod, null, (PsiElement)expression2, false, (Range<Integer>)this.$lines)));
                        }
                    } else if (function2 instanceof PsiMethod) {
                        this.$result.add((Object)new MethodSmartStepTarget((PsiMethod)function2, (String)null, (PsiElement)expression2, false, this.$lines));
                    }
                }
            }
            {
                this.$bindingContext = $captured_local_variable$0;
                this.$file = $captured_local_variable$1;
                this.$result = $captured_local_variable$2;
                this.$lines = $captured_local_variable$3;
            }
        }, null);
        return (List)result2;
    }

    @Nullable
    protected MethodFilter createMethodFilter(@JetValueParameter(name="stepTarget", type="?") @Nullable SmartStepTarget stepTarget) {
        if (stepTarget instanceof KotlinMethodSmartStepTarget) {
            return (MethodFilter)new KotlinBasicStepMethodFilter((KotlinMethodSmartStepTarget)stepTarget);
        }
        return super.createMethodFilter(stepTarget);
    }

    private final PsiElement getTopmostElementAtOffset(@JetValueParameter(name="element") PsiElement element, @JetValueParameter(name="offset") int offset) {
        PsiElement psiElement;
        PsiElement resultElement = element;
        while (((psiElement = resultElement) != null && (psiElement = psiElement.getParent()) != null ? psiElement.getTextRange() : null) != null) {
            PsiElement psiElement2 = resultElement;
            TextRange textRange = psiElement2 != null && (psiElement2 = psiElement2.getParent()) != null ? psiElement2.getTextRange() : null;
            if (textRange == null) {
                Intrinsics.throwNpe();
            }
            if (textRange.getStartOffset() < offset) break;
            PsiElement psiElement3 = resultElement;
            if (psiElement3 == null) {
                Intrinsics.throwNpe();
            }
            resultElement = psiElement3.getParent();
        }
        return resultElement;
    }

    @KotlinClass(abiVersion=23, kind=KotlinClass.Kind.CLASS, data={"[\u0006)Y2j\u001c;mS:\u0014\u0015m]5d'R,\u0007/T3uQ>$g)\u001b7uKJT!dS8uY&t7+\\1siN#X\r]%oi>D\u0015M\u001c3mKJT1a\u001c:h\u0015%QW\r\u001e2sC&t7O\u0003\u0004l_Rd\u0017N\u001c\u0006\u0005S\u0012,\u0017M\u0003\u0005eK\n,xmZ3s\u0015U\u0011\u0015m]5d'R,\u0007/T3uQ>$g)\u001b7uKJT1aY8n\u0015!Ig\u000e^3mY&T'BB3oO&tWM\u0003\u0004=S:LGO\u0010\u0006\u000bgR,\u0007\u000fV1sO\u0016$(bG&pi2Lg.T3uQ>$7+\\1siN#X\r\u001d+be\u001e,GO\u0003\u001cL_Rd\u0017N\\*nCJ$8\u000b^3q\u0013:$x\u000eS1oI2,'\u000fJ&pi2Lg.T3uQ>$7+\\1siN#X\r\u001d+be\u001e,GOC\u0007hKR\u001cF/\u001a9UCJ<W\r\u001e\u0006\u0010Y>\u001c\u0017\r^5p]6\u000bGo\u00195fg*9\u0001O]8dKN\u001c(\u0002\u0005#fEV<\u0007K]8dKN\u001c\u0018*\u001c9m\u0015!awnY1uS>t'\u0002\u0003'pG\u0006$\u0018n\u001c8\u000b\u0007M,hNC\u0002kI&TqAQ8pY\u0016\fg\u000ed\u0001\u000b\u0005A\u0011!\u0002\u0002\u0005\u0001!\rQA\u0001C\u0001\u0011\t)!\u0001B\u0001\t\u0006\u0015\u0011A1\u0001\u0005\u0004\u000b\r!!\u0001#\u0001\r\u0001\u0015\u0019AQ\u0001\u0005\u0001\u0019\u0001)\u0011\u0001\u0003\u0003\u0006\u0005\u0011\u001d\u0001\u0012B\u0003\u0003\t\u0011A1!\u0002\u0002\u0005\n!)Qa\u0001\u0003\u0006\u0011\u000fa\u0001!B\u0002\u0005\u0006!5A\u0002A\u0003\u0003\t\tAq!B\u0002\u0005\u000b!IA\u0002A\u0003\u0003\t\u000fA)\"\u0002\u0002\u0005\u0010!YQa\u0001\u0003\t\u0011)a\u0001!B\u0001\t\u0005\u0015\u0019A!\u0003E\f\u0019\u0001)!\u0001B\u0003\t\u0013\u0015\u0011A\u0001\u0003\u0005\u000b\t\u0001a1!\u0007\u0002\u0006\u0003!-Qf\u0004\u0003a\ta1\u0011EA\u0003\u0002\u0011\u0019)6\u0001C\u0003\u0004\t\u0019I\u0011\u0001#\u0004\u000e\u0007\u0011=\u0011\"\u0001E\u0007[s!1\u0002\u0007\u0005\u001e\u000e\u0011\u0001\u0001\u0012C\u0007\u0003\u000b\u0005Aq\u0001U\u0002\u0001;\u001b!\u0001\u0001c\u0005\u000e\u0005\u0015\t\u0001\u0012\u0003)\u0004\u0002\u0005\u0012Q!\u0001E\n#\u000e9A\u0001C\u0005\u0002\t\u0003i\u0011\u0001\u0003\u0006\u000e\u0003!UQ\u0017FC\u0014\t\r\b\u00014BO\u0007\t\u0001Aa!\u0004\u0002\u0006\u0003!1\u0001k\u0001\u0001\"\u0005\u0015\t\u0001bA)\u0004\u000b\u0011-\u0011\"\u0001\u0003\u0001\u001b\u0005Ai\u0001"})
    public static final class KotlinBasicStepMethodFilter
    extends BasicStepMethodFilter {
        public static final /* synthetic */ KClass $kotlinClass;
        @NotNull
        private final KotlinMethodSmartStepTarget stepTarget;

        static {
            $kotlinClass = Reflection.createKotlinClass(KotlinBasicStepMethodFilter.class);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean locationMatches(@JetValueParameter(name="process") @NotNull DebugProcessImpl process2, @JetValueParameter(name="location") @NotNull Location location) {
            Intrinsics.checkParameterIsNotNull((Object)process2, (String)"process");
            Intrinsics.checkParameterIsNotNull((Object)location, (String)"location");
            if (super.locationMatches(process2, location)) {
                return true;
            }
            PsiFile containingFile2 = (PsiFile)ApplicationPackage.runReadAction((Function0)new Function0<PsiFile>(this){
                final /* synthetic */ KotlinBasicStepMethodFilter this$0;

                public final PsiFile invoke() {
                    return this.this$0.getStepTarget().getResolvedElement().getContainingFile();
                }
                {
                    this.this$0 = kotlinBasicStepMethodFilter;
                    super(0);
                }
            });
            if (!(containingFile2 instanceof JetFile)) {
                return false;
            }
            CompoundPositionManager positionManager = process2.getPositionManager();
            if (positionManager == null) {
                return false;
            }
            List classes2 = positionManager.getAllClasses((SourcePosition)new MockSourcePosition(containingFile2, (PsiElement)this.stepTarget.getResolvedElement(), null, null, null, 28, null));
            Method method = location.method();
            if (!Intrinsics.areEqual((Object)this.stepTarget.getMethod().getName(), (Object)method.name())) return false;
            JVMName jVMName = this.myTargetMethodSignature;
            if (!Intrinsics.areEqual((Object)(jVMName != null ? jVMName.getName(process2) : null), (Object)method.signature())) return false;
            if (!classes2.contains(location.declaringType())) return false;
            return true;
        }

        @NotNull
        public final KotlinMethodSmartStepTarget getStepTarget() {
            return this.stepTarget;
        }

        public KotlinBasicStepMethodFilter(@JetValueParameter(name="stepTarget") @NotNull KotlinMethodSmartStepTarget stepTarget) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)stepTarget), (String)"stepTarget");
            super(stepTarget.getMethod(), stepTarget.getCallingExpressionLines());
            this.stepTarget = stepTarget;
        }
    }

    @KotlinClass(abiVersion=23, kind=KotlinClass.Kind.CLASS, data={"W\u0006)Y2j\u001c;mS:lU\r\u001e5pINk\u0017M\u001d;Ti\u0016\u0004H+\u0019:hKRT!dS8uY&t7+\\1siN#X\r]%oi>D\u0015M\u001c3mKJT1a\u001c:h\u0015%QW\r\u001e2sC&t7O\u0003\u0004l_Rd\u0017N\u001c\u0006\u0005S\u0012,\u0017M\u0003\u0005eK\n,xmZ3s\u0015UiU\r\u001e5pINk\u0017M\u001d;Ti\u0016\u0004H+\u0019:hKRT1aY8n\u0015!Ig\u000e^3mY&T'bB1di&|gn\u001d\u0006\u0007y%t\u0017\u000e\u001e \u000b\u001fI,7o\u001c7wK\u0012,E.Z7f]RT!BS3u\u000b2,W.\u001a8u\u0015\r\u00018/\u001b\u0006\naNLW*\u001a;i_\u0012T\u0011\u0002U:j\u001b\u0016$\bn\u001c3\u000b\u000b1\f'-\u001a7\u000b\rM#(/\u001b8h\u0015AA\u0017n\u001a5mS\u001eDG/\u00127f[\u0016tGO\u0003\u0006Qg&,E.Z7f]RTQC\\3fI\n\u0013X-Y6q_&tGOU3rk\u0016\u001cHOC\u0004C_>dW-\u00198\u000b\u000b1Lg.Z:\u000b\u000bI\u000bgnZ3\u000b\tU$\u0018\u000e\u001c\u0006\u0004\u0013:$(\u0002\u00026bm\u0006TA\u0001\\1oO*\u0011r-\u001a;SKN|GN^3e\u000b2,W.\u001a8u\u0001\bQ!\u0001\u0005\u0002\u000b\t!\u0001\u0001c\u0001\u0006\u0005\u0011\u0005\u0001BA\u0003\u0003\t\u0005A)!\u0002\u0002\u0005\u0004!\u0019Qa\u0001\u0003\u0003\u0011\u0003a\u0001!B\u0002\u0005\u0006!\u0001A\u0002A\u0003\u0002\u0011\u0011)!\u0001b\u0002\t\n\u0015\u0011A\u0001\u0002\u0005\u0004\u000b\t!I\u0001C\u0003\u0006\u0007\u0011)\u0001r\u0001\u0007\u0001\u000b\t!\u0011\u0001C\u0004\u0006\u0007\u00111\u0001R\u0002\u0007\u0001\u000b\t!A\u0001C\u0004\u0006\u0007\u00119\u0001\u0002\u0003\u0007\u0001\u000b\u0005A!!B\u0002\u0005\u0011!IA\u0002A\u0003\u0004\t\u001dA!\u0002\u0004\u0001\u0006\u0007\u0011A\u0001b\u0003\u0007\u0001\u000b\t!A\u0001#\u0007\u0006\u0007\u0011Q\u0001\u0002\u0004\u0007\u0001\u000b\r!\u0001\u0002C\u0007\r\u0001\u0015\u0011AA\u0002E\u0007\u000b\t!q\u0001\u0003\u0005\u0006\u0003!mQA\u0001C\r\u00119)!\u0001B\u0007\t\u0013\u0015\u0011Aa\u0002\u0005\u000b\u000b\t!!\u0002\u0003\u0007\u0005\u00011\u0019\u0011DA\u0003\u0002\u0011\u0017is\u0002\u00021\u00051\u0019\t#!B\u0001\t\u000eU\u001b\u0001\"B\u0002\u0005\r%\t\u0001rC\u0007\u0004\t;I\u0011\u0001c\u00066\u0014\u0004)\u0001\u001a\u0001\u0003d\u0002a-QT\u0002\u0003\u0001\u0011\u0019i!!B\u0001\t\u000eA\u001b\u0001!(\u0004\u0005\u0001!=QBA\u0003\u0002\u0011\u001f\u00016\u0011AO\b\t\u0001A\t\"D\u0002\u0006\u0003!EA\u0012\u0001)\u0004\u0003u5A\u0001\u0001E\n\u001b\t)\u0011\u0001C\u0005Q\u0007\u0007ij\u0001\u0002\u0001\t\u00165\u0011Q!\u0001E\n!\u000e\u0011QT\u0003\u0003\u0001\u0011/ia!B\u0001\t\u0016%\u0019\u0011BA\u0003\u0002\u0011-\u00016QA\u0011\u0003\u000b\u0005A1!U\u0002\u0010\t\u0017I\u0011\u0001\u0002\u0001\u000e\u0003!]Q\"\u0001\u0005\r\u001b\u0005AY\"D\u0001\t\u001d5\tA\u0011A\u0007\u0002\u0011;\u0001"})
    public static final class KotlinMethodSmartStepTarget
    extends MethodSmartStepTarget {
        public static final /* synthetic */ KClass $kotlinClass;
        @NotNull
        private final JetElement resolvedElement;

        static {
            $kotlinClass = Reflection.createKotlinClass(KotlinMethodSmartStepTarget.class);
        }

        @NotNull
        public final JetElement getResolvedElement() {
            return this.resolvedElement;
        }

        public KotlinMethodSmartStepTarget(@JetValueParameter(name="resolvedElement") @NotNull JetElement resolvedElement, @JetValueParameter(name="psiMethod") @NotNull PsiMethod psiMethod, @JetValueParameter(name="label", type="?") @Nullable String label, @JetValueParameter(name="highlightElement") @NotNull PsiElement highlightElement, @JetValueParameter(name="needBreakpointRequest") boolean needBreakpointRequest, @JetValueParameter(name="lines") @NotNull Range<Integer> lines) {
            Intrinsics.checkParameterIsNotNull((Object)resolvedElement, (String)"resolvedElement");
            Intrinsics.checkParameterIsNotNull((Object)psiMethod, (String)"psiMethod");
            Intrinsics.checkParameterIsNotNull((Object)highlightElement, (String)"highlightElement");
            Intrinsics.checkParameterIsNotNull(lines, (String)"lines");
            super(psiMethod, label, highlightElement, needBreakpointRequest, lines);
            this.resolvedElement = resolvedElement;
        }
    }
}

