/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.filters;

import com.intellij.execution.filters.ExceptionFilter;
import com.intellij.execution.filters.Filter;
import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.execution.filters.OpenFileHyperlinkInfo;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.GlobalSearchScope;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.KotlinPackage;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.util.DebuggerUtils;
import org.jetbrains.kotlin.load.kotlin.PackageClassUtils;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.JetFile;
import org.jetbrains.kotlin.resolve.jvm.JvmClassName;

public class JetExceptionFilter
implements Filter {
    private final ExceptionFilter exceptionFilter;
    private final GlobalSearchScope searchScope;
    private static final Pattern STACK_TRACE_ELEMENT_PATTERN = Pattern.compile("^[\\w|\\s]*at\\s+(.+)\\.(.+)\\((.+):(\\d+)\\)\\s*$");

    public JetExceptionFilter(@NotNull GlobalSearchScope searchScope2) {
        if (searchScope2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "searchScope", "org/jetbrains/kotlin/idea/filters/JetExceptionFilter", "<init>"));
        }
        this.exceptionFilter = new ExceptionFilter(searchScope2);
        this.searchScope = searchScope2;
    }

    @Nullable
    private HyperlinkInfo createHyperlinkInfo(@NotNull String line) {
        if (line == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "line", "org/jetbrains/kotlin/idea/filters/JetExceptionFilter", "createHyperlinkInfo"));
        }
        Project project = this.searchScope.getProject();
        if (project == null) {
            return null;
        }
        StackTraceElement element = JetExceptionFilter.parseStackTraceLine(line);
        if (element == null) {
            return null;
        }
        String fileName = element.getFileName();
        String fullyQualifiedName = element.getClassName();
        if (!JetExceptionFilter.isPackageClassOrPackagePartPrefixedName(fullyQualifiedName)) {
            return null;
        }
        String internalName = fullyQualifiedName.replace('.', '/');
        JvmClassName jvmClassName = JvmClassName.byInternalName(internalName);
        JetFile file = DebuggerUtils.findSourceFileForClass(project, this.searchScope, jvmClassName, fileName, element.getLineNumber() - 1);
        if (file == null) {
            return null;
        }
        VirtualFile virtualFile = file.getVirtualFile();
        if (virtualFile == null) {
            return null;
        }
        return new OpenFileHyperlinkInfo(project, virtualFile, element.getLineNumber() - 1);
    }

    private static boolean isPackageClassOrPackagePartPrefixedName(String fqName2) {
        if (fqName2.equals(PackageClassUtils.getPackageClassName(FqName.ROOT))) {
            return true;
        }
        int lastDot = fqName2.lastIndexOf(46);
        String classNameWithInners = fqName2.substring(lastDot + 1);
        int firstDollar = classNameWithInners.indexOf(36);
        String className = firstDollar >= 0 ? classNameWithInners.substring(0, firstDollar) : classNameWithInners;
        String packageClassName = PackageClassUtils.getPackageClassName(new FqName(fqName2).parent());
        return packageClassName.equals(className);
    }

    @Nullable
    private static StackTraceElement parseStackTraceLine(@NotNull String line) {
        if (line == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "line", "org/jetbrains/kotlin/idea/filters/JetExceptionFilter", "parseStackTraceLine"));
        }
        Matcher matcher = STACK_TRACE_ELEMENT_PATTERN.matcher(line);
        if (matcher.matches()) {
            String declaringClass = matcher.group(1);
            String methodName = matcher.group(2);
            String fileName = matcher.group(3);
            String lineNumber = matcher.group(4);
            return new StackTraceElement(declaringClass, methodName, fileName, Integer.parseInt(lineNumber));
        }
        return null;
    }

    @NotNull
    private Filter.Result patchResult(@NotNull Filter.Result result2, @NotNull String line) {
        if (result2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "org/jetbrains/kotlin/idea/filters/JetExceptionFilter", "patchResult"));
        }
        if (line == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "line", "org/jetbrains/kotlin/idea/filters/JetExceptionFilter", "patchResult"));
        }
        final HyperlinkInfo newHyperlinkInfo = this.createHyperlinkInfo(line);
        if (newHyperlinkInfo == null) {
            Filter.Result result3 = result2;
            if (result3 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/filters/JetExceptionFilter", "patchResult"));
            }
            return result3;
        }
        Filter.Result result4 = new Filter.Result(KotlinPackage.map((Iterable)result2.getResultItems(), (Function1)new Function1<Filter.ResultItem, Filter.ResultItem>(){

            public Filter.ResultItem invoke(Filter.ResultItem item) {
                return new Filter.ResultItem(item.getHighlightStartOffset(), item.getHighlightEndOffset(), newHyperlinkInfo, item.getHighlightAttributes());
            }
        }));
        if (result4 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/filters/JetExceptionFilter", "patchResult"));
        }
        return result4;
    }

    @Nullable
    public Filter.Result applyFilter(String line, int entireLength) {
        Filter.Result result2 = this.exceptionFilter.applyFilter(line, entireLength);
        return result2 == null ? null : this.patchResult(result2, line);
    }
}

