/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.highlighter;

import com.google.common.base.Predicate;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.diagnostics.rendering.TabledDescriptorRenderer;
import org.jetbrains.kotlin.idea.highlighter.IdeRenderers;
import org.jetbrains.kotlin.idea.highlighter.renderersUtil.RenderersUtilPackage;
import org.jetbrains.kotlin.renderer.DescriptorRenderer;
import org.jetbrains.kotlin.renderer.DescriptorRendererBuilder;
import org.jetbrains.kotlin.renderer.Renderer;
import org.jetbrains.kotlin.resolve.calls.inference.constraintPosition.ConstraintPosition;
import org.jetbrains.kotlin.resolve.calls.inference.constraintPosition.ConstraintPositionKind;
import org.jetbrains.kotlin.types.JetType;

public class HtmlTabledDescriptorRenderer
extends TabledDescriptorRenderer {
    private static final DescriptorRenderer.ValueParametersHandler VALUE_PARAMETERS_HANDLER = new DescriptorRenderer.ValueParametersHandler(){

        @Override
        public void appendBeforeValueParameter(@NotNull ValueParameterDescriptor parameter, @NotNull StringBuilder stringBuilder) {
            if (parameter == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameter", "org/jetbrains/kotlin/idea/highlighter/HtmlTabledDescriptorRenderer$1", "appendBeforeValueParameter"));
            }
            if (stringBuilder == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stringBuilder", "org/jetbrains/kotlin/idea/highlighter/HtmlTabledDescriptorRenderer$1", "appendBeforeValueParameter"));
            }
            stringBuilder.append("<td align=\"right\" style=\"white-space:nowrap;font-weight:bold;\">");
        }

        @Override
        public void appendAfterValueParameter(@NotNull ValueParameterDescriptor parameter, @NotNull StringBuilder stringBuilder) {
            boolean last;
            if (parameter == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameter", "org/jetbrains/kotlin/idea/highlighter/HtmlTabledDescriptorRenderer$1", "appendAfterValueParameter"));
            }
            if (stringBuilder == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stringBuilder", "org/jetbrains/kotlin/idea/highlighter/HtmlTabledDescriptorRenderer$1", "appendAfterValueParameter"));
            }
            boolean bl = last = ((FunctionDescriptor)parameter.getContainingDeclaration()).getValueParameters().size() - 1 == parameter.getIndex();
            if (!last) {
                stringBuilder.append(",");
            }
            stringBuilder.append("</td>");
        }

        @Override
        public void appendBeforeValueParameters(@NotNull FunctionDescriptor function2, @NotNull StringBuilder stringBuilder) {
            if (function2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "org/jetbrains/kotlin/idea/highlighter/HtmlTabledDescriptorRenderer$1", "appendBeforeValueParameters"));
            }
            if (stringBuilder == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stringBuilder", "org/jetbrains/kotlin/idea/highlighter/HtmlTabledDescriptorRenderer$1", "appendBeforeValueParameters"));
            }
            stringBuilder.append("</td>");
            if (function2.getValueParameters().isEmpty()) {
                HtmlTabledDescriptorRenderer.tdBold(stringBuilder, "( )");
            } else {
                HtmlTabledDescriptorRenderer.tdBold(stringBuilder, "(");
            }
        }

        @Override
        public void appendAfterValueParameters(@NotNull FunctionDescriptor function2, @NotNull StringBuilder stringBuilder) {
            if (function2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "org/jetbrains/kotlin/idea/highlighter/HtmlTabledDescriptorRenderer$1", "appendAfterValueParameters"));
            }
            if (stringBuilder == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stringBuilder", "org/jetbrains/kotlin/idea/highlighter/HtmlTabledDescriptorRenderer$1", "appendAfterValueParameters"));
            }
            if (!function2.getValueParameters().isEmpty()) {
                HtmlTabledDescriptorRenderer.tdBold(stringBuilder, ")");
            }
            stringBuilder.append("<td style=\"white-space:nowrap;font-weight:bold;\">");
        }
    };
    public static final DescriptorRenderer DESCRIPTOR_IN_TABLE = new DescriptorRendererBuilder().setWithDefinedIn(false).setModifiers(new DescriptorRenderer.Modifier[0]).setValueParametersHandler(VALUE_PARAMETERS_HANDLER).setTextFormat(DescriptorRenderer.TextFormat.HTML).build();

    @Override
    @NotNull
    public Renderer<JetType> getTypeRenderer() {
        Renderer<JetType> renderer = IdeRenderers.HTML_RENDER_TYPE;
        if (renderer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/highlighter/HtmlTabledDescriptorRenderer", "getTypeRenderer"));
        }
        return renderer;
    }

    @Override
    protected void renderText(TabledDescriptorRenderer.TextRenderer textRenderer, StringBuilder result2) {
        for (TabledDescriptorRenderer.TextRenderer.TextElement element : textRenderer.elements) {
            HtmlTabledDescriptorRenderer.renderText(result2, element.type, element.text);
        }
    }

    private static void renderText(StringBuilder result2, TabledDescriptorRenderer.TextElementType elementType, String text) {
        if (elementType == TabledDescriptorRenderer.TextElementType.DEFAULT) {
            result2.append(text);
        } else if (elementType == TabledDescriptorRenderer.TextElementType.ERROR) {
            result2.append(RenderersUtilPackage.renderError(text));
        } else if (elementType == TabledDescriptorRenderer.TextElementType.STRONG) {
            result2.append(RenderersUtilPackage.renderStrong(text));
        }
    }

    private static int countColumnNumber(TabledDescriptorRenderer.TableRenderer table) {
        int argumentsNumber = 0;
        for (TabledDescriptorRenderer.TableRenderer.TableRow row : table.rows) {
            int argumentTypesNumber;
            if (row instanceof TabledDescriptorRenderer.TableRenderer.DescriptorRow) {
                int valueParametersNumber = ((TabledDescriptorRenderer.TableRenderer.DescriptorRow)row).descriptor.getValueParameters().size();
                if (valueParametersNumber <= argumentsNumber) continue;
                argumentsNumber = valueParametersNumber;
                continue;
            }
            if (!(row instanceof TabledDescriptorRenderer.TableRenderer.FunctionArgumentsRow) || (argumentTypesNumber = ((TabledDescriptorRenderer.TableRenderer.FunctionArgumentsRow)row).argumentTypes.size()) <= argumentsNumber) continue;
            argumentsNumber = argumentTypesNumber;
        }
        return argumentsNumber + 6;
    }

    @Override
    protected void renderTable(TabledDescriptorRenderer.TableRenderer table, StringBuilder result2) {
        if (table.rows.isEmpty()) {
            return;
        }
        int rowsNumber = HtmlTabledDescriptorRenderer.countColumnNumber(table);
        result2.append("<table>");
        for (TabledDescriptorRenderer.TableRenderer.TableRow row : table.rows) {
            result2.append("<tr>");
            if (row instanceof TabledDescriptorRenderer.TextRenderer) {
                StringBuilder rowText = new StringBuilder();
                this.renderText((TabledDescriptorRenderer.TextRenderer)row, rowText);
                HtmlTabledDescriptorRenderer.tdColspan(result2, rowText.toString(), rowsNumber);
            }
            if (row instanceof TabledDescriptorRenderer.TableRenderer.DescriptorRow) {
                HtmlTabledDescriptorRenderer.tdSpace(result2);
                HtmlTabledDescriptorRenderer.tdRightBoldColspan(result2, 2, DESCRIPTOR_IN_TABLE.render(((TabledDescriptorRenderer.TableRenderer.DescriptorRow)row).descriptor));
            }
            if (row instanceof TabledDescriptorRenderer.TableRenderer.FunctionArgumentsRow) {
                TabledDescriptorRenderer.TableRenderer.FunctionArgumentsRow functionArgumentsRow = (TabledDescriptorRenderer.TableRenderer.FunctionArgumentsRow)row;
                this.renderFunctionArguments(functionArgumentsRow.receiverType, functionArgumentsRow.argumentTypes, functionArgumentsRow.isErrorPosition, result2);
            }
            result2.append("</tr>");
        }
        result2.append("</table>");
    }

    private void renderFunctionArguments(@Nullable JetType receiverType, @NotNull List<JetType> argumentTypes, Predicate<ConstraintPosition> isErrorPosition, StringBuilder result2) {
        if (argumentTypes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "argumentTypes", "org/jetbrains/kotlin/idea/highlighter/HtmlTabledDescriptorRenderer", "renderFunctionArguments"));
        }
        boolean hasReceiver = receiverType != null;
        HtmlTabledDescriptorRenderer.tdSpace(result2);
        String receiver = "";
        if (hasReceiver) {
            boolean error = false;
            if (isErrorPosition.apply((Object)ConstraintPositionKind.RECEIVER_POSITION.position())) {
                error = true;
            }
            receiver = "receiver: " + RenderersUtilPackage.renderStrong(this.getTypeRenderer().render(receiverType), error);
        }
        HtmlTabledDescriptorRenderer.td(result2, receiver);
        HtmlTabledDescriptorRenderer.td(result2, hasReceiver ? "arguments: " : "");
        if (argumentTypes.isEmpty()) {
            HtmlTabledDescriptorRenderer.tdBold(result2, "( )");
            return;
        }
        HtmlTabledDescriptorRenderer.td(result2, RenderersUtilPackage.renderStrong("("));
        int i = 0;
        Iterator<JetType> iterator2 = argumentTypes.iterator();
        while (iterator2.hasNext()) {
            JetType argumentType = iterator2.next();
            boolean error = false;
            if (isErrorPosition.apply((Object)ConstraintPositionKind.VALUE_PARAMETER_POSITION.position(i))) {
                error = true;
            }
            String renderedArgument = this.getTypeRenderer().render(argumentType);
            HtmlTabledDescriptorRenderer.tdRight(result2, RenderersUtilPackage.renderStrong(renderedArgument, error) + (iterator2.hasNext() ? RenderersUtilPackage.renderStrong(",") : ""));
            ++i;
        }
        HtmlTabledDescriptorRenderer.td(result2, RenderersUtilPackage.renderStrong(")"));
    }

    public static HtmlTabledDescriptorRenderer create() {
        return new HtmlTabledDescriptorRenderer();
    }

    protected HtmlTabledDescriptorRenderer() {
    }

    private static void td(StringBuilder builder, String text) {
        builder.append("<td style=\"white-space:nowrap;\">").append(text).append("</td>");
    }

    private static void tdSpace(StringBuilder builder) {
        builder.append("<td width=\"10%\"></td>");
    }

    private static void tdColspan(StringBuilder builder, String text, int colspan) {
        builder.append("<td colspan=\"").append(colspan).append("\" style=\"white-space:nowrap;\">").append(text).append("</td>");
    }

    private static void tdBold(StringBuilder builder, String text) {
        builder.append("<td style=\"white-space:nowrap;font-weight:bold;\">").append(text).append("</td>");
    }

    private static void tdRight(StringBuilder builder, String text) {
        builder.append("<td align=\"right\" style=\"white-space:nowrap;\">").append(text).append("</td>");
    }

    private static void tdRightBoldColspan(StringBuilder builder, int colspan, String text) {
        builder.append("<td align=\"right\" colspan=\"").append(colspan).append("\" style=\"white-space:nowrap;font-weight:bold;\">").append(text).append("</td>");
    }

    public static String tableForTypes(String message, String firstDescription, TabledDescriptorRenderer.TextElementType firstType, String secondDescription, TabledDescriptorRenderer.TextElementType secondType) {
        StringBuilder result2 = new StringBuilder();
        result2.append("<html>").append(message);
        result2.append("<table><tr><td>").append(firstDescription).append("</td><td>");
        HtmlTabledDescriptorRenderer.renderText(result2, firstType, "{0}");
        result2.append("</td></tr><tr><td>").append(secondDescription).append("</td><td>");
        HtmlTabledDescriptorRenderer.renderText(result2, secondType, "{1}");
        result2.append("</td></tr></table></html>");
        return result2.toString();
    }
}

