/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.highlighter;

import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.idea.highlighter.AfterAnalysisHighlightingVisitor;
import org.jetbrains.kotlin.idea.highlighter.JetHighlightingColors;
import org.jetbrains.kotlin.idea.highlighter.JetPsiChecker;
import org.jetbrains.kotlin.psi.JetClass;
import org.jetbrains.kotlin.psi.JetDynamicType;
import org.jetbrains.kotlin.psi.JetEnumEntry;
import org.jetbrains.kotlin.psi.JetObjectDeclarationName;
import org.jetbrains.kotlin.psi.JetSimpleNameExpression;
import org.jetbrains.kotlin.psi.JetTypeParameter;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilPackage;
import org.jetbrains.kotlin.resolve.BindingContext;

class TypeKindHighlightingVisitor
extends AfterAnalysisHighlightingVisitor {
    TypeKindHighlightingVisitor(AnnotationHolder holder, BindingContext bindingContext2) {
        super(holder, bindingContext2);
    }

    @Override
    public void visitSimpleNameExpression(@NotNull JetSimpleNameExpression expression2) {
        if (expression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/idea/highlighter/TypeKindHighlightingVisitor", "visitSimpleNameExpression"));
        }
        PsiReference ref = expression2.getReference();
        if (ref == null) {
            return;
        }
        if (JetPsiChecker.Companion.getNamesHighlightingEnabled()) {
            DeclarationDescriptor referenceTarget = this.bindingContext.get(BindingContext.REFERENCE_TARGET, expression2);
            if (referenceTarget instanceof ConstructorDescriptor) {
                referenceTarget = referenceTarget.getContainingDeclaration();
            }
            if (referenceTarget instanceof ClassDescriptor) {
                TextAttributesKey textAttributesKey = TypeKindHighlightingVisitor.textAttributesKeyForClass((ClassDescriptor)referenceTarget);
                if (textAttributesKey == JetHighlightingColors.ANNOTATION) {
                    this.highlightAnnotation(expression2);
                } else {
                    this.highlightName((PsiElement)expression2, textAttributesKey);
                }
            } else if (referenceTarget instanceof TypeParameterDescriptor) {
                this.highlightName((PsiElement)expression2, JetHighlightingColors.TYPE_PARAMETER);
            }
        }
    }

    private void highlightAnnotation(@NotNull JetSimpleNameExpression expression2) {
        if (expression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/idea/highlighter/TypeKindHighlightingVisitor", "highlightAnnotation"));
        }
        TextRange toHighlight = PsiUtilPackage.getCalleeHighlightingRange(expression2);
        JetPsiChecker.highlightName(this.holder, toHighlight, JetHighlightingColors.ANNOTATION);
    }

    @Override
    public void visitObjectDeclarationName(@NotNull JetObjectDeclarationName declaration) {
        if (declaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declaration", "org/jetbrains/kotlin/idea/highlighter/TypeKindHighlightingVisitor", "visitObjectDeclarationName"));
        }
        PsiElement nameIdentifier = declaration.getNameIdentifier();
        if (nameIdentifier != null) {
            this.highlightName(nameIdentifier, JetHighlightingColors.CLASS);
        }
    }

    @Override
    public void visitTypeParameter(@NotNull JetTypeParameter parameter) {
        if (parameter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameter", "org/jetbrains/kotlin/idea/highlighter/TypeKindHighlightingVisitor", "visitTypeParameter"));
        }
        PsiElement identifier = parameter.getNameIdentifier();
        if (identifier != null) {
            this.highlightName(identifier, JetHighlightingColors.TYPE_PARAMETER);
        }
        super.visitTypeParameter(parameter);
    }

    @Override
    public void visitEnumEntry(@NotNull JetEnumEntry enumEntry) {
        if (enumEntry == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "enumEntry", "org/jetbrains/kotlin/idea/highlighter/TypeKindHighlightingVisitor", "visitEnumEntry"));
        }
    }

    @Override
    public void visitClass(@NotNull JetClass klass) {
        if (klass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "klass", "org/jetbrains/kotlin/idea/highlighter/TypeKindHighlightingVisitor", "visitClass"));
        }
        PsiElement identifier = klass.getNameIdentifier();
        ClassDescriptor classDescriptor = this.bindingContext.get(BindingContext.CLASS, klass);
        if (identifier != null && classDescriptor != null) {
            this.highlightName(identifier, TypeKindHighlightingVisitor.textAttributesKeyForClass(classDescriptor));
        }
        super.visitClass(klass);
    }

    @Override
    public void visitDynamicType(@NotNull JetDynamicType type2) {
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/idea/highlighter/TypeKindHighlightingVisitor", "visitDynamicType"));
        }
    }

    private void highlightName(@NotNull PsiElement whatToHighlight, @NotNull TextAttributesKey textAttributesKey) {
        if (whatToHighlight == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "whatToHighlight", "org/jetbrains/kotlin/idea/highlighter/TypeKindHighlightingVisitor", "highlightName"));
        }
        if (textAttributesKey == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "textAttributesKey", "org/jetbrains/kotlin/idea/highlighter/TypeKindHighlightingVisitor", "highlightName"));
        }
        JetPsiChecker.highlightName(this.holder, whatToHighlight, textAttributesKey);
    }

    @NotNull
    private static TextAttributesKey textAttributesKeyForClass(@NotNull ClassDescriptor descriptor2) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/idea/highlighter/TypeKindHighlightingVisitor", "textAttributesKeyForClass"));
        }
        switch (descriptor2.getKind()) {
            case INTERFACE: {
                TextAttributesKey textAttributesKey = JetHighlightingColors.TRAIT;
                if (textAttributesKey == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/highlighter/TypeKindHighlightingVisitor", "textAttributesKeyForClass"));
                }
                return textAttributesKey;
            }
            case ANNOTATION_CLASS: {
                TextAttributesKey textAttributesKey = JetHighlightingColors.ANNOTATION;
                if (textAttributesKey == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/highlighter/TypeKindHighlightingVisitor", "textAttributesKeyForClass"));
                }
                return textAttributesKey;
            }
            case OBJECT: {
                TextAttributesKey textAttributesKey = JetHighlightingColors.OBJECT;
                if (textAttributesKey == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/highlighter/TypeKindHighlightingVisitor", "textAttributesKeyForClass"));
                }
                return textAttributesKey;
            }
            case ENUM_ENTRY: {
                TextAttributesKey textAttributesKey = JetHighlightingColors.INSTANCE_PROPERTY;
                if (textAttributesKey == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/highlighter/TypeKindHighlightingVisitor", "textAttributesKeyForClass"));
                }
                return textAttributesKey;
            }
        }
        TextAttributesKey textAttributesKey = descriptor2.getModality() == Modality.ABSTRACT ? JetHighlightingColors.ABSTRACT_CLASS : JetHighlightingColors.CLASS;
        if (textAttributesKey == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/highlighter/TypeKindHighlightingVisitor", "textAttributesKeyForClass"));
        }
        return textAttributesKey;
    }
}

