/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiImportList;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.impl.compiled.ClsClassImpl;
import java.util.ArrayList;
import java.util.List;
import jet.runtime.typeinfo.JetValueParameter;
import kotlin.KotlinPackage;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.inspections.ReplaceDeprecatedFunctionClassUsages;
import org.jetbrains.kotlin.idea.util.ProjectRootsUtil;
import org.jetbrains.kotlin.load.java.lazy.DeprecatedFunctionClassFqNameParser;

@KotlinClass(abiVersion=23, kind=KotlinClass.Kind.CLASS, data={"\u0015\u0006)!#+\u001a9mC\u000e,G)\u001a9sK\u000e\fG/\u001a3Gk:\u001cG/[8o\u00072\f7o]+tC\u001e,7OC\u0002pe\u001eT\u0011B[3uEJ\f\u0017N\\:\u000b\r-|G\u000f\\5o\u0015\u0011IG-Z1\u000b\u0017%t7\u000f]3di&|gn\u001d\u0006\u0014\u0019>\u001c\u0017\r\\%ogB,7\r^5p]R{w\u000e\u001c\u0006\u0004G>l'\u0002C5oi\u0016dG.\u001b6\u000b\u001d\r|G-Z%ogB,7\r^5p]*1A(\u001b8jizR\u0011b\u00195fG.4\u0015\u000e\\3\u000b\t\u0019LG.\u001a\u0006\b!NLg)\u001b7f\u0015\r\u00018/\u001b\u0006\b[\u0006t\u0017mZ3s\u0015EIen\u001d9fGRLwN\\'b]\u0006<WM\u001d\u0006\u000bSN|e\u000e\u00165f\r2L(b\u0002\"p_2,\u0017M\u001c\u0006\u0006\u0003J\u0014\u0018-\u001f\u0006\u0012!J|'\r\\3n\t\u0016\u001c8M]5qi>\u0014(b\u0003)tS*\u000bg/\u0019$jY\u0016T\u0011bQ8na\u0006t\u0017n\u001c8\u000b\u0007\u0019K\u0007Pd\u0001\u000b\u0005A\t!\u0002\u0002\u0005\u0001!\tQA\u0001C\u0001\u0011\u0007)!\u0001B\u0001\t\u0005\u0015\u0011A1\u0001E\u0003\u000b\r!!\u0001\u0003\u0001\r\u0001\u0015\t\u0001rA\u0003\u0003\t\rAA!\u0002\u0002\u0005\b!%Qa\u0001\u0003\u0005\u0011\ra\u0001!\u0002\u0002\u0005\b!9Qa\u0001\u0003\u0006\u0011\u001ba\u0001!B\u0002\u0005\t!AA\u0002A\u0003\u0002\u0011\u0007)1\u0001\"\u0004\t\u00131\u0001Qa\u0001C\u0007\u0011'a\u0001!B\u0002\u0005\t!QA\u0002A\u0003\u0003\t\u0011A!\"\u0002\u0002\u0005\u000b!5QA\u0001\u0003\u0005\u0011!)1\u0001B\u0003\t\u00161\u0001QA\u0001\u0003\u0006\u0011+!1\u0001$\u0002\u0011\u0017e\u0011Q!\u0001E\u00059-a:\"\f\u0017\u0005\u0017a-QT\u0002\u0003\u0001\u0011\u0019i!!B\u0001\t\fA\u001b\u0001!(\u0004\u0005\u0001!=QBA\u0003\u0002\u0011\u0019\u00016\u0011AO\u0007\t\u0001A\t\"\u0004\u0002\u0006\u0003!9\u0001kA\u0001\"\u000f\u0015\t\u0001rB\u0005\u0004\u0013\t)\u0011\u0001\u0003\u0005\r\u0002E\u001b!\u0002b\u0003\n\u0005!EA\u0012A\u0007\u0002\u0011%i\u0011\u0001c\u0005\u000e\u0003\u0011\u0005Q6\b\u0003\u00041\u0017ij\u0001\u0002\u0001\t\r5\u0011Q!\u0001\u0005\u000b!\u000e\u0001QT\u0002\u0003\u0001\u0011\u001fi!!B\u0001\t\rA\u001b\t!I\u0002\u0006\u0003!AA\u0012A)\u0004\u000f\u0011-\u0011\"\u0001E\t\u001b\u0005A)\"D\u0001\t\u0014UZQA\u0003\u0003d\u0002a)\u0011EA\u0003\u0002\u0011\u000b\t6a\u0001\u0003\u0006\u0013\u0005!\u0001\u0001"})
public final class ReplaceDeprecatedFunctionClassUsages
extends LocalInspectionTool {
    public static final /* synthetic */ KClass $kotlinClass;
    @NotNull
    public static final String MESSAGE = "Replace usages of deprecated Kotlin function classes in Java sources";
    public static final Companion Companion;
    @Deprecated
    public static final Companion OBJECT$;

    static {
        $kotlinClass = Reflection.createKotlinClass(ReplaceDeprecatedFunctionClassUsages.class);
        OBJECT$ = Companion = org.jetbrains.kotlin.idea.inspections.ReplaceDeprecatedFunctionClassUsages$Companion.access$init$0();
        MESSAGE = MESSAGE;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public ProblemDescriptor[] checkFile(@JetValueParameter(name="file") @NotNull PsiFile file, @JetValueParameter(name="manager") @NotNull InspectionManager manager, @JetValueParameter(name="isOnTheFly") boolean isOnTheFly) {
        ProblemDescriptor[] problemDescriptorArray;
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        Intrinsics.checkParameterIsNotNull((Object)manager, (String)"manager");
        if (isOnTheFly || !ProjectRootsUtil.isInProjectSource((PsiElement)file) || !(file instanceof PsiJavaFile)) {
            return null;
        }
        ProblemDescriptor problemDescriptor = this.checkFile((PsiJavaFile)file, manager);
        if (problemDescriptor != null) {
            void $receiver;
            ProblemDescriptor problemDescriptor2 = problemDescriptor;
            ProblemDescriptor it = (ProblemDescriptor)$receiver;
            problemDescriptorArray = new ProblemDescriptor[]{it};
        } else {
            problemDescriptorArray = null;
        }
        return problemDescriptorArray;
    }

    @Nullable
    public final ProblemDescriptor checkFile(@JetValueParameter(name="file") @NotNull PsiJavaFile file, @JetValueParameter(name="manager") @NotNull InspectionManager manager) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        Intrinsics.checkParameterIsNotNull((Object)manager, (String)"manager");
        ArrayList references = new ArrayList(0);
        file.acceptChildren((PsiElementVisitor)new JavaRecursiveElementVisitor(references){
            public static final /* synthetic */ KClass $kotlinClass;
            final /* synthetic */ ArrayList $references;

            static {
                $kotlinClass = Reflection.createKotlinClass(checkFile.2.class);
            }

            public void visitReferenceElement(@JetValueParameter(name="reference") @NotNull PsiJavaCodeReferenceElement reference) {
                Intrinsics.checkParameterIsNotNull((Object)reference, (String)"reference");
                if (KotlinPackage.contains$default((String)reference.getText(), (CharSequence)"Function", (boolean)false, (int)2) && ReplaceDeprecatedFunctionClassUsages.Companion.extractFunctionClassFqName((PsiReference)reference) != null) {
                    this.$references.add(reference);
                }
                super.visitElement((PsiElement)reference);
            }

            public void visitImportList(@JetValueParameter(name="list", type="?") @Nullable PsiImportList list) {
            }
            {
                this.$references = $captured_local_variable$0;
            }
        });
        return references.isEmpty() ? (ProblemDescriptor)null : manager.createProblemDescriptor((PsiElement)file, Companion.getMESSAGE(), false, (LocalQuickFix[])new Fix[]{new Fix(references)}, ProblemHighlightType.GENERIC_ERROR_OR_WARNING);
    }

    @KotlinClass(abiVersion=23, kind=KotlinClass.Kind.CLASS, data={"I\u0006)\u0019a)\u001b=\u000bII+\u0007\u000f\\1dK\u0012+\u0007O]3dCR,GMR;oGRLwN\\\"mCN\u001cXk]1hKNT1a\u001c:h\u0015%QW\r\u001e2sC&t7O\u0003\u0004l_Rd\u0017N\u001c\u0006\u0005S\u0012,\u0017MC\u0006j]N\u0004Xm\u0019;j_:\u001c(\"\u0004'pG\u0006d\u0017+^5dW\u001aK\u0007PC\u0002d_6T\u0001\"\u001b8uK2d\u0017N\u001b\u0006\u000fG>$W-\u00138ta\u0016\u001cG/[8o\u0015\u0019a\u0014N\\5u})Q!/\u001a4fe\u0016t7-Z:\u000b\t1K7\u000f\u001e\u0006\u001c!NL'*\u0019<b\u0007>$WMU3gKJ,gnY3FY\u0016lWM\u001c;\u000b\u0007A\u001c\u0018N\u0003\u0003kCZ\f'\u0002B;uS2TQbZ3u%\u00164WM]3oG\u0016\u001c(\u0002C1qa2Lh)\u001b=\u000b\u000fA\u0014xN[3di*9\u0001K]8kK\u000e$(bB8qK:\f\u0007/\u001b\u0006\baJ|'\r\\3n\u0015E\u0001&o\u001c2mK6$Um]2sSB$xN\u001d\u0006\u0005+:LGOC\u0007hKR4\u0015-\\5ms:\u000bW.\u001a\u0006\u0007'R\u0014\u0018N\\4\u000b\t1\fgn\u001a\u0006\bO\u0016$h*Y7fe\u0007Q!\u0001\u0005\u0002\u000b\t!\u0001\u0001c\u0001\u0006\u0005\u0011\u0005\u0001BA\u0003\u0003\t\u0005A)!\u0002\u0002\u0005\u0004!\u0019Qa\u0001\u0003\u0003\u0011\u0003a\u0001!B\u0002\u0005\u0006!\u0001A\u0002A\u0003\u0002\u0011\u0011)!\u0001b\u0002\t\n\u0015\u0011A\u0001\u0002\u0005\u0006\u000b\r!I\u0001c\u0002\r\u0001\u0015\t\u0001BA\u0003\u0004\t\u0017Ai\u0001\u0004\u0001\u0006\u0005\u0011!\u0001rB\u0003\u0004\t\u001bAq\u0001\u0004\u0001\u0006\u0003!AQA\u0001C\b\u0011#)!\u0001\u0002\u0005\t\u000e\u0015\u0011A\u0001\u0002\u0005\f\u000b\t!\u0011\u0002\u0003\u0006\u0006\u0007\u0011M\u0001R\u0003\u0007\u0001\u000b\r!I\u0001\u0003\u0007\r\u0001\u0015\u0019A1\u0002E\r\u0019\u0001)!\u0001b\u0005\t\u0016\u0015\u0011A\u0011\u0002\u0005\r\u000b\r!Y\u0001c\u0007\r\u0001\u0015\u0011Aq\u0002\u0005\u000f\u000b\t!Q\u0002c\u0007\u0005\u00031\u0019\u0011DA\u0003\u0002\u0011\u0015i3\u0003\u00021\u00051\u0019\tc!B\u0001\t\r%\u0019\u0011BA\u0003\u0002\u0011\u001d)6\u0001C\u0003\u0004\t\u0019I\u0011\u0001#\u0005\u000e\u0007\u0011I\u0011\"\u0001E\t[s!1\u0002g\u0005\u001e\u000e\u0011\u0001\u0001BC\u0007\u0003\u000b\u0005A!\u0002U\u0002\u0001;\u001b!\u0001\u0001c\u0006\u000e\u0005\u0015\t\u0001R\u0003)\u0004\u0002\u0005\u0012Q!\u0001\u0005\f#\u000e9A1C\u0005\u0002\t\u0001i\u0011\u0001c\u0006\u000e\u0003!aQ6\u0003\u0003\f15\t#!B\u0001\t\u001aE\u001b1\u0001B\u0007\n\u0003!mQ6\u0003\u0003\f1;\t#!B\u0001\t\u001aE\u001b1\u0001\"\b\n\u0003!mQ\u0017GC\u0018\t\r\b\u00014BO\u000b\t\u0001Aa!\u0004\u0004\u0006\u0003!1\u0011bA\u0005\u0003\u000b\u0005Aq\u0001U\u0002\u0001C\t)\u0011\u0001C\u0002R\u0007\u0015!Y!C\u0001\u0005\u00015\t\u0001\u0012\u0003"})
    private static final class Fix
    implements LocalQuickFix {
        public static final /* synthetic */ KClass $kotlinClass;
        @NotNull
        private final List<? extends PsiJavaCodeReferenceElement> references;

        static {
            $kotlinClass = Reflection.createKotlinClass(Fix.class);
        }

        @NotNull
        public String getName() {
            return Companion.getMESSAGE();
        }

        @NotNull
        public String getFamilyName() {
            return Companion.getMESSAGE();
        }

        public void applyFix(@JetValueParameter(name="project") @NotNull Project project, @JetValueParameter(name="problem") @NotNull ProblemDescriptor problem) {
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            Intrinsics.checkParameterIsNotNull((Object)problem, (String)"problem");
            JavaPsiFacade psiFacade = JavaPsiFacade.getInstance((Project)project);
            JavaCodeStyleManager codeStyleManager = JavaCodeStyleManager.getInstance((Project)project);
            ArrayList<PsiElement> newReferences = new ArrayList<PsiElement>(this.references.size());
            for (PsiJavaCodeReferenceElement psiJavaCodeReferenceElement : this.references) {
                String newFqName;
                if (Companion.extractFunctionClassFqName((PsiReference)psiJavaCodeReferenceElement) == null) {
                    continue;
                }
                PsiClass newClass = psiFacade.findClass(newFqName, psiJavaCodeReferenceElement.getResolveScope());
                if (newClass == null) continue;
                newReferences.add(psiJavaCodeReferenceElement.bindToElement((PsiElement)newClass));
            }
            codeStyleManager.optimizeImports(problem.getPsiElement().getContainingFile());
            for (PsiElement psiElement : newReferences) {
                codeStyleManager.shortenClassReferences(psiElement);
            }
        }

        @NotNull
        public final List<PsiJavaCodeReferenceElement> getReferences() {
            return this.references;
        }

        public Fix(@JetValueParameter(name="references") @NotNull List<? extends PsiJavaCodeReferenceElement> references) {
            Intrinsics.checkParameterIsNotNull(references, (String)"references");
            this.references = references;
        }
    }

    @KotlinClass(abiVersion=23, kind=KotlinClass.Kind.CLASS, data={"T\u0004)I1i\\7qC:LwN\u001c\u0006%%\u0016\u0004H.Y2f\t\u0016\u0004(/Z2bi\u0016$g)\u001e8di&|gn\u00117bgN,6/Y4fg*\u0019qN]4\u000b\u0013),GO\u0019:bS:\u001c(BB6pi2LgN\u0003\u0003jI\u0016\f'bC5ogB,7\r^5p]NT1!\u00118z\u0015\u001diUiU*B\u000f\u0016Saa\u0015;sS:<'\u0002\u00026bm\u0006TA\u0001\\1oO*Qq-\u001a;N\u000bN\u001b\u0016iR#\u000b5\u0015DHO]1di\u001a+hn\u0019;j_:\u001cE.Y:t\rFt\u0015-\\3\u000b\u0013I,g-\u001a:f]\u000e,'\u0002\u0004)tSJ+g-\u001a:f]\u000e,'bA2p[*A\u0011N\u001c;fY2L'NC\u0002qg&t'B\u0001\t\u0003\u0015\u0011A\u0001\u0001E\u0002\u000b\t!\t\u0001\u0003\u0002\u0006\u0005\u0011\t\u0001RA\u0003\u0003\t\u0007A1!B\u0002\u0005\u0005!\u0005A\u0002A\u0003\u0004\t\u000bA\u0001\u0001\u0004\u0001\u0006\u0003!\u0011Qa\u0001C\u0004\u0011\u000fa\u0001!B\u0002\u0005\b!%A\u0002A\u0003\u0002\u0011\u0015)!\u0001B\u0003\t\f\u0015\u0011A1\u0002E\u0005\u000b\u0005A\u0001\"\u0002\u0002\u0005\u000e!EQA\u0001\u0003\b\u0011%)1\u0001b\u0004\t\u00101\u0001QA\u0001C\b\u0011\u001f!19\u0001\u0007\u00043\t)\u0011\u0001\u0003\u0003.!\u0011\u0001G\u0003\u0007\u0003\"\u0005\u0015\t\u0001\u0012B+\u0004\u0013\u0015!A\u0001B\u0005\u0002\u0011\u0019a\t!D\u0002\u0005\r%\t\u0001BB\u0017\u0015\t\u0001Aj!(\u0004\u0005\u0001!9QBA\u0003\u0002\u0011!\u00016\u0001A\u0011\u0004\u000b\u0005AI\u0001$\u0001R\u0007\u0015!i!C\u0001\t\r5\t\u0001\u0012C\u001b\u0001"})
    public static final class Companion {
        public static final /* synthetic */ KClass $kotlinClass;

        static {
            $kotlinClass = Reflection.createKotlinClass(Companion.class);
        }

        @NotNull
        public final String getMESSAGE() {
            return MESSAGE;
        }

        @Nullable
        public final String extractFunctionClassFqName(@JetValueParameter(name="reference") @NotNull PsiReference reference) {
            Object object;
            Intrinsics.checkParameterIsNotNull((Object)reference, (String)"reference");
            PsiElement psiElement = reference.resolve();
            if (!(psiElement instanceof ClsClassImpl)) {
                psiElement = null;
            }
            if ((object = (ClsClassImpl)psiElement) == null || (object = object.getQualifiedName()) == null) {
                return null;
            }
            Object fqName2 = object;
            Pair<String, String> pair2 = DeprecatedFunctionClassFqNameParser.INSTANCE$.extractOldAndNewFqName((String)fqName2);
            return pair2 != null ? (String)pair2.getSecond() : null;
        }

        private Companion() {
        }

        @NotNull
        public static final /* synthetic */ Companion access$init$0() {
            return new Companion();
        }
    }
}

