/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.liveTemplates.macro;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.ExpressionContext;
import com.intellij.codeInsight.template.Macro;
import com.intellij.codeInsight.template.Result;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.idea.JetBundle;
import org.jetbrains.kotlin.idea.caches.resolve.ResolvePackage;
import org.jetbrains.kotlin.idea.liveTemplates.macro.AnonymousTemplateEditingListener;
import org.jetbrains.kotlin.idea.liveTemplates.macro.JetPsiElementResult;
import org.jetbrains.kotlin.psi.JetExpression;
import org.jetbrains.kotlin.psi.JetFile;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;
import org.jetbrains.kotlin.resolve.scopes.DescriptorKindFilter;
import org.jetbrains.kotlin.resolve.scopes.JetScope;

public class JetAnonymousSuperMacro
extends Macro {
    public String getName() {
        return "anonymousSuper";
    }

    public String getPresentableName() {
        return JetBundle.message("macro.fun.anonymousSuper", new Object[0]);
    }

    public Result calculateResult(@NotNull Expression[] params2, ExpressionContext context2) {
        if (params2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "params", "org/jetbrains/kotlin/idea/liveTemplates/macro/JetAnonymousSuperMacro", "calculateResult"));
        }
        AnonymousTemplateEditingListener.registerListener(context2.getEditor(), context2.getProject());
        PsiNamedElement[] vars = JetAnonymousSuperMacro.getSupertypes(params2, context2);
        if (vars == null || vars.length == 0) {
            return null;
        }
        return new JetPsiElementResult(vars[0]);
    }

    public LookupElement[] calculateLookupItems(@NotNull Expression[] params2, ExpressionContext context2) {
        if (params2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "params", "org/jetbrains/kotlin/idea/liveTemplates/macro/JetAnonymousSuperMacro", "calculateLookupItems"));
        }
        PsiNamedElement[] vars = JetAnonymousSuperMacro.getSupertypes(params2, context2);
        if (vars == null || vars.length < 2) {
            return null;
        }
        LinkedHashSet<LookupElementBuilder> set = new LinkedHashSet<LookupElementBuilder>();
        for (PsiNamedElement var : vars) {
            set.add(LookupElementBuilder.create((PsiNamedElement)var));
        }
        return set.toArray(new LookupElement[set.size()]);
    }

    @Nullable
    private static PsiNamedElement[] getSupertypes(Expression[] params2, ExpressionContext context2) {
        if (params2.length != 0) {
            return null;
        }
        Project project = context2.getProject();
        PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        PsiFile psiFile = PsiDocumentManager.getInstance((Project)project).getPsiFile(context2.getEditor().getDocument());
        if (!(psiFile instanceof JetFile)) {
            return null;
        }
        JetExpression expression2 = (JetExpression)PsiTreeUtil.getParentOfType((PsiElement)psiFile.findElementAt(context2.getStartOffset()), JetExpression.class);
        if (expression2 == null) {
            return null;
        }
        BindingContext bc = ResolvePackage.analyze(expression2, BodyResolveMode.FULL);
        JetScope scope2 = bc.get(BindingContext.RESOLUTION_SCOPE, expression2);
        if (scope2 == null) {
            return null;
        }
        ArrayList<PsiNamedElement> result2 = new ArrayList<PsiNamedElement>();
        for (DeclarationDescriptor descriptor2 : scope2.getDescriptors(DescriptorKindFilter.NON_SINGLETON_CLASSIFIERS, JetScope.ALL_NAME_FILTER)) {
            PsiElement declaration;
            ClassKind kind2;
            ClassDescriptor classDescriptor;
            if (!(descriptor2 instanceof ClassDescriptor) || !(classDescriptor = (ClassDescriptor)descriptor2).getModality().isOverridable() || (kind2 = classDescriptor.getKind()) != ClassKind.INTERFACE && kind2 != ClassKind.CLASS || (declaration = DescriptorToSourceUtils.descriptorToDeclaration(descriptor2)) == null) continue;
            result2.add((PsiNamedElement)declaration);
        }
        return result2.toArray(new PsiNamedElement[result2.size()]);
    }
}

