/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.quickfix;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import java.util.Collection;
import java.util.List;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.idea.JetBundle;
import org.jetbrains.kotlin.idea.caches.resolve.ResolvePackage;
import org.jetbrains.kotlin.idea.core.refactoring.JetNameSuggester;
import org.jetbrains.kotlin.idea.core.refactoring.JetNameValidator;
import org.jetbrains.kotlin.idea.core.refactoring.SimpleCollectingValidator;
import org.jetbrains.kotlin.idea.quickfix.ChangeFunctionSignatureFix;
import org.jetbrains.kotlin.idea.refactoring.changeSignature.ChangeSignaturePackage;
import org.jetbrains.kotlin.idea.refactoring.changeSignature.JetChangeSignatureConfiguration;
import org.jetbrains.kotlin.idea.refactoring.changeSignature.JetMethodDescriptor;
import org.jetbrains.kotlin.idea.refactoring.changeSignature.JetMutableMethodDescriptor;
import org.jetbrains.kotlin.idea.refactoring.changeSignature.JetParameterInfo;
import org.jetbrains.kotlin.idea.refactoring.changeSignature.JetValVar;
import org.jetbrains.kotlin.psi.JetFile;
import org.jetbrains.kotlin.psi.JetFunctionLiteral;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.types.JetType;

public class ChangeFunctionLiteralSignatureFix
extends ChangeFunctionSignatureFix {
    private final List<JetType> parameterTypes;

    public ChangeFunctionLiteralSignatureFix(@NotNull JetFunctionLiteral functionLiteral, @NotNull FunctionDescriptor functionDescriptor, @NotNull List<JetType> parameterTypes) {
        if (functionLiteral == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionLiteral", "org/jetbrains/kotlin/idea/quickfix/ChangeFunctionLiteralSignatureFix", "<init>"));
        }
        if (functionDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionDescriptor", "org/jetbrains/kotlin/idea/quickfix/ChangeFunctionLiteralSignatureFix", "<init>"));
        }
        if (parameterTypes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameterTypes", "org/jetbrains/kotlin/idea/quickfix/ChangeFunctionLiteralSignatureFix", "<init>"));
        }
        super(functionLiteral, functionDescriptor);
        this.parameterTypes = parameterTypes;
    }

    @NotNull
    public String getText() {
        String string = JetBundle.message("change.function.literal.signature", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/quickfix/ChangeFunctionLiteralSignatureFix", "getText"));
        }
        return string;
    }

    @Override
    protected void invoke(@NotNull Project project, Editor editor, JetFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/kotlin/idea/quickfix/ChangeFunctionLiteralSignatureFix", "invoke"));
        }
        BindingContext bindingContext2 = ResolvePackage.analyzeFully(file);
        ChangeSignaturePackage.runChangeSignature(project, this.functionDescriptor, new JetChangeSignatureConfiguration(){

            @Override
            @NotNull
            public JetMethodDescriptor configure(@NotNull JetMethodDescriptor originalDescriptor, @NotNull BindingContext bindingContext2) {
                if (originalDescriptor == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "originalDescriptor", "org/jetbrains/kotlin/idea/quickfix/ChangeFunctionLiteralSignatureFix$1", "configure"));
                }
                if (bindingContext2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bindingContext", "org/jetbrains/kotlin/idea/quickfix/ChangeFunctionLiteralSignatureFix$1", "configure"));
                }
                JetMethodDescriptor jetMethodDescriptor = ChangeSignaturePackage.modify(originalDescriptor, (Function1<? super JetMutableMethodDescriptor, ? extends Unit>)new Function1<JetMutableMethodDescriptor, Unit>(){

                    public Unit invoke(JetMutableMethodDescriptor descriptor2) {
                        SimpleCollectingValidator validator2 = new SimpleCollectingValidator();
                        descriptor2.clearNonReceiverParameters();
                        for (JetType type2 : ChangeFunctionLiteralSignatureFix.this.parameterTypes) {
                            String name2 = JetNameSuggester.suggestNames(type2, (JetNameValidator)validator2, "param")[0];
                            descriptor2.addParameter(new JetParameterInfo(ChangeFunctionLiteralSignatureFix.this.functionDescriptor, -1, name2, type2, null, null, JetValVar.None, null));
                        }
                        return null;
                    }
                });
                if (jetMethodDescriptor == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/quickfix/ChangeFunctionLiteralSignatureFix$1", "configure"));
                }
                return jetMethodDescriptor;
            }

            @Override
            public boolean performSilently(@NotNull Collection<? extends PsiElement> elements) {
                if (elements == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "org/jetbrains/kotlin/idea/quickfix/ChangeFunctionLiteralSignatureFix$1", "performSilently"));
                }
                return false;
            }

            @Override
            public boolean forcePerformForSelectedFunctionOnly() {
                return false;
            }
        }, bindingContext2, this.context, this.getText());
    }
}

