/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.quickfix;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateBuilderImpl;
import com.intellij.codeInsight.template.TemplateEditingAdapter;
import com.intellij.codeInsight.template.TemplateEditingListener;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.rename.inplace.MyLookupExpression;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.DiagnosticWithParameters1;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.idea.JetBundle;
import org.jetbrains.kotlin.idea.caches.resolve.ResolvePackage;
import org.jetbrains.kotlin.idea.core.quickfix.QuickFixUtil;
import org.jetbrains.kotlin.idea.quickfix.JetIntentionAction;
import org.jetbrains.kotlin.idea.quickfix.JetSingleIntentionActionFactory;
import org.jetbrains.kotlin.psi.JetDotQualifiedExpression;
import org.jetbrains.kotlin.psi.JetExpression;
import org.jetbrains.kotlin.psi.JetFile;
import org.jetbrains.kotlin.psi.JetImportDirective;
import org.jetbrains.kotlin.psi.JetReferenceExpression;
import org.jetbrains.kotlin.psi.JetSimpleNameExpression;
import org.jetbrains.kotlin.psi.JetTypeArgumentList;
import org.jetbrains.kotlin.psi.JetTypeElement;
import org.jetbrains.kotlin.psi.JetTypeReference;
import org.jetbrains.kotlin.psi.JetUserType;
import org.jetbrains.kotlin.psi.PsiPackage;
import org.jetbrains.kotlin.renderer.DescriptorRenderer;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.diagnostics.Diagnostics;

public class MapPlatformClassToKotlinFix
extends JetIntentionAction<JetReferenceExpression> {
    private static final String PRIMARY_USAGE = "PrimaryUsage";
    private static final String OTHER_USAGE = "OtherUsage";
    private final ClassDescriptor platformClass;
    private final Collection<ClassDescriptor> possibleClasses;

    public MapPlatformClassToKotlinFix(@NotNull JetReferenceExpression element, @NotNull ClassDescriptor platformClass, @NotNull Collection<ClassDescriptor> possibleClasses) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/idea/quickfix/MapPlatformClassToKotlinFix", "<init>"));
        }
        if (platformClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "platformClass", "org/jetbrains/kotlin/idea/quickfix/MapPlatformClassToKotlinFix", "<init>"));
        }
        if (possibleClasses == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "possibleClasses", "org/jetbrains/kotlin/idea/quickfix/MapPlatformClassToKotlinFix", "<init>"));
        }
        super(element);
        this.platformClass = platformClass;
        this.possibleClasses = possibleClasses;
    }

    @NotNull
    public String getText() {
        String platformClassQualifiedName = DescriptorRenderer.FQ_NAMES_IN_TYPES.renderType(this.platformClass.getDefaultType());
        String string = this.possibleClasses.size() == 1 ? JetBundle.message("map.platform.class.to.kotlin", platformClassQualifiedName, DescriptorRenderer.FQ_NAMES_IN_TYPES.renderType(this.possibleClasses.iterator().next().getDefaultType())) : JetBundle.message("map.platform.class.to.kotlin.multiple", platformClassQualifiedName);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/quickfix/MapPlatformClassToKotlinFix", "getText"));
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = JetBundle.message("map.platform.class.to.kotlin.family", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/quickfix/MapPlatformClassToKotlinFix", "getFamilyName"));
        }
        return string;
    }

    @Override
    public void invoke(@NotNull Project project, Editor editor, JetFile file) throws IncorrectOperationException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/kotlin/idea/quickfix/MapPlatformClassToKotlinFix", "invoke"));
        }
        BindingContext context2 = ResolvePackage.analyzeFully(file);
        Diagnostics diagnostics = context2.getDiagnostics();
        ArrayList<JetImportDirective> imports = new ArrayList<JetImportDirective>();
        ArrayList<JetUserType> usages2 = new ArrayList<JetUserType>();
        for (Diagnostic diagnostic : diagnostics) {
            ClassDescriptor descriptor2;
            JetReferenceExpression refExpr;
            if (diagnostic.getFactory() != Errors.PLATFORM_CLASS_MAPPED_TO_KOTLIN || (refExpr = MapPlatformClassToKotlinFix.getImportOrUsageFromDiagnostic(diagnostic)) == null || (descriptor2 = MapPlatformClassToKotlinFix.resolveToClass(refExpr, context2)) == null || !descriptor2.equals(this.platformClass)) continue;
            JetImportDirective imp = (JetImportDirective)PsiTreeUtil.getParentOfType((PsiElement)refExpr, JetImportDirective.class);
            if (imp == null) {
                JetUserType type2 = (JetUserType)PsiTreeUtil.getParentOfType((PsiElement)refExpr, JetUserType.class);
                if (type2 == null) continue;
                usages2.add(type2);
                continue;
            }
            imports.add(imp);
        }
        for (JetImportDirective imp : imports) {
            imp.delete();
        }
        if (usages2.isEmpty()) {
            return;
        }
        List<PsiElement> replacedElements = this.replaceUsagesWithFirstClass(project, usages2);
        if (this.possibleClasses.size() > 1) {
            LinkedHashSet<String> possibleTypes = new LinkedHashSet<String>();
            for (ClassDescriptor klass : this.possibleClasses) {
                possibleTypes.add(klass.getName().asString());
            }
            MapPlatformClassToKotlinFix.buildAndShowTemplate(project, editor, (PsiFile)file, replacedElements, possibleTypes);
        }
    }

    private List<PsiElement> replaceUsagesWithFirstClass(Project project, List<JetUserType> usages2) {
        ClassDescriptor replacementClass = this.possibleClasses.iterator().next();
        String replacementClassName = replacementClass.getName().asString();
        ArrayList<PsiElement> replacedElements = new ArrayList<PsiElement>();
        for (JetUserType usage : usages2) {
            JetTypeArgumentList typeArguments = usage.getTypeArgumentList();
            String typeArgumentsString = typeArguments == null ? "" : typeArguments.getText();
            JetTypeReference replacementType = PsiPackage.JetPsiFactory(project).createType(replacementClassName + typeArgumentsString);
            JetTypeElement replacementTypeElement = replacementType.getTypeElement();
            assert (replacementTypeElement != null);
            PsiElement replacedElement = usage.replace((PsiElement)replacementTypeElement);
            PsiElement replacedExpression = replacedElement.getFirstChild();
            assert (replacedExpression instanceof JetSimpleNameExpression);
            replacedElements.add(replacedExpression);
        }
        return replacedElements;
    }

    private static void buildAndShowTemplate(Project project, Editor editor, PsiFile file, Collection<PsiElement> replacedElements, LinkedHashSet<String> options) {
        PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        PsiDocumentManager.getInstance((Project)project).doPostponedOperationsAndUnblockDocument(editor.getDocument());
        PsiElement primaryReplacedExpression = replacedElements.iterator().next();
        final CaretModel caretModel = editor.getCaretModel();
        final int oldOffset = caretModel.getOffset();
        caretModel.moveToOffset(file.getNode().getStartOffset());
        TemplateBuilderImpl builder = new TemplateBuilderImpl((PsiElement)file);
        MyLookupExpression expression2 = new MyLookupExpression(primaryReplacedExpression.getText(), options, null, null, false, JetBundle.message("map.platform.class.to.kotlin.advertisement", new Object[0]));
        builder.replaceElement(primaryReplacedExpression, PRIMARY_USAGE, (Expression)expression2, true);
        for (PsiElement replacedExpression : replacedElements) {
            if (replacedExpression == primaryReplacedExpression) continue;
            builder.replaceElement(replacedExpression, OTHER_USAGE, PRIMARY_USAGE, false);
        }
        TemplateManager.getInstance((Project)project).startTemplate(editor, builder.buildInlineTemplate(), (TemplateEditingListener)new TemplateEditingAdapter(){

            public void templateFinished(Template template, boolean brokenOff) {
                caretModel.moveToOffset(oldOffset);
            }
        });
    }

    private static JetReferenceExpression getImportOrUsageFromDiagnostic(@NotNull Diagnostic diagnostic) {
        JetReferenceExpression typeExpr;
        if (diagnostic == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "diagnostic", "org/jetbrains/kotlin/idea/quickfix/MapPlatformClassToKotlinFix", "getImportOrUsageFromDiagnostic"));
        }
        JetImportDirective imp = QuickFixUtil.getParentElementOfType(diagnostic, JetImportDirective.class);
        if (imp == null) {
            JetUserType type2 = QuickFixUtil.getParentElementOfType(diagnostic, JetUserType.class);
            if (type2 == null) {
                return null;
            }
            typeExpr = type2.getReferenceExpression();
        } else {
            JetExpression importRef = imp.getImportedReference();
            if (importRef == null || !(importRef instanceof JetDotQualifiedExpression)) {
                return null;
            }
            JetExpression refExpr = ((JetDotQualifiedExpression)importRef).getSelectorExpression();
            if (refExpr == null || !(refExpr instanceof JetReferenceExpression)) {
                return null;
            }
            typeExpr = (JetReferenceExpression)refExpr;
        }
        return typeExpr;
    }

    public static JetSingleIntentionActionFactory createFactory() {
        return new JetSingleIntentionActionFactory(){

            @Override
            @Nullable
            public IntentionAction createAction(Diagnostic diagnostic) {
                JetReferenceExpression typeExpr = MapPlatformClassToKotlinFix.getImportOrUsageFromDiagnostic(diagnostic);
                if (typeExpr == null) {
                    return null;
                }
                PsiFile psiFile = diagnostic.getPsiFile();
                if (!(psiFile instanceof JetFile)) {
                    return null;
                }
                BindingContext context2 = ResolvePackage.analyzeFully((JetFile)psiFile);
                ClassDescriptor platformClass = MapPlatformClassToKotlinFix.resolveToClass(typeExpr, context2);
                if (platformClass == null) {
                    return null;
                }
                DiagnosticWithParameters1 parametrizedDiagnostic = (DiagnosticWithParameters1)Errors.PLATFORM_CLASS_MAPPED_TO_KOTLIN.cast(diagnostic);
                return new MapPlatformClassToKotlinFix(typeExpr, platformClass, (Collection)parametrizedDiagnostic.getA());
            }
        };
    }

    @Nullable
    private static ClassDescriptor resolveToClass(@NotNull JetReferenceExpression referenceExpression, @NotNull BindingContext context2) {
        if (referenceExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "referenceExpression", "org/jetbrains/kotlin/idea/quickfix/MapPlatformClassToKotlinFix", "resolveToClass"));
        }
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/idea/quickfix/MapPlatformClassToKotlinFix", "resolveToClass"));
        }
        DeclarationDescriptor descriptor2 = context2.get(BindingContext.REFERENCE_TARGET, referenceExpression);
        Collection<? extends DeclarationDescriptor> ambiguousTargets = context2.get(BindingContext.AMBIGUOUS_REFERENCE_TARGET, referenceExpression);
        if (descriptor2 instanceof ClassDescriptor) {
            return (ClassDescriptor)descriptor2;
        }
        if (ambiguousTargets != null) {
            for (DeclarationDescriptor declarationDescriptor : ambiguousTargets) {
                if (!(declarationDescriptor instanceof ClassDescriptor)) continue;
                return (ClassDescriptor)declarationDescriptor;
            }
        }
        return null;
    }
}

