/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.quickfix;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.idea.JetBundle;
import org.jetbrains.kotlin.idea.core.quickfix.QuickFixUtil;
import org.jetbrains.kotlin.idea.quickfix.JetIntentionAction;
import org.jetbrains.kotlin.idea.quickfix.JetSingleIntentionActionFactory;
import org.jetbrains.kotlin.lexer.JetTokens;
import org.jetbrains.kotlin.psi.JetDelegationSpecifier;
import org.jetbrains.kotlin.psi.JetFile;

public class RemoveSupertypeFix
extends JetIntentionAction<JetDelegationSpecifier> {
    private final JetDelegationSpecifier superClass;

    public RemoveSupertypeFix(@NotNull JetDelegationSpecifier superClass) {
        if (superClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "superClass", "org/jetbrains/kotlin/idea/quickfix/RemoveSupertypeFix", "<init>"));
        }
        super(superClass);
        this.superClass = superClass;
    }

    @NotNull
    public String getText() {
        String string = JetBundle.message("remove.supertype", this.superClass.getText());
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/quickfix/RemoveSupertypeFix", "getText"));
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = JetBundle.message("remove.supertype.family", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/quickfix/RemoveSupertypeFix", "getFamilyName"));
        }
        return string;
    }

    @Override
    public void invoke(@NotNull Project project, Editor editor, JetFile file) throws IncorrectOperationException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/kotlin/idea/quickfix/RemoveSupertypeFix", "invoke"));
        }
        PsiElement prevSibling = this.superClass.getPrevSibling();
        assert (prevSibling != null) : "A PSI element should exist before supertype declaration";
        ASTNode prev2 = PsiImplUtil.skipWhitespaceAndCommentsBack((ASTNode)prevSibling.getNode());
        assert (prev2 != null) : "A non-whitespace element should exist before supertype declaration";
        if (prev2.getElementType() == JetTokens.COMMA) {
            prev2.getPsi().delete();
        }
        this.superClass.delete();
    }

    public static JetSingleIntentionActionFactory createFactory() {
        return new JetSingleIntentionActionFactory(){

            @Override
            public JetIntentionAction<JetDelegationSpecifier> createAction(Diagnostic diagnostic) {
                JetDelegationSpecifier superClass = QuickFixUtil.getParentElementOfType(diagnostic, JetDelegationSpecifier.class);
                if (superClass == null) {
                    return null;
                }
                return new RemoveSupertypeFix(superClass);
            }
        };
    }
}

