/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.refactoring.changeSignature;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.changeSignature.ChangeInfo;
import com.intellij.refactoring.changeSignature.ChangeSignatureProcessorBase;
import com.intellij.refactoring.changeSignature.ChangeSignatureUsageProcessor;
import com.intellij.refactoring.changeSignature.JavaChangeInfo;
import com.intellij.refactoring.changeSignature.JavaChangeSignatureUsageProcessor;
import com.intellij.refactoring.changeSignature.OverriderUsageInfo;
import com.intellij.refactoring.rename.RenameUtil;
import com.intellij.refactoring.ui.ConflictsDialog;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewDescriptor;
import com.intellij.util.containers.HashSet;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Set;
import kotlin.KotlinPackage;
import kotlin.Pair;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.refactoring.changeSignature.ChangeSignaturePackage;
import org.jetbrains.kotlin.idea.refactoring.changeSignature.JetChangeInfo;
import org.jetbrains.kotlin.idea.refactoring.changeSignature.JetUsagesViewDescriptor;
import org.jetbrains.kotlin.idea.refactoring.changeSignature.usages.JetUsageInfo;
import org.jetbrains.kotlin.idea.refactoring.changeSignature.usages.KotlinWrapperForJavaUsageInfos;

public class JetChangeSignatureProcessor
extends ChangeSignatureProcessorBase {
    private final String commandName;

    public JetChangeSignatureProcessor(Project project, JetChangeInfo changeInfo, String commandName) {
        super(project, (ChangeInfo)changeInfo);
        this.commandName = commandName;
    }

    @NotNull
    protected UsageViewDescriptor createUsageViewDescriptor(UsageInfo[] usages2) {
        String subject = ChangeSignaturePackage.getKind(this.getChangeInfo()).getIsConstructor() ? "constructor" : "function";
        JetUsagesViewDescriptor jetUsagesViewDescriptor = new JetUsagesViewDescriptor(this.myChangeInfo.getMethod(), RefactoringBundle.message((String)"0.to.change.signature", (Object[])new Object[]{subject}));
        if (jetUsagesViewDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/refactoring/changeSignature/JetChangeSignatureProcessor", "createUsageViewDescriptor"));
        }
        return jetUsagesViewDescriptor;
    }

    public JetChangeInfo getChangeInfo() {
        return (JetChangeInfo)super.getChangeInfo();
    }

    @NotNull
    protected UsageInfo[] findUsages() {
        Object[] kotlinUsages = super.findUsages();
        JavaChangeInfo javaChangeInfo = this.getChangeInfo().getOrCreateJavaChangeInfo();
        if (javaChangeInfo == null) {
            if (kotlinUsages == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/refactoring/changeSignature/JetChangeSignatureProcessor", "findUsages"));
            }
            return kotlinUsages;
        }
        ArrayList javaUsages = new ArrayList();
        KotlinPackage.filterNotTo((Object[])new JavaChangeSignatureUsageProcessor().findUsages((ChangeInfo)javaChangeInfo), javaUsages, (Function1)new Function1<UsageInfo, Boolean>(){

            public Boolean invoke(UsageInfo info) {
                return info instanceof OverriderUsageInfo;
            }
        });
        Pair usagesByKotlinProcessor = KotlinPackage.partition((Object[])kotlinUsages, (Function1)new Function1<UsageInfo, Boolean>(){

            public Boolean invoke(UsageInfo info) {
                return info instanceof JetUsageInfo;
            }
        });
        javaUsages.addAll((Collection)usagesByKotlinProcessor.getSecond());
        ArrayList<KotlinWrapperForJavaUsageInfos> allUsages = new ArrayList<KotlinWrapperForJavaUsageInfos>();
        allUsages.add(new KotlinWrapperForJavaUsageInfos(javaUsages.toArray(new UsageInfo[javaUsages.size()]), this.getChangeInfo().getMethod()));
        allUsages.addAll((Collection)usagesByKotlinProcessor.getFirst());
        UsageInfo[] usageInfoArray = allUsages.toArray(new UsageInfo[allUsages.size()]);
        if (usageInfoArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/refactoring/changeSignature/JetChangeSignatureProcessor", "findUsages"));
        }
        return usageInfoArray;
    }

    protected boolean preprocessUsages(Ref<UsageInfo[]> refUsages) {
        for (ChangeSignatureUsageProcessor processor : (ChangeSignatureUsageProcessor[])ChangeSignatureUsageProcessor.EP_NAME.getExtensions()) {
            if (processor.setupDefaultValues(this.myChangeInfo, refUsages, this.myProject)) continue;
            return false;
        }
        MultiMap conflictDescriptions = new MultiMap();
        for (ChangeSignatureUsageProcessor usageProcessor : (ChangeSignatureUsageProcessor[])ChangeSignatureUsageProcessor.EP_NAME.getExtensions()) {
            MultiMap conflicts2 = usageProcessor.findConflicts(this.myChangeInfo, refUsages);
            for (PsiElement key : conflicts2.keySet()) {
                Collection collection = conflictDescriptions.get((Object)key);
                if (collection.size() == 0) {
                    collection = new HashSet();
                }
                collection.addAll(conflicts2.get((Object)key));
                conflictDescriptions.put((Object)key, collection);
            }
        }
        UsageInfo[] usagesIn = (UsageInfo[])refUsages.get();
        RenameUtil.addConflictDescriptions((UsageInfo[])usagesIn, (MultiMap)conflictDescriptions);
        HashSet usagesSet = new HashSet(Arrays.asList(usagesIn));
        RenameUtil.removeConflictUsages((Set)usagesSet);
        if (!conflictDescriptions.isEmpty()) {
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                throw new BaseRefactoringProcessor.ConflictsInTestsException(conflictDescriptions.values());
            }
            if (this.myPrepareSuccessfulSwingThreadCallback != null) {
                ConflictsDialog dialog2 = this.prepareConflictsDialog(conflictDescriptions, usagesIn);
                dialog2.show();
                if (!dialog2.isOK()) {
                    if (dialog2.isShowConflicts()) {
                        this.prepareSuccessful();
                    }
                    return false;
                }
            }
        }
        UsageInfo[] array = usagesSet.toArray(new UsageInfo[usagesSet.size()]);
        Arrays.sort(array, new Comparator<UsageInfo>(){

            @Override
            public int compare(@NotNull UsageInfo u1, @NotNull UsageInfo u2) {
                if (u1 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "u1", "org/jetbrains/kotlin/idea/refactoring/changeSignature/JetChangeSignatureProcessor$3", "compare"));
                }
                if (u2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "u2", "org/jetbrains/kotlin/idea/refactoring/changeSignature/JetChangeSignatureProcessor$3", "compare"));
                }
                PsiElement element1 = u1.getElement();
                PsiElement element2 = u2.getElement();
                int rank1 = element1 != null ? element1.getTextOffset() : -1;
                int rank2 = element2 != null ? element2.getTextOffset() : -1;
                return rank2 - rank1;
            }
        });
        refUsages.set((Object)array);
        this.prepareSuccessful();
        return true;
    }

    protected boolean isPreviewUsages(UsageInfo[] usages2) {
        return this.isPreviewUsages();
    }

    protected String getCommandName() {
        return this.commandName;
    }
}

