/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.refactoring.changeSignature;

import com.intellij.codeInsight.NullableNotNullManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReference;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.changeSignature.ChangeInfo;
import com.intellij.refactoring.changeSignature.ChangeSignatureUsageProcessor;
import com.intellij.refactoring.changeSignature.JavaChangeInfo;
import com.intellij.refactoring.changeSignature.OverriderUsageInfo;
import com.intellij.refactoring.rename.ResolveSnapshotProvider;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.refactoring.util.MoveRenameUsageInfo;
import com.intellij.refactoring.util.RefactoringUIUtil;
import com.intellij.refactoring.util.TextOccurrencesUtil;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashSet;
import com.intellij.util.containers.MultiMap;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.KotlinPackage;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analyzer.AnalyzerPackage;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptorWithResolutionScopes;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.idea.JetFileType;
import org.jetbrains.kotlin.idea.caches.resolve.ResolvePackage;
import org.jetbrains.kotlin.idea.codeInsight.DescriptorToSourceUtilsIde;
import org.jetbrains.kotlin.idea.codeInsight.JetFileReferencesResolver;
import org.jetbrains.kotlin.idea.refactoring.RefactoringPackage;
import org.jetbrains.kotlin.idea.refactoring.changeSignature.ChangeSignaturePackage;
import org.jetbrains.kotlin.idea.refactoring.changeSignature.JetChangeInfo;
import org.jetbrains.kotlin.idea.refactoring.changeSignature.JetChangeSignatureData;
import org.jetbrains.kotlin.idea.refactoring.changeSignature.JetMethodDescriptor;
import org.jetbrains.kotlin.idea.refactoring.changeSignature.JetParameterInfo;
import org.jetbrains.kotlin.idea.refactoring.changeSignature.JetValVar;
import org.jetbrains.kotlin.idea.refactoring.changeSignature.usages.DeferredSAMUsage;
import org.jetbrains.kotlin.idea.refactoring.changeSignature.usages.JavaConstructorDeferredUsageInDelegationCall;
import org.jetbrains.kotlin.idea.refactoring.changeSignature.usages.JavaMethodDeferredKotlinUsage;
import org.jetbrains.kotlin.idea.refactoring.changeSignature.usages.JavaMethodKotlinCallUsage;
import org.jetbrains.kotlin.idea.refactoring.changeSignature.usages.JavaMethodKotlinUsageWithDelegate;
import org.jetbrains.kotlin.idea.refactoring.changeSignature.usages.JetConstructorDelegationCallUsage;
import org.jetbrains.kotlin.idea.refactoring.changeSignature.usages.JetEnumEntryWithoutSuperCallUsage;
import org.jetbrains.kotlin.idea.refactoring.changeSignature.usages.JetFunctionCallUsage;
import org.jetbrains.kotlin.idea.refactoring.changeSignature.usages.JetFunctionDefinitionUsage;
import org.jetbrains.kotlin.idea.refactoring.changeSignature.usages.JetImplicitOuterThisToQualifiedThisUsage;
import org.jetbrains.kotlin.idea.refactoring.changeSignature.usages.JetImplicitThisToParameterUsage;
import org.jetbrains.kotlin.idea.refactoring.changeSignature.usages.JetNonQualifiedOuterThisUsage;
import org.jetbrains.kotlin.idea.refactoring.changeSignature.usages.JetParameterUsage;
import org.jetbrains.kotlin.idea.refactoring.changeSignature.usages.JetUsageInfo;
import org.jetbrains.kotlin.idea.refactoring.changeSignature.usages.KotlinWrapperForJavaUsageInfos;
import org.jetbrains.kotlin.idea.references.JetSimpleNameReference;
import org.jetbrains.kotlin.idea.search.usagesSearch.UsagesSearchPackage;
import org.jetbrains.kotlin.kdoc.psi.impl.KDocName;
import org.jetbrains.kotlin.load.java.descriptors.JavaClassDescriptor;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.JetCallElement;
import org.jetbrains.kotlin.psi.JetCallExpression;
import org.jetbrains.kotlin.psi.JetClass;
import org.jetbrains.kotlin.psi.JetConstructorCalleeExpression;
import org.jetbrains.kotlin.psi.JetConstructorDelegationCall;
import org.jetbrains.kotlin.psi.JetDeclaration;
import org.jetbrains.kotlin.psi.JetDelegatorToSuperCall;
import org.jetbrains.kotlin.psi.JetElement;
import org.jetbrains.kotlin.psi.JetEnumEntry;
import org.jetbrains.kotlin.psi.JetExpression;
import org.jetbrains.kotlin.psi.JetFile;
import org.jetbrains.kotlin.psi.JetFunction;
import org.jetbrains.kotlin.psi.JetFunctionLiteral;
import org.jetbrains.kotlin.psi.JetFunctionLiteralExpression;
import org.jetbrains.kotlin.psi.JetNamedFunction;
import org.jetbrains.kotlin.psi.JetParameter;
import org.jetbrains.kotlin.psi.JetParameterList;
import org.jetbrains.kotlin.psi.JetPsiFactory;
import org.jetbrains.kotlin.psi.JetQualifiedExpression;
import org.jetbrains.kotlin.psi.JetReferenceExpression;
import org.jetbrains.kotlin.psi.JetSimpleNameExpression;
import org.jetbrains.kotlin.psi.JetThisExpression;
import org.jetbrains.kotlin.psi.JetTreeVisitor;
import org.jetbrains.kotlin.psi.JetTypeReference;
import org.jetbrains.kotlin.psi.JetUserType;
import org.jetbrains.kotlin.psi.JetValueArgument;
import org.jetbrains.kotlin.psi.JetValueArgumentName;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.psi.typeRefHelpers.TypeRefHelpersPackage;
import org.jetbrains.kotlin.renderer.DescriptorRenderer;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTraceContext;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilPackage;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowInfo;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;
import org.jetbrains.kotlin.resolve.scopes.JetScope;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.kotlin.resolve.scopes.receivers.ThisReceiver;
import org.jetbrains.kotlin.types.JetType;
import org.jetbrains.kotlin.types.TypeUtils;

public class JetChangeSignatureUsageProcessor
implements ChangeSignatureUsageProcessor {
    private JetMethodDescriptor originalJavaMethodDescriptor;

    public UsageInfo[] findUsages(ChangeInfo info) {
        HashSet result2 = new HashSet();
        if (info instanceof JetChangeInfo) {
            JetChangeSignatureUsageProcessor.findAllMethodUsages((JetChangeInfo)info, (Set<UsageInfo>)result2);
        } else {
            JetChangeSignatureUsageProcessor.findSAMUsages(info, (Set<UsageInfo>)result2);
            JetChangeSignatureUsageProcessor.findConstructorDelegationUsages(info, (Set<UsageInfo>)result2);
        }
        return result2.toArray(new UsageInfo[result2.size()]);
    }

    private static void findAllMethodUsages(JetChangeInfo changeInfo, Set<UsageInfo> result2) {
        for (UsageInfo functionUsageInfo : ChangeSignaturePackage.getAffectedFunctions(changeInfo)) {
            if (functionUsageInfo instanceof JetFunctionDefinitionUsage) {
                JetChangeSignatureUsageProcessor.findOneMethodUsages((JetFunctionDefinitionUsage)functionUsageInfo, changeInfo, result2);
                continue;
            }
            result2.add(functionUsageInfo);
            PsiElement callee = functionUsageInfo.getElement();
            if (callee == null) continue;
            SearchScope scope2 = callee.getUseScope();
            if (scope2 instanceof GlobalSearchScope) {
                scope2 = GlobalSearchScope.getScopeRestrictedByFileTypes((GlobalSearchScope)((GlobalSearchScope)scope2), (FileType[])new FileType[]{JetFileType.INSTANCE});
            }
            for (PsiReference reference : ReferencesSearch.search((PsiElement)callee, (SearchScope)scope2)) {
                PsiElement element = reference.getElement();
                JetCallElement callElement2 = (JetCallElement)PsiTreeUtil.getParentOfType((PsiElement)element, JetCallElement.class);
                JetExpression calleeExpression = callElement2 != null ? callElement2.getCalleeExpression() : null;
                if (calleeExpression == null || !PsiTreeUtil.isAncestor((PsiElement)calleeExpression, (PsiElement)element, (boolean)false)) continue;
                result2.add(new JetFunctionCallUsage(callElement2, changeInfo.getMethodDescriptor().getOriginalPrimaryFunction()));
            }
        }
    }

    private static void findOneMethodUsages(@NotNull JetFunctionDefinitionUsage<?> functionUsageInfo, final JetChangeInfo changeInfo, final Set<UsageInfo> result2) {
        Object functionPsi;
        if (functionUsageInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionUsageInfo", "org/jetbrains/kotlin/idea/refactoring/changeSignature/JetChangeSignatureUsageProcessor", "findOneMethodUsages"));
        }
        boolean isInherited = functionUsageInfo.isInherited();
        if (isInherited) {
            result2.add(functionUsageInfo);
        }
        if ((functionPsi = functionUsageInfo.getElement()) == null) {
            return;
        }
        for (PsiReference reference : ReferencesSearch.search(functionPsi, (SearchScope)functionPsi.getUseScope())) {
            PsiElement element = reference.getElement();
            if (functionPsi instanceof JetClass && reference.resolve() != functionPsi || !(element instanceof JetReferenceExpression)) continue;
            PsiElement parent = element.getParent();
            if (parent instanceof JetCallExpression) {
                result2.add(new JetFunctionCallUsage((JetCallExpression)parent, functionUsageInfo));
                continue;
            }
            if (!(parent instanceof JetUserType) || !(parent.getParent() instanceof JetTypeReference) || !((parent = parent.getParent().getParent()) instanceof JetConstructorCalleeExpression) || !(parent.getParent() instanceof JetDelegatorToSuperCall)) continue;
            result2.add(new JetFunctionCallUsage((JetDelegatorToSuperCall)parent.getParent(), functionUsageInfo));
        }
        String oldName = ChangeSignaturePackage.getOldName(changeInfo);
        if (oldName != null) {
            TextOccurrencesUtil.findNonCodeUsages(functionPsi, (String)oldName, (boolean)true, (boolean)true, (String)changeInfo.getNewName(), result2);
        }
        List<JetParameter> oldParameters = functionPsi instanceof JetFunction ? ((JetFunction)functionPsi).getValueParameters() : ((JetClass)functionPsi).getPrimaryConstructorParameters();
        JetParameterInfo newReceiverInfo = changeInfo.getReceiverParameterInfo();
        for (JetParameterInfo parameterInfo : changeInfo.getNewParameters()) {
            if (parameterInfo.getOldIndex() < 0 || parameterInfo.getOldIndex() >= oldParameters.size()) continue;
            JetParameter oldParam = oldParameters.get(parameterInfo.getOldIndex());
            String oldParamName = oldParam.getName();
            if (parameterInfo != newReceiverInfo && (oldParamName == null || oldParamName.equals(parameterInfo.getName()))) continue;
            for (PsiReference reference : ReferencesSearch.search((PsiElement)oldParam, (SearchScope)oldParam.getUseScope())) {
                PsiElement element = reference.getElement();
                if (!(element instanceof JetSimpleNameExpression) && !(element instanceof KDocName) || element.getParent() instanceof JetValueArgumentName) continue;
                JetParameterUsage parameterUsage = new JetParameterUsage((JetElement)element, parameterInfo, functionUsageInfo);
                result2.add(parameterUsage);
            }
        }
        if (functionPsi instanceof JetFunction && newReceiverInfo != changeInfo.getMethodDescriptor().getReceiver()) {
            JetChangeSignatureUsageProcessor.findOriginalReceiversUsages(functionUsageInfo, result2, changeInfo);
        }
        if (functionPsi instanceof JetClass && ((JetClass)functionPsi).isEnum()) {
            for (JetDeclaration declaration : ((JetClass)functionPsi).getDeclarations()) {
                if (!(declaration instanceof JetEnumEntry) || !((JetEnumEntry)declaration).getDelegationSpecifiers().isEmpty()) continue;
                result2.add(new JetEnumEntryWithoutSuperCallUsage((JetEnumEntry)declaration));
            }
        }
        UsagesSearchPackage.processDelegationCallConstructorUsages(functionPsi, functionPsi.getUseScope(), (Function1<? super JetConstructorDelegationCall, ? extends Unit>)new Function1<JetConstructorDelegationCall, Unit>(){

            public Unit invoke(JetConstructorDelegationCall element) {
                result2.add(new JetConstructorDelegationCallUsage(element, changeInfo));
                return null;
            }
        });
    }

    private static void processInternalReferences(JetFunctionDefinitionUsage functionUsageInfo, JetTreeVisitor<BindingContext> visitor2) {
        JetFunction jetFunction = (JetFunction)functionUsageInfo.getDeclaration();
        JetExpression body2 = jetFunction.getBodyExpression();
        if (body2 != null) {
            body2.accept(visitor2, ResolvePackage.analyze(body2, BodyResolveMode.FULL));
        }
        for (JetParameter parameter : jetFunction.getValueParameters()) {
            JetExpression defaultValue = parameter.getDefaultValue();
            if (defaultValue == null) continue;
            defaultValue.accept(visitor2, ResolvePackage.analyze(defaultValue, BodyResolveMode.FULL));
        }
    }

    private static void findOriginalReceiversUsages(final @NotNull JetFunctionDefinitionUsage<?> functionUsageInfo, final @NotNull Set<UsageInfo> result2, final @NotNull JetChangeInfo changeInfo) {
        if (functionUsageInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionUsageInfo", "org/jetbrains/kotlin/idea/refactoring/changeSignature/JetChangeSignatureUsageProcessor", "findOriginalReceiversUsages"));
        }
        if (result2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "org/jetbrains/kotlin/idea/refactoring/changeSignature/JetChangeSignatureUsageProcessor", "findOriginalReceiversUsages"));
        }
        if (changeInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changeInfo", "org/jetbrains/kotlin/idea/refactoring/changeSignature/JetChangeSignatureUsageProcessor", "findOriginalReceiversUsages"));
        }
        final JetParameterInfo originalReceiverInfo = changeInfo.getMethodDescriptor().getReceiver();
        final FunctionDescriptor functionDescriptor = functionUsageInfo.getOriginalFunctionDescriptor();
        JetChangeSignatureUsageProcessor.processInternalReferences(functionUsageInfo, new JetTreeVisitor<BindingContext>(){

            private void processExplicitThis(@NotNull JetSimpleNameExpression expression2, @NotNull ReceiverParameterDescriptor receiverDescriptor) {
                if (expression2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/idea/refactoring/changeSignature/JetChangeSignatureUsageProcessor$2", "processExplicitThis"));
                }
                if (receiverDescriptor == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "receiverDescriptor", "org/jetbrains/kotlin/idea/refactoring/changeSignature/JetChangeSignatureUsageProcessor$2", "processExplicitThis"));
                }
                if (originalReceiverInfo != null && !changeInfo.hasParameter(originalReceiverInfo)) {
                    return;
                }
                if (!(expression2.getParent() instanceof JetThisExpression)) {
                    return;
                }
                if (receiverDescriptor == functionDescriptor.getExtensionReceiverParameter()) {
                    assert (originalReceiverInfo != null) : "No original receiver info provided: " + functionUsageInfo.getDeclaration().getText();
                    result2.add(new JetParameterUsage(expression2, originalReceiverInfo, functionUsageInfo));
                } else {
                    ClassifierDescriptor targetDescriptor = receiverDescriptor.getType().getConstructor().getDeclarationDescriptor();
                    assert (targetDescriptor != null) : "Receiver type has no descriptor: " + functionUsageInfo.getDeclaration().getText();
                    result2.add(new JetNonQualifiedOuterThisUsage((JetThisExpression)expression2.getParent(), targetDescriptor));
                }
            }

            private void processImplicitThis(@NotNull JetElement callElement2, @NotNull ThisReceiver receiverValue) {
                if (callElement2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callElement", "org/jetbrains/kotlin/idea/refactoring/changeSignature/JetChangeSignatureUsageProcessor$2", "processImplicitThis"));
                }
                if (receiverValue == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "receiverValue", "org/jetbrains/kotlin/idea/refactoring/changeSignature/JetChangeSignatureUsageProcessor$2", "processImplicitThis"));
                }
                DeclarationDescriptor targetDescriptor = receiverValue.getDeclarationDescriptor();
                if (targetDescriptor == functionDescriptor) {
                    assert (originalReceiverInfo != null) : "No original receiver info provided: " + functionUsageInfo.getDeclaration().getText();
                    result2.add(new JetImplicitThisToParameterUsage(callElement2, originalReceiverInfo, functionUsageInfo));
                } else {
                    result2.add(new JetImplicitOuterThisToQualifiedThisUsage(callElement2, targetDescriptor));
                }
            }

            @Override
            public Void visitSimpleNameExpression(@NotNull JetSimpleNameExpression expression2, BindingContext context2) {
                if (expression2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/idea/refactoring/changeSignature/JetChangeSignatureUsageProcessor$2", "visitSimpleNameExpression"));
                }
                ResolvedCall<? extends CallableDescriptor> resolvedCall = CallUtilPackage.getResolvedCall(expression2, context2);
                if (resolvedCall == null) {
                    return null;
                }
                CallableDescriptor resultingDescriptor = resolvedCall.getResultingDescriptor();
                if (resultingDescriptor instanceof ReceiverParameterDescriptor) {
                    this.processExplicitThis(expression2, (ReceiverParameterDescriptor)resultingDescriptor);
                    return null;
                }
                ReceiverValue receiverValue = resolvedCall.getExtensionReceiver();
                if (!(receiverValue instanceof ThisReceiver)) {
                    receiverValue = resolvedCall.getDispatchReceiver();
                }
                if (receiverValue instanceof ThisReceiver) {
                    this.processImplicitThis(resolvedCall.getCall().getCallElement(), (ThisReceiver)receiverValue);
                }
                return null;
            }
        });
    }

    private static void findSAMUsages(ChangeInfo changeInfo, Set<UsageInfo> result2) {
        PsiElement method = changeInfo.getMethod();
        if (!org.jetbrains.kotlin.idea.core.refactoring.RefactoringPackage.isTrueJavaMethod(method)) {
            return;
        }
        FunctionDescriptor methodDescriptor = ResolvePackage.getJavaMethodDescriptor((PsiMethod)method);
        DeclarationDescriptor containingDescriptor = methodDescriptor.getContainingDeclaration();
        if (!(containingDescriptor instanceof JavaClassDescriptor)) {
            return;
        }
        if (((JavaClassDescriptor)containingDescriptor).getFunctionTypeForSamInterface() == null) {
            return;
        }
        PsiClass samClass = ((PsiMethod)method).getContainingClass();
        if (samClass == null) {
            return;
        }
        for (PsiReference ref : ReferencesSearch.search((PsiElement)samClass)) {
            JetExpression argExpression;
            List<JetValueArgument> arguments2;
            JetSimpleNameExpression callee;
            JetCallExpression callExpression;
            if (!(ref instanceof JetSimpleNameReference) || (callExpression = (JetCallExpression)PsiTreeUtil.getParentOfType((PsiElement)(callee = (JetSimpleNameExpression)((JetSimpleNameReference)ref).getExpression()), JetCallExpression.class)) == null || callExpression.getCalleeExpression() != callee || (arguments2 = callExpression.getValueArguments()).size() != 1 || !((argExpression = ((ValueArgument)arguments2.get(0)).getArgumentExpression()) instanceof JetFunctionLiteralExpression)) continue;
            BindingContext context2 = ResolvePackage.analyze(callExpression, BodyResolveMode.FULL);
            JetFunctionLiteral functionLiteral = ((JetFunctionLiteralExpression)argExpression).getFunctionLiteral();
            FunctionDescriptor functionDescriptor = context2.get(BindingContext.FUNCTION, functionLiteral);
            assert (functionDescriptor != null) : "No descriptor for " + functionLiteral.getText();
            JetType samCallType = context2.getType(callExpression);
            if (samCallType == null) continue;
            result2.add(new DeferredSAMUsage(functionLiteral, functionDescriptor, samCallType));
        }
    }

    private static void findConstructorDelegationUsages(@NotNull ChangeInfo changeInfo, final @NotNull Set<UsageInfo> result2) {
        if (changeInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changeInfo", "org/jetbrains/kotlin/idea/refactoring/changeSignature/JetChangeSignatureUsageProcessor", "findConstructorDelegationUsages"));
        }
        if (result2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "org/jetbrains/kotlin/idea/refactoring/changeSignature/JetChangeSignatureUsageProcessor", "findConstructorDelegationUsages"));
        }
        PsiElement method = changeInfo.getMethod();
        if (!org.jetbrains.kotlin.idea.core.refactoring.RefactoringPackage.isTrueJavaMethod(method)) {
            return;
        }
        PsiMethod psiMethod = (PsiMethod)method;
        if (!psiMethod.isConstructor()) {
            return;
        }
        UsagesSearchPackage.processDelegationCallConstructorUsages((PsiElement)psiMethod, psiMethod.getUseScope(), (Function1<? super JetConstructorDelegationCall, ? extends Unit>)new Function1<JetConstructorDelegationCall, Unit>(){

            public Unit invoke(JetConstructorDelegationCall element) {
                result2.add(new JavaConstructorDeferredUsageInDelegationCall(element));
                return null;
            }
        });
    }

    public MultiMap<PsiElement, String> findConflicts(ChangeInfo info, Ref<UsageInfo[]> refUsages) {
        MultiMap result2 = new MultiMap();
        if (!(info instanceof JetChangeInfo)) {
            return result2;
        }
        HashSet parameterNames2 = new HashSet();
        JetChangeInfo changeInfo = (JetChangeInfo)info;
        PsiElement function2 = info.getMethod();
        PsiElement element = function2 != null ? function2 : changeInfo.getContext();
        BindingContext bindingContext2 = ResolvePackage.analyze((JetElement)element, BodyResolveMode.FULL);
        FunctionDescriptor oldDescriptor = ChangeSignaturePackage.getOriginalBaseFunctionDescriptor(changeInfo);
        DeclarationDescriptor containingDeclaration = oldDescriptor.getContainingDeclaration();
        JetScope parametersScope = null;
        if (oldDescriptor instanceof ConstructorDescriptor && containingDeclaration instanceof ClassDescriptorWithResolutionScopes) {
            parametersScope = ((ClassDescriptorWithResolutionScopes)containingDeclaration).getScopeForInitializerResolution();
        } else if (function2 instanceof JetFunction) {
            parametersScope = RefactoringPackage.getBodyScope((JetFunction)function2, bindingContext2);
        }
        JetScope functionScope = RefactoringPackage.getContainingScope(oldDescriptor, bindingContext2);
        JetMethodDescriptor.Kind kind2 = ChangeSignaturePackage.getKind(changeInfo);
        if (!kind2.getIsConstructor() && functionScope != null && !info.getNewName().isEmpty()) {
            for (FunctionDescriptor conflict : functionScope.getFunctions(Name.identifier(info.getNewName()))) {
                PsiElement conflictElement;
                if (conflict == oldDescriptor || (conflictElement = DescriptorToSourceUtils.descriptorToDeclaration(conflict)) == changeInfo.getMethod() || !((Object)JetChangeSignatureUsageProcessor.getFunctionParameterTypes(conflict)).equals(JetChangeSignatureUsageProcessor.getFunctionParameterTypes(oldDescriptor))) continue;
                result2.putValue((Object)conflictElement, (Object)("Function already exists: '" + DescriptorRenderer.SHORT_NAMES_IN_TYPES.render(conflict) + "'"));
                break;
            }
        }
        block1: for (JetParameterInfo parameter : changeInfo.getNonReceiverParameters()) {
            VariableDescriptor variable;
            JetValVar valOrVar = parameter.getValOrVar();
            String parameterName = parameter.getName();
            if (!parameterNames2.add(parameterName)) {
                result2.putValue((Object)element, (Object)("Duplicating parameter '" + parameterName + "'"));
            }
            if (parametersScope == null) continue;
            if (kind2 == JetMethodDescriptor.Kind.PRIMARY_CONSTRUCTOR && valOrVar != JetValVar.None) {
                for (VariableDescriptor property : parametersScope.getProperties(Name.identifier(parameterName))) {
                    PsiElement propertyDeclaration = DescriptorToSourceUtils.descriptorToDeclaration(property);
                    if (propertyDeclaration == null || propertyDeclaration.getParent() instanceof JetParameterList) continue;
                    result2.putValue((Object)propertyDeclaration, (Object)("Duplicating property '" + parameterName + "'"));
                    continue block1;
                }
                continue;
            }
            if (!(function2 instanceof JetFunction) || (variable = parametersScope.getLocalVariable(Name.identifier(parameterName))) == null || variable instanceof ValueParameterDescriptor) continue;
            PsiElement conflictElement = DescriptorToSourceUtils.descriptorToDeclaration(variable);
            result2.putValue((Object)conflictElement, (Object)("Duplicating local variable '" + parameterName + "'"));
        }
        JetParameterInfo newReceiverInfo = changeInfo.getReceiverParameterInfo();
        JetParameterInfo originalReceiverInfo = changeInfo.getMethodDescriptor().getReceiver();
        if (function2 instanceof JetNamedFunction && newReceiverInfo != originalReceiverInfo) {
            JetChangeSignatureUsageProcessor.findReceiverIntroducingConflicts((MultiMap<PsiElement, String>)result2, function2, newReceiverInfo);
            JetChangeSignatureUsageProcessor.findInternalExplicitReceiverConflicts((UsageInfo[])refUsages.get(), (MultiMap<PsiElement, String>)result2, originalReceiverInfo);
            JetChangeSignatureUsageProcessor.findThisLabelConflicts((JetChangeInfo)info, refUsages, (MultiMap<PsiElement, String>)result2, changeInfo, function2);
        }
        return result2;
    }

    private static void findThisLabelConflicts(JetChangeInfo info, Ref<UsageInfo[]> refUsages, MultiMap<PsiElement, String> result2, JetChangeInfo changeInfo, PsiElement function2) {
        JetPsiFactory psiFactory = new JetPsiFactory(function2.getProject());
        for (UsageInfo usageInfo : (UsageInfo[])refUsages.get()) {
            BindingContext newContext;
            JetThisExpression newExpr;
            JetSimpleNameExpression labelExpr;
            JetExpression originalExpr;
            JetScope scope2;
            String newExprText;
            if (!(usageInfo instanceof JetParameterUsage) || !(newExprText = ((JetParameterUsage)usageInfo).getReplacementText(changeInfo)).startsWith("this@") || usageInfo.getElement() instanceof KDocName || (scope2 = ResolvePackage.analyze(originalExpr = (JetExpression)usageInfo.getElement(), BodyResolveMode.FULL).get(BindingContext.RESOLUTION_SCOPE, originalExpr)) == null || (labelExpr = (newExpr = (JetThisExpression)psiFactory.createExpression(newExprText)).getTargetLabel()) == null || (newContext = AnalyzerPackage.analyzeInContext(newExpr, scope2, new BindingTraceContext(), DataFlowInfo.EMPTY, TypeUtils.NO_EXPECTED_TYPE, DescriptorUtils.getContainingModule(scope2.getContainingDeclaration()))).get(BindingContext.AMBIGUOUS_LABEL_TARGET, labelExpr) == null) continue;
            result2.putValue((Object)originalExpr, (Object)("Parameter reference can't be safely replaced with " + newExprText + " since " + labelExpr.getText() + " is ambiguous in this context"));
        }
    }

    private static void findInternalExplicitReceiverConflicts(UsageInfo[] usages2, MultiMap<PsiElement, String> result2, JetParameterInfo originalReceiverInfo) {
        if (originalReceiverInfo == null) {
            for (UsageInfo usageInfo : usages2) {
                PsiElement parent;
                JetFunctionCallUsage callUsage;
                JetElement callElement2;
                if (!(usageInfo instanceof JetFunctionCallUsage) || (callElement2 = (JetElement)(callUsage = (JetFunctionCallUsage)usageInfo).getElement()) == null || !((parent = callElement2.getParent()) instanceof JetQualifiedExpression) || ((JetQualifiedExpression)parent).getSelectorExpression() != callElement2) continue;
                String message = "Explicit receiver is already present in call element: " + CommonRefactoringUtil.htmlEmphasize((String)parent.getText());
                result2.putValue((Object)callElement2, (Object)message);
            }
        }
    }

    private static void findReceiverIntroducingConflicts(MultiMap<PsiElement, String> result2, PsiElement callable, JetParameterInfo newReceiverInfo) {
        if (newReceiverInfo != null && ((JetNamedFunction)callable).getBodyExpression() != null) {
            Map noReceiverRefToContext = KotlinPackage.filter(JetFileReferencesResolver.INSTANCE$.resolve((JetNamedFunction)callable, true, true), (Function1)new Function1<Map.Entry<? extends JetReferenceExpression, ? extends BindingContext>, Boolean>(){

                public Boolean invoke(Map.Entry<? extends JetReferenceExpression, ? extends BindingContext> entry) {
                    ResolvedCall<? extends CallableDescriptor> resolvedCall = CallUtilPackage.getResolvedCall(entry.getKey(), entry.getValue());
                    return resolvedCall != null && !resolvedCall.getDispatchReceiver().exists() && !resolvedCall.getExtensionReceiver().exists();
                }
            });
            JetPsiFactory psiFactory = new JetPsiFactory(callable.getProject());
            JetFile tempFile = org.jetbrains.kotlin.idea.core.refactoring.RefactoringPackage.createTempCopy((JetFile)callable.getContainingFile(), (Function1<? super String, ? extends String>)new Function1<String, String>(){

                public String invoke(String s) {
                    return s;
                }
            });
            JetNamedFunction functionWithReceiver = (JetNamedFunction)PsiTreeUtil.getParentOfType((PsiElement)tempFile.findElementAt(callable.getTextOffset()), JetNamedFunction.class);
            JetTypeReference receiverTypeRef = psiFactory.createType(newReceiverInfo.getCurrentTypeText());
            TypeRefHelpersPackage.setReceiverTypeReference(functionWithReceiver, receiverTypeRef);
            BindingContext newContext = ResolvePackage.analyze(functionWithReceiver.getBodyExpression(), BodyResolveMode.FULL);
            int originalOffset = ((JetNamedFunction)callable).getBodyExpression().getTextOffset();
            JetExpression newBody = functionWithReceiver.getBodyExpression();
            for (Map.Entry entry : noReceiverRefToContext.entrySet()) {
                JetReferenceExpression originalRef = (JetReferenceExpression)entry.getKey();
                BindingContext originalContext = (BindingContext)entry.getValue();
                JetReferenceExpression newRef = (JetReferenceExpression)PsiTreeUtil.getParentOfType((PsiElement)newBody.findElementAt(originalRef.getTextOffset() - originalOffset), JetReferenceExpression.class);
                ResolvedCall<? extends CallableDescriptor> newResolvedCall = CallUtilPackage.getResolvedCall(newRef, newContext);
                if (newResolvedCall != null && !newResolvedCall.getExtensionReceiver().exists() && !newResolvedCall.getDispatchReceiver().exists()) continue;
                CallableDescriptor descriptor2 = CallUtilPackage.getResolvedCall(originalRef, originalContext).getCandidateDescriptor();
                PsiElement declaration = DescriptorToSourceUtilsIde.INSTANCE$.getAnyDeclaration(callable.getProject(), descriptor2);
                String prefix = declaration != null ? RefactoringUIUtil.getDescription((PsiElement)declaration, (boolean)true) : originalRef.getText();
                result2.putValue((Object)originalRef, (Object)KotlinPackage.capitalize((String)(prefix + " will no longer be accessible after signature change")));
            }
        }
    }

    private static List<JetType> getFunctionParameterTypes(FunctionDescriptor descriptor2) {
        return ContainerUtil.map(descriptor2.getValueParameters(), (Function)new Function<ValueParameterDescriptor, JetType>(){

            public JetType fun(ValueParameterDescriptor descriptor2) {
                return descriptor2.getType();
            }
        });
    }

    private static boolean isJavaMethodUsage(UsageInfo usageInfo) {
        if (usageInfo instanceof JavaMethodDeferredKotlinUsage) {
            return true;
        }
        return usageInfo instanceof MoveRenameUsageInfo && org.jetbrains.kotlin.idea.core.refactoring.RefactoringPackage.isTrueJavaMethod(((MoveRenameUsageInfo)usageInfo).getReferencedElement());
    }

    @Nullable
    private static UsageInfo createReplacementUsage(UsageInfo originalUsageInfo, JetChangeInfo javaMethodChangeInfo) {
        if (originalUsageInfo instanceof JavaMethodDeferredKotlinUsage) {
            return ((JavaMethodDeferredKotlinUsage)originalUsageInfo).resolve(javaMethodChangeInfo);
        }
        JetCallElement callElement2 = (JetCallElement)PsiTreeUtil.getParentOfType((PsiElement)originalUsageInfo.getElement(), JetCallElement.class);
        return callElement2 != null ? new JavaMethodKotlinCallUsage(callElement2, javaMethodChangeInfo) : null;
    }

    public boolean processUsage(ChangeInfo changeInfo, UsageInfo usageInfo, boolean beforeMethodChange, UsageInfo[] usages2) {
        PsiElement method = changeInfo.getMethod();
        boolean isJavaMethodUsage = JetChangeSignatureUsageProcessor.isJavaMethodUsage(usageInfo);
        if (usageInfo instanceof KotlinWrapperForJavaUsageInfos) {
            JavaChangeInfo javaChangeInfo = ((JetChangeInfo)changeInfo).getOrCreateJavaChangeInfo();
            assert (javaChangeInfo != null) : "JavaChangeInfo not found: " + method.getText();
            UsageInfo[] javaUsageInfos = ((KotlinWrapperForJavaUsageInfos)usageInfo).getJavaUsageInfos();
            ChangeSignatureUsageProcessor[] processors = (ChangeSignatureUsageProcessor[])ChangeSignatureUsageProcessor.EP_NAME.getExtensions();
            NullabilityPropagator nullabilityPropagator = new NullabilityPropagator(javaChangeInfo.getMethod());
            for (UsageInfo usage : javaUsageInfos) {
                PsiMethod overridingMethod;
                if (usage instanceof OverriderUsageInfo && beforeMethodChange) continue;
                for (ChangeSignatureUsageProcessor processor : processors) {
                    if (processor instanceof JetChangeSignatureUsageProcessor) continue;
                    if (usage instanceof OverriderUsageInfo) {
                        processor.processUsage((ChangeInfo)javaChangeInfo, usage, true, javaUsageInfos);
                    }
                    if (processor.processUsage((ChangeInfo)javaChangeInfo, usage, beforeMethodChange, javaUsageInfos)) break;
                }
                if (!(usage instanceof OverriderUsageInfo) || (overridingMethod = ((OverriderUsageInfo)usage).getOverridingMethod()) == null) continue;
                nullabilityPropagator.processMethod(overridingMethod);
            }
        }
        if (beforeMethodChange) {
            FunctionDescriptor methodDescriptor;
            JetChangeSignatureData changeSignatureData;
            if (isJavaMethodUsage && (changeSignatureData = new JetChangeSignatureData(methodDescriptor = ResolvePackage.getJavaMethodDescriptor((PsiMethod)method), method, Collections.singletonList(methodDescriptor))) != this.originalJavaMethodDescriptor) {
                this.originalJavaMethodDescriptor = changeSignatureData;
            }
            return true;
        }
        PsiElement element = usageInfo.getElement();
        if (element == null) {
            return false;
        }
        if (isJavaMethodUsage && this.originalJavaMethodDescriptor != null) {
            JetChangeInfo javaMethodChangeInfo = ChangeSignaturePackage.toJetChangeInfo(changeInfo, this.originalJavaMethodDescriptor);
            this.originalJavaMethodDescriptor = null;
            for (int i = 0; i < usages2.length; ++i) {
                UsageInfo newUsageInfo;
                UsageInfo oldUsageInfo = usages2[i];
                if (!JetChangeSignatureUsageProcessor.isJavaMethodUsage(oldUsageInfo) || (newUsageInfo = JetChangeSignatureUsageProcessor.createReplacementUsage(oldUsageInfo, javaMethodChangeInfo)) == null) continue;
                usages2[i] = newUsageInfo;
                if (oldUsageInfo != usageInfo) continue;
                usageInfo = newUsageInfo;
            }
        }
        if (usageInfo instanceof JavaMethodKotlinUsageWithDelegate) {
            return ((JavaMethodKotlinUsageWithDelegate)usageInfo).processUsage();
        }
        if (usageInfo instanceof MoveRenameUsageInfo && isJavaMethodUsage) {
            PsiReference ref;
            JetSimpleNameExpression callee = (JetSimpleNameExpression)PsiTreeUtil.getParentOfType((PsiElement)usageInfo.getElement(), JetSimpleNameExpression.class, (boolean)false);
            PsiReference psiReference = ref = callee != null ? callee.getReference() : null;
            if (ref instanceof JetSimpleNameReference) {
                ((JetSimpleNameReference)ref).handleElementRename(((PsiMethod)method).getName());
                return true;
            }
            return false;
        }
        return usageInfo instanceof JetUsageInfo ? ((JetUsageInfo)usageInfo).processUsage((JetChangeInfo)changeInfo, element) : true;
    }

    public boolean processPrimaryMethod(ChangeInfo changeInfo) {
        if (!(changeInfo instanceof JetChangeInfo)) {
            return false;
        }
        JetChangeInfo jetChangeInfo = (JetChangeInfo)changeInfo;
        for (JetFunctionDefinitionUsage<PsiElement> primaryFunction : jetChangeInfo.getMethodDescriptor().getPrimaryFunctions()) {
            primaryFunction.processUsage(jetChangeInfo, primaryFunction.getDeclaration());
        }
        jetChangeInfo.primaryMethodUpdated();
        return true;
    }

    public boolean shouldPreviewUsages(ChangeInfo changeInfo, UsageInfo[] usages2) {
        return false;
    }

    public boolean setupDefaultValues(ChangeInfo changeInfo, Ref<UsageInfo[]> refUsages, Project project) {
        return true;
    }

    public void registerConflictResolvers(List<ResolveSnapshotProvider.ResolveSnapshot> snapshots, @NotNull ResolveSnapshotProvider resolveSnapshotProvider, UsageInfo[] usages2, ChangeInfo changeInfo) {
        if (resolveSnapshotProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolveSnapshotProvider", "org/jetbrains/kotlin/idea/refactoring/changeSignature/JetChangeSignatureUsageProcessor", "registerConflictResolvers"));
        }
    }

    private static class NullabilityPropagator {
        private final NullableNotNullManager nullManager;
        private final JavaPsiFacade javaPsiFacade;
        private final JavaCodeStyleManager javaCodeStyleManager;
        private final PsiAnnotation methodAnnotation;
        private final PsiAnnotation[] parameterAnnotations;

        public NullabilityPropagator(@NotNull PsiMethod baseMethod) {
            if (baseMethod == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseMethod", "org/jetbrains/kotlin/idea/refactoring/changeSignature/JetChangeSignatureUsageProcessor$NullabilityPropagator", "<init>"));
            }
            Project project = baseMethod.getProject();
            this.nullManager = NullableNotNullManager.getInstance((Project)project);
            this.javaPsiFacade = JavaPsiFacade.getInstance((Project)project);
            this.javaCodeStyleManager = JavaCodeStyleManager.getInstance((Project)project);
            this.methodAnnotation = this.getNullabilityAnnotation((PsiModifierListOwner)baseMethod);
            this.parameterAnnotations = (PsiAnnotation[])ContainerUtil.map2Array((Object[])baseMethod.getParameterList().getParameters(), PsiAnnotation.class, (Function)new Function<PsiParameter, PsiAnnotation>(){

                public PsiAnnotation fun(PsiParameter parameter) {
                    return NullabilityPropagator.this.getNullabilityAnnotation((PsiModifierListOwner)parameter);
                }
            });
        }

        @Nullable
        private PsiAnnotation getNullabilityAnnotation(@NotNull PsiModifierListOwner element) {
            PsiAnnotation notNullAnnotation;
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/idea/refactoring/changeSignature/JetChangeSignatureUsageProcessor$NullabilityPropagator", "getNullabilityAnnotation"));
            }
            PsiAnnotation nullAnnotation = this.nullManager.getNullableAnnotation(element, false);
            if (nullAnnotation == null == ((notNullAnnotation = this.nullManager.getNotNullAnnotation(element, false)) == null)) {
                return null;
            }
            return nullAnnotation != null ? nullAnnotation : notNullAnnotation;
        }

        private void addNullabilityAnnotationIfApplicable(@NotNull PsiModifierListOwner element, @Nullable PsiAnnotation annotation2) {
            String annotationQualifiedName;
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/idea/refactoring/changeSignature/JetChangeSignatureUsageProcessor$NullabilityPropagator", "addNullabilityAnnotationIfApplicable"));
            }
            PsiAnnotation nullableAnnotation = this.nullManager.getNullableAnnotation(element, false);
            PsiAnnotation notNullAnnotation = this.nullManager.getNotNullAnnotation(element, false);
            if (notNullAnnotation != null && nullableAnnotation == null && element instanceof PsiMethod) {
                return;
            }
            String string = annotationQualifiedName = annotation2 != null ? annotation2.getQualifiedName() : null;
            if (annotationQualifiedName != null && this.javaPsiFacade.findClass(annotationQualifiedName, element.getResolveScope()) == null) {
                return;
            }
            if (notNullAnnotation != null) {
                notNullAnnotation.delete();
            }
            if (nullableAnnotation != null) {
                nullableAnnotation.delete();
            }
            if (annotationQualifiedName == null) {
                return;
            }
            PsiModifierList modifierList = element.getModifierList();
            if (modifierList != null) {
                modifierList.addAnnotation(annotationQualifiedName);
                this.javaCodeStyleManager.shortenClassReferences((PsiElement)element);
            }
        }

        public void processMethod(@NotNull PsiMethod currentMethod) {
            if (currentMethod == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "currentMethod", "org/jetbrains/kotlin/idea/refactoring/changeSignature/JetChangeSignatureUsageProcessor$NullabilityPropagator", "processMethod"));
            }
            PsiParameter[] currentParameters = currentMethod.getParameterList().getParameters();
            this.addNullabilityAnnotationIfApplicable((PsiModifierListOwner)currentMethod, this.methodAnnotation);
            for (int i = 0; i < this.parameterAnnotations.length; ++i) {
                this.addNullabilityAnnotationIfApplicable((PsiModifierListOwner)currentParameters[i], this.parameterAnnotations[i]);
            }
        }
    }
}

