/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.run;

import com.intellij.execution.CommonJavaRunConfigurationParameters;
import com.intellij.execution.configurations.ModuleBasedConfiguration;
import com.intellij.execution.ui.CommonJavaParametersPanel;
import com.intellij.execution.ui.ConfigurationModuleSelector;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.LabeledComponent;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.run.JetRunConfiguration;

public class JetRunConfigurationEditor
extends SettingsEditor<JetRunConfiguration> {
    private JPanel myMainPanel;
    private JTextField myMainClassField;
    private JPanel myModuleChooserHolder;
    private CommonJavaParametersPanel myCommonProgramParameters;
    private ConfigurationModuleSelector myModuleSelector;

    public JetRunConfigurationEditor(Project project) {
        this.$$$setupUI$$$();
        LabeledComponent moduleChooser = LabeledComponent.create(new JComboBox(), (String)"Use classpath and JDK of module:");
        this.myModuleChooserHolder.add((Component)moduleChooser, "Center");
        this.myModuleSelector = new ConfigurationModuleSelector(project, (JComboBox)moduleChooser.getComponent());
        this.myCommonProgramParameters.setModuleContext(this.myModuleSelector.getModule());
        ((JComboBox)moduleChooser.getComponent()).addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JetRunConfigurationEditor.this.myCommonProgramParameters.setModuleContext(JetRunConfigurationEditor.this.myModuleSelector.getModule());
            }
        });
    }

    protected void resetEditorFrom(JetRunConfiguration configuration) {
        this.myCommonProgramParameters.reset((CommonJavaRunConfigurationParameters)configuration);
        this.myMainClassField.setText(configuration.getRunClass() == null ? null : configuration.getRunClass());
        this.myModuleSelector.reset((ModuleBasedConfiguration)configuration);
    }

    protected void applyEditorTo(JetRunConfiguration configuration) throws ConfigurationException {
        this.myModuleSelector.applyTo((ModuleBasedConfiguration)configuration);
        this.myCommonProgramParameters.applyTo((CommonJavaRunConfigurationParameters)configuration);
        configuration.setRunClass(this.myMainClassField.getText());
    }

    @NotNull
    protected JComponent createEditor() {
        JPanel jPanel = this.myMainPanel;
        if (jPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/run/JetRunConfigurationEditor", "createEditor"));
        }
        return jPanel;
    }

    protected void disposeEditor() {
    }

    private /* synthetic */ void $$$setupUI$$$() {
        CommonJavaParametersPanel commonJavaParametersPanel;
        JPanel jPanel;
        JTextField jTextField;
        JPanel jPanel2;
        this.myMainPanel = jPanel2 = new JPanel();
        jPanel2.setLayout(new GridLayoutManager(4, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JLabel jLabel = new JLabel();
        jLabel.setText("Main class:");
        jPanel2.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel2.add((Component)spacer, new GridConstraints(3, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myMainClassField = jTextField = new JTextField();
        jPanel2.add((Component)jTextField, new GridConstraints(0, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.myModuleChooserHolder = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel2.add((Component)jPanel, new GridConstraints(2, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        this.myCommonProgramParameters = commonJavaParametersPanel = new CommonJavaParametersPanel();
        jPanel2.add((Component)commonJavaParametersPanel, new GridConstraints(1, 0, 1, 2, 0, 1, 3, 3, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }
}

