/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.load.kotlin;

import com.intellij.ide.highlighter.JavaClassFileType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.load.kotlin.KotlinJvmBinaryClass;
import org.jetbrains.kotlin.load.kotlin.VirtualFileKotlinClass;

public final class KotlinBinaryClassCache
implements Disposable {
    private final ThreadLocal<RequestCache> cache = new ThreadLocal<RequestCache>(){

        @Override
        protected RequestCache initialValue() {
            return new RequestCache();
        }
    };

    @Nullable
    public static KotlinJvmBinaryClass getKotlinBinaryClass(final @NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/kotlin/load/kotlin/KotlinBinaryClassCache", "getKotlinBinaryClass"));
        }
        if (file.getFileType() != JavaClassFileType.INSTANCE) {
            return null;
        }
        KotlinBinaryClassCache service = (KotlinBinaryClassCache)ServiceManager.getService(KotlinBinaryClassCache.class);
        RequestCache requestCache = service.cache.get();
        if (file.getModificationStamp() == requestCache.modificationStamp && file.equals(requestCache.virtualFile)) {
            return requestCache.virtualFileKotlinClass;
        }
        VirtualFileKotlinClass aClass = (VirtualFileKotlinClass)ApplicationManager.getApplication().runReadAction((Computable)new Computable<VirtualFileKotlinClass>(){

            public VirtualFileKotlinClass compute() {
                return VirtualFileKotlinClass.Factory.create(file);
            }
        });
        return requestCache.cache(file, aClass);
    }

    public void dispose() {
        this.cache.remove();
    }

    private static class RequestCache {
        VirtualFile virtualFile;
        long modificationStamp;
        VirtualFileKotlinClass virtualFileKotlinClass;

        private RequestCache() {
        }

        public VirtualFileKotlinClass cache(VirtualFile file, VirtualFileKotlinClass aClass) {
            this.virtualFile = file;
            this.virtualFileKotlinClass = aClass;
            this.modificationStamp = file.getModificationStamp();
            return aClass;
        }
    }
}

