/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.model;

import com.google.common.collect.Maps;
import com.intellij.util.Function;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.psi.Call;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.resolve.DelegatingBindingTrace;
import org.jetbrains.kotlin.resolve.calls.CallResolverUtil;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilPackage;
import org.jetbrains.kotlin.resolve.calls.inference.ConstraintSystem;
import org.jetbrains.kotlin.resolve.calls.model.ArgumentMapping;
import org.jetbrains.kotlin.resolve.calls.model.ArgumentMatch;
import org.jetbrains.kotlin.resolve.calls.model.ArgumentMatchImpl;
import org.jetbrains.kotlin.resolve.calls.model.ArgumentMatchStatus;
import org.jetbrains.kotlin.resolve.calls.model.ArgumentUnmapped;
import org.jetbrains.kotlin.resolve.calls.model.MutableDataFlowInfoForArguments;
import org.jetbrains.kotlin.resolve.calls.model.MutableResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedValueArgument;
import org.jetbrains.kotlin.resolve.calls.results.ResolutionStatus;
import org.jetbrains.kotlin.resolve.calls.tasks.ExplicitReceiverKind;
import org.jetbrains.kotlin.resolve.calls.tasks.ResolutionCandidate;
import org.jetbrains.kotlin.resolve.calls.tasks.TracingStrategy;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.kotlin.types.JetType;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.TypeSubstitutor;

public class ResolvedCallImpl<D extends CallableDescriptor>
implements MutableResolvedCall<D> {
    public static final Function<MutableResolvedCall<?>, CallableDescriptor> MAP_TO_CANDIDATE = new Function<MutableResolvedCall<?>, CallableDescriptor>(){

        public CallableDescriptor fun(MutableResolvedCall<?> resolvedCall) {
            return resolvedCall.getCandidateDescriptor();
        }
    };
    public static final Function<MutableResolvedCall<?>, CallableDescriptor> MAP_TO_RESULT = new Function<MutableResolvedCall<?>, CallableDescriptor>(){

        public CallableDescriptor fun(MutableResolvedCall<?> resolvedCall) {
            return resolvedCall.getResultingDescriptor();
        }
    };
    private final Call call;
    private final D candidateDescriptor;
    private D resultingDescriptor;
    private final ReceiverValue dispatchReceiver;
    private final ReceiverValue extensionReceiver;
    private final ExplicitReceiverKind explicitReceiverKind;
    private final TypeSubstitutor knownTypeParametersSubstitutor;
    private final Map<TypeParameterDescriptor, JetType> typeArguments;
    private final Map<ValueParameterDescriptor, ResolvedValueArgument> valueArguments;
    private final MutableDataFlowInfoForArguments dataFlowInfoForArguments;
    private final Map<ValueArgument, ArgumentMatchImpl> argumentToParameterMap;
    private DelegatingBindingTrace trace;
    private TracingStrategy tracing;
    private ResolutionStatus status;
    private ConstraintSystem constraintSystem;
    private Boolean hasInferredReturnType;
    private boolean completed;

    @NotNull
    public static <D extends CallableDescriptor> ResolvedCallImpl<D> create(@NotNull ResolutionCandidate<D> candidate, @NotNull DelegatingBindingTrace trace, @NotNull TracingStrategy tracing, @NotNull MutableDataFlowInfoForArguments dataFlowInfoForArguments) {
        if (candidate == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "candidate", "org/jetbrains/kotlin/resolve/calls/model/ResolvedCallImpl", "create"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/resolve/calls/model/ResolvedCallImpl", "create"));
        }
        if (tracing == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tracing", "org/jetbrains/kotlin/resolve/calls/model/ResolvedCallImpl", "create"));
        }
        if (dataFlowInfoForArguments == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataFlowInfoForArguments", "org/jetbrains/kotlin/resolve/calls/model/ResolvedCallImpl", "create"));
        }
        ResolvedCallImpl<D> resolvedCallImpl = new ResolvedCallImpl<D>(candidate, trace, tracing, dataFlowInfoForArguments);
        if (resolvedCallImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/model/ResolvedCallImpl", "create"));
        }
        return resolvedCallImpl;
    }

    private ResolvedCallImpl(@NotNull ResolutionCandidate<D> candidate, @NotNull DelegatingBindingTrace trace, @NotNull TracingStrategy tracing, @NotNull MutableDataFlowInfoForArguments dataFlowInfoForArguments) {
        if (candidate == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "candidate", "org/jetbrains/kotlin/resolve/calls/model/ResolvedCallImpl", "<init>"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/resolve/calls/model/ResolvedCallImpl", "<init>"));
        }
        if (tracing == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tracing", "org/jetbrains/kotlin/resolve/calls/model/ResolvedCallImpl", "<init>"));
        }
        if (dataFlowInfoForArguments == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataFlowInfoForArguments", "org/jetbrains/kotlin/resolve/calls/model/ResolvedCallImpl", "<init>"));
        }
        this.typeArguments = Maps.newLinkedHashMap();
        this.valueArguments = Maps.newLinkedHashMap();
        this.argumentToParameterMap = Maps.newHashMap();
        this.status = ResolutionStatus.UNKNOWN_STATUS;
        this.constraintSystem = null;
        this.hasInferredReturnType = null;
        this.completed = false;
        this.call = candidate.getCall();
        this.candidateDescriptor = candidate.getDescriptor();
        this.dispatchReceiver = candidate.getDispatchReceiver();
        this.extensionReceiver = candidate.getExtensionReceiver();
        this.explicitReceiverKind = candidate.getExplicitReceiverKind();
        this.knownTypeParametersSubstitutor = candidate.getKnownTypeParametersResultingSubstitutor();
        this.trace = trace;
        this.tracing = tracing;
        this.dataFlowInfoForArguments = dataFlowInfoForArguments;
    }

    @Override
    @NotNull
    public ResolutionStatus getStatus() {
        ResolutionStatus resolutionStatus = this.status;
        if (resolutionStatus == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/model/ResolvedCallImpl", "getStatus"));
        }
        return resolutionStatus;
    }

    @Override
    public void addStatus(@NotNull ResolutionStatus status) {
        if (status == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "status", "org/jetbrains/kotlin/resolve/calls/model/ResolvedCallImpl", "addStatus"));
        }
        this.status = this.status.combine(status);
    }

    @Override
    public void setStatusToSuccess() {
        assert (this.status == ResolutionStatus.INCOMPLETE_TYPE_INFERENCE || this.status == ResolutionStatus.UNKNOWN_STATUS);
        this.status = ResolutionStatus.SUCCESS;
    }

    @Override
    @NotNull
    public DelegatingBindingTrace getTrace() {
        this.assertNotCompleted("Trace");
        DelegatingBindingTrace delegatingBindingTrace = this.trace;
        if (delegatingBindingTrace == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/model/ResolvedCallImpl", "getTrace"));
        }
        return delegatingBindingTrace;
    }

    @NotNull
    public TracingStrategy getTracing() {
        this.assertNotCompleted("TracingStrategy");
        TracingStrategy tracingStrategy = this.tracing;
        if (tracingStrategy == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/model/ResolvedCallImpl", "getTracing"));
        }
        return tracingStrategy;
    }

    @Override
    @NotNull
    public Call getCall() {
        Call call = this.call;
        if (call == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/model/ResolvedCallImpl", "getCall"));
        }
        return call;
    }

    @Override
    @NotNull
    public D getCandidateDescriptor() {
        D d = this.candidateDescriptor;
        if (d == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/model/ResolvedCallImpl", "getCandidateDescriptor"));
        }
        return d;
    }

    @Override
    @NotNull
    public D getResultingDescriptor() {
        D d = this.resultingDescriptor == null ? this.candidateDescriptor : this.resultingDescriptor;
        if (d == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/model/ResolvedCallImpl", "getResultingDescriptor"));
        }
        return d;
    }

    @Override
    public void setResultingSubstitutor(@NotNull TypeSubstitutor substitutor3) {
        if (substitutor3 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "substitutor", "org/jetbrains/kotlin/resolve/calls/model/ResolvedCallImpl", "setResultingSubstitutor"));
        }
        this.resultingDescriptor = this.candidateDescriptor.substitute(substitutor3);
        assert (this.resultingDescriptor != null) : this.candidateDescriptor;
        for (TypeParameterDescriptor typeParameter : this.candidateDescriptor.getTypeParameters()) {
            TypeProjection typeArgumentProjection = substitutor3.getSubstitution().get(typeParameter.getTypeConstructor());
            if (typeArgumentProjection == null) continue;
            this.typeArguments.put(typeParameter, typeArgumentProjection.getType());
        }
        HashMap substitutedParametersMap = Maps.newHashMap();
        for (ValueParameterDescriptor valueParameterDescriptor : this.resultingDescriptor.getValueParameters()) {
            substitutedParametersMap.put(valueParameterDescriptor.getOriginal(), valueParameterDescriptor);
        }
        LinkedHashMap originalValueArguments = Maps.newLinkedHashMap(this.valueArguments);
        this.valueArguments.clear();
        for (Map.Entry entry : originalValueArguments.entrySet()) {
            ValueParameterDescriptor substitutedVersion = (ValueParameterDescriptor)substitutedParametersMap.get(((ValueParameterDescriptor)entry.getKey()).getOriginal());
            assert (substitutedVersion != null) : (ValueParameterDescriptor)entry.getKey();
            this.valueArguments.put(substitutedVersion, (ResolvedValueArgument)entry.getValue());
        }
        LinkedHashMap originalArgumentToParameterMap = Maps.newLinkedHashMap(this.argumentToParameterMap);
        this.argumentToParameterMap.clear();
        for (Map.Entry entry : originalArgumentToParameterMap.entrySet()) {
            ArgumentMatchImpl argumentMatch = (ArgumentMatchImpl)entry.getValue();
            ValueParameterDescriptor valueParameterDescriptor = argumentMatch.getValueParameter();
            ValueParameterDescriptor substitutedVersion = (ValueParameterDescriptor)substitutedParametersMap.get(valueParameterDescriptor.getOriginal());
            assert (substitutedVersion != null) : valueParameterDescriptor;
            this.argumentToParameterMap.put((ValueArgument)entry.getKey(), argumentMatch.replaceValueParameter(substitutedVersion));
        }
    }

    @Override
    public void setConstraintSystem(@NotNull ConstraintSystem constraintSystem) {
        if (constraintSystem == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "constraintSystem", "org/jetbrains/kotlin/resolve/calls/model/ResolvedCallImpl", "setConstraintSystem"));
        }
        this.constraintSystem = constraintSystem;
    }

    @Override
    @Nullable
    public ConstraintSystem getConstraintSystem() {
        this.assertNotCompleted("ConstraintSystem");
        return this.constraintSystem;
    }

    @Override
    public void recordValueArgument(@NotNull ValueParameterDescriptor valueParameter, @NotNull ResolvedValueArgument valueArgument) {
        if (valueParameter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "valueParameter", "org/jetbrains/kotlin/resolve/calls/model/ResolvedCallImpl", "recordValueArgument"));
        }
        if (valueArgument == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "valueArgument", "org/jetbrains/kotlin/resolve/calls/model/ResolvedCallImpl", "recordValueArgument"));
        }
        assert (!this.valueArguments.containsKey(valueParameter)) : valueParameter + " -> " + valueArgument;
        this.valueArguments.put(valueParameter, valueArgument);
        for (ValueArgument argument : valueArgument.getArguments()) {
            this.argumentToParameterMap.put(argument, new ArgumentMatchImpl(valueParameter));
        }
    }

    @Override
    @NotNull
    public ReceiverValue getExtensionReceiver() {
        ReceiverValue receiverValue = this.extensionReceiver;
        if (receiverValue == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/model/ResolvedCallImpl", "getExtensionReceiver"));
        }
        return receiverValue;
    }

    @Override
    @NotNull
    public ReceiverValue getDispatchReceiver() {
        ReceiverValue receiverValue = this.dispatchReceiver;
        if (receiverValue == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/model/ResolvedCallImpl", "getDispatchReceiver"));
        }
        return receiverValue;
    }

    @Override
    @NotNull
    public ExplicitReceiverKind getExplicitReceiverKind() {
        ExplicitReceiverKind explicitReceiverKind = this.explicitReceiverKind;
        if (explicitReceiverKind == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/model/ResolvedCallImpl", "getExplicitReceiverKind"));
        }
        return explicitReceiverKind;
    }

    @Override
    @NotNull
    public Map<ValueParameterDescriptor, ResolvedValueArgument> getValueArguments() {
        Map<ValueParameterDescriptor, ResolvedValueArgument> map2 = this.valueArguments;
        if (map2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/model/ResolvedCallImpl", "getValueArguments"));
        }
        return map2;
    }

    @Override
    @Nullable
    public List<ResolvedValueArgument> getValueArgumentsByIndex() {
        ArrayList<ResolvedValueArgument> arguments2 = new ArrayList<ResolvedValueArgument>(this.candidateDescriptor.getValueParameters().size());
        for (int i = 0; i < this.candidateDescriptor.getValueParameters().size(); ++i) {
            arguments2.add(null);
        }
        for (Map.Entry<ValueParameterDescriptor, ResolvedValueArgument> entry : this.valueArguments.entrySet()) {
            ValueParameterDescriptor parameterDescriptor = entry.getKey();
            ResolvedValueArgument value2 = entry.getValue();
            ResolvedValueArgument oldValue = arguments2.set(parameterDescriptor.getIndex(), value2);
            if (oldValue == null) continue;
            return null;
        }
        for (int i = 0; i < arguments2.size(); ++i) {
            Object o = arguments2.get(i);
            if (o != null) continue;
            return null;
        }
        return arguments2;
    }

    @Override
    public void recordArgumentMatchStatus(@NotNull ValueArgument valueArgument, @NotNull ArgumentMatchStatus matchStatus) {
        if (valueArgument == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "valueArgument", "org/jetbrains/kotlin/resolve/calls/model/ResolvedCallImpl", "recordArgumentMatchStatus"));
        }
        if (matchStatus == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "matchStatus", "org/jetbrains/kotlin/resolve/calls/model/ResolvedCallImpl", "recordArgumentMatchStatus"));
        }
        ArgumentMatchImpl argumentMatch = this.argumentToParameterMap.get(valueArgument);
        argumentMatch.recordMatchStatus(matchStatus);
    }

    @Override
    @NotNull
    public ArgumentMapping getArgumentMapping(@NotNull ValueArgument valueArgument) {
        if (valueArgument == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "valueArgument", "org/jetbrains/kotlin/resolve/calls/model/ResolvedCallImpl", "getArgumentMapping"));
        }
        ArgumentMatch argumentMatch = this.argumentToParameterMap.get(valueArgument);
        if (argumentMatch == null) {
            ArgumentUnmapped argumentUnmapped = ArgumentUnmapped.INSTANCE$;
            if (argumentUnmapped == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/model/ResolvedCallImpl", "getArgumentMapping"));
            }
            return argumentUnmapped;
        }
        ArgumentMatch argumentMatch2 = argumentMatch;
        if (argumentMatch2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/model/ResolvedCallImpl", "getArgumentMapping"));
        }
        return argumentMatch2;
    }

    @Override
    @NotNull
    public Map<TypeParameterDescriptor, JetType> getTypeArguments() {
        Map<TypeParameterDescriptor, JetType> map2 = this.typeArguments;
        if (map2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/model/ResolvedCallImpl", "getTypeArguments"));
        }
        return map2;
    }

    @Override
    public boolean isSafeCall() {
        return CallUtilPackage.isSafeCall(this.call);
    }

    @Override
    @NotNull
    public MutableDataFlowInfoForArguments getDataFlowInfoForArguments() {
        MutableDataFlowInfoForArguments mutableDataFlowInfoForArguments = this.dataFlowInfoForArguments;
        if (mutableDataFlowInfoForArguments == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/model/ResolvedCallImpl", "getDataFlowInfoForArguments"));
        }
        return mutableDataFlowInfoForArguments;
    }

    @Override
    public boolean hasInferredReturnType() {
        if (!this.completed) {
            this.hasInferredReturnType = this.constraintSystem == null || CallResolverUtil.hasInferredReturnType(this.candidateDescriptor, this.constraintSystem);
        }
        assert (this.hasInferredReturnType != null) : "The property 'hasInferredReturnType' was not set when the call was completed.";
        return this.hasInferredReturnType;
    }

    @Override
    public void markCallAsCompleted() {
        if (!this.completed) {
            this.hasInferredReturnType();
        }
        this.trace = null;
        this.constraintSystem = null;
        this.tracing = null;
        this.completed = true;
    }

    @Override
    public boolean isCompleted() {
        return this.completed;
    }

    private void assertNotCompleted(String elementName) {
        assert (!this.completed) : elementName + " is erased after resolution completion.";
    }

    @Override
    @Nullable
    public TypeSubstitutor getKnownTypeParametersSubstitutor() {
        return this.knownTypeParametersSubstitutor;
    }
}

