/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.constants;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.types.JetType;
import org.jetbrains.kotlin.types.TypeConstructor;

public class IntegerValueTypeConstructor
implements TypeConstructor {
    private final long value;
    private final Collection<JetType> supertypes = new ArrayList<JetType>(4);

    public IntegerValueTypeConstructor(long value2) {
        this.value = value2;
        this.checkBoundsAndAddSuperType(value2, Integer.MIN_VALUE, Integer.MAX_VALUE, KotlinBuiltIns.getInstance().getIntType());
        this.checkBoundsAndAddSuperType(value2, -128L, 127L, KotlinBuiltIns.getInstance().getByteType());
        this.checkBoundsAndAddSuperType(value2, -32768L, 32767L, KotlinBuiltIns.getInstance().getShortType());
        this.supertypes.add(KotlinBuiltIns.getInstance().getLongType());
    }

    private void checkBoundsAndAddSuperType(long value2, long minValue, long maxValue, JetType kotlinType) {
        if (value2 >= minValue && value2 <= maxValue) {
            this.supertypes.add(kotlinType);
        }
    }

    @Override
    @NotNull
    public Collection<JetType> getSupertypes() {
        Collection<JetType> collection = this.supertypes;
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/constants/IntegerValueTypeConstructor", "getSupertypes"));
        }
        return collection;
    }

    @Override
    @NotNull
    public List<TypeParameterDescriptor> getParameters() {
        List<TypeParameterDescriptor> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/constants/IntegerValueTypeConstructor", "getParameters"));
        }
        return list;
    }

    @Override
    public boolean isFinal() {
        return false;
    }

    @Override
    public boolean isDenotable() {
        return false;
    }

    @Override
    @Nullable
    public ClassifierDescriptor getDeclarationDescriptor() {
        return null;
    }

    @Override
    @NotNull
    public Annotations getAnnotations() {
        Annotations annotations2 = Annotations.EMPTY;
        if (annotations2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/constants/IntegerValueTypeConstructor", "getAnnotations"));
        }
        return annotations2;
    }

    public Long getValue() {
        return this.value;
    }

    public String toString() {
        return "IntegerValueType(" + this.value + ")";
    }
}

