/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.types;

import org.jetbrains.kotlin.types.TypeConstructor;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.TypeSubstitution;

public class CompositeTypeSubstitution
extends TypeSubstitution {
    private final TypeSubstitution[] inner;

    public CompositeTypeSubstitution(TypeSubstitution ... inner) {
        if (inner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inner", "org/jetbrains/kotlin/types/CompositeTypeSubstitution", "<init>"));
        }
        this.inner = inner;
    }

    @Override
    public TypeProjection get(TypeConstructor key) {
        for (TypeSubstitution substitution : this.inner) {
            TypeProjection value2 = substitution.get(key);
            if (value2 == null) continue;
            return value2;
        }
        return null;
    }

    @Override
    public boolean isEmpty() {
        for (TypeSubstitution substitution : this.inner) {
            if (substitution.isEmpty()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean approximateCapturedTypes() {
        for (TypeSubstitution substitution : this.inner) {
            if (!substitution.approximateCapturedTypes()) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        for (TypeSubstitution substitution : this.inner) {
            builder.append(substitution).append(" * ");
        }
        return builder.toString();
    }
}

