/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.types;

import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.types.JetType;
import org.jetbrains.kotlin.types.TypeConstructor;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.TypeSubstitutor;

public class SubstitutionUtils {
    private SubstitutionUtils() {
    }

    @NotNull
    public static TypeSubstitutor buildDeepSubstitutor(@NotNull JetType type2) {
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/types/SubstitutionUtils", "buildDeepSubstitutor"));
        }
        HashMap substitution = Maps.newHashMap();
        TypeSubstitutor typeSubstitutor2 = TypeSubstitutor.create(substitution);
        SubstitutionUtils.fillInDeepSubstitutor(type2, typeSubstitutor2, substitution, null);
        TypeSubstitutor typeSubstitutor3 = typeSubstitutor2;
        if (typeSubstitutor3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/SubstitutionUtils", "buildDeepSubstitutor"));
        }
        return typeSubstitutor3;
    }

    @NotNull
    public static Multimap<TypeConstructor, TypeProjection> buildDeepSubstitutionMultimap(@NotNull JetType type2) {
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/types/SubstitutionUtils", "buildDeepSubstitutionMultimap"));
        }
        LinkedHashMultimap fullSubstitution = LinkedHashMultimap.create();
        HashMap substitution = Maps.newHashMap();
        TypeSubstitutor typeSubstitutor2 = TypeSubstitutor.create(substitution);
        SubstitutionUtils.fillInDeepSubstitutor(type2, typeSubstitutor2, substitution, (Multimap<TypeConstructor, TypeProjection>)fullSubstitution);
        LinkedHashMultimap linkedHashMultimap = fullSubstitution;
        if (linkedHashMultimap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/SubstitutionUtils", "buildDeepSubstitutionMultimap"));
        }
        return linkedHashMultimap;
    }

    private static void fillInDeepSubstitutor(@NotNull JetType context2, @NotNull TypeSubstitutor substitutor3, @NotNull Map<TypeConstructor, TypeProjection> substitution, @Nullable Multimap<TypeConstructor, TypeProjection> fullSubstitution) {
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/types/SubstitutionUtils", "fillInDeepSubstitutor"));
        }
        if (substitutor3 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "substitutor", "org/jetbrains/kotlin/types/SubstitutionUtils", "fillInDeepSubstitutor"));
        }
        if (substitution == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "substitution", "org/jetbrains/kotlin/types/SubstitutionUtils", "fillInDeepSubstitutor"));
        }
        List<TypeParameterDescriptor> parameters2 = context2.getConstructor().getParameters();
        List<TypeProjection> arguments2 = context2.getArguments();
        if (parameters2.size() != arguments2.size()) {
            throw new IllegalStateException();
        }
        for (int i = 0; i < arguments2.size(); ++i) {
            TypeProjection argument = arguments2.get(i);
            TypeParameterDescriptor parameter = parameters2.get(i);
            TypeProjection substitute = substitutor3.substitute(argument);
            assert (substitute != null);
            substitution.put(parameter.getTypeConstructor(), substitute);
            if (fullSubstitution == null) continue;
            fullSubstitution.put((Object)parameter.getTypeConstructor(), (Object)substitute);
        }
        if (KotlinBuiltIns.isNothingOrNullableNothing(context2)) {
            return;
        }
        for (JetType supertype : context2.getConstructor().getSupertypes()) {
            SubstitutionUtils.fillInDeepSubstitutor(supertype, substitutor3, substitution, fullSubstitution);
        }
    }
}

