/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dvcs.push;

import com.intellij.dvcs.push.CommitLoader;
import com.intellij.dvcs.push.VcsErrorHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsError {
    @NotNull
    String myErrorText;
    @Nullable
    private final VcsErrorHandler myErrorHandleListener;

    public VcsError(@NotNull String text) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/dvcs/push/VcsError", "<init>"));
        }
        this(text, null);
    }

    public VcsError(@NotNull String text, @Nullable VcsErrorHandler listener) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/dvcs/push/VcsError", "<init>"));
        }
        this.myErrorText = text;
        this.myErrorHandleListener = listener;
    }

    public String getText() {
        return this.myErrorText;
    }

    public void handleError(@NotNull CommitLoader loader) {
        if (loader == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "loader", "com/intellij/dvcs/push/VcsError", "handleError"));
        }
        if (this.myErrorHandleListener != null) {
            this.myErrorHandleListener.handleError(loader);
        }
    }

    public static VcsError createEmptyTargetError(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/dvcs/push/VcsError", "createEmptyTargetError"));
        }
        return new VcsError("Please, specify not empty remote push path for repository " + name + ".");
    }
}

