/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang;

import com.intellij.injected.editor.VirtualFileWindow;
import com.intellij.lang.PerFileMappings;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.roots.impl.FilePropertyPusher;
import com.intellij.openapi.roots.impl.PushedFilePropertiesUpdater;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PerFileMappingsBase<T>
implements PersistentStateComponent<Element>,
PerFileMappings<T> {
    private final Map<VirtualFile, T> myMappings = ContainerUtil.newHashMap();

    @Nullable
    protected FilePropertyPusher<T> getFilePropertyPusher() {
        return null;
    }

    @Nullable
    protected Project getProject() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    @NotNull
    public Map<VirtualFile, T> getMappings() {
        Map<VirtualFile, T> map2 = this.myMappings;
        // MONITORENTER : map2
        this.cleanup();
        Map<VirtualFile, T> map = Collections.unmodifiableMap(this.myMappings);
        // MONITOREXIT : map2
        if (map != null) return map;
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/PerFileMappingsBase", "getMappings"));
    }

    private void cleanup() {
        for (VirtualFile file : new ArrayList<VirtualFile>(this.myMappings.keySet())) {
            if (file == null || file.isValid()) continue;
            this.myMappings.remove(file);
        }
    }

    @Override
    @Nullable
    public T getMapping(@Nullable VirtualFile file) {
        FilePropertyPusher<T> pusher = this.getFilePropertyPusher();
        T t = PerFileMappingsBase.getMappingInner(file, this.myMappings, pusher == null ? null : pusher.getFileDataKey());
        return t == null ? this.getDefaultMapping(file) : t;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    protected static <T> T getMappingInner(@Nullable VirtualFile file, @Nullable Map<VirtualFile, T> mappings, @Nullable Key<T> pusherKey) {
        Object pushedValue;
        VirtualFile originalFile;
        if (file instanceof VirtualFileWindow) {
            VirtualFileWindow window = (VirtualFileWindow)((Object)file);
            file = window.getDelegate();
        }
        VirtualFile virtualFile = originalFile = file instanceof LightVirtualFile ? ((LightVirtualFile)file).getOriginalFile() : null;
        if (Comparing.equal((Object)originalFile, (Object)file)) {
            originalFile = null;
        }
        if (file != null) {
            Object object = pushedValue = pusherKey == null ? null : file.getUserData(pusherKey);
            if (pushedValue != null) {
                return (T)pushedValue;
            }
        }
        if (originalFile != null) {
            Object object = pushedValue = pusherKey == null ? null : originalFile.getUserData(pusherKey);
            if (pushedValue != null) {
                return (T)pushedValue;
            }
        }
        if (mappings == null) {
            return null;
        }
        Map<VirtualFile, T> map = mappings;
        synchronized (map) {
            T t = PerFileMappingsBase.getMappingForHierarchy(file, mappings);
            if (t != null) {
                return t;
            }
            t = PerFileMappingsBase.getMappingForHierarchy(originalFile, mappings);
            if (t != null) {
                return t;
            }
            return mappings.get(null);
        }
    }

    private static <T> T getMappingForHierarchy(@Nullable VirtualFile file, @NotNull Map<VirtualFile, T> mappings) {
        if (mappings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mappings", "com/intellij/lang/PerFileMappingsBase", "getMappingForHierarchy"));
        }
        for (VirtualFile cur = file; cur != null; cur = cur.getParent()) {
            T t = mappings.get(cur);
            if (t == null) continue;
            return t;
        }
        return null;
    }

    @Override
    public T chosenToStored(VirtualFile file, T value) {
        return value;
    }

    @Override
    public boolean isSelectable(T value) {
        return true;
    }

    @Override
    @Nullable
    public T getDefaultMapping(@Nullable VirtualFile file) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public T getImmediateMapping(@Nullable VirtualFile file) {
        Map<VirtualFile, T> map = this.myMappings;
        synchronized (map) {
            return this.myMappings.get(file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setMappings(@NotNull Map<VirtualFile, T> mappings) {
        ArrayList oldFiles;
        if (mappings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mappings", "com/intellij/lang/PerFileMappingsBase", "setMappings"));
        }
        Map<VirtualFile, T> map = this.myMappings;
        synchronized (map) {
            oldFiles = ContainerUtil.newArrayList(this.myMappings.keySet());
            this.myMappings.clear();
            this.myMappings.putAll(mappings);
            this.cleanup();
        }
        Project project = this.getProject();
        this.handleMappingChange(mappings.keySet(), oldFiles, project != null && !project.isDefault());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setMapping(@Nullable VirtualFile file, @Nullable T dialect) {
        Map<VirtualFile, T> map = this.myMappings;
        synchronized (map) {
            if (dialect == null) {
                this.myMappings.remove(file);
            } else {
                this.myMappings.put(file, dialect);
            }
        }
        List files = ContainerUtil.createMaybeSingletonList((Object)file);
        this.handleMappingChange(files, files, false);
    }

    private void handleMappingChange(Collection<VirtualFile> files, Collection<VirtualFile> oldFiles, boolean includeOpenFiles) {
        Project project = this.getProject();
        FilePropertyPusher<T> pusher = this.getFilePropertyPusher();
        if (project != null && pusher != null) {
            for (VirtualFile oldFile : oldFiles) {
                if (oldFile == null) continue;
                oldFile.putUserData(pusher.getFileDataKey(), null);
            }
            PushedFilePropertiesUpdater updater = PushedFilePropertiesUpdater.getInstance(project);
            updater.pushAll(pusher);
        }
        if (this.shouldReparseFiles()) {
            Project[] projects;
            Project[] projectArray;
            if (project == null) {
                projectArray = ProjectManager.getInstance().getOpenProjects();
            } else {
                Project[] projectArray2 = new Project[1];
                projectArray = projectArray2;
                projectArray2[0] = project;
            }
            for (Project p : projects = projectArray) {
                PsiDocumentManager.getInstance(p).reparseFiles(files, includeOpenFiles);
            }
        }
    }

    @Override
    public Collection<T> getAvailableValues(VirtualFile file) {
        return this.getAvailableValues();
    }

    protected abstract List<T> getAvailableValues();

    @Nullable
    protected abstract String serialize(T var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Element getState() {
        Map<VirtualFile, T> map = this.myMappings;
        synchronized (map) {
            this.cleanup();
            Element element = new Element("x");
            ArrayList<VirtualFile> files = new ArrayList<VirtualFile>(this.myMappings.keySet());
            Collections.sort(files, new Comparator<VirtualFile>(){

                @Override
                public int compare(VirtualFile o1, VirtualFile o2) {
                    if (o1 == null || o2 == null) {
                        return o1 == null ? (o2 == null ? 0 : 1) : -1;
                    }
                    return o1.getPath().compareTo(o2.getPath());
                }
            });
            for (VirtualFile file : files) {
                T dialect = this.myMappings.get(file);
                String value = this.serialize(dialect);
                if (value == null) continue;
                Element child = new Element("file");
                element.addContent(child);
                child.setAttribute("url", file == null ? "PROJECT" : file.getUrl());
                child.setAttribute(this.getValueAttribute(), value);
            }
            return element;
        }
    }

    @Nullable
    protected T handleUnknownMapping(VirtualFile file, String value) {
        return null;
    }

    @NotNull
    protected String getValueAttribute() {
        if ("value" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/PerFileMappingsBase", "getValueAttribute"));
        }
        return "value";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void loadState(Element state) {
        Map<VirtualFile, T> map = this.myMappings;
        synchronized (map) {
            THashMap dialectMap = new THashMap();
            for (T dialect : this.getAvailableValues()) {
                String key = this.serialize(dialect);
                if (key == null) continue;
                dialectMap.put((Object)key, dialect);
            }
            this.myMappings.clear();
            List files = state.getChildren("file");
            for (Element fileElement : files) {
                String url = fileElement.getAttributeValue("url");
                String dialectID = fileElement.getAttributeValue(this.getValueAttribute());
                VirtualFile file = url.equals("PROJECT") ? null : VirtualFileManager.getInstance().findFileByUrl(url);
                Object dialect = dialectMap.get((Object)dialectID);
                if (dialect == null && (dialect = this.handleUnknownMapping(file, dialectID)) == null || file == null && !url.equals("PROJECT")) continue;
                this.myMappings.put(file, dialect);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanupForNextTest() {
        Map<VirtualFile, T> map = this.myMappings;
        synchronized (map) {
            this.myMappings.clear();
        }
    }

    protected boolean shouldReparseFiles() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasMappings() {
        Map<VirtualFile, T> map = this.myMappings;
        synchronized (map) {
            return !this.myMappings.isEmpty();
        }
    }
}

