/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdklib;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.prefs.AndroidLocation;
import com.android.sdklib.BuildToolInfo;
import com.android.sdklib.IAndroidTarget;
import com.android.sdklib.internal.androidTarget.PlatformTarget;
import com.android.sdklib.repository.FullRevision;
import com.android.sdklib.repository.descriptors.IPkgDesc;
import com.android.sdklib.repository.descriptors.PkgType;
import com.android.sdklib.repository.local.LocalExtraPkgInfo;
import com.android.sdklib.repository.local.LocalPkgInfo;
import com.android.sdklib.repository.local.LocalSdk;
import com.android.utils.ILogger;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;

public class SdkManager {
    private static final boolean DEBUG = System.getenv("SDKMAN_DEBUG") != null;
    private static final String ADB_INI_FILE = "adb_usb.ini";
    private static final String ADB_INI_HEADER = "# ANDROID 3RD PARTY USB VENDOR ID LIST -- DO NOT EDIT.\n# USE 'android update adb' TO GENERATE.\n# 1 USB VENDOR ID PER LINE.\n";
    private final LocalSdk mLocalSdk;

    protected SdkManager(@NonNull String osSdkPath) {
        this.mLocalSdk = new LocalSdk(new File(osSdkPath));
    }

    private SdkManager(@NonNull LocalSdk localSdk) {
        this.mLocalSdk = localSdk;
    }

    @Nullable
    public static SdkManager createManager(@NonNull String osSdkPath, @NonNull ILogger log) {
        try {
            SdkManager manager = new SdkManager(osSdkPath);
            manager.reloadSdk(log);
            return manager;
        }
        catch (Throwable throwable) {
            log.error(throwable, "Error parsing the sdk.", new Object[0]);
            return null;
        }
    }

    @NonNull
    public static SdkManager createManager(@NonNull LocalSdk localSdk) {
        return new SdkManager(localSdk);
    }

    @NonNull
    public LocalSdk getLocalSdk() {
        return this.mLocalSdk;
    }

    public void reloadSdk(@NonNull ILogger log) {
        this.mLocalSdk.clearLocalPkg(PkgType.PKG_ALL);
    }

    public boolean hasChanged() {
        return this.hasChanged(null);
    }

    public boolean hasChanged(@Nullable ILogger log) {
        return this.mLocalSdk.hasChanged(EnumSet.of(PkgType.PKG_PLATFORM, PkgType.PKG_ADDON, PkgType.PKG_BUILD_TOOLS));
    }

    @NonNull
    public String getLocation() {
        File f = this.mLocalSdk.getLocation();
        assert (f != null);
        return f.getPath();
    }

    @NonNull
    public IAndroidTarget[] getTargets() {
        return this.mLocalSdk.getTargets();
    }

    @Deprecated
    @NonNull
    public Set<FullRevision> getBuildTools() {
        LocalPkgInfo[] pkgs = this.mLocalSdk.getPkgsInfos(PkgType.PKG_BUILD_TOOLS);
        TreeSet<FullRevision> bt = new TreeSet<FullRevision>();
        for (LocalPkgInfo pkg : pkgs) {
            IPkgDesc d = pkg.getDesc();
            if (!d.hasFullRevision()) continue;
            bt.add(d.getFullRevision());
        }
        return Collections.unmodifiableSet(bt);
    }

    @Nullable
    public BuildToolInfo getLatestBuildTool() {
        return this.mLocalSdk.getLatestBuildTool();
    }

    @Nullable
    public BuildToolInfo getBuildTool(@Nullable FullRevision revision) {
        return this.mLocalSdk.getBuildTool(revision);
    }

    @Nullable
    public IAndroidTarget getTargetFromHashString(@Nullable String hash) {
        return this.mLocalSdk.getTargetFromHashString(hash);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateAdb() throws AndroidLocation.AndroidLocationException, IOException {
        OutputStreamWriter writer = null;
        try {
            File adbIni = new File(AndroidLocation.getFolder(), ADB_INI_FILE);
            writer = new FileWriter(adbIni);
            HashSet<Integer> set = new HashSet<Integer>();
            IAndroidTarget[] targets = this.getTargets();
            for (IAndroidTarget target : targets) {
                if (target.getUsbVendorId() == 0) continue;
                set.add(target.getUsbVendorId());
            }
            writer.write(ADB_INI_HEADER);
            for (Integer i : set) {
                writer.write(String.format("0x%04x\n", i));
            }
        }
        finally {
            if (writer != null) {
                writer.close();
            }
        }
    }

    @Deprecated
    @Nullable
    public LayoutlibVersion getMaxLayoutlibVersion() {
        LayoutlibVersion maxVersion = null;
        for (IAndroidTarget target : this.getTargets()) {
            LayoutlibVersion lv;
            if (!(target instanceof PlatformTarget) || (lv = ((PlatformTarget)target).getLayoutlibVersion()) == null || maxVersion != null && lv.compareTo(maxVersion) <= 0) continue;
            maxVersion = lv;
        }
        return maxVersion;
    }

    @NonNull
    public Map<File, String> getExtraSamples() {
        LocalPkgInfo[] pkgsInfos = this.mLocalSdk.getPkgsInfos(PkgType.PKG_EXTRA);
        HashMap<File, String> samples = new HashMap<File, String>();
        for (LocalPkgInfo info : pkgsInfos) {
            assert (info instanceof LocalExtraPkgInfo);
            File root = info.getLocalDir();
            File path = new File(root, "samples");
            if (path.isDirectory()) {
                samples.put(path, info.getListDescription());
                continue;
            }
            path = new File(root, "sample");
            if (!path.isDirectory() || !new File(path, "AndroidManifest.xml").isFile()) continue;
            samples.put(path, info.getListDescription());
        }
        return samples;
    }

    @Deprecated
    @NonNull
    public Map<String, Integer> getExtrasVersions() {
        LocalPkgInfo[] pkgsInfos = this.mLocalSdk.getPkgsInfos(PkgType.PKG_EXTRA);
        TreeMap<String, Integer> extraVersions = new TreeMap<String, Integer>();
        for (LocalPkgInfo info : pkgsInfos) {
            assert (info instanceof LocalExtraPkgInfo);
            if (!(info instanceof LocalExtraPkgInfo)) continue;
            LocalExtraPkgInfo ei = (LocalExtraPkgInfo)info;
            IPkgDesc d = ei.getDesc();
            String vendor = d.getVendor().getId();
            String path = d.getPath();
            int majorRev = d.getFullRevision().getMajor();
            extraVersions.put(vendor + '/' + path, majorRev);
        }
        return extraVersions;
    }

    @Nullable
    public String getPlatformToolsVersion() {
        IPkgDesc d;
        LocalPkgInfo info = this.mLocalSdk.getPkgInfo(PkgType.PKG_PLATFORM_TOOLS);
        IPkgDesc iPkgDesc = d = info == null ? null : info.getDesc();
        if (d != null && d.hasFullRevision()) {
            return d.getFullRevision().toShortString();
        }
        return null;
    }

    public static class LayoutlibVersion
    implements Comparable<LayoutlibVersion> {
        private final int mApi;
        private final int mRevision;
        public static final int NOT_SPECIFIED = 0;

        public LayoutlibVersion(int api, int revision) {
            this.mApi = api;
            this.mRevision = revision;
        }

        public int getApi() {
            return this.mApi;
        }

        public int getRevision() {
            return this.mRevision;
        }

        @Override
        public int compareTo(@NonNull LayoutlibVersion rhs) {
            boolean useRev = this.mRevision > 0 && rhs.mRevision > 0;
            int lhsValue = (this.mApi << 16) + (useRev ? this.mRevision : 0);
            int rhsValue = (rhs.mApi << 16) + (useRev ? rhs.mRevision : 0);
            return lhsValue - rhsValue;
        }
    }
}

