/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.completion.JavaCompletionUtil;
import com.intellij.codeInsight.completion.MemberLookupHelper;
import com.intellij.codeInsight.completion.OffsetKey;
import com.intellij.codeInsight.completion.StaticallyImportable;
import com.intellij.codeInsight.completion.util.MethodParenthesesHandler;
import com.intellij.codeInsight.lookup.DefaultLookupItemRenderer;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementPresentation;
import com.intellij.codeInsight.lookup.LookupItem;
import com.intellij.codeInsight.lookup.TypedLookupItem;
import com.intellij.codeInsight.lookup.impl.JavaElementLookupRenderer;
import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.util.ClassConditionKey;
import com.intellij.psi.PsiCapturedWildcardType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.TypeConversionUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaMethodCallElement
extends LookupItem<PsiMethod>
implements TypedLookupItem,
StaticallyImportable {
    public static final ClassConditionKey<JavaMethodCallElement> CLASS_CONDITION_KEY = ClassConditionKey.create(JavaMethodCallElement.class);
    @Nullable
    private final PsiClass myContainingClass;
    private final PsiMethod myMethod;
    private final MemberLookupHelper myHelper;
    private PsiSubstitutor myInferenceSubstitutor;
    private boolean myMayNeedExplicitTypeParameters;

    public JavaMethodCallElement(@NotNull PsiMethod method) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/codeInsight/completion/JavaMethodCallElement", "<init>"));
        }
        this(method, method.getName());
    }

    public JavaMethodCallElement(@NotNull PsiMethod method, String methodName) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/codeInsight/completion/JavaMethodCallElement", "<init>"));
        }
        super(method, methodName);
        this.myInferenceSubstitutor = PsiSubstitutor.EMPTY;
        this.myMethod = method;
        this.myHelper = null;
        this.myContainingClass = method.getContainingClass();
    }

    public JavaMethodCallElement(PsiMethod method, boolean shouldImportStatic, boolean mergedOverloads) {
        super(method, method.getName());
        this.myInferenceSubstitutor = PsiSubstitutor.EMPTY;
        this.myMethod = method;
        this.myContainingClass = method.getContainingClass();
        this.myHelper = new MemberLookupHelper((PsiMember)method, this.myContainingClass, shouldImportStatic, mergedOverloads);
        if (!shouldImportStatic) {
            this.forceQualify();
        }
    }

    @Override
    public PsiType getType() {
        return this.getSubstitutor().substitute(this.getInferenceSubstitutor().substitute(((PsiMethod)this.getObject()).getReturnType()));
    }

    public void setInferenceSubstitutor(@NotNull PsiSubstitutor substitutor, PsiElement place) {
        if (substitutor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "substitutor", "com/intellij/codeInsight/completion/JavaMethodCallElement", "setInferenceSubstitutor"));
        }
        this.myInferenceSubstitutor = substitutor;
        this.myMayNeedExplicitTypeParameters = JavaMethodCallElement.mayNeedTypeParameters(place);
    }

    @NotNull
    public PsiSubstitutor getSubstitutor() {
        PsiSubstitutor substitutor = (PsiSubstitutor)this.getAttribute(SUBSTITUTOR);
        PsiSubstitutor psiSubstitutor = substitutor == null ? PsiSubstitutor.EMPTY : substitutor;
        if (psiSubstitutor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/completion/JavaMethodCallElement", "getSubstitutor"));
        }
        return psiSubstitutor;
    }

    @NotNull
    public PsiSubstitutor getInferenceSubstitutor() {
        PsiSubstitutor psiSubstitutor = this.myInferenceSubstitutor;
        if (psiSubstitutor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/completion/JavaMethodCallElement", "getInferenceSubstitutor"));
        }
        return psiSubstitutor;
    }

    @Override
    public void setShouldBeImported(boolean shouldImportStatic) {
        this.myHelper.setShouldBeImported(shouldImportStatic);
    }

    @Override
    public boolean canBeImported() {
        return this.myHelper != null;
    }

    @Override
    public boolean willBeImported() {
        return this.canBeImported() && this.myHelper.willBeImported();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof JavaMethodCallElement)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        return this.myInferenceSubstitutor.equals(((JavaMethodCallElement)o).myInferenceSubstitutor);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.myInferenceSubstitutor.hashCode();
        return result;
    }

    @Override
    public void handleInsert(InsertionContext context) {
        Document document = context.getDocument();
        PsiFile file = context.getFile();
        PsiMethod method = (PsiMethod)this.getObject();
        LookupElement[] allItems = context.getElements();
        boolean overloadsMatter = allItems.length == 1 && this.getUserData(FORCE_SHOW_SIGNATURE_ATTR) == null;
        boolean hasParams = MethodParenthesesHandler.hasParams((LookupElement)this, (LookupElement[])allItems, (boolean)overloadsMatter, (PsiMethod)method);
        JavaCompletionUtil.insertParentheses(context, (LookupElement)this, overloadsMatter, hasParams);
        int startOffset = context.getStartOffset();
        OffsetKey refStart = context.trackOffset(startOffset, true);
        if (this.shouldInsertTypeParameters() && JavaMethodCallElement.mayNeedTypeParameters(context.getFile().findElementAt(context.getStartOffset()))) {
            this.qualifyMethodCall(file, startOffset, document);
            this.insertExplicitTypeParameters(context, refStart);
        } else if (this.myHelper != null || this.getAttribute(FORCE_QUALIFY) != null) {
            context.commitDocument();
            if (this.myHelper != null && this.willBeImported()) {
                PsiReferenceExpression ref = (PsiReferenceExpression)PsiTreeUtil.findElementOfClassAtOffset((PsiFile)file, (int)startOffset, PsiReferenceExpression.class, (boolean)false);
                if (ref != null && this.myContainingClass != null && !ref.isReferenceTo((PsiElement)method)) {
                    ref.bindToElementViaStaticImport(this.myContainingClass);
                }
                return;
            }
            this.qualifyMethodCall(file, startOffset, document);
        }
        PsiType type = method.getReturnType();
        if (context.getCompletionChar() == '!' && type != null && PsiType.BOOLEAN.isAssignableFrom(type)) {
            context.setAddCompletionChar(false);
            context.commitDocument();
            int offset = context.getOffset(refStart);
            PsiMethodCallExpression methodCall = (PsiMethodCallExpression)PsiTreeUtil.findElementOfClassAtOffset((PsiFile)file, (int)offset, PsiMethodCallExpression.class, (boolean)false);
            if (methodCall != null) {
                FeatureUsageTracker.getInstance().triggerFeatureUsed("editing.completion.finishByExclamation");
                document.insertString(methodCall.getTextRange().getStartOffset(), (CharSequence)"!");
            }
        }
    }

    private boolean shouldInsertTypeParameters() {
        return this.myMayNeedExplicitTypeParameters && !this.getInferenceSubstitutor().equals(PsiSubstitutor.EMPTY) && this.myMethod.getParameterList().getParametersCount() == 0;
    }

    public static boolean mayNeedTypeParameters(PsiElement leaf) {
        PsiElement parent;
        if (PsiTreeUtil.getParentOfType((PsiElement)leaf, PsiExpressionList.class, (boolean)true, (Class[])new Class[]{PsiCodeBlock.class, PsiModifierListOwner.class}) == null && PsiTreeUtil.getParentOfType((PsiElement)leaf, PsiConditionalExpression.class, (boolean)true, (Class[])new Class[]{PsiCodeBlock.class, PsiModifierListOwner.class}) == null) {
            return false;
        }
        return leaf == null || !((parent = leaf.getParent()) instanceof PsiReferenceExpression) || ((PsiReferenceExpression)parent).getTypeParameters().length <= 0;
    }

    private void insertExplicitTypeParameters(InsertionContext context, OffsetKey refStart) {
        context.commitDocument();
        String typeParams = this.getTypeParamsText(false);
        if (typeParams != null) {
            context.getDocument().insertString(context.getOffset(refStart), (CharSequence)typeParams);
            JavaCompletionUtil.shortenReference(context.getFile(), context.getOffset(refStart));
        }
    }

    private void qualifyMethodCall(PsiFile file, int startOffset, Document document) {
        PsiReference reference = file.findReferenceAt(startOffset);
        if (reference instanceof PsiReferenceExpression && ((PsiReferenceExpression)reference).isQualified()) {
            return;
        }
        PsiMethod method = (PsiMethod)this.getObject();
        if (!method.hasModifierProperty("static")) {
            document.insertString(startOffset, (CharSequence)"this.");
            return;
        }
        if (this.myContainingClass == null) {
            return;
        }
        document.insertString(startOffset, (CharSequence)".");
        JavaCompletionUtil.insertClassReference(this.myContainingClass, file, startOffset);
    }

    @Nullable
    private String getTypeParamsText(boolean presentable) {
        PsiMethod method = (PsiMethod)this.getObject();
        PsiSubstitutor substitutor = this.getInferenceSubstitutor();
        PsiTypeParameter[] parameters = method.getTypeParameters();
        assert (parameters.length > 0);
        StringBuilder builder = new StringBuilder("<");
        boolean first = true;
        for (PsiTypeParameter parameter : parameters) {
            String text;
            if (!first) {
                builder.append(", ");
            }
            first = false;
            PsiType type = substitutor.substitute(parameter);
            if (type instanceof PsiWildcardType) {
                type = ((PsiWildcardType)type).getExtendsBound();
            }
            if (type == null || type instanceof PsiCapturedWildcardType) {
                return null;
            }
            if (type.equals(TypeConversionUtil.typeParameterErasure((PsiTypeParameter)parameter))) {
                return null;
            }
            String string = text = presentable ? type.getPresentableText() : type.getCanonicalText();
            if (text.indexOf(63) >= 0) {
                return null;
            }
            builder.append(text);
        }
        return builder.append(">").toString();
    }

    @Override
    public LookupItem<PsiMethod> forceQualify() {
        String className;
        if (this.myContainingClass != null && (className = this.myContainingClass.getName()) != null) {
            this.addLookupStrings(new String[]{className + "." + this.myMethod.getName()});
        }
        return super.forceQualify();
    }

    public boolean isValid() {
        return super.isValid() && this.myInferenceSubstitutor.isValid() && this.getSubstitutor().isValid();
    }

    @Override
    public void renderElement(LookupElementPresentation presentation) {
        String typeParamsText;
        MemberLookupHelper helper;
        presentation.setIcon(DefaultLookupItemRenderer.getRawIcon((LookupElement)this, presentation.isReal()));
        presentation.setStrikeout(JavaElementLookupRenderer.isToStrikeout(this));
        MemberLookupHelper memberLookupHelper = helper = this.myHelper != null ? this.myHelper : new MemberLookupHelper((PsiMember)this.myMethod, this.myContainingClass, false, false);
        Boolean qualify = this.getAttribute(FORCE_QUALIFY) != null ? Boolean.TRUE : (this.myHelper == null ? Boolean.FALSE : null);
        helper.renderElement(presentation, qualify, this.getSubstitutor());
        if (this.shouldInsertTypeParameters() && (typeParamsText = this.getTypeParamsText(true)) != null) {
            if (typeParamsText.length() > 10) {
                typeParamsText = typeParamsText.substring(0, 10) + "...>";
            }
            String itemText = presentation.getItemText();
            assert (itemText != null);
            int i = itemText.indexOf(46);
            if (i > 0) {
                presentation.setItemText(itemText.substring(0, i + 1) + typeParamsText + itemText.substring(i + 1));
            }
        }
    }
}

