/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.completion.BasicExpressionCompletionContributor;
import com.intellij.codeInsight.completion.CompletionUtil;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.completion.JavaChainLookupElement;
import com.intellij.codeInsight.completion.JavaCompletionUtil;
import com.intellij.codeInsight.completion.JavaKeywordCompletion;
import com.intellij.codeInsight.completion.JavaMethodCallElement;
import com.intellij.codeInsight.completion.JavaSmartCompletionContributor;
import com.intellij.codeInsight.completion.JavaSmartCompletionParameters;
import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.codeInsight.completion.RecursionWeigher;
import com.intellij.codeInsight.completion.SmartCompletionDecorator;
import com.intellij.codeInsight.lookup.ExpressionLookupItem;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PsiJavaElementPattern;
import com.intellij.patterns.PsiJavaPatterns;
import com.intellij.patterns.PsiMethodPattern;
import com.intellij.patterns.StandardPatterns;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotationParameterList;
import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSwitchLabelStatement;
import com.intellij.psi.PsiSwitchStatement;
import com.intellij.psi.PsiThrowStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.filters.AndFilter;
import com.intellij.psi.filters.ClassFilter;
import com.intellij.psi.filters.ElementExtractorFilter;
import com.intellij.psi.filters.ElementFilter;
import com.intellij.psi.filters.TrueFilter;
import com.intellij.psi.filters.element.ModifierFilter;
import com.intellij.psi.filters.types.AssignableFromFilter;
import com.intellij.psi.infos.CandidateInfo;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.Consumer;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.PlatformIcons;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ReferenceExpressionCompletionContributor {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.completion.ReferenceExpressionCompletionContributor");
    private static final PsiMethodPattern OBJECT_METHOD_PATTERN = ((PsiMethodPattern)PsiJavaPatterns.psiMethod().withName((ElementPattern)StandardPatterns.string().oneOf(new String[]{"hashCode", "equals", "finalize", "wait", "notify", "notifyAll", "getClass", "clone", "toString"}))).definedInClass("java.lang.Object");
    private static final PrefixMatcher TRUE_MATCHER = new PrefixMatcher(""){

        public boolean prefixMatches(@NotNull String name) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/codeInsight/completion/ReferenceExpressionCompletionContributor$1", "prefixMatches"));
            }
            return true;
        }

        @NotNull
        public PrefixMatcher cloneWithPrefix(@NotNull String prefix) {
            if (prefix == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "prefix", "com/intellij/codeInsight/completion/ReferenceExpressionCompletionContributor$1", "cloneWithPrefix"));
            }
            1 v0 = this;
            if (v0 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/completion/ReferenceExpressionCompletionContributor$1", "cloneWithPrefix"));
            }
            return v0;
        }
    };
    public static final ElementPattern<PsiElement> IN_SWITCH_LABEL = PsiJavaPatterns.psiElement().withSuperParent(2, (ElementPattern)PsiJavaPatterns.psiElement(PsiSwitchLabelStatement.class).withSuperParent(2, PsiSwitchStatement.class));

    @NotNull
    private static ElementFilter getReferenceFilter(PsiElement element, boolean allowRecursion) {
        ElementFilter filter;
        if (((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement().withParent((ElementPattern)PsiJavaPatterns.psiElement(PsiReferenceExpression.class).withParent(PsiThrowStatement.class))).accepts((Object)element)) {
            ElementFilter elementFilter = TrueFilter.INSTANCE;
            if (elementFilter == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/completion/ReferenceExpressionCompletionContributor", "getReferenceFilter"));
            }
            return elementFilter;
        }
        if (((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement().inside(StandardPatterns.or((ElementPattern[])new ElementPattern[]{PsiJavaPatterns.psiElement(PsiAnnotationParameterList.class), PsiJavaPatterns.psiElement(PsiSwitchLabelStatement.class)}))).accepts((Object)element)) {
            ElementExtractorFilter elementExtractorFilter = new ElementExtractorFilter(new AndFilter((ElementFilter)new ClassFilter(PsiField.class), (ElementFilter)new ModifierFilter("static", "final")));
            if (elementExtractorFilter == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/completion/ReferenceExpressionCompletionContributor", "getReferenceFilter"));
            }
            return elementExtractorFilter;
        }
        final PsiForeachStatement foreach = (PsiForeachStatement)PsiTreeUtil.getParentOfType((PsiElement)element, PsiForeachStatement.class);
        if (foreach != null && !PsiTreeUtil.isAncestor((PsiElement)foreach.getBody(), (PsiElement)element, (boolean)false)) {
            ElementExtractorFilter elementExtractorFilter = new ElementExtractorFilter(new ElementFilter(){

                public boolean isAcceptable(Object element, @Nullable PsiElement context) {
                    return element != foreach.getIterationParameter();
                }

                public boolean isClassAcceptable(Class hintClass) {
                    return true;
                }
            });
            if (elementExtractorFilter == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/completion/ReferenceExpressionCompletionContributor", "getReferenceFilter"));
            }
            return elementExtractorFilter;
        }
        if (!allowRecursion && (filter = RecursionWeigher.recursionFilter(element)) != null) {
            ElementExtractorFilter elementExtractorFilter = new ElementExtractorFilter(filter);
            if (elementExtractorFilter == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/completion/ReferenceExpressionCompletionContributor", "getReferenceFilter"));
            }
            return elementExtractorFilter;
        }
        ElementFilter elementFilter = TrueFilter.INSTANCE;
        if (elementFilter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/completion/ReferenceExpressionCompletionContributor", "getReferenceFilter"));
        }
        return elementFilter;
    }

    @Nullable
    public static Runnable fillCompletionVariants(final JavaSmartCompletionParameters parameters, final Consumer<LookupElement> result) {
        final PsiElement element = parameters.getPosition();
        if (JavaSmartCompletionContributor.INSIDE_TYPECAST_EXPRESSION.accepts((Object)element)) {
            return null;
        }
        if (JavaKeywordCompletion.isAfterPrimitiveOrArrayType(element)) {
            return null;
        }
        int offset = parameters.getParameters().getOffset();
        final PsiReference reference = element.getContainingFile().findReferenceAt(offset);
        if (reference != null) {
            ElementFilter filter = ReferenceExpressionCompletionContributor.getReferenceFilter(element, false);
            for (LookupElement item : ReferenceExpressionCompletionContributor.completeFinalReference(element, reference, filter, parameters)) {
                result.consume((Object)item);
            }
            boolean secondTime = parameters.getParameters().getInvocationCount() >= 2;
            final Set<LookupElement> base = JavaSmartCompletionContributor.completeReference(element, reference, filter, false, true, parameters.getParameters(), PrefixMatcher.ALWAYS_TRUE);
            for (LookupElement item : new LinkedHashSet<LookupElement>(base)) {
                ExpressionLookupItem access = ReferenceExpressionCompletionContributor.getSingleArrayElementAccess(element, item);
                if (access == null) continue;
                base.add(access);
                PsiType type = access.getType();
                if (type == null || !parameters.getExpectedType().isAssignableFrom(type)) continue;
                result.consume((Object)access);
            }
            if (secondTime) {
                return new Runnable(){

                    @Override
                    public void run() {
                        for (LookupElement item : base) {
                            ReferenceExpressionCompletionContributor.addSecondCompletionVariants(element, reference, item, parameters, (Consumer<LookupElement>)result);
                        }
                        if (!((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement().afterLeaf(new String[]{"."})).accepts((Object)element)) {
                            BasicExpressionCompletionContributor.processDataflowExpressionTypes(element, null, TRUE_MATCHER, new Consumer<LookupElement>(){

                                public void consume(LookupElement baseItem) {
                                    ReferenceExpressionCompletionContributor.addSecondCompletionVariants(element, reference, baseItem, parameters, (Consumer<LookupElement>)result);
                                }
                            });
                        }
                    }
                };
            }
        }
        return null;
    }

    private static Set<LookupElement> completeFinalReference(final PsiElement element, PsiReference reference, ElementFilter filter, final JavaSmartCompletionParameters parameters) {
        final Set<Object> used = parameters.getParameters().getInvocationCount() < 2 ? ReferenceExpressionCompletionContributor.findConstantsUsedInSwitch(element) : Collections.emptySet();
        Set<LookupElement> elements = JavaSmartCompletionContributor.completeReference(element, reference, new AndFilter(filter, new ElementFilter(){

            public boolean isAcceptable(Object o, PsiElement context) {
                if (o instanceof CandidateInfo) {
                    CandidateInfo info = (CandidateInfo)o;
                    PsiElement member = info.getElement();
                    PsiType expectedType = parameters.getExpectedType();
                    if (expectedType.equals(PsiType.VOID)) {
                        return member instanceof PsiMethod;
                    }
                    if (member instanceof PsiEnumConstant && used.contains(CompletionUtil.getOriginalOrSelf(member))) {
                        return false;
                    }
                    return AssignableFromFilter.isAcceptable(member, element, expectedType, info.getSubstitutor());
                }
                return false;
            }

            public boolean isClassAcceptable(Class hintClass) {
                return true;
            }
        }), false, true, parameters.getParameters(), PrefixMatcher.ALWAYS_TRUE);
        for (LookupElement lookupElement : elements) {
            PsiMethod method;
            JavaMethodCallElement item;
            if (!(lookupElement.getObject() instanceof PsiMethod) || (item = (JavaMethodCallElement)lookupElement.as(JavaMethodCallElement.CLASS_CONDITION_KEY)) == null || !SmartCompletionDecorator.hasUnboundTypeParams(method = (PsiMethod)lookupElement.getObject(), parameters.getExpectedType())) continue;
            item.setInferenceSubstitutor(SmartCompletionDecorator.calculateMethodReturnTypeSubstitutor(method, parameters.getExpectedType()), element);
        }
        return elements;
    }

    @NotNull
    public static Set<PsiField> findConstantsUsedInSwitch(@Nullable PsiElement position) {
        if (IN_SWITCH_LABEL.accepts((Object)position)) {
            LinkedHashSet used = ContainerUtil.newLinkedHashSet();
            PsiSwitchStatement sw = (PsiSwitchStatement)PsiTreeUtil.getParentOfType((PsiElement)position, PsiSwitchStatement.class);
            assert (sw != null);
            PsiCodeBlock body = sw.getBody();
            assert (body != null);
            for (PsiStatement statement : body.getStatements()) {
                PsiElement target;
                PsiExpression value;
                if (!(statement instanceof PsiSwitchLabelStatement) || !((value = ((PsiSwitchLabelStatement)statement).getCaseValue()) instanceof PsiReferenceExpression) || !((target = ((PsiReferenceExpression)value).resolve()) instanceof PsiField)) continue;
                used.add(CompletionUtil.getOriginalOrSelf((PsiField)target));
            }
            LinkedHashSet linkedHashSet = used;
            if (linkedHashSet == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/completion/ReferenceExpressionCompletionContributor", "findConstantsUsedInSwitch"));
            }
            return linkedHashSet;
        }
        Set<PsiField> set = Collections.emptySet();
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/completion/ReferenceExpressionCompletionContributor", "findConstantsUsedInSwitch"));
        }
        return set;
    }

    @Nullable
    private static ExpressionLookupItem getSingleArrayElementAccess(PsiElement element, LookupElement item) {
        if (item.getObject() instanceof PsiLocalVariable) {
            PsiNewExpression newExpression;
            PsiExpression[] dimensions;
            PsiLocalVariable variable = (PsiLocalVariable)item.getObject();
            PsiType type = variable.getType();
            PsiExpression expression = variable.getInitializer();
            if (type instanceof PsiArrayType && expression instanceof PsiNewExpression && (dimensions = (newExpression = (PsiNewExpression)expression).getArrayDimensions()).length == 1 && "1".equals(dimensions[0].getText()) && newExpression.getArrayInitializer() == null) {
                String text = variable.getName() + "[0]";
                return new ExpressionLookupItem(ReferenceExpressionCompletionContributor.createExpression(text, element), variable.getIcon(1), text, text);
            }
        }
        return null;
    }

    private static PsiExpression createExpression(String text, PsiElement element) {
        return JavaPsiFacade.getInstance((Project)element.getProject()).getElementFactory().createExpressionFromText(text, element);
    }

    private static void addSecondCompletionVariants(PsiElement element, PsiReference reference, LookupElement baseItem, JavaSmartCompletionParameters parameters, Consumer<LookupElement> result) {
        Object object = baseItem.getObject();
        try {
            String prefix;
            PsiType itemType = JavaCompletionUtil.getLookupElementType(baseItem);
            if (itemType instanceof PsiWildcardType) {
                itemType = ((PsiWildcardType)itemType).getExtendsBound();
            }
            if (itemType == null) {
                return;
            }
            assert (itemType.isValid()) : baseItem + "; " + baseItem.getClass();
            PsiElement element1 = reference.getElement();
            PsiElement qualifier = element1 instanceof PsiJavaCodeReferenceElement ? ((PsiJavaCodeReferenceElement)element1).getQualifier() : null;
            PsiType expectedType = parameters.getExpectedType();
            if (!(OBJECT_METHOD_PATTERN.accepts(object) && !ReferenceExpressionCompletionContributor.allowGetClass(object, parameters) || parameters.getParameters().getInvocationCount() < 3 && itemType.equalsToText("java.lang.String") || object instanceof PsiMethod && ((PsiMethod)object).getParameterList().getParametersCount() > 0)) {
                ReferenceExpressionCompletionContributor.addChainedCallVariants(element, baseItem, result, itemType, expectedType, parameters);
            }
            if ((prefix = ReferenceExpressionCompletionContributor.getItemText(object)) == null) {
                return;
            }
            ReferenceExpressionCompletionContributor.addConversionsToArray(element, prefix, itemType, result, qualifier, expectedType);
            ReferenceExpressionCompletionContributor.addToArrayConversions(element, object, prefix, itemType, result, qualifier, expectedType);
            ReferenceExpressionCompletionContributor.addArrayMemberAccessors(element, prefix, itemType, qualifier, result, (PsiModifierListOwner)object, expectedType);
        }
        catch (IncorrectOperationException incorrectOperationException) {
            // empty catch block
        }
    }

    private static void addArrayMemberAccessors(final PsiElement element, String prefix, PsiType itemType, PsiElement qualifier, Consumer<LookupElement> result, PsiModifierListOwner object, PsiType expectedType) throws IncorrectOperationException {
        if (itemType instanceof PsiArrayType && expectedType.isAssignableFrom(((PsiArrayType)itemType).getComponentType())) {
            PsiExpression conversion = ReferenceExpressionCompletionContributor.createExpression(ReferenceExpressionCompletionContributor.getQualifierText(qualifier) + prefix + "[0]", element);
            result.consume((Object)new ExpressionLookupItem(conversion, object.getIcon(1), prefix + "[...]", new String[]{prefix}){

                public void handleInsert(InsertionContext context) {
                    FeatureUsageTracker.getInstance().triggerFeatureUsed("editing.completion.second.smarttype.array.member");
                    int tailOffset = context.getTailOffset();
                    String callSpace = ReferenceExpressionCompletionContributor.getSpace(CodeStyleSettingsManager.getSettings((Project)element.getProject()).SPACE_WITHIN_BRACKETS);
                    context.getDocument().insertString(tailOffset, (CharSequence)("[" + callSpace + callSpace + "]"));
                    context.getEditor().getCaretModel().moveToOffset(tailOffset + 1 + callSpace.length());
                }
            });
        }
    }

    private static boolean allowGetClass(Object object, JavaSmartCompletionParameters parameters) {
        if (!"getClass".equals(((PsiMethod)object).getName())) {
            return false;
        }
        PsiType type = parameters.getDefaultType();
        String canonicalText = type.getCanonicalText();
        if ("java.lang.ClassLoader".equals(canonicalText)) {
            return true;
        }
        return canonicalText.startsWith("java.lang.reflect.");
    }

    private static void addConversionsToArray(final PsiElement element, final String prefix, PsiType itemType, Consumer<LookupElement> result, @Nullable PsiElement qualifier, PsiType expectedType) throws IncorrectOperationException {
        final String methodName = ReferenceExpressionCompletionContributor.getArraysConversionMethod(itemType, expectedType);
        if (methodName == null) {
            return;
        }
        final String qualifierText = ReferenceExpressionCompletionContributor.getQualifierText(qualifier);
        PsiExpression conversion = ReferenceExpressionCompletionContributor.createExpression("java.util.Arrays." + methodName + "(" + qualifierText + prefix + ")", element);
        String presentable = "Arrays." + methodName + "(" + qualifierText + prefix + ")";
        String[] lookupStrings = new String[]{StringUtil.isEmpty((String)qualifierText) ? presentable : prefix, prefix, presentable, methodName + "(" + prefix + ")"};
        result.consume((Object)new ExpressionLookupItem(conversion, PlatformIcons.METHOD_ICON, presentable, lookupStrings){

            public void handleInsert(InsertionContext context) {
                FeatureUsageTracker.getInstance().triggerFeatureUsed("editing.completion.second.smarttype.aslist");
                int startOffset = context.getStartOffset() - qualifierText.length();
                Project project = element.getProject();
                String callSpace = ReferenceExpressionCompletionContributor.getSpace(CodeStyleSettingsManager.getSettings((Project)project).SPACE_WITHIN_METHOD_CALL_PARENTHESES);
                String newText = "java.util.Arrays." + methodName + "(" + callSpace + qualifierText + prefix + callSpace + ")";
                context.getDocument().replaceString(startOffset, context.getTailOffset(), (CharSequence)newText);
                context.commitDocument();
                JavaCodeStyleManager.getInstance((Project)project).shortenClassReferences((PsiElement)context.getFile(), startOffset, startOffset + "java.util.Arrays".length());
            }
        });
    }

    @Nullable
    private static String getArraysConversionMethod(PsiType itemType, PsiType expectedType) {
        String methodName = "asList";
        PsiType componentType = PsiUtil.extractIterableTypeParameter((PsiType)expectedType, (boolean)true);
        if (componentType == null) {
            methodName = "stream";
            componentType = ReferenceExpressionCompletionContributor.getStreamComponentType(expectedType);
            PsiPrimitiveType unboxedType = PsiPrimitiveType.getUnboxedType((PsiType)componentType);
            if (unboxedType != null) {
                componentType = unboxedType;
            }
        }
        if (componentType == null || !(itemType instanceof PsiArrayType) || !componentType.isAssignableFrom(((PsiArrayType)itemType).getComponentType())) {
            return null;
        }
        return methodName;
    }

    private static PsiType getStreamComponentType(PsiType expectedType) {
        return PsiUtil.substituteTypeParameter((PsiType)expectedType, (String)"java.util.stream.BaseStream", (int)0, (boolean)true);
    }

    private static void addToArrayConversions(PsiElement element, Object object, String prefix, PsiType itemType, Consumer<LookupElement> result, @Nullable PsiElement qualifier, PsiType expectedType) {
        String callSpace = ReferenceExpressionCompletionContributor.getSpace(CodeStyleSettingsManager.getSettings((Project)element.getProject()).SPACE_WITHIN_METHOD_CALL_PARENTHESES);
        PsiType componentType = PsiUtil.extractIterableTypeParameter((PsiType)itemType, (boolean)true);
        if (componentType == null || !(expectedType instanceof PsiArrayType)) {
            return;
        }
        PsiArrayType type = (PsiArrayType)expectedType;
        if (!type.getComponentType().isAssignableFrom(componentType) || componentType instanceof PsiClassType && ((PsiClassType)componentType).hasParameters()) {
            return;
        }
        String bracketSpace = ReferenceExpressionCompletionContributor.getSpace(CodeStyleSettingsManager.getSettings((Project)element.getProject()).SPACE_WITHIN_BRACKETS);
        if (object instanceof PsiVariable && !JavaCompletionUtil.mayHaveSideEffects(qualifier)) {
            PsiVariable variable = (PsiVariable)object;
            ReferenceExpressionCompletionContributor.addToArrayConversion(element, prefix, "new " + componentType.getCanonicalText() + "[" + bracketSpace + ReferenceExpressionCompletionContributor.getQualifierText(qualifier) + variable.getName() + ".size(" + callSpace + ")" + bracketSpace + "]", "new " + ReferenceExpressionCompletionContributor.getQualifierText(qualifier) + componentType.getPresentableText() + "[" + variable.getName() + ".size()]", result, qualifier);
        } else {
            boolean hasEmptyArrayField = false;
            PsiClass psiClass = PsiUtil.resolveClassInType((PsiType)type);
            if (psiClass != null) {
                for (PsiField field : psiClass.getAllFields()) {
                    boolean needQualify;
                    if (!field.hasModifierProperty("static") || !field.hasModifierProperty("final") || !JavaPsiFacade.getInstance((Project)field.getProject()).getResolveHelper().isAccessible((PsiMember)field, element, null) || !type.isAssignableFrom(field.getType()) || !ReferenceExpressionCompletionContributor.isEmptyArrayInitializer((PsiElement)field.getInitializer())) continue;
                    try {
                        needQualify = !field.isEquivalentTo(((PsiReferenceExpression)ReferenceExpressionCompletionContributor.createExpression(field.getName(), element)).resolve());
                    }
                    catch (IncorrectOperationException e) {
                        continue;
                    }
                    ReferenceExpressionCompletionContributor.addToArrayConversion(element, prefix, (needQualify ? field.getContainingClass().getQualifiedName() + "." : "") + field.getName(), (needQualify ? field.getContainingClass().getName() + "." : "") + field.getName(), result, qualifier);
                    hasEmptyArrayField = true;
                }
            }
            if (!hasEmptyArrayField) {
                ReferenceExpressionCompletionContributor.addToArrayConversion(element, prefix, "new " + componentType.getCanonicalText() + "[" + bracketSpace + "0" + bracketSpace + "]", "new " + componentType.getPresentableText() + "[0]", result, qualifier);
            }
        }
    }

    private static String getQualifierText(@Nullable PsiElement qualifier) {
        return qualifier == null ? "" : qualifier.getText() + ".";
    }

    private static void addChainedCallVariants(PsiElement place, LookupElement qualifierItem, Consumer<LookupElement> result, PsiType qualifierType, PsiType expectedType, JavaSmartCompletionParameters parameters) throws IncorrectOperationException {
        PsiReferenceExpression mockRef = ReferenceExpressionCompletionContributor.createMockReference(place, qualifierType, qualifierItem);
        if (mockRef == null) {
            return;
        }
        ElementFilter filter = ReferenceExpressionCompletionContributor.getReferenceFilter(place, true);
        for (LookupElement item : ReferenceExpressionCompletionContributor.completeFinalReference(place, (PsiReference)mockRef, filter, parameters)) {
            if (!ReferenceExpressionCompletionContributor.shouldChain(place, qualifierType, expectedType, item)) continue;
            result.consume((Object)new JavaChainLookupElement(qualifierItem, item){

                @Override
                public void handleInsert(InsertionContext context) {
                    FeatureUsageTracker.getInstance().triggerFeatureUsed("editing.completion.second.smarttype.chain");
                    super.handleInsert(context);
                }
            });
        }
    }

    @Nullable
    public static PsiReferenceExpression createMockReference(PsiElement place, @NotNull PsiType qualifierType, LookupElement qualifierItem) {
        if (qualifierType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifierType", "com/intellij/codeInsight/completion/ReferenceExpressionCompletionContributor", "createMockReference"));
        }
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)place.getProject());
        if (qualifierItem.getObject() instanceof PsiClass) {
            String qname = ((PsiClass)qualifierItem.getObject()).getQualifiedName();
            if (qname == null) {
                return null;
            }
            String text = qname + ".xxx";
            try {
                PsiExpression expr = factory.createExpressionFromText(text, place);
                if (expr instanceof PsiReferenceExpression) {
                    return (PsiReferenceExpression)expr;
                }
                return null;
            }
            catch (IncorrectOperationException e) {
                LOG.info((Throwable)e);
                return null;
            }
        }
        return (PsiReferenceExpression)factory.createExpressionFromText("xxx.xxx", (PsiElement)JavaCompletionUtil.createContextWithXxxVariable(place, qualifierType));
    }

    private static boolean shouldChain(PsiElement element, PsiType qualifierType, PsiType expectedType, LookupElement item) {
        Object object = item.getObject();
        if (object instanceof PsiModifierListOwner && ((PsiModifierListOwner)object).hasModifierProperty("static")) {
            return false;
        }
        if (object instanceof PsiMethod) {
            PsiClassType classType;
            PsiClass psiClass;
            PsiMethod method = (PsiMethod)object;
            if (((PsiMethodPattern)PsiJavaPatterns.psiMethod().withName("toArray")).withParameterCount(1).definedInClass("java.util.Collection").accepts((Object)method)) {
                return false;
            }
            PsiMethod parentMethod = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)element, PsiMethod.class);
            if (ReferenceExpressionCompletionContributor.isUselessObjectMethod(method, parentMethod, qualifierType)) {
                return false;
            }
            PsiType type = method.getReturnType();
            if (type instanceof PsiClassType && (psiClass = (classType = (PsiClassType)type).resolve()) instanceof PsiTypeParameter && method.getTypeParameterList() == psiClass.getParent()) {
                PsiTypeParameter typeParameter = (PsiTypeParameter)psiClass;
                if (typeParameter.getExtendsListTypes().length == 0) {
                    return false;
                }
                if (!expectedType.isAssignableFrom(TypeConversionUtil.typeParameterErasure((PsiTypeParameter)typeParameter))) {
                    return false;
                }
            }
        }
        return true;
    }

    private static boolean isUselessObjectMethod(PsiMethod method, PsiMethod parentMethod, PsiType qualifierType) {
        if (!OBJECT_METHOD_PATTERN.accepts((Object)method)) {
            return false;
        }
        if (OBJECT_METHOD_PATTERN.accepts((Object)parentMethod) && method.getName().equals(parentMethod.getName())) {
            return false;
        }
        return !"toString".equals(method.getName()) || !qualifierType.equalsToText("java.lang.StringBuffer") && !InheritanceUtil.isInheritor((PsiType)qualifierType, (String)"java.lang.AbstractStringBuilder");
    }

    private static void addToArrayConversion(PsiElement element, String prefix, @NonNls String expressionString, @NonNls String presentableString, Consumer<LookupElement> result, PsiElement qualifier) {
        PsiExpression conversion;
        boolean callSpace = CodeStyleSettingsManager.getSettings((Project)element.getProject()).SPACE_WITHIN_METHOD_CALL_PARENTHESES;
        try {
            conversion = ReferenceExpressionCompletionContributor.createExpression(ReferenceExpressionCompletionContributor.getQualifierText(qualifier) + prefix + ".toArray(" + ReferenceExpressionCompletionContributor.getSpace(callSpace) + expressionString + ReferenceExpressionCompletionContributor.getSpace(callSpace) + ")", element);
        }
        catch (IncorrectOperationException e) {
            return;
        }
        String[] lookupStrings = new String[]{prefix + ".toArray(" + ReferenceExpressionCompletionContributor.getSpace(callSpace) + expressionString + ReferenceExpressionCompletionContributor.getSpace(callSpace) + ")", presentableString};
        result.consume((Object)new ExpressionLookupItem(conversion, PlatformIcons.METHOD_ICON, prefix + ".toArray(" + presentableString + ")", lookupStrings){

            public void handleInsert(InsertionContext context) {
                FeatureUsageTracker.getInstance().triggerFeatureUsed("editing.completion.second.smarttype.toar");
                context.commitDocument();
                JavaCodeStyleManager.getInstance((Project)context.getProject()).shortenClassReferences((PsiElement)context.getFile(), context.getStartOffset(), context.getTailOffset());
            }
        });
    }

    private static boolean isEmptyArrayInitializer(@Nullable PsiElement element) {
        if (element instanceof PsiNewExpression) {
            PsiExpression[] dimensions;
            PsiNewExpression expression = (PsiNewExpression)element;
            for (PsiExpression dimension : dimensions = expression.getArrayDimensions()) {
                if (dimension instanceof PsiLiteralExpression && "0".equals(dimension.getText())) continue;
                return false;
            }
            PsiArrayInitializerExpression initializer = expression.getArrayInitializer();
            return initializer == null || initializer.getInitializers().length <= 0;
        }
        return false;
    }

    @Nullable
    private static String getItemText(Object o) {
        if (o instanceof PsiMethod) {
            PsiMethod method = (PsiMethod)o;
            PsiType type = method.getReturnType();
            if (PsiType.VOID.equals((Object)type) || PsiType.NULL.equals((Object)type)) {
                return null;
            }
            if (method.getParameterList().getParametersCount() > 0) {
                return null;
            }
            return method.getName() + "(" + ReferenceExpressionCompletionContributor.getSpace(CodeStyleSettingsManager.getSettings((Project)method.getProject()).SPACE_WITHIN_METHOD_CALL_PARENTHESES) + ")";
        }
        if (o instanceof PsiVariable) {
            return ((PsiVariable)o).getName();
        }
        return null;
    }

    private static String getSpace(boolean needSpace) {
        return needSpace ? " " : "";
    }
}

