/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion.actions;

import com.intellij.codeInsight.CodeInsightActionHandler;
import com.intellij.codeInsight.CodeInsightUtilBase;
import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.completion.impl.CamelHumpMatcher;
import com.intellij.codeInsight.highlighting.HighlightManager;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.CaretAction;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiFile;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HippieWordCompletionHandler
implements CodeInsightActionHandler {
    private static final Key<CompletionState> KEY_STATE = new Key("HIPPIE_COMPLETION_STATE");
    private final boolean myForward;

    public HippieWordCompletionHandler(boolean forward) {
        this.myForward = forward;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invoke(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file) {
        CompletionVariant nextVariant;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/completion/actions/HippieWordCompletionHandler", "invoke"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/completion/actions/HippieWordCompletionHandler", "invoke"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/completion/actions/HippieWordCompletionHandler", "invoke"));
        }
        if (!FileModificationService.getInstance().prepareFileForWrite(file)) {
            return;
        }
        int caretOffset = editor.getCaretModel().getOffset();
        if (editor.isViewer() || editor.getDocument().getRangeGuard(caretOffset, caretOffset) != null) {
            editor.getDocument().fireReadOnlyModificationAttempt();
            CodeInsightUtilBase.showReadOnlyViewWarning(editor);
            return;
        }
        LookupManager.getInstance(project).hideActiveLookup();
        CharSequence charsSequence = editor.getDocument().getCharsSequence();
        CompletionData data = HippieWordCompletionHandler.computeData(editor, charsSequence);
        String currentPrefix = data.myPrefix;
        CompletionState completionState = HippieWordCompletionHandler.getCompletionState(editor);
        String oldPrefix = completionState.oldPrefix;
        CompletionVariant lastProposedVariant = completionState.lastProposedVariant;
        boolean fromOtherFiles = completionState.fromOtherFiles;
        if (lastProposedVariant == null || oldPrefix == null || !new CamelHumpMatcher(oldPrefix).isStartMatch(currentPrefix) || !currentPrefix.equals(lastProposedVariant.variant)) {
            completionState.oldPrefix = oldPrefix = currentPrefix;
            lastProposedVariant = null;
            fromOtherFiles = false;
        }
        if ((nextVariant = this.computeNextVariant(editor, oldPrefix, lastProposedVariant, data, file, fromOtherFiles, false)) == null) {
            return;
        }
        nextVariant.fastenBelts();
        try {
            HippieWordCompletionHandler.insertStringForEachCaret(editor, nextVariant.variant, caretOffset - data.startOffset);
        }
        finally {
            nextVariant.unfastenBelts();
        }
        completionState.lastProposedVariant = nextVariant;
        boolean bl = completionState.fromOtherFiles = nextVariant.editor != editor;
        if (nextVariant.editor == editor) {
            HippieWordCompletionHandler.highlightWord(nextVariant, project);
        }
    }

    private static void insertStringForEachCaret(final Editor editor, final String text, final int relativeOffset) {
        editor.getCaretModel().runForEachCaret(new CaretAction(){

            public void perform(Caret caret) {
                int caretOffset = caret.getOffset();
                int startOffset = Math.max(0, caretOffset - relativeOffset);
                editor.getDocument().replaceString(startOffset, caretOffset, (CharSequence)text);
                caret.moveToOffset(startOffset + text.length());
            }
        });
    }

    private static void highlightWord(CompletionVariant variant, Project project) {
        HighlightManager highlightManager = HighlightManager.getInstance((Project)project);
        EditorColorsManager colorManager = EditorColorsManager.getInstance();
        TextAttributes attributes = colorManager.getGlobalScheme().getAttributes(EditorColors.TEXT_SEARCH_RESULT_ATTRIBUTES);
        highlightManager.addOccurrenceHighlight(variant.editor, variant.offset, variant.offset + variant.variant.length(), attributes, 2, null, null);
    }

    @Nullable
    private CompletionVariant computeNextVariant(Editor editor, @Nullable String prefix, @Nullable CompletionVariant lastProposedVariant, CompletionData data, PsiFile file, boolean includeWordsFromOtherFiles, boolean weAlreadyDoBestAttempt) {
        CompletionVariant result;
        List<CompletionVariant> variants = HippieWordCompletionHandler.computeVariants(editor, new CamelHumpMatcher(StringUtil.notNullize((String)prefix)), file, includeWordsFromOtherFiles);
        if (variants.isEmpty()) {
            return weAlreadyDoBestAttempt ? null : this.computeNextVariant(editor, prefix, null, data, file, !includeWordsFromOtherFiles, true);
        }
        if (lastProposedVariant != null) {
            for (CompletionVariant completionVariant : variants) {
                if (!completionVariant.variant.equals(((CompletionVariant)lastProposedVariant).variant)) continue;
                if (((CompletionVariant)lastProposedVariant).offset > data.startOffset && completionVariant.offset > data.startOffset) {
                    lastProposedVariant = completionVariant;
                }
                if (((CompletionVariant)lastProposedVariant).offset < data.startOffset && completionVariant.offset < data.startOffset) {
                    lastProposedVariant = completionVariant;
                }
                if (!includeWordsFromOtherFiles || ((CompletionVariant)lastProposedVariant).editor != completionVariant.editor) continue;
                lastProposedVariant = completionVariant;
            }
        }
        if (lastProposedVariant == null) {
            result = null;
            if (this.myForward) {
                if (includeWordsFromOtherFiles) {
                    return variants.get(variants.size() - 1);
                }
                for (CompletionVariant variant : variants) {
                    if (variant.offset < data.startOffset) {
                        result = variant;
                        continue;
                    }
                    if (result != null) continue;
                    result = variant;
                    break;
                }
            } else {
                if (includeWordsFromOtherFiles) {
                    return variants.get(0);
                }
                for (CompletionVariant variant : variants) {
                    if (variant.offset <= data.startOffset) continue;
                    return variant;
                }
                return variants.iterator().next();
            }
            return result;
        }
        if (this.myForward) {
            result = null;
            for (CompletionVariant variant : variants) {
                if (variant == lastProposedVariant) {
                    if (result == null) {
                        return this.computeNextVariant(editor, prefix, null, data, file, !includeWordsFromOtherFiles, true);
                    }
                    return result;
                }
                result = variant;
            }
            return variants.get(variants.size() - 1);
        }
        Iterator<CompletionVariant> i = variants.iterator();
        while (i.hasNext()) {
            CompletionVariant completionVariant = i.next();
            if (completionVariant != lastProposedVariant) continue;
            if (i.hasNext()) {
                return i.next();
            }
            return this.computeNextVariant(editor, prefix, null, data, file, !includeWordsFromOtherFiles, true);
        }
        return null;
    }

    private static boolean containsLettersOrDigits(CharSequence seq, int start, int end) {
        for (int i = start; i < end; ++i) {
            if (!Character.isLetterOrDigit(seq.charAt(i))) continue;
            return true;
        }
        return false;
    }

    private static List<CompletionVariant> computeVariants(@NotNull Editor editor, CamelHumpMatcher matcher, PsiFile file, boolean includeWordsFromOtherFiles) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/completion/actions/HippieWordCompletionHandler", "computeVariants"));
        }
        ArrayList<CompletionVariant> words = new ArrayList<CompletionVariant>();
        ArrayList<CompletionVariant> afterWords = new ArrayList<CompletionVariant>();
        if (includeWordsFromOtherFiles) {
            for (FileEditor fileEditor : FileEditorManager.getInstance((Project)file.getProject()).getAllEditors()) {
                Editor anotherEditor;
                if (!(fileEditor instanceof TextEditor) || (anotherEditor = ((TextEditor)fileEditor).getEditor()) == editor) continue;
                HippieWordCompletionHandler.addWordsForEditor((EditorEx)anotherEditor, matcher, words, afterWords, false);
            }
        } else {
            HippieWordCompletionHandler.addWordsForEditor((EditorEx)editor, matcher, words, afterWords, true);
        }
        HashSet<String> allWords = new HashSet<String>();
        ArrayList<CompletionVariant> result = new ArrayList<CompletionVariant>();
        Collections.reverse(words);
        for (CompletionVariant variant : words) {
            if (allWords.contains(variant.variant)) continue;
            result.add(variant);
            allWords.add(variant.variant);
        }
        Collections.reverse(result);
        allWords.clear();
        for (CompletionVariant variant : afterWords) {
            if (allWords.contains(variant.variant)) continue;
            result.add(variant);
            allWords.add(variant.variant);
        }
        return result;
    }

    private static void addWordsForEditor(final EditorEx editor, final CamelHumpMatcher matcher, final List<CompletionVariant> words, final List<CompletionVariant> afterWords, boolean takeCaretsIntoAccount) {
        int[] caretOffsets;
        int primaryCaretOffset;
        final CharSequence chars = editor.getDocument().getImmutableCharSequence();
        if (takeCaretsIntoAccount) {
            CaretModel caretModel = editor.getCaretModel();
            primaryCaretOffset = caretModel.getOffset();
            caretOffsets = HippieWordCompletionHandler.getCaretOffsets(caretModel);
        } else {
            primaryCaretOffset = 0;
            caretOffsets = new int[1];
        }
        TokenProcessor processor = new TokenProcessor(){

            @Override
            public boolean processToken(int start, int end) {
                String word;
                for (int caretOffset : caretOffsets) {
                    if (start > caretOffset || end < caretOffset) continue;
                    return true;
                }
                if (end - start > matcher.getPrefix().length() && matcher.isStartMatch(word = chars.subSequence(start, end).toString())) {
                    CompletionVariant v = new CompletionVariant(editor, word, start);
                    if (end > primaryCaretOffset) {
                        afterWords.add(v);
                    } else {
                        words.add(v);
                    }
                }
                return true;
            }
        };
        HippieWordCompletionHandler.processWords(editor, 0, processor);
    }

    private static int[] getCaretOffsets(CaretModel caretModel) {
        int[] caretOffsets = new int[caretModel.getCaretCount()];
        int i = 0;
        for (Caret caret : caretModel.getAllCarets()) {
            caretOffsets[i++] = caret.getOffset();
        }
        return caretOffsets;
    }

    private static void processWords(Editor editor, int startOffset, TokenProcessor processor) {
        CharSequence chars = editor.getDocument().getCharsSequence();
        HighlighterIterator iterator = ((EditorEx)editor).getHighlighter().createIterator(startOffset);
        while (!iterator.atEnd()) {
            int start = iterator.getStart();
            int end = iterator.getEnd();
            while (start < end) {
                int wordEnd;
                int wordStart;
                for (wordStart = start; wordStart < end && !HippieWordCompletionHandler.isWordPart(chars.charAt(wordStart)); ++wordStart) {
                }
                for (wordEnd = wordStart; wordEnd < end && HippieWordCompletionHandler.isWordPart(chars.charAt(wordEnd)); ++wordEnd) {
                }
                if (wordEnd > wordStart && HippieWordCompletionHandler.containsLettersOrDigits(chars, wordStart, wordEnd) && !processor.processToken(wordStart, wordEnd)) {
                    return;
                }
                start = wordEnd + 1;
            }
            iterator.advance();
        }
    }

    private static boolean isWordPart(char c) {
        return Character.isJavaIdentifierPart(c) || c == '-' || c == '*';
    }

    private static CompletionData computeData(Editor editor, final CharSequence charsSequence) {
        final int offset = editor.getCaretModel().getOffset();
        final CompletionData data = new CompletionData();
        HippieWordCompletionHandler.processWords(editor, Math.max(offset - 1, 0), new TokenProcessor(){

            @Override
            public boolean processToken(int start, int end) {
                if (start > offset) {
                    return false;
                }
                if (end >= offset) {
                    data.myPrefix = charsSequence.subSequence(start, offset).toString();
                    data.myWordUnderCursor = charsSequence.subSequence(start, end).toString();
                    data.startOffset = start;
                    return false;
                }
                return true;
            }
        });
        if (data.myPrefix == null) {
            data.myPrefix = "";
            data.myWordUnderCursor = "";
            data.startOffset = offset;
        }
        return data;
    }

    public boolean startInWriteAction() {
        return true;
    }

    private static CompletionState getCompletionState(Editor editor) {
        CompletionState state = (CompletionState)editor.getUserData(KEY_STATE);
        if (state == null) {
            state = new CompletionState();
            editor.putUserData(KEY_STATE, (Object)state);
        }
        return state;
    }

    private static class CompletionState {
        public String oldPrefix;
        public CompletionVariant lastProposedVariant;
        public boolean fromOtherFiles;

        private CompletionState() {
        }
    }

    private static interface TokenProcessor {
        public boolean processToken(int var1, int var2);
    }

    public static class CompletionVariant {
        public final Editor editor;
        public final String variant;
        public int offset;
        private RangeMarker marker;

        public CompletionVariant(Editor editor, String variant, int offset) {
            this.editor = editor;
            this.variant = variant;
            this.offset = offset;
        }

        public void fastenBelts() {
            this.marker = this.editor.getDocument().createRangeMarker(this.offset, this.offset);
        }

        public void unfastenBelts() {
            if (this.marker.isValid()) {
                this.offset = this.marker.getStartOffset();
                this.marker.dispose();
            }
            this.marker = null;
        }
    }

    private static class CompletionData {
        public String myPrefix;
        public String myWordUnderCursor;
        public int startOffset;

        private CompletionData() {
        }
    }
}

