/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeInsight.daemon.impl.DaemonProgressIndicator;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightingSession;
import com.intellij.codeInsight.daemon.impl.UpdateHighlightersUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.ex.RangeHighlighterEx;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.TransferToEDTQueue;
import gnu.trove.THashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HighlightingSessionImpl
implements HighlightingSession {
    @NotNull
    private final PsiFile myPsiFile;
    @Nullable
    private final Editor myEditor;
    @NotNull
    private final ProgressIndicator myProgressIndicator;
    private final EditorColorsScheme myEditorColorsScheme;
    @NotNull
    private final Project myProject;
    private final Document myDocument;
    private final Map<TextRange, RangeMarker> myRanges2markersCache;
    private static final Key<ConcurrentMap<PsiFile, HighlightingSession>> HIGHLIGHTING_SESSION = Key.create((String)"HIGHLIGHTING_SESSION");
    private final TransferToEDTQueue<Info> myAddHighlighterInEDTQueue;
    private final TransferToEDTQueue<RangeHighlighterEx> myDisposeHighlighterInEDTQueue;

    private HighlightingSessionImpl(@NotNull PsiFile psiFile, @Nullable Editor editor, @NotNull DaemonProgressIndicator progressIndicator, EditorColorsScheme editorColorsScheme) {
        if (psiFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiFile", "com/intellij/codeInsight/daemon/impl/HighlightingSessionImpl", "<init>"));
        }
        if (progressIndicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progressIndicator", "com/intellij/codeInsight/daemon/impl/HighlightingSessionImpl", "<init>"));
        }
        this.myRanges2markersCache = new THashMap();
        this.myAddHighlighterInEDTQueue = new TransferToEDTQueue("Apply highlighting results", (Processor)new Processor<Info>(){

            public boolean process(Info info) {
                EditorColorsScheme colorsScheme = HighlightingSessionImpl.this.getColorsScheme();
                UpdateHighlightersUtil.addHighlighterToEditorIncrementally(HighlightingSessionImpl.this.myProject, HighlightingSessionImpl.this.myDocument, HighlightingSessionImpl.this.getPsiFile(), info.myRestrictRange.getStartOffset(), info.myRestrictRange.getEndOffset(), info.myInfo, colorsScheme, info.myGroupId, HighlightingSessionImpl.this.myRanges2markersCache);
                return true;
            }
        }, (Condition)new Condition<Object>(){

            public boolean value(Object o) {
                return HighlightingSessionImpl.this.myProject.isDisposed() || HighlightingSessionImpl.this.getProgressIndicator().isCanceled();
            }
        }, 200);
        this.myDisposeHighlighterInEDTQueue = new TransferToEDTQueue("Dispose abandoned highlighter", (Processor)new Processor<RangeHighlighterEx>(){

            public boolean process(@NotNull RangeHighlighterEx highlighter) {
                if (highlighter == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "highlighter", "com/intellij/codeInsight/daemon/impl/HighlightingSessionImpl$3", "process"));
                }
                highlighter.dispose();
                return true;
            }
        }, (Condition)new Condition<Object>(){

            public boolean value(Object o) {
                return HighlightingSessionImpl.this.myProject.isDisposed() || HighlightingSessionImpl.this.getProgressIndicator().isCanceled();
            }
        }, 200);
        this.myPsiFile = psiFile;
        this.myEditor = editor;
        this.myProgressIndicator = progressIndicator;
        this.myEditorColorsScheme = editorColorsScheme;
        this.myProject = psiFile.getProject();
        this.myDocument = PsiDocumentManager.getInstance((Project)this.myProject).getDocument(psiFile);
    }

    public static HighlightingSession getHighlightingSession(@NotNull PsiFile psiFile, @NotNull ProgressIndicator progressIndicator) {
        if (psiFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiFile", "com/intellij/codeInsight/daemon/impl/HighlightingSessionImpl", "getHighlightingSession"));
        }
        if (progressIndicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progressIndicator", "com/intellij/codeInsight/daemon/impl/HighlightingSessionImpl", "getHighlightingSession"));
        }
        Map map = (Map)((DaemonProgressIndicator)progressIndicator).getUserData(HIGHLIGHTING_SESSION);
        return map == null ? null : (HighlightingSession)map.get(psiFile);
    }

    @NotNull
    static HighlightingSession getOrCreateHighlightingSession(@NotNull PsiFile psiFile, @Nullable Editor editor, @NotNull DaemonProgressIndicator progressIndicator, @Nullable EditorColorsScheme editorColorsScheme) {
        if (psiFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiFile", "com/intellij/codeInsight/daemon/impl/HighlightingSessionImpl", "getOrCreateHighlightingSession"));
        }
        if (progressIndicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progressIndicator", "com/intellij/codeInsight/daemon/impl/HighlightingSessionImpl", "getOrCreateHighlightingSession"));
        }
        HighlightingSession session = HighlightingSessionImpl.getHighlightingSession(psiFile, progressIndicator);
        if (session == null) {
            session = new HighlightingSessionImpl(psiFile, editor, progressIndicator, editorColorsScheme);
            ConcurrentMap map = (ConcurrentMap)progressIndicator.getUserData(HIGHLIGHTING_SESSION);
            if (map == null) {
                map = (ConcurrentMap)progressIndicator.putUserDataIfAbsent(HIGHLIGHTING_SESSION, ContainerUtil.newConcurrentMap());
            }
            session = (HighlightingSession)ConcurrencyUtil.cacheOrGet((ConcurrentMap)map, (Object)psiFile, (Object)session);
        }
        HighlightingSession highlightingSession = session;
        if (highlightingSession == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/HighlightingSessionImpl", "getOrCreateHighlightingSession"));
        }
        return highlightingSession;
    }

    @Override
    @NotNull
    public PsiFile getPsiFile() {
        PsiFile psiFile = this.myPsiFile;
        if (psiFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/HighlightingSessionImpl", "getPsiFile"));
        }
        return psiFile;
    }

    @Override
    @Nullable
    public Editor getEditor() {
        return this.myEditor;
    }

    @Override
    @NotNull
    public Document getDocument() {
        Document document = this.myDocument;
        if (document == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/HighlightingSessionImpl", "getDocument"));
        }
        return document;
    }

    @Override
    @NotNull
    public ProgressIndicator getProgressIndicator() {
        ProgressIndicator progressIndicator = this.myProgressIndicator;
        if (progressIndicator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/HighlightingSessionImpl", "getProgressIndicator"));
        }
        return progressIndicator;
    }

    @Override
    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/HighlightingSessionImpl", "getProject"));
        }
        return project;
    }

    @Override
    public EditorColorsScheme getColorsScheme() {
        return this.myEditorColorsScheme;
    }

    void queueHighlightInfo(@NotNull HighlightInfo info, @NotNull TextRange priorityRange, @NotNull TextRange restrictedRange, int groupId) {
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/intellij/codeInsight/daemon/impl/HighlightingSessionImpl", "queueHighlightInfo"));
        }
        if (priorityRange == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "priorityRange", "com/intellij/codeInsight/daemon/impl/HighlightingSessionImpl", "queueHighlightInfo"));
        }
        if (restrictedRange == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "restrictedRange", "com/intellij/codeInsight/daemon/impl/HighlightingSessionImpl", "queueHighlightInfo"));
        }
        this.myAddHighlighterInEDTQueue.offer((Object)new Info(info, restrictedRange, groupId));
    }

    void queueDisposeHighlighter(@Nullable RangeHighlighterEx highlighter) {
        if (highlighter == null) {
            return;
        }
        this.myDisposeHighlighterInEDTQueue.offer((Object)highlighter);
    }

    void waitForHighlightInfosApplied() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.myAddHighlighterInEDTQueue.drain();
    }

    private static class Info {
        @NotNull
        private final HighlightInfo myInfo;
        @NotNull
        private final TextRange myRestrictRange;
        private final int myGroupId;

        private Info(@NotNull HighlightInfo info, @NotNull TextRange restrictRange, int groupId) {
            if (info == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/intellij/codeInsight/daemon/impl/HighlightingSessionImpl$Info", "<init>"));
            }
            if (restrictRange == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "restrictRange", "com/intellij/codeInsight/daemon/impl/HighlightingSessionImpl$Info", "<init>"));
            }
            this.myInfo = info;
            this.myRestrictRange = restrictRange;
            this.myGroupId = groupId;
        }
    }
}

