/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.analysis;

import com.intellij.codeInsight.intention.PsiElementBaseIntentionAction;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.XmlRecursiveElementVisitor;
import com.intellij.psi.impl.source.xml.SchemaPrefix;
import com.intellij.psi.impl.source.xml.SchemaPrefixReference;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConvertSchemaPrefixToDefaultIntention
extends PsiElementBaseIntentionAction {
    public static final String NAME = "Reset to default namespace";

    public ConvertSchemaPrefixToDefaultIntention() {
        this.setText(NAME);
    }

    public void invoke(@NotNull Project project, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/analysis/ConvertSchemaPrefixToDefaultIntention", "invoke"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/daemon/impl/analysis/ConvertSchemaPrefixToDefaultIntention", "invoke"));
        }
        final XmlAttribute xmlns = ConvertSchemaPrefixToDefaultIntention.getXmlnsDeclaration(element);
        if (xmlns == null) {
            return;
        }
        SchemaPrefixReference prefixRef = null;
        for (PsiReference ref : xmlns.getReferences()) {
            if (!(ref instanceof SchemaPrefixReference)) continue;
            prefixRef = (SchemaPrefixReference)ref;
            break;
        }
        if (prefixRef == null) {
            return;
        }
        final SchemaPrefix prefix = prefixRef.resolve();
        final String ns = prefixRef.getNamespacePrefix();
        final ArrayList tags = new ArrayList();
        final ArrayList attrs = new ArrayList();
        xmlns.getParent().accept((PsiElementVisitor)new XmlRecursiveElementVisitor(){

            public void visitXmlTag(XmlTag tag) {
                if (ns.equals(tag.getNamespacePrefix())) {
                    tags.add(tag);
                }
                super.visitXmlTag(tag);
            }

            public void visitXmlAttributeValue(XmlAttributeValue value) {
                if (value.getValue().startsWith(ns + ":")) {
                    for (PsiReference ref : value.getReferences()) {
                        if (!(ref instanceof SchemaPrefixReference) || !ref.isReferenceTo((PsiElement)prefix)) continue;
                        attrs.add((XmlAttribute)value.getParent());
                    }
                }
            }
        });
        new WriteCommandAction(project, NAME, new PsiFile[]{xmlns.getContainingFile()}){

            protected void run(@NotNull Result result) throws Throwable {
                if (result == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/codeInsight/daemon/impl/analysis/ConvertSchemaPrefixToDefaultIntention$2", "run"));
                }
                int index = ns.length() + 1;
                for (XmlTag tag : tags) {
                    String s = tag.getName().substring(index);
                    if (s.isEmpty()) continue;
                    tag.setName(s);
                }
                for (XmlAttribute attr : attrs) {
                    attr.setValue(attr.getValue().substring(index));
                }
                xmlns.setName("xmlns");
            }
        }.execute();
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/analysis/ConvertSchemaPrefixToDefaultIntention", "isAvailable"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/daemon/impl/analysis/ConvertSchemaPrefixToDefaultIntention", "isAvailable"));
        }
        return ConvertSchemaPrefixToDefaultIntention.getXmlnsDeclaration(element) != null;
    }

    @NotNull
    public String getFamilyName() {
        if (NAME == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/analysis/ConvertSchemaPrefixToDefaultIntention", "getFamilyName"));
        }
        return NAME;
    }

    @Nullable
    private static XmlAttribute getXmlnsDeclaration(PsiElement element) {
        PsiElement parent = element.getParent();
        if (parent == null) {
            return null;
        }
        for (PsiReference ref : parent.getReferences()) {
            PsiElement tag;
            PsiElement attr;
            PsiElement elem;
            if (!(ref instanceof SchemaPrefixReference) || (elem = ref.resolve()) == null || !((attr = elem.getParent()) instanceof XmlAttribute) || !((tag = attr.getParent()) instanceof XmlTag) || ((XmlTag)tag).getAttribute("xmlns") != null) continue;
            return (XmlAttribute)attr;
        }
        return null;
    }
}

