/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intention.impl;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.intention.impl.BaseIntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceSet;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public class ConvertAbsolutePathToRelativeIntentionAction
extends BaseIntentionAction {
    protected boolean isConvertToRelative() {
        return true;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        FileReference fileReference;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/intention/impl/ConvertAbsolutePathToRelativeIntentionAction", "isAvailable"));
        }
        int offset = editor.getCaretModel().getOffset();
        PsiElement element = file.findElementAt(offset);
        if (element == null || element instanceof PsiWhiteSpace) {
            return false;
        }
        PsiReference reference = file.findReferenceAt(offset);
        FileReference fileReference2 = fileReference = reference == null ? null : FileReference.findFileReference(reference);
        if (fileReference != null) {
            FileReferenceSet set = fileReference.getFileReferenceSet();
            FileReference lastReference = set.getLastReference();
            return set.couldBeConvertedTo(this.isConvertToRelative()) && lastReference != null && (!this.isConvertToRelative() && !set.isAbsolutePathReference() || this.isConvertToRelative() && set.isAbsolutePathReference()) && lastReference.resolve() != null;
        }
        return false;
    }

    @NotNull
    public String getFamilyName() {
        String string = "Convert " + (this.isConvertToRelative() ? "absolute" : "relative") + " path to " + (this.isConvertToRelative() ? "relative" : "absolute");
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/intention/impl/ConvertAbsolutePathToRelativeIntentionAction", "getFamilyName"));
        }
        return string;
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        FileReference lastReference;
        FileReference fileReference;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/intention/impl/ConvertAbsolutePathToRelativeIntentionAction", "invoke"));
        }
        if (!FileModificationService.getInstance().prepareFileForWrite(file)) {
            return;
        }
        PsiReference reference = file.findReferenceAt(editor.getCaretModel().getOffset());
        FileReference fileReference2 = fileReference = reference == null ? null : FileReference.findFileReference(reference);
        if (fileReference != null && (lastReference = fileReference.getFileReferenceSet().getLastReference()) != null) {
            lastReference.bindToElement((PsiElement)lastReference.resolve(), !this.isConvertToRelative());
        }
    }

    @NotNull
    public String getText() {
        String string = "Convert path to " + (this.isConvertToRelative() ? "relative" : "absolute");
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/intention/impl/ConvertAbsolutePathToRelativeIntentionAction", "getText"));
        }
        return string;
    }

    public boolean startInWriteAction() {
        return true;
    }
}

