/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.lookup;

import com.intellij.codeInsight.completion.CompletionUtil;
import com.intellij.codeInsight.completion.DefaultInsertHandler;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.completion.JavaCompletionUtil;
import com.intellij.codeInsight.completion.JavaPsiClassReferenceElement;
import com.intellij.codeInsight.lookup.DefaultLookupItemRenderer;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementPresentation;
import com.intellij.codeInsight.lookup.LookupItem;
import com.intellij.codeInsight.lookup.TypedLookupItem;
import com.intellij.diagnostic.AttachmentFactory;
import com.intellij.diagnostic.LogMessageEx;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ClassConditionKey;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiDiamondType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReferenceParameterList;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.impl.DebugUtil;
import com.intellij.psi.impl.source.PostprocessReformattingAspect;
import com.intellij.psi.impl.source.PsiClassReferenceType;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ArrayUtil;
import java.util.HashSet;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiTypeLookupItem
extends LookupItem
implements TypedLookupItem {
    private static final InsertHandler<PsiTypeLookupItem> DEFAULT_IMPORT_FIXER = new InsertHandler<PsiTypeLookupItem>(){

        public void handleInsert(InsertionContext context, PsiTypeLookupItem item) {
            if (item.getObject() instanceof PsiClass) {
                PsiTypeLookupItem.addImportForItem(context, (PsiClass)item.getObject());
            }
        }
    };
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.lookup.PsiTypeLookupItem");
    public static final ClassConditionKey<PsiTypeLookupItem> CLASS_CONDITION_KEY = ClassConditionKey.create(PsiTypeLookupItem.class);
    private final boolean myDiamond;
    private final int myBracketsCount;
    private boolean myIndicateAnonymous;
    private final InsertHandler<PsiTypeLookupItem> myImportFixer;
    private boolean myAddArrayInitializer;

    private PsiTypeLookupItem(Object o, @NotNull @NonNls String lookupString, boolean diamond, int bracketsCount, InsertHandler<PsiTypeLookupItem> fixer) {
        if (lookupString == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lookupString", "com/intellij/codeInsight/lookup/PsiTypeLookupItem", "<init>"));
        }
        super(o, lookupString);
        this.myDiamond = diamond;
        this.myBracketsCount = bracketsCount;
        this.myImportFixer = fixer;
    }

    @Override
    @NotNull
    public PsiType getType() {
        Object object = this.getObject();
        PsiType type = object instanceof PsiType ? (PsiType)object : JavaPsiFacade.getElementFactory((Project)((PsiClass)object).getProject()).createType((PsiClass)object);
        for (int i = 0; i < this.getBracketsCount(); ++i) {
            type = new PsiArrayType(type);
        }
        PsiType psiType = this.getSubstitutor().substitute(type);
        if (psiType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/lookup/PsiTypeLookupItem", "getType"));
        }
        return psiType;
    }

    public void setIndicateAnonymous(boolean indicateAnonymous) {
        this.myIndicateAnonymous = indicateAnonymous;
    }

    public boolean isIndicateAnonymous() {
        return this.myIndicateAnonymous;
    }

    @Override
    public boolean equals(Object o) {
        return super.equals(o) && o instanceof PsiTypeLookupItem && this.getBracketsCount() == ((PsiTypeLookupItem)o).getBracketsCount() && this.myAddArrayInitializer == ((PsiTypeLookupItem)o).myAddArrayInitializer;
    }

    public boolean isAddArrayInitializer() {
        return this.myAddArrayInitializer;
    }

    public void setAddArrayInitializer() {
        this.myAddArrayInitializer = true;
    }

    @Override
    public void handleInsert(InsertionContext context) {
        this.myImportFixer.handleInsert(context, (LookupElement)this);
        PsiElement position = context.getFile().findElementAt(context.getStartOffset());
        if (position != null) {
            int genericsStart = context.getTailOffset();
            context.getDocument().insertString(genericsStart, (CharSequence)JavaCompletionUtil.escapeXmlIfNeeded(context, this.calcGenerics(position, context)));
            JavaCompletionUtil.shortenReference(context.getFile(), genericsStart - 1);
        }
        int tail = context.getTailOffset();
        String braces = StringUtil.repeat((String)"[]", (int)this.getBracketsCount());
        Editor editor = context.getEditor();
        if (!braces.isEmpty()) {
            if (this.myAddArrayInitializer) {
                context.getDocument().insertString(tail, (CharSequence)(braces + "{}"));
                editor.getCaretModel().moveToOffset(tail + braces.length() + 1);
            } else {
                context.getDocument().insertString(tail, (CharSequence)braces);
                editor.getCaretModel().moveToOffset(tail + 1);
                if (context.getCompletionChar() == '[') {
                    context.setAddCompletionChar(false);
                }
            }
        } else {
            editor.getCaretModel().moveToOffset(tail);
        }
        editor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
        InsertHandler<LookupItem> handler = this.getInsertHandler();
        if (handler != null && !(handler instanceof DefaultInsertHandler)) {
            handler.handleInsert(context, (LookupElement)this);
        }
    }

    public String calcGenerics(@NotNull PsiElement context, InsertionContext insertionContext) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/codeInsight/lookup/PsiTypeLookupItem", "calcGenerics"));
        }
        if (insertionContext.getCompletionChar() == '<') {
            return "";
        }
        assert (context.isValid());
        if (this.myDiamond) {
            return "<>";
        }
        if (this.getObject() instanceof PsiClass) {
            PsiClass psiClass = (PsiClass)this.getObject();
            PsiResolveHelper resolveHelper = JavaPsiFacade.getInstance((Project)psiClass.getProject()).getResolveHelper();
            PsiSubstitutor substitutor = this.getSubstitutor();
            StringBuilder builder = new StringBuilder();
            for (PsiTypeParameter parameter : psiClass.getTypeParameters()) {
                PsiType substitute = substitutor.substitute(parameter);
                if (substitute == null || PsiUtil.resolveClassInType((PsiType)substitute) == parameter && resolveHelper.resolveReferencedClass(parameter.getName(), context) != CompletionUtil.getOriginalOrSelf(parameter)) {
                    return "";
                }
                if (builder.length() > 0) {
                    builder.append(", ");
                }
                builder.append(substitute.getCanonicalText());
            }
            if (builder.length() > 0) {
                return "<" + builder + ">";
            }
        }
        return "";
    }

    @Override
    public int hashCode() {
        int fromSuper = super.hashCode();
        int dim = this.getBracketsCount();
        return fromSuper + dim * 31;
    }

    public int getBracketsCount() {
        return this.myBracketsCount;
    }

    public static PsiTypeLookupItem createLookupItem(@NotNull PsiType type, @Nullable PsiElement context) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/codeInsight/lookup/PsiTypeLookupItem", "createLookupItem"));
        }
        boolean diamond = PsiTypeLookupItem.isDiamond(type);
        return PsiTypeLookupItem.createLookupItem(type, context, diamond);
    }

    public static PsiTypeLookupItem createLookupItem(@NotNull PsiType type, @Nullable PsiElement context, boolean isDiamond) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/codeInsight/lookup/PsiTypeLookupItem", "createLookupItem"));
        }
        return PsiTypeLookupItem.createLookupItem(type, context, isDiamond, DEFAULT_IMPORT_FIXER);
    }

    public static PsiTypeLookupItem createLookupItem(@NotNull PsiType type, @Nullable PsiElement context, boolean isDiamond, InsertHandler<PsiTypeLookupItem> importFixer) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/codeInsight/lookup/PsiTypeLookupItem", "createLookupItem"));
        }
        int dim = 0;
        while (type instanceof PsiArrayType) {
            type = ((PsiArrayType)type).getComponentType();
            ++dim;
        }
        return PsiTypeLookupItem.doCreateItem(type, context, dim, isDiamond, importFixer);
    }

    private static PsiTypeLookupItem doCreateItem(PsiType type, PsiElement context, int bracketsCount, boolean diamond, InsertHandler<PsiTypeLookupItem> importFixer) {
        String name;
        PsiClassType.ClassResolveResult classResolveResult;
        PsiClass psiClass;
        if (type instanceof PsiClassType && (psiClass = (classResolveResult = ((PsiClassType)type).resolveGenerics()).getElement()) != null && (name = psiClass.getName()) != null) {
            PsiSubstitutor substitutor = classResolveResult.getSubstitutor();
            PsiClass resolved = JavaPsiFacade.getInstance((Project)psiClass.getProject()).getResolveHelper().resolveReferencedClass(name, context);
            HashSet<String> allStrings = new HashSet<String>();
            allStrings.add(name);
            if (!psiClass.getManager().areElementsEquivalent((PsiElement)resolved, (PsiElement)psiClass) && !PsiUtil.isInnerClass((PsiClass)psiClass)) {
                for (PsiClass aClass = psiClass.getContainingClass(); aClass != null && !PsiUtil.isInnerClass((PsiClass)aClass) && aClass.getName() != null; aClass = aClass.getContainingClass()) {
                    name = aClass.getName() + '.' + name;
                    allStrings.add(name);
                }
            }
            PsiTypeLookupItem item = new PsiTypeLookupItem(psiClass, name, diamond, bracketsCount, importFixer);
            item.addLookupStrings(ArrayUtil.toStringArray(allStrings));
            item.setAttribute(SUBSTITUTOR, substitutor);
            return item;
        }
        return new PsiTypeLookupItem(type, type.getPresentableText(), false, bracketsCount, importFixer);
    }

    public static boolean isDiamond(PsiType type) {
        PsiReferenceParameterList parameterList;
        boolean diamond = false;
        if (type instanceof PsiClassReferenceType && (parameterList = ((PsiClassReferenceType)type).getReference().getParameterList()) != null) {
            PsiTypeElement[] typeParameterElements = parameterList.getTypeParameterElements();
            diamond = typeParameterElements.length == 1 && typeParameterElements[0].getType() instanceof PsiDiamondType;
        }
        return diamond;
    }

    @NotNull
    private PsiSubstitutor getSubstitutor() {
        PsiSubstitutor attribute = (PsiSubstitutor)this.getAttribute(SUBSTITUTOR);
        PsiSubstitutor psiSubstitutor = attribute != null ? attribute : PsiSubstitutor.EMPTY;
        if (psiSubstitutor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/lookup/PsiTypeLookupItem", "getSubstitutor"));
        }
        return psiSubstitutor;
    }

    @Override
    public void renderElement(LookupElementPresentation presentation) {
        Object object = this.getObject();
        if (object instanceof PsiClass) {
            JavaPsiClassReferenceElement.renderClassItem(presentation, this, (PsiClass)object, this.myDiamond);
        } else {
            assert (object instanceof PsiType);
            if (!(object instanceof PsiPrimitiveType)) {
                presentation.setIcon(DefaultLookupItemRenderer.getRawIcon((LookupElement)this, presentation.isReal()));
            }
            presentation.setItemText(((PsiType)object).getCanonicalText());
            presentation.setItemTextBold(object instanceof PsiPrimitiveType);
            if (this.isAddArrayInitializer()) {
                presentation.setTailText("{...}");
            }
        }
        if (this.myBracketsCount > 0) {
            presentation.setTailText(StringUtil.repeat((String)"[]", (int)this.myBracketsCount) + StringUtil.notNullize((String)presentation.getTailText()), true);
        }
    }

    public static void addImportForItem(InsertionContext context, PsiClass aClass) {
        int tail;
        int startOffset;
        if (aClass.getQualifiedName() == null) {
            return;
        }
        PsiFile file = context.getFile();
        int newTail = JavaCompletionUtil.insertClassReference(aClass, file, startOffset = context.getStartOffset(), tail = context.getTailOffset());
        if (newTail > context.getDocument().getTextLength() || newTail < 0) {
            LOG.error((Object)LogMessageEx.createEvent("Invalid offset after insertion ", "offset=" + newTail + "\n" + "start=" + startOffset + "\n" + "tail=" + tail + "\n" + "file.length=" + file.getTextLength() + "\n" + "document=" + context.getDocument() + "\n" + DebugUtil.currentStackTrace(), AttachmentFactory.createAttachment(context.getDocument())));
            return;
        }
        context.setTailOffset(newTail);
        JavaCompletionUtil.shortenReference(file, context.getStartOffset());
        PostprocessReformattingAspect.getInstance(context.getProject()).doPostponedFormatting();
    }
}

