/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.impl;

import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionLocation;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionPreselectSkipper;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResult;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.template.CustomLiveTemplate;
import com.intellij.codeInsight.template.CustomLiveTemplateBase;
import com.intellij.codeInsight.template.CustomTemplateCallback;
import com.intellij.codeInsight.template.impl.ListTemplatesHandler;
import com.intellij.codeInsight.template.impl.LiveTemplateLookupElement;
import com.intellij.codeInsight.template.impl.LiveTemplateLookupElementImpl;
import com.intellij.codeInsight.template.impl.TemplateImpl;
import com.intellij.codeInsight.template.impl.TemplateManagerImpl;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPlainTextFile;
import com.intellij.ui.EditorTextField;
import com.intellij.util.Consumer;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LiveTemplateCompletionContributor
extends CompletionContributor {
    private static boolean ourShowTemplatesInTests = false;

    public static void setShowTemplatesInTests(boolean show, @NotNull Disposable parentDisposable) {
        if (parentDisposable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentDisposable", "com/intellij/codeInsight/template/impl/LiveTemplateCompletionContributor", "setShowTemplatesInTests"));
        }
        ourShowTemplatesInTests = show;
        Disposer.register((Disposable)parentDisposable, (Disposable)new Disposable(){

            public void dispose() {
                ourShowTemplatesInTests = false;
            }
        });
    }

    public static boolean shouldShowAllTemplates() {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return ourShowTemplatesInTests;
        }
        return Registry.is((String)"show.live.templates.in.completion");
    }

    public LiveTemplateCompletionContributor() {
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement(), (CompletionProvider)new CompletionProvider<CompletionParameters>(){

            protected void addCompletions(final @NotNull CompletionParameters parameters, ProcessingContext context, @NotNull CompletionResultSet result) {
                TemplateImpl template;
                if (parameters == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/codeInsight/template/impl/LiveTemplateCompletionContributor$2", "addCompletions"));
                }
                if (result == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/codeInsight/template/impl/LiveTemplateCompletionContributor$2", "addCompletions"));
                }
                PsiFile file = parameters.getPosition().getContainingFile();
                if (file instanceof PsiPlainTextFile && parameters.getEditor().getComponent().getParent() instanceof EditorTextField) {
                    return;
                }
                Editor editor = parameters.getEditor();
                int offset = editor.getCaretModel().getOffset();
                List<TemplateImpl> availableTemplates = TemplateManagerImpl.listApplicableTemplates(file, offset, false);
                final Map<TemplateImpl, String> templates = ListTemplatesHandler.filterTemplatesByPrefix(availableTemplates, editor, offset, false, false);
                if (LiveTemplateCompletionContributor.this.showAllTemplates()) {
                    final AtomicBoolean templatesShown = new AtomicBoolean(false);
                    final CompletionResultSet finalResult = result;
                    result.runRemainingContributors(parameters, (Consumer)new Consumer<CompletionResult>(){

                        public void consume(CompletionResult completionResult) {
                            finalResult.passResult(completionResult);
                            if (completionResult.isStartMatch()) {
                                LiveTemplateCompletionContributor.ensureTemplatesShown(templatesShown, templates, parameters, finalResult);
                            }
                        }
                    });
                    LiveTemplateCompletionContributor.ensureTemplatesShown(templatesShown, templates, parameters, result);
                    return;
                }
                if (parameters.getInvocationCount() > 0) {
                    return;
                }
                if (!LiveTemplateCompletionContributor.customTemplateAvailableAndHasCompletionItem(null, editor, file, offset) && (template = LiveTemplateCompletionContributor.findFullMatchedApplicableTemplate(editor, offset, availableTemplates)) != null) {
                    result.withPrefixMatcher(result.getPrefixMatcher().cloneWithPrefix(template.getKey())).addElement((LookupElement)new LiveTemplateLookupElementImpl(template, true));
                }
                for (Map.Entry<TemplateImpl, String> possible : templates.entrySet()) {
                    String templateKey = possible.getKey().getKey();
                    String currentPrefix = possible.getValue();
                    result.withPrefixMatcher(result.getPrefixMatcher().cloneWithPrefix(currentPrefix)).restartCompletionOnPrefixChange(templateKey);
                }
            }
        });
    }

    public static boolean customTemplateAvailableAndHasCompletionItem(@Nullable Character shortcutChar, @NotNull Editor editor, @NotNull PsiFile file, int offset) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/template/impl/LiveTemplateCompletionContributor", "customTemplateAvailableAndHasCompletionItem"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/template/impl/LiveTemplateCompletionContributor", "customTemplateAvailableAndHasCompletionItem"));
        }
        CustomTemplateCallback callback = new CustomTemplateCallback(editor, file);
        for (CustomLiveTemplate customLiveTemplate : TemplateManagerImpl.listApplicableCustomTemplates(editor, file, false)) {
            if (!(customLiveTemplate instanceof CustomLiveTemplateBase) || shortcutChar != null && customLiveTemplate.getShortcut() != shortcutChar.charValue() || !((CustomLiveTemplateBase)customLiveTemplate).hasCompletionItem(file, offset)) continue;
            return customLiveTemplate.computeTemplateKey(callback) != null;
        }
        return false;
    }

    protected boolean showAllTemplates() {
        return LiveTemplateCompletionContributor.shouldShowAllTemplates();
    }

    private static void ensureTemplatesShown(AtomicBoolean templatesShown, Map<TemplateImpl, String> templates, CompletionParameters parameters, CompletionResultSet result) {
        if (!templatesShown.getAndSet(true)) {
            for (Map.Entry<TemplateImpl, String> entry : templates.entrySet()) {
                result.withPrefixMatcher(result.getPrefixMatcher().cloneWithPrefix(StringUtil.notNullize((String)entry.getValue()))).addElement((LookupElement)new LiveTemplateLookupElementImpl(entry.getKey(), false));
            }
            PsiFile file = parameters.getPosition().getContainingFile();
            Editor editor = parameters.getEditor();
            for (CustomLiveTemplate customLiveTemplate : TemplateManagerImpl.listApplicableCustomTemplates(editor, file, false)) {
                if (!(customLiveTemplate instanceof CustomLiveTemplateBase)) continue;
                ((CustomLiveTemplateBase)customLiveTemplate).addCompletions(parameters, result);
            }
        }
    }

    @Nullable
    public static TemplateImpl findFullMatchedApplicableTemplate(@NotNull Editor editor, int offset, @NotNull Collection<TemplateImpl> availableTemplates) {
        TemplateImpl template;
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/template/impl/LiveTemplateCompletionContributor", "findFullMatchedApplicableTemplate"));
        }
        if (availableTemplates == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "availableTemplates", "com/intellij/codeInsight/template/impl/LiveTemplateCompletionContributor", "findFullMatchedApplicableTemplate"));
        }
        Map<TemplateImpl, String> templates = ListTemplatesHandler.filterTemplatesByPrefix(availableTemplates, editor, offset, true, false);
        if (templates.size() == 1 && (template = (TemplateImpl)ContainerUtil.getFirstItem(templates.keySet())) != null) {
            return template;
        }
        return null;
    }

    public static class Skipper
    extends CompletionPreselectSkipper {
        public boolean skipElement(LookupElement element, CompletionLocation location) {
            return element instanceof LiveTemplateLookupElement && ((LiveTemplateLookupElement)element).sudden && !Registry.is((String)"ide.completion.autopopup.select.live.templates");
        }
    }
}

