/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.ex;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ex.GlobalInspectionContextImpl;
import com.intellij.codeInspection.ex.InspectionManagerEx;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.codeInspection.ex.PerformFixesModalTask;
import com.intellij.codeInspection.reference.RefElement;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.reference.RefManagerImpl;
import com.intellij.codeInspection.ui.InspectionResultsView;
import com.intellij.codeInspection.ui.InspectionTree;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.ReadonlyStatusHandler;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.SequentialModalProgressTask;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.KeyStroke;
import org.jetbrains.annotations.NotNull;

public class QuickFixAction
extends AnAction {
    public static final QuickFixAction[] EMPTY = new QuickFixAction[0];
    protected final InspectionToolWrapper myToolWrapper;

    public static InspectionResultsView getInvoker(AnActionEvent e) {
        return (InspectionResultsView)InspectionResultsView.DATA_KEY.getData(e.getDataContext());
    }

    protected QuickFixAction(String text, @NotNull InspectionToolWrapper toolWrapper) {
        if (toolWrapper == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolWrapper", "com/intellij/codeInspection/ex/QuickFixAction", "<init>"));
        }
        this(text, AllIcons.Actions.CreateFromUsage, null, toolWrapper);
    }

    protected QuickFixAction(String text, Icon icon, KeyStroke keyStroke, @NotNull InspectionToolWrapper toolWrapper) {
        if (toolWrapper == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolWrapper", "com/intellij/codeInspection/ex/QuickFixAction", "<init>"));
        }
        super(text, null, icon);
        this.myToolWrapper = toolWrapper;
        if (keyStroke != null) {
            this.registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(keyStroke), null);
        }
    }

    public void update(AnActionEvent e) {
        InspectionResultsView view = QuickFixAction.getInvoker(e);
        if (view == null) {
            e.getPresentation().setEnabled(false);
            return;
        }
        e.getPresentation().setVisible(false);
        e.getPresentation().setEnabled(false);
        InspectionTree tree = view.getTree();
        InspectionToolWrapper toolWrapper = tree.getSelectedToolWrapper();
        if (!view.isSingleToolInSelection() || toolWrapper != this.myToolWrapper) {
            return;
        }
        if (!this.isProblemDescriptorsAcceptable() && tree.getSelectedElements().length > 0 || this.isProblemDescriptorsAcceptable() && tree.getSelectedDescriptors().length > 0) {
            e.getPresentation().setVisible(true);
            e.getPresentation().setEnabled(true);
        }
    }

    protected boolean isProblemDescriptorsAcceptable() {
        return false;
    }

    public String getText(RefEntity where) {
        return this.getTemplatePresentation().getText();
    }

    public void actionPerformed(AnActionEvent e) {
        CommonProblemDescriptor[] descriptors;
        InspectionResultsView view = QuickFixAction.getInvoker(e);
        InspectionTree tree = view.getTree();
        if (this.isProblemDescriptorsAcceptable() && (descriptors = tree.getSelectedDescriptors()).length > 0) {
            this.doApplyFix(view.getProject(), descriptors, tree.getContext());
            return;
        }
        this.doApplyFix(QuickFixAction.getSelectedElements(e), view);
    }

    protected void applyFix(@NotNull Project project, @NotNull GlobalInspectionContextImpl context, @NotNull CommonProblemDescriptor[] descriptors, @NotNull Set<PsiElement> ignoredElements) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/ex/QuickFixAction", "applyFix"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/codeInspection/ex/QuickFixAction", "applyFix"));
        }
        if (descriptors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptors", "com/intellij/codeInspection/ex/QuickFixAction", "applyFix"));
        }
        if (ignoredElements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ignoredElements", "com/intellij/codeInspection/ex/QuickFixAction", "applyFix"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doApplyFix(final @NotNull Project project, final @NotNull CommonProblemDescriptor[] descriptors, final @NotNull GlobalInspectionContextImpl context) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/ex/QuickFixAction", "doApplyFix"));
        }
        if (descriptors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptors", "com/intellij/codeInspection/ex/QuickFixAction", "doApplyFix"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/codeInspection/ex/QuickFixAction", "doApplyFix"));
        }
        THashSet readOnlyFiles = new THashSet();
        for (CommonProblemDescriptor descriptor : descriptors) {
            PsiElement psiElement;
            PsiElement psiElement2 = psiElement = descriptor instanceof ProblemDescriptor ? ((ProblemDescriptor)descriptor).getPsiElement() : null;
            if (psiElement == null || psiElement.isWritable()) continue;
            readOnlyFiles.add(psiElement.getContainingFile().getVirtualFile());
        }
        if (!FileModificationService.getInstance().prepareVirtualFilesForWrite(project, (Collection)readOnlyFiles)) {
            return;
        }
        RefManagerImpl refManager = (RefManagerImpl)context.getRefManager();
        boolean initial = refManager.isInProcess();
        refManager.inspectionReadActionFinished();
        try {
            final HashSet<PsiElement> ignoredElements = new HashSet<PsiElement>();
            final String templatePresentationText = this.getTemplatePresentation().getText();
            assert (templatePresentationText != null);
            CommandProcessor.getInstance().executeCommand(project, new Runnable(){

                @Override
                public void run() {
                    CommandProcessor.getInstance().markCurrentCommandAsGlobal(project);
                    SequentialModalProgressTask progressTask = new SequentialModalProgressTask(project, templatePresentationText, false);
                    progressTask.setMinIterationTime(200L);
                    progressTask.setTask(new PerformFixesTask(project, descriptors, ignoredElements, progressTask, context));
                    ProgressManager.getInstance().run((Task)progressTask);
                }
            }, templatePresentationText, null);
            QuickFixAction.refreshViews(project, ignoredElements, this.myToolWrapper);
        }
        finally {
            if (initial) {
                refManager.inspectionReadActionStarted();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doApplyFix(final @NotNull RefEntity[] refElements, @NotNull InspectionResultsView view) {
        if (refElements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refElements", "com/intellij/codeInspection/ex/QuickFixAction", "doApplyFix"));
        }
        if (view == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "view", "com/intellij/codeInspection/ex/QuickFixAction", "doApplyFix"));
        }
        RefManagerImpl refManager = (RefManagerImpl)view.getGlobalInspectionContext().getRefManager();
        boolean initial = refManager.isInProcess();
        refManager.inspectionReadActionFinished();
        try {
            final boolean[] refreshNeeded = new boolean[]{false};
            if (refElements.length > 0) {
                final Project project = refElements[0].getRefManager().getProject();
                CommandProcessor.getInstance().executeCommand(project, new Runnable(){

                    @Override
                    public void run() {
                        CommandProcessor.getInstance().markCurrentCommandAsGlobal(project);
                        ApplicationManager.getApplication().runWriteAction(new Runnable(){

                            @Override
                            public void run() {
                                refreshNeeded[0] = QuickFixAction.this.applyFix(refElements);
                            }
                        });
                    }
                }, this.getTemplatePresentation().getText(), null);
            }
            if (refreshNeeded[0]) {
                QuickFixAction.refreshViews(view.getProject(), refElements, this.myToolWrapper);
            }
        }
        finally {
            if (initial) {
                refManager.inspectionReadActionStarted();
            }
        }
    }

    public static void removeElements(@NotNull RefEntity[] refElements, @NotNull Project project, @NotNull InspectionToolWrapper toolWrapper) {
        if (refElements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refElements", "com/intellij/codeInspection/ex/QuickFixAction", "removeElements"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/ex/QuickFixAction", "removeElements"));
        }
        if (toolWrapper == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolWrapper", "com/intellij/codeInspection/ex/QuickFixAction", "removeElements"));
        }
        QuickFixAction.refreshViews(project, refElements, toolWrapper);
        ArrayList deletedRefs = new ArrayList(1);
        for (RefEntity refElement : refElements) {
            if (!(refElement instanceof RefElement)) continue;
            refElement.getRefManager().removeRefElement((RefElement)refElement, deletedRefs);
        }
    }

    private static Set<VirtualFile> getReadOnlyFiles(@NotNull RefEntity[] refElements) {
        if (refElements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refElements", "com/intellij/codeInspection/ex/QuickFixAction", "getReadOnlyFiles"));
        }
        THashSet readOnlyFiles = new THashSet();
        for (RefEntity refElement : refElements) {
            PsiElement psiElement;
            PsiElement psiElement2 = psiElement = refElement instanceof RefElement ? ((RefElement)refElement).getElement() : null;
            if (psiElement == null || psiElement.getContainingFile() == null) continue;
            readOnlyFiles.add(psiElement.getContainingFile().getVirtualFile());
        }
        return readOnlyFiles;
    }

    private static RefEntity[] getSelectedElements(AnActionEvent e) {
        InspectionResultsView invoker = QuickFixAction.getInvoker(e);
        if (invoker == null) {
            return new RefElement[0];
        }
        ArrayList<RefEntity> selection = new ArrayList<RefEntity>(Arrays.asList(invoker.getTree().getSelectedElements()));
        PsiDocumentManager.getInstance((Project)invoker.getProject()).commitAllDocuments();
        Collections.sort(selection, new Comparator<RefEntity>(){

            @Override
            public int compare(RefEntity o1, RefEntity o2) {
                if (o1 instanceof RefElement && o2 instanceof RefElement) {
                    PsiFile containingFile2;
                    RefElement r1 = (RefElement)o1;
                    RefElement r2 = (RefElement)o2;
                    PsiElement element1 = r1.getElement();
                    PsiElement element2 = r2.getElement();
                    PsiFile containingFile1 = element1.getContainingFile();
                    if (containingFile1 == (containingFile2 = element2.getContainingFile())) {
                        int i2;
                        int i1 = element1.getTextOffset();
                        if (i1 < (i2 = element2.getTextOffset())) {
                            return 1;
                        }
                        if (i1 > i2) {
                            return -1;
                        }
                        return 0;
                    }
                    return containingFile1.getName().compareTo(containingFile2.getName());
                }
                if (o1 instanceof RefElement) {
                    return 1;
                }
                if (o2 instanceof RefElement) {
                    return -1;
                }
                return o1.getName().compareTo(o2.getName());
            }
        });
        return selection.toArray(new RefEntity[selection.size()]);
    }

    private static void refreshViews(@NotNull Project project, @NotNull Set<PsiElement> selectedElements, @NotNull InspectionToolWrapper toolWrapper) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/ex/QuickFixAction", "refreshViews"));
        }
        if (selectedElements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selectedElements", "com/intellij/codeInspection/ex/QuickFixAction", "refreshViews"));
        }
        if (toolWrapper == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolWrapper", "com/intellij/codeInspection/ex/QuickFixAction", "refreshViews"));
        }
        InspectionManagerEx managerEx = (InspectionManagerEx)InspectionManager.getInstance((Project)project);
        Set<GlobalInspectionContextImpl> runningContexts = managerEx.getRunningContexts();
        for (GlobalInspectionContextImpl context : runningContexts) {
            for (PsiElement element : selectedElements) {
                context.ignoreElement(toolWrapper.getTool(), element);
            }
            context.refreshViews();
        }
    }

    private static void refreshViews(@NotNull Project project, @NotNull RefEntity[] refElements, @NotNull InspectionToolWrapper toolWrapper) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/ex/QuickFixAction", "refreshViews"));
        }
        if (refElements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refElements", "com/intellij/codeInspection/ex/QuickFixAction", "refreshViews"));
        }
        if (toolWrapper == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolWrapper", "com/intellij/codeInspection/ex/QuickFixAction", "refreshViews"));
        }
        HashSet<PsiElement> ignoredElements = new HashSet<PsiElement>();
        for (RefEntity element : refElements) {
            PsiElement psiElement;
            PsiElement psiElement2 = psiElement = element instanceof RefElement ? ((RefElement)element).getElement() : null;
            if (psiElement == null || !psiElement.isValid()) continue;
            ignoredElements.add(psiElement);
        }
        QuickFixAction.refreshViews(project, ignoredElements, toolWrapper);
    }

    protected boolean applyFix(@NotNull RefEntity[] refElements) {
        Project project;
        ReadonlyStatusHandler.OperationStatus operationStatus;
        if (refElements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refElements", "com/intellij/codeInspection/ex/QuickFixAction", "applyFix"));
        }
        Set<VirtualFile> readOnlyFiles = QuickFixAction.getReadOnlyFiles(refElements);
        return readOnlyFiles.isEmpty() || !(operationStatus = ReadonlyStatusHandler.getInstance((Project)(project = refElements[0].getRefManager().getProject())).ensureFilesWritable(VfsUtilCore.toVirtualFileArray(readOnlyFiles))).hasReadonlyFiles();
    }

    private class PerformFixesTask
    extends PerformFixesModalTask {
        @NotNull
        private final GlobalInspectionContextImpl myContext;
        @NotNull
        private final Set<PsiElement> myIgnoredElements;

        public PerformFixesTask(@NotNull Project project, @NotNull CommonProblemDescriptor[] descriptors, @NotNull Set<PsiElement> ignoredElements, @NotNull SequentialModalProgressTask task, GlobalInspectionContextImpl context) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/ex/QuickFixAction$PerformFixesTask", "<init>"));
            }
            if (descriptors == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptors", "com/intellij/codeInspection/ex/QuickFixAction$PerformFixesTask", "<init>"));
            }
            if (ignoredElements == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ignoredElements", "com/intellij/codeInspection/ex/QuickFixAction$PerformFixesTask", "<init>"));
            }
            if (task == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "com/intellij/codeInspection/ex/QuickFixAction$PerformFixesTask", "<init>"));
            }
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/codeInspection/ex/QuickFixAction$PerformFixesTask", "<init>"));
            }
            super(project, descriptors, task);
            this.myContext = context;
            this.myIgnoredElements = ignoredElements;
        }

        @Override
        protected void applyFix(Project project, CommonProblemDescriptor descriptor) {
            QuickFixAction.this.applyFix(this.myProject, this.myContext, new CommonProblemDescriptor[]{descriptor}, this.myIgnoredElements);
        }

        @Override
        public void stop() {
        }
    }
}

