/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.server;

import com.google.protobuf.MessageLite;
import com.intellij.ProjectTopics;
import com.intellij.compiler.CompilerConfiguration;
import com.intellij.compiler.CompilerWorkspaceConfiguration;
import com.intellij.compiler.impl.CompilerUtil;
import com.intellij.compiler.impl.javaCompiler.javac.JavacConfiguration;
import com.intellij.compiler.server.AutoMakeMessageHandler;
import com.intellij.compiler.server.BuildManagerListener;
import com.intellij.compiler.server.BuildMessageDispatcher;
import com.intellij.compiler.server.BuildProcessParametersProvider;
import com.intellij.compiler.server.BuilderMessageHandler;
import com.intellij.compiler.server.DefaultMessageHandler;
import com.intellij.compiler.server.DelegatingMessageHandler;
import com.intellij.compiler.server.PreloadedProcessMessageHandler;
import com.intellij.compiler.server.impl.BuildProcessClasspathManager;
import com.intellij.concurrency.JobScheduler;
import com.intellij.execution.ExecutionAdapter;
import com.intellij.execution.ExecutionManager;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.ide.DataManager;
import com.intellij.ide.PowerSaveMode;
import com.intellij.ide.file.BatchFileChangeListener;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.compiler.CompilationStatusListener;
import com.intellij.openapi.compiler.CompileContext;
import com.intellij.openapi.compiler.CompilerTopics;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.event.DocumentAdapter;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.impl.FileDocumentManagerImpl;
import com.intellij.openapi.fileTypes.impl.FileTypeManagerImpl;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectCoreUtil;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectManagerAdapter;
import com.intellij.openapi.project.ProjectManagerListener;
import com.intellij.openapi.projectRoots.JavaSdk;
import com.intellij.openapi.projectRoots.JavaSdkType;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.impl.JavaAwareProjectJdkTableImpl;
import com.intellij.openapi.roots.ModuleRootAdapter;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.ShutDownTracker;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.newvfs.impl.FileNameCache;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.util.Alarm;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.SmartList;
import com.intellij.util.concurrency.Semaphore;
import com.intellij.util.concurrency.SequentialTaskExecutor;
import com.intellij.util.containers.IntArrayList;
import com.intellij.util.io.storage.HeavyProcessLatch;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.net.NetUtils;
import com.intellij.util.text.DateFormatUtil;
import gnu.trove.THashSet;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.handler.codec.protobuf.ProtobufDecoder;
import io.netty.handler.codec.protobuf.ProtobufEncoder;
import io.netty.handler.codec.protobuf.ProtobufVarint32FrameDecoder;
import io.netty.handler.codec.protobuf.ProtobufVarint32LengthFieldPrepender;
import io.netty.util.internal.ThreadLocalRandom;
import java.awt.Component;
import java.awt.Container;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.SwingUtilities;
import javax.tools.JavaCompiler;
import javax.tools.ToolProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.ide.PooledThreadExecutor;
import org.jetbrains.io.ChannelRegistrar;
import org.jetbrains.io.NettyUtil;
import org.jetbrains.jps.api.CmdlineProtoUtil;
import org.jetbrains.jps.api.CmdlineRemoteProto;
import org.jetbrains.jps.api.RequestFuture;
import org.jetbrains.jps.api.TaskFuture;
import org.jetbrains.jps.cmdline.BuildMain;
import org.jetbrains.jps.cmdline.ClasspathBootstrap;
import org.jetbrains.jps.cmdline.Launcher;
import org.jetbrains.jps.incremental.Utils;

public class BuildManager
implements Disposable {
    public static final Key<Boolean> ALLOW_AUTOMAKE = Key.create((String)"_allow_automake_when_process_is_active_");
    private static final Key<Integer> COMPILER_PROCESS_DEBUG_PORT = Key.create((String)"_compiler_process_debug_port_");
    private static final Key<String> FORCE_MODEL_LOADING_PARAMETER = Key.create((String)"_force_model_loading");
    private static final Key<CharSequence> STDERR_OUTPUT = Key.create((String)"_process_launch_errors_");
    private static final SimpleDateFormat USAGE_STAMP_DATE_FORMAT = new SimpleDateFormat("dd.MM.yyyy");
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.compiler.server.BuildManager");
    private static final String COMPILER_PROCESS_JDK_PROPERTY = "compiler.process.jdk";
    public static final String SYSTEM_ROOT = "compile-server";
    public static final String TEMP_DIR_NAME = "_temp_";
    private final boolean IS_UNIT_TEST_MODE;
    private static final String IWS_EXTENSION = ".iws";
    private static final String IPR_EXTENSION = ".ipr";
    private static final String IDEA_PROJECT_DIR_PATTERN = "/.idea/";
    private static final Function<String, Boolean> PATH_FILTER = SystemInfo.isFileSystemCaseSensitive ? new Function<String, Boolean>(){

        public Boolean fun(String s) {
            return !s.contains(BuildManager.IDEA_PROJECT_DIR_PATTERN) && !s.endsWith(BuildManager.IWS_EXTENSION) && !s.endsWith(BuildManager.IPR_EXTENSION);
        }
    } : new Function<String, Boolean>(){

        public Boolean fun(String s) {
            return !StringUtil.endsWithIgnoreCase((String)s, (String)BuildManager.IWS_EXTENSION) && !StringUtil.endsWithIgnoreCase((String)s, (String)BuildManager.IPR_EXTENSION) && !StringUtil.containsIgnoreCase((String)s, (String)BuildManager.IDEA_PROJECT_DIR_PATTERN);
        }
    };
    private final File mySystemDirectory;
    private final ProjectManager myProjectManager;
    private final Map<TaskFuture, Project> myAutomakeFutures = Collections.synchronizedMap(new HashMap());
    private final Map<String, RequestFuture> myBuildsInProgress = Collections.synchronizedMap(new HashMap());
    private final Map<String, Future<Pair<RequestFuture<PreloadedProcessMessageHandler>, OSProcessHandler>>> myPreloadedBuilds = Collections.synchronizedMap(new HashMap());
    private final BuildProcessClasspathManager myClasspathManager = new BuildProcessClasspathManager();
    private final SequentialTaskExecutor myRequestsProcessor = new SequentialTaskExecutor((Executor)PooledThreadExecutor.INSTANCE);
    private final Map<String, ProjectData> myProjectDataMap = Collections.synchronizedMap(new HashMap());
    private final BuildManagerPeriodicTask myAutoMakeTask = new BuildManagerPeriodicTask(){

        @Override
        protected int getDelay() {
            return Registry.intValue((String)"compiler.automake.trigger.delay");
        }

        @Override
        protected void runTask() {
            BuildManager.this.runAutoMake();
        }
    };
    private final BuildManagerPeriodicTask myDocumentSaveTask = new BuildManagerPeriodicTask(){
        private final Semaphore mySemaphore = new Semaphore();
        private final Runnable mySaveDocsRunnable = new Runnable(){

            @Override
            public void run() {
                try {
                    ((FileDocumentManagerImpl)FileDocumentManager.getInstance()).saveAllDocuments(false);
                }
                finally {
                    mySemaphore.up();
                }
            }
        };

        @Override
        protected int getDelay() {
            return Registry.intValue((String)"compiler.document.save.trigger.delay");
        }

        @Override
        public void runTask() {
            if (this.shouldSaveDocuments()) {
                this.mySemaphore.down();
                ApplicationManager.getApplication().invokeLater(this.mySaveDocsRunnable, ModalityState.NON_MODAL);
                this.mySemaphore.waitFor();
            }
        }

        private boolean shouldSaveDocuments() {
            Project contextProject = BuildManager.this.getCurrentContextProject();
            return contextProject != null && BuildManager.canStartAutoMake(contextProject);
        }
    };
    private final Runnable myGCTask = new Runnable(){

        @Override
        public void run() {
            int unusedThresholdDays = Registry.intValue((String)"compiler.build.data.unused.threshold", (int)-1);
            if (unusedThresholdDays <= 0) {
                return;
            }
            File buildSystemDir = BuildManager.this.getBuildSystemDirectory();
            File[] dirs = buildSystemDir.listFiles(new FileFilter(){

                @Override
                public boolean accept(File pathname) {
                    return pathname.isDirectory() && !BuildManager.TEMP_DIR_NAME.equals(pathname.getName());
                }
            });
            if (dirs != null) {
                Date now = new Date();
                for (File buildDataProjectDir : dirs) {
                    File usageFile = BuildManager.getUsageFile(buildDataProjectDir);
                    if (usageFile.exists()) {
                        File projectFile;
                        Pair usageData = BuildManager.readUsageFile(usageFile);
                        if (usageData == null || ((projectFile = (File)usageData.second) == null || projectFile.exists()) && DateFormatUtil.getDifferenceInDays((Date)((Date)usageData.first), (Date)now) <= (long)unusedThresholdDays) continue;
                        LOG.info("Clearing project build data because the project does not exist or was not opened for more than " + unusedThresholdDays + " days: " + buildDataProjectDir.getPath());
                        FileUtil.delete((File)buildDataProjectDir);
                        continue;
                    }
                    BuildManager.updateUsageFile(null, buildDataProjectDir);
                }
            }
        }
    };
    private final ChannelRegistrar myChannelRegistrar = new ChannelRegistrar();
    private final BuildMessageDispatcher myMessageDispatcher = new BuildMessageDispatcher();
    private volatile int myListenPort = -1;
    @NotNull
    private final Charset mySystemCharset = CharsetToolkit.getDefaultSystemCharset();

    public BuildManager(ProjectManager projectManager) {
        Application application = ApplicationManager.getApplication();
        this.IS_UNIT_TEST_MODE = application.isUnitTestMode();
        this.myProjectManager = projectManager;
        String systemPath = PathManager.getSystemPath();
        File system = new File(systemPath);
        try {
            system = system.getCanonicalFile();
        }
        catch (IOException e) {
            LOG.info((Throwable)e);
        }
        this.mySystemDirectory = system;
        projectManager.addProjectManagerListener((ProjectManagerListener)new ProjectWatcher());
        MessageBusConnection conn = application.getMessageBus().connect();
        conn.subscribe(VirtualFileManager.VFS_CHANGES, (Object)new BulkFileListener.Adapter(){

            public void after(@NotNull List<? extends VFileEvent> events) {
                if (events == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "events", "com/intellij/compiler/server/BuildManager$6", "after"));
                }
                if (this.shouldTriggerMake(events)) {
                    BuildManager.this.scheduleAutoMake();
                }
            }

            private boolean shouldTriggerMake(List<? extends VFileEvent> events) {
                if (PowerSaveMode.isEnabled()) {
                    return false;
                }
                Project project = null;
                ProjectFileIndex fileIndex = null;
                for (VFileEvent vFileEvent : events) {
                    VirtualFile eventFile = vFileEvent.getFile();
                    if (eventFile == null) continue;
                    if (!eventFile.isValid()) {
                        return true;
                    }
                    if (project == null) {
                        project = BuildManager.this.getCurrentContextProject();
                        if (project == null) {
                            return false;
                        }
                        fileIndex = ProjectRootManager.getInstance((Project)project).getFileIndex();
                    }
                    if (!fileIndex.isInContent(eventFile) || ProjectCoreUtil.isProjectOrWorkspaceFile((VirtualFile)eventFile)) continue;
                    return true;
                }
                return false;
            }
        });
        conn.subscribe(BatchFileChangeListener.TOPIC, (Object)new BatchFileChangeListener.Adapter(){

            @Override
            public void batchChangeStarted(Project project) {
                BuildManager.this.cancelAutoMakeTasks(project);
            }
        });
        EditorFactory.getInstance().getEventMulticaster().addDocumentListener((DocumentListener)new DocumentAdapter(){

            public void documentChanged(DocumentEvent e) {
                BuildManager.this.scheduleProjectSave();
            }
        });
        ShutDownTracker.getInstance().registerShutdownTask(new Runnable(){

            @Override
            public void run() {
                BuildManager.this.stopListening();
            }
        });
        JobScheduler.getScheduler().scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                BuildManager.this.runCommand(BuildManager.this.myGCTask);
            }
        }, 3L, 180L, TimeUnit.MINUTES);
    }

    private List<Project> getOpenProjects() {
        Project[] projects = this.myProjectManager.getOpenProjects();
        if (projects.length == 0) {
            return Collections.emptyList();
        }
        SmartList projectList = new SmartList();
        for (Project project : projects) {
            if (!BuildManager.isValidProject(project)) continue;
            projectList.add(project);
        }
        return projectList;
    }

    private static boolean isValidProject(@Nullable Project project) {
        return project != null && !project.isDisposed() && !project.isDefault() && project.isInitialized();
    }

    public static BuildManager getInstance() {
        return (BuildManager)ApplicationManager.getApplication().getComponent(BuildManager.class);
    }

    public void notifyFilesChanged(Collection<File> paths) {
        this.doNotify(paths, false);
    }

    public void notifyFilesDeleted(Collection<File> paths) {
        this.doNotify(paths, true);
    }

    public void runCommand(Runnable command) {
        this.myRequestsProcessor.submit(command);
    }

    private void doNotify(final Collection<File> paths, final boolean notifyDeletion) {
        this.runCommand(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                ArrayList<String> filtered = new ArrayList<String>(paths.size());
                for (File file : paths) {
                    String path = FileUtil.toSystemIndependentName((String)file.getPath());
                    if (!((Boolean)PATH_FILTER.fun((Object)path)).booleanValue()) continue;
                    filtered.add(path);
                }
                if (filtered.isEmpty()) {
                    return;
                }
                Map map = BuildManager.this.myProjectDataMap;
                synchronized (map) {
                    if (BuildManager.this.IS_UNIT_TEST_MODE) {
                        if (notifyDeletion) {
                            LOG.info("Registering deleted paths: " + filtered);
                        } else {
                            LOG.info("Registering changed paths: " + filtered);
                        }
                    }
                    for (Map.Entry entry : BuildManager.this.myProjectDataMap.entrySet()) {
                        RequestFuture future2;
                        ProjectData data2 = (ProjectData)entry.getValue();
                        if (notifyDeletion) {
                            data2.addDeleted(filtered);
                        } else {
                            data2.addChanged(filtered);
                        }
                        if ((future2 = (RequestFuture)BuildManager.this.myBuildsInProgress.get(entry.getKey())) == null || future2.isCancelled() || future2.isDone()) continue;
                        UUID sessionId = future2.getRequestID();
                        Channel channel = BuildManager.this.myMessageDispatcher.getConnectedChannel(sessionId);
                        if (channel == null) continue;
                        CmdlineRemoteProto.Message.ControllerMessage message = CmdlineRemoteProto.Message.ControllerMessage.newBuilder().setType(CmdlineRemoteProto.Message.ControllerMessage.Type.FS_EVENT).setFsEvent(data2.createNextEvent()).build();
                        channel.writeAndFlush((Object)CmdlineProtoUtil.toMessage((UUID)sessionId, (CmdlineRemoteProto.Message.ControllerMessage)message));
                    }
                }
            }
        });
    }

    public static void forceModelLoading(CompileContext context) {
        context.getCompileScope().putUserData(FORCE_MODEL_LOADING_PARAMETER, (Object)Boolean.TRUE.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearState(Project project) {
        String projectPath = BuildManager.getProjectPath(project);
        this.cancelPreloadedBuilds(projectPath);
        Map<String, ProjectData> map = this.myProjectDataMap;
        synchronized (map) {
            ProjectData data2 = this.myProjectDataMap.get(projectPath);
            if (data2 != null) {
                data2.dropChanges();
            }
        }
        this.scheduleAutoMake();
    }

    public boolean isProjectWatched(Project project) {
        return this.myProjectDataMap.containsKey(BuildManager.getProjectPath(project));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public List<String> getFilesChangedSinceLastCompilation(Project project) {
        String projectPath = BuildManager.getProjectPath(project);
        Map<String, ProjectData> map = this.myProjectDataMap;
        synchronized (map) {
            ProjectData data2 = this.myProjectDataMap.get(projectPath);
            if (data2 != null && !data2.myNeedRescan) {
                return BuildManager.convertToStringPaths(data2.myChanged);
            }
            return null;
        }
    }

    private static List<String> convertToStringPaths(Collection<InternedPath> interned) {
        ArrayList<String> list = new ArrayList<String>(interned.size());
        for (InternedPath path : interned) {
            list.add(path.getValue());
        }
        return list;
    }

    @Nullable
    private static String getProjectPath(Project project) {
        String url = project.getPresentableUrl();
        if (url == null) {
            return null;
        }
        return VirtualFileManager.extractPath((String)url);
    }

    public void scheduleAutoMake() {
        if (!this.IS_UNIT_TEST_MODE && !PowerSaveMode.isEnabled()) {
            this.myAutoMakeTask.schedule();
        }
    }

    private void scheduleProjectSave() {
        if (!this.IS_UNIT_TEST_MODE && !PowerSaveMode.isEnabled()) {
            this.myDocumentSaveTask.schedule();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runAutoMake() {
        Project project = this.getCurrentContextProject();
        if (project == null || !BuildManager.canStartAutoMake(project)) {
            return;
        }
        List scopes = CmdlineProtoUtil.createAllModulesScopes((boolean)false);
        AutoMakeMessageHandler handler = new AutoMakeMessageHandler(project);
        TaskFuture future2 = this.scheduleBuild(project, false, true, false, scopes, Collections.<String>emptyList(), Collections.<String, String>emptyMap(), handler);
        if (future2 != null) {
            this.myAutomakeFutures.put(future2, project);
            try {
                future2.waitFor();
            }
            finally {
                this.myAutomakeFutures.remove(future2);
            }
        }
    }

    private static boolean canStartAutoMake(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/compiler/server/BuildManager", "canStartAutoMake"));
        }
        if (project.isDisposed()) {
            return false;
        }
        CompilerWorkspaceConfiguration config = CompilerWorkspaceConfiguration.getInstance((Project)project);
        if (!config.MAKE_PROJECT_ON_SAVE) {
            return false;
        }
        return config.allowAutoMakeWhileRunningApplication() || !BuildManager.hasRunningProcess(project);
    }

    @Nullable
    private Project getCurrentContextProject() {
        return this.getContextProject(null);
    }

    @Nullable
    private Project getContextProject(@Nullable Window window) {
        Container _parent;
        List<Project> openProjects = this.getOpenProjects();
        if (openProjects.isEmpty()) {
            return null;
        }
        if (openProjects.size() == 1) {
            return openProjects.get(0);
        }
        if (window == null && (window = KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow()) == null) {
            return null;
        }
        Container comp = window;
        while ((_parent = comp.getParent()) != null) {
            comp = _parent;
        }
        Project project = null;
        if (comp instanceof IdeFrame) {
            project = ((IdeFrame)comp).getProject();
        }
        if (project == null) {
            project = (Project)CommonDataKeys.PROJECT.getData(DataManager.getInstance().getDataContext((Component)comp));
        }
        return BuildManager.isValidProject(project) ? project : null;
    }

    private static boolean hasRunningProcess(Project project) {
        for (ProcessHandler handler : ExecutionManager.getInstance((Project)project).getRunningProcesses()) {
            if (handler.isProcessTerminated() || ((Boolean)ALLOW_AUTOMAKE.get((UserDataHolder)handler, (Object)Boolean.FALSE)).booleanValue()) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<TaskFuture> cancelAutoMakeTasks(Project project) {
        SmartList futures = new SmartList();
        Map<TaskFuture, Project> map = this.myAutomakeFutures;
        synchronized (map) {
            for (Map.Entry<TaskFuture, Project> entry : this.myAutomakeFutures.entrySet()) {
                if (!entry.getValue().equals(project)) continue;
                TaskFuture future2 = entry.getKey();
                future2.cancel(false);
                futures.add(future2);
            }
        }
        return futures;
    }

    private void cancelPreloadedBuilds(final String projectPath) {
        this.runCommand(new Runnable(){

            @Override
            public void run() {
                Pair pair = BuildManager.this.takePreloadedProcess(projectPath);
                if (pair != null) {
                    final RequestFuture future2 = (RequestFuture)pair.first;
                    final OSProcessHandler processHandler2 = (OSProcessHandler)pair.second;
                    BuildManager.this.myMessageDispatcher.cancelSession(future2.getRequestID());
                    ((BuildManager)BuildManager.this).getProjectData((String)projectPath).taskQueue.submit(new Runnable(){

                        @Override
                        public void run() {
                            Throwable error = null;
                            try {
                                while (!processHandler2.waitFor()) {
                                    LOG.info("processHandler.waitFor() returned false for session " + future2.getRequestID() + ", continue waiting");
                                }
                            }
                            catch (Throwable e) {
                                error = e;
                            }
                            finally {
                                BuildManager.this.notifySessionTerminationIfNeeded(future2.getRequestID(), error);
                            }
                        }
                    });
                }
            }
        });
    }

    @Nullable
    private Pair<RequestFuture<PreloadedProcessMessageHandler>, OSProcessHandler> takePreloadedProcess(String projectPath) {
        Pair<RequestFuture<PreloadedProcessMessageHandler>, OSProcessHandler> result;
        Future<Pair<RequestFuture<PreloadedProcessMessageHandler>, OSProcessHandler>> preloadProgress = this.myPreloadedBuilds.remove(projectPath);
        try {
            result = preloadProgress != null ? preloadProgress.get() : null;
        }
        catch (Throwable e) {
            LOG.info(e);
            result = null;
        }
        return result != null && !((RequestFuture)result.first).isDone() ? result : null;
    }

    @Nullable
    public TaskFuture scheduleBuild(final Project project, final boolean isRebuild, final boolean isMake, final boolean onlyCheckUpToDate, final List<CmdlineRemoteProto.Message.ControllerMessage.ParametersMessage.TargetTypeBuildScope> scopes, final Collection<String> paths, final Map<String, String> userData, final DefaultMessageHandler messageHandler) {
        final String projectPath = BuildManager.getProjectPath(project);
        final boolean isAutomake = messageHandler instanceof AutoMakeMessageHandler;
        final NotifyingMessageHandler handler = new NotifyingMessageHandler(project, messageHandler, isAutomake);
        try {
            this.ensureListening();
        }
        catch (Exception e) {
            UUID sessionId = UUID.randomUUID();
            handler.handleFailure(sessionId, CmdlineProtoUtil.createFailure((String)e.getMessage(), null));
            handler.sessionTerminated(sessionId);
            return null;
        }
        final DelegateFuture _future = new DelegateFuture();
        this.runCommand(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                SequentialTaskExecutor projectTaskQueue;
                CmdlineRemoteProto.Message.ControllerMessage.FSEvent currentFSChanges;
                boolean needRescan;
                UUID sessionId;
                boolean usingPreloadedProcess;
                final Pair preloaded = BuildManager.this.takePreloadedProcess(projectPath);
                RequestFuture preloadedFuture = preloaded != null ? (RequestFuture)preloaded.first : null;
                boolean bl = usingPreloadedProcess = preloadedFuture != null;
                if (usingPreloadedProcess) {
                    LOG.info("Using preloaded build process to compile " + projectPath);
                    sessionId = preloadedFuture.getRequestID();
                    ((PreloadedProcessMessageHandler)preloadedFuture.getMessageHandler()).setDelegateHandler(handler);
                } else {
                    sessionId = UUID.randomUUID();
                }
                final RequestFuture future2 = usingPreloadedProcess ? preloadedFuture : new RequestFuture((Object)handler, sessionId, new CancelBuildSessionAction());
                _future.setDelegate(future2);
                if (!usingPreloadedProcess && (future2.isCancelled() || project.isDisposed())) {
                    handler.sessionTerminated(sessionId);
                    future2.setDone();
                    return;
                }
                CmdlineRemoteProto.Message.ControllerMessage.GlobalSettings globals = CmdlineRemoteProto.Message.ControllerMessage.GlobalSettings.newBuilder().setGlobalOptionsPath(PathManager.getOptionsPath()).build();
                Map map = BuildManager.this.myProjectDataMap;
                synchronized (map) {
                    ProjectData data2 = BuildManager.this.getProjectData(projectPath);
                    if (isRebuild) {
                        data2.dropChanges();
                    }
                    if (BuildManager.this.IS_UNIT_TEST_MODE) {
                        LOG.info("Scheduling build for " + projectPath + "; CHANGED: " + new HashSet(BuildManager.convertToStringPaths(data2.myChanged)) + "; DELETED: " + new HashSet(BuildManager.convertToStringPaths(data2.myDeleted)));
                    }
                    currentFSChanges = (needRescan = data2.getAndResetRescanFlag()) ? null : data2.createNextEvent();
                    projectTaskQueue = data2.taskQueue;
                }
                final CmdlineRemoteProto.Message.ControllerMessage params = isRebuild ? CmdlineProtoUtil.createBuildRequest((String)projectPath, (List)scopes, Collections.emptyList(), (Map)userData, (CmdlineRemoteProto.Message.ControllerMessage.GlobalSettings)globals, null) : (onlyCheckUpToDate ? CmdlineProtoUtil.createUpToDateCheckRequest((String)projectPath, (List)scopes, (Collection)paths, (Map)userData, (CmdlineRemoteProto.Message.ControllerMessage.GlobalSettings)globals, (CmdlineRemoteProto.Message.ControllerMessage.FSEvent)currentFSChanges) : CmdlineProtoUtil.createBuildRequest((String)projectPath, (List)scopes, isMake ? Collections.emptyList() : paths, (Map)userData, (CmdlineRemoteProto.Message.ControllerMessage.GlobalSettings)globals, (CmdlineRemoteProto.Message.ControllerMessage.FSEvent)currentFSChanges));
                if (!usingPreloadedProcess) {
                    BuildManager.this.myMessageDispatcher.registerBuildMessageHandler((RequestFuture<? extends BuilderMessageHandler>)future2, params);
                }
                try {
                    projectTaskQueue.submit(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         * Enabled force condition propagation
                         * Lifted jumps to return sites
                         */
                        @Override
                        public void run() {
                            Throwable execFailure;
                            block17: {
                                execFailure = null;
                                if (!project.isDisposed()) break block17;
                                if (usingPreloadedProcess) {
                                    future2.cancel(false);
                                    break block17;
                                }
                                BuildManager.this.myBuildsInProgress.remove(projectPath);
                                BuildManager.this.notifySessionTerminationIfNeeded(sessionId, execFailure);
                                if (!BuildManager.this.isProcessPreloadingEnabled(project)) return;
                                BuildManager.this.runCommand(new Runnable(){

                                    @Override
                                    public void run() {
                                        if (!BuildManager.this.myPreloadedBuilds.containsKey(projectPath)) {
                                            try {
                                                Future preloadResult = BuildManager.this.launchPreloadedBuildProcess(project, projectTaskQueue);
                                                BuildManager.this.myPreloadedBuilds.put(projectPath, preloadResult);
                                            }
                                            catch (Throwable e) {
                                                LOG.info("Error pre-loading build process for project " + projectPath, e);
                                            }
                                        }
                                    }
                                });
                                return;
                            }
                            try {
                                CharSequence errorsOnLaunch;
                                OSProcessHandler processHandler2;
                                BuildManager.this.myBuildsInProgress.put(projectPath, future2);
                                if (usingPreloadedProcess) {
                                    boolean paramsSent = BuildManager.this.myMessageDispatcher.sendBuildParameters(future2.getRequestID(), params);
                                    if (!paramsSent) {
                                        BuildManager.this.myMessageDispatcher.cancelSession(future2.getRequestID());
                                    }
                                    processHandler2 = (OSProcessHandler)preloaded.second;
                                    errorsOnLaunch = (CharSequence)STDERR_OUTPUT.get((UserDataHolder)processHandler2);
                                } else {
                                    if (isAutomake && needRescan) {
                                        try {
                                            SwingUtilities.invokeAndWait(new Runnable(){

                                                @Override
                                                public void run() {
                                                    project.save();
                                                }
                                            });
                                        }
                                        catch (Throwable e) {
                                            LOG.info(e);
                                        }
                                    }
                                    processHandler2 = BuildManager.this.launchBuildProcess(project, BuildManager.this.myListenPort, sessionId, false);
                                    errorsOnLaunch = new StringBuffer();
                                    processHandler2.addProcessListener((ProcessListener)new StdOutputCollector((StringBuffer)errorsOnLaunch));
                                    processHandler2.startNotify();
                                }
                                Integer debugPort = (Integer)processHandler2.getUserData(COMPILER_PROCESS_DEBUG_PORT);
                                if (debugPort != null) {
                                    String message = "Make: waiting for debugger connection on port " + debugPort;
                                    messageHandler.handleCompileMessage(sessionId, CmdlineProtoUtil.createCompileProgressMessageResponse((String)message).getCompileMessage());
                                }
                                while (!processHandler2.waitFor()) {
                                    LOG.info("processHandler.waitFor() returned false for session " + sessionId + ", continue waiting");
                                }
                                int exitValue = processHandler2.getProcess().exitValue();
                                if (exitValue != 0) {
                                    StringBuilder msg = new StringBuilder();
                                    msg.append("Abnormal build process termination: ");
                                    if (errorsOnLaunch != null && errorsOnLaunch.length() > 0) {
                                        msg.append("\n").append(errorsOnLaunch);
                                    } else {
                                        msg.append("unknown error");
                                    }
                                    handler.handleFailure(sessionId, CmdlineProtoUtil.createFailure((String)msg.toString(), null));
                                }
                                BuildManager.this.myBuildsInProgress.remove(projectPath);
                            }
                            catch (Throwable e) {
                                try {
                                    execFailure = e;
                                    BuildManager.this.myBuildsInProgress.remove(projectPath);
                                }
                                catch (Throwable throwable) {
                                    BuildManager.this.myBuildsInProgress.remove(projectPath);
                                    BuildManager.this.notifySessionTerminationIfNeeded(sessionId, execFailure);
                                    if (!BuildManager.this.isProcessPreloadingEnabled(project)) throw throwable;
                                    BuildManager.this.runCommand(new /* invalid duplicate definition of identical inner class */);
                                    throw throwable;
                                }
                                BuildManager.this.notifySessionTerminationIfNeeded(sessionId, execFailure);
                                if (!BuildManager.this.isProcessPreloadingEnabled(project)) return;
                                BuildManager.this.runCommand(new /* invalid duplicate definition of identical inner class */);
                                return;
                            }
                            BuildManager.this.notifySessionTerminationIfNeeded(sessionId, execFailure);
                            if (!BuildManager.this.isProcessPreloadingEnabled(project)) return;
                            BuildManager.this.runCommand(new /* invalid duplicate definition of identical inner class */);
                            return;
                        }
                    });
                }
                catch (Throwable e) {
                    BuildManager.this.handleProcessExecutionFailure(sessionId, e);
                }
            }
        });
        return _future;
    }

    private boolean isProcessPreloadingEnabled(Project project) {
        if (this.IS_UNIT_TEST_MODE || !Registry.is((String)"compiler.process.preload") || Registry.intValue((String)"compiler.process.debug.port") > 0) {
            return false;
        }
        if (project.isDisposed()) {
            return true;
        }
        for (BuildProcessParametersProvider provider : (BuildProcessParametersProvider[])project.getExtensions(BuildProcessParametersProvider.EP_NAME)) {
            if (provider.isProcessPreloadingEnabled()) continue;
            return false;
        }
        return true;
    }

    private void notifySessionTerminationIfNeeded(UUID sessionId, @Nullable Throwable execFailure) {
        BuilderMessageHandler unregistered;
        if (this.myMessageDispatcher.getAssociatedChannel(sessionId) == null && (unregistered = this.myMessageDispatcher.unregisterBuildMessageHandler(sessionId)) != null) {
            if (execFailure != null) {
                unregistered.handleFailure(sessionId, CmdlineProtoUtil.createFailure((String)execFailure.getMessage(), (Throwable)execFailure));
            }
            unregistered.sessionTerminated(sessionId);
        }
    }

    private void handleProcessExecutionFailure(UUID sessionId, Throwable e) {
        BuilderMessageHandler unregistered = this.myMessageDispatcher.unregisterBuildMessageHandler(sessionId);
        if (unregistered != null) {
            unregistered.handleFailure(sessionId, CmdlineProtoUtil.createFailure((String)e.getMessage(), (Throwable)e));
            unregistered.sessionTerminated(sessionId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    private ProjectData getProjectData(String projectPath) {
        Map<String, ProjectData> map = this.myProjectDataMap;
        // MONITORENTER : map
        ProjectData data2 = this.myProjectDataMap.get(projectPath);
        if (data2 == null) {
            data2 = new ProjectData(new SequentialTaskExecutor((Executor)PooledThreadExecutor.INSTANCE));
            this.myProjectDataMap.put(projectPath, data2);
        }
        ProjectData projectData = data2;
        // MONITOREXIT : map
        if (projectData != null) return projectData;
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/compiler/server/BuildManager", "getProjectData"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureListening() throws Exception {
        if (this.myListenPort < 0) {
            BuildManager buildManager = this;
            synchronized (buildManager) {
                if (this.myListenPort < 0) {
                    this.myListenPort = this.startListening();
                }
            }
        }
    }

    public void dispose() {
        this.stopListening();
    }

    @NotNull
    public static Pair<Sdk, JavaSdkVersion> getBuildProcessRuntimeSdk(Project project) {
        Sdk projectJdk = null;
        int sdkMinorVersion = 0;
        JavaSdkVersion sdkVersion = null;
        LinkedHashSet<Sdk> candidates = new LinkedHashSet<Sdk>();
        Sdk defaultSdk = ProjectRootManager.getInstance((Project)project).getProjectSdk();
        if (defaultSdk != null && defaultSdk.getSdkType() instanceof JavaSdkType) {
            candidates.add(defaultSdk);
        }
        for (Module module : ModuleManager.getInstance((Project)project).getModules()) {
            Sdk sdk = ModuleRootManager.getInstance((Module)module).getSdk();
            if (sdk == null || !(sdk.getSdkType() instanceof JavaSdkType)) continue;
            candidates.add(sdk);
        }
        JavaSdk javaSdkType = JavaSdk.getInstance();
        for (Sdk candidate : candidates) {
            JavaSdkVersion candidateVersion;
            String vs = candidate.getVersionString();
            if (vs == null || (candidateVersion = javaSdkType.getVersion(vs)) == null) continue;
            int candidateMinorVersion = BuildManager.getMinorVersion(vs);
            if (projectJdk == null) {
                sdkVersion = candidateVersion;
                sdkMinorVersion = candidateMinorVersion;
                projectJdk = candidate;
                continue;
            }
            int result = candidateVersion.compareTo((Enum)sdkVersion);
            if (result <= 0 && (result != 0 || candidateMinorVersion <= sdkMinorVersion)) continue;
            sdkVersion = candidateVersion;
            sdkMinorVersion = candidateMinorVersion;
            projectJdk = candidate;
        }
        Sdk internalJdk = JavaAwareProjectJdkTableImpl.getInstanceEx().getInternalJdk();
        if (projectJdk == null || sdkVersion == null || !sdkVersion.isAtLeast(JavaSdkVersion.JDK_1_6)) {
            projectJdk = internalJdk;
            sdkVersion = javaSdkType.getVersion(internalJdk);
        }
        Pair pair = Pair.create((Object)projectJdk, (Object)sdkVersion);
        if (pair == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/compiler/server/BuildManager", "getBuildProcessRuntimeSdk"));
        }
        return pair;
    }

    private Future<Pair<RequestFuture<PreloadedProcessMessageHandler>, OSProcessHandler>> launchPreloadedBuildProcess(final Project project, SequentialTaskExecutor projectTaskQueue) throws Exception {
        this.ensureListening();
        return projectTaskQueue.submit((Callable)new Callable<Pair<RequestFuture<PreloadedProcessMessageHandler>, OSProcessHandler>>(){

            @Override
            public Pair<RequestFuture<PreloadedProcessMessageHandler>, OSProcessHandler> call() throws Exception {
                if (project.isDisposed()) {
                    return null;
                }
                RequestFuture future2 = new RequestFuture((Object)new PreloadedProcessMessageHandler(), UUID.randomUUID(), new CancelBuildSessionAction());
                try {
                    BuildManager.this.myMessageDispatcher.registerBuildMessageHandler((RequestFuture<? extends BuilderMessageHandler>)future2, null);
                    OSProcessHandler processHandler2 = BuildManager.this.launchBuildProcess(project, BuildManager.this.myListenPort, future2.getRequestID(), true);
                    StringBuffer errors = new StringBuffer();
                    processHandler2.addProcessListener((ProcessListener)new StdOutputCollector(errors));
                    STDERR_OUTPUT.set((UserDataHolder)processHandler2, (Object)errors);
                    processHandler2.startNotify();
                    return Pair.create((Object)future2, (Object)processHandler2);
                }
                catch (Throwable e) {
                    BuildManager.this.handleProcessExecutionFailure(future2.getRequestID(), e);
                    throw e instanceof Exception ? (Exception)e : new RuntimeException(e);
                }
            }
        });
    }

    private OSProcessHandler launchBuildProcess(Project project, int port, UUID sessionId, boolean requestProjectPreload) throws com.intellij.execution.ExecutionException {
        String[] propertiesToPass;
        int debugPort;
        String shouldGenerateIndex;
        String additionalOptions;
        String vmExecutablePath;
        String compilerPath;
        JavaSdkVersion sdkVersion = null;
        String forcedCompiledJdkHome = Registry.stringValue((String)COMPILER_PROCESS_JDK_PROPERTY);
        if (StringUtil.isEmptyOrSpaces((String)forcedCompiledJdkHome)) {
            Pair<Sdk, JavaSdkVersion> pair = BuildManager.getBuildProcessRuntimeSdk(project);
            Sdk projectJdk = (Sdk)pair.first;
            sdkVersion = (JavaSdkVersion)pair.second;
            Sdk internalJdk = JavaAwareProjectJdkTableImpl.getInstanceEx().getInternalJdk();
            JavaSdkType projectJdkType = (JavaSdkType)projectJdk.getSdkType();
            if (FileUtil.pathsEqual((String)projectJdk.getHomePath(), (String)internalJdk.getHomePath())) {
                JavaCompiler systemCompiler = ToolProvider.getSystemJavaCompiler();
                if (systemCompiler == null) {
                    throw new com.intellij.execution.ExecutionException("No system java compiler is provided by the JRE. Make sure tools.jar is present in IntelliJ IDEA classpath.");
                }
                compilerPath = ClasspathBootstrap.getResourcePath(systemCompiler.getClass());
            } else {
                compilerPath = projectJdkType.getToolsPath(projectJdk);
                if (compilerPath == null) {
                    throw new com.intellij.execution.ExecutionException("Cannot determine path to 'tools.jar' library for " + projectJdk.getName() + " (" + projectJdk.getHomePath() + ")");
                }
            }
            vmExecutablePath = projectJdkType.getVMExecutablePath(projectJdk);
        } else {
            compilerPath = new File(forcedCompiledJdkHome, "lib/tools.jar").getAbsolutePath();
            vmExecutablePath = new File(forcedCompiledJdkHome, "bin/java").getAbsolutePath();
        }
        CompilerConfiguration projectConfig = CompilerConfiguration.getInstance((Project)project);
        CompilerWorkspaceConfiguration config = CompilerWorkspaceConfiguration.getInstance((Project)project);
        GeneralCommandLine cmdLine = new GeneralCommandLine();
        cmdLine.setExePath(vmExecutablePath);
        boolean isProfilingMode = false;
        String userDefinedHeapSize = null;
        SmartList userAdditionalOptionsList = new SmartList();
        String userAdditionalVMOptions = config.COMPILER_PROCESS_ADDITIONAL_VM_OPTIONS;
        boolean userLocalOptionsActive = !StringUtil.isEmptyOrSpaces((String)userAdditionalVMOptions);
        String string = additionalOptions = userLocalOptionsActive ? userAdditionalVMOptions : projectConfig.getBuildProcessVMOptions();
        if (!StringUtil.isEmptyOrSpaces((String)additionalOptions)) {
            StringTokenizer tokenizer = new StringTokenizer(additionalOptions, " ", false);
            while (tokenizer.hasMoreTokens()) {
                String option = tokenizer.nextToken();
                if (StringUtil.startsWithIgnoreCase((String)option, (String)"-Xmx")) {
                    if (!userLocalOptionsActive) continue;
                    userDefinedHeapSize = option;
                    continue;
                }
                if ("-Dprofiling.mode=true".equals(option)) {
                    isProfilingMode = true;
                }
                userAdditionalOptionsList.add(option);
            }
        }
        if (userDefinedHeapSize != null) {
            cmdLine.addParameter(userDefinedHeapSize);
        } else {
            int heapSize = projectConfig.getBuildProcessHeapSize(JavacConfiguration.getOptions((Project)project, JavacConfiguration.class).MAXIMUM_HEAP_SIZE);
            cmdLine.addParameter("-Xmx" + heapSize + "m");
        }
        if (SystemInfo.isMac && sdkVersion != null && JavaSdkVersion.JDK_1_6.equals((Object)sdkVersion) && Registry.is((String)"compiler.process.32bit.vm.on.mac")) {
            cmdLine.addParameter("-d32");
        }
        cmdLine.addParameter("-Djava.awt.headless=true");
        if (sdkVersion != null && sdkVersion.ordinal() < JavaSdkVersion.JDK_1_9.ordinal()) {
            cmdLine.addParameter("-Djava.endorsed.dirs=\"\"");
        }
        if (this.IS_UNIT_TEST_MODE) {
            cmdLine.addParameter("-Dtest.mode=true");
        }
        cmdLine.addParameter("-Djdt.compiler.useSingleThread=true");
        if (requestProjectPreload) {
            cmdLine.addParameter("-Dpreload.project.path=" + FileUtil.toCanonicalPath((String)BuildManager.getProjectPath(project)));
            cmdLine.addParameter("-Dpreload.config.path=" + FileUtil.toCanonicalPath((String)PathManager.getOptionsPath()));
        }
        if ((shouldGenerateIndex = System.getProperty("generate.classpath.index")) != null) {
            cmdLine.addParameter("-Dgenerate.classpath.index=" + shouldGenerateIndex);
        }
        cmdLine.addParameter("-Dcompile.parallel=" + Boolean.toString(config.PARALLEL_COMPILATION));
        cmdLine.addParameter("-Drebuild.on.dependency.change=" + Boolean.toString(config.REBUILD_ON_DEPENDENCY_CHANGE));
        if (Boolean.TRUE.equals(Boolean.valueOf(System.getProperty("java.net.preferIPv4Stack", "false")))) {
            cmdLine.addParameter("-Djava.net.preferIPv4Stack=true");
        }
        cmdLine.addParameter("-Dio.netty.initialSeedUniquifier=" + ThreadLocalRandom.getInitialSeedUniquifier());
        for (String option : userAdditionalOptionsList) {
            cmdLine.addParameter(option);
        }
        if (isProfilingMode) {
            cmdLine.addParameter("-agentlib:yjpagent=disablealloc,delay=10000,sessionname=ExternalBuild");
        }
        if ((debugPort = Registry.intValue((String)"compiler.process.debug.port")) > 0) {
            cmdLine.addParameter("-XX:+HeapDumpOnOutOfMemoryError");
            cmdLine.addParameter("-agentlib:jdwp=transport=dt_socket,server=y,suspend=y,address=" + debugPort);
        }
        if (!Registry.is((String)"compiler.process.use.memory.temp.cache")) {
            cmdLine.addParameter("-Duse.memory.temp.cache=false");
        }
        cmdLine.setCharset(this.mySystemCharset);
        cmdLine.addParameter("-Dfile.encoding=" + this.mySystemCharset.name());
        cmdLine.addParameter("-Djps.file.types.component.name=" + FileTypeManagerImpl.getFileTypeComponentName());
        for (String name : propertiesToPass = new String[]{"user.language", "user.country", "user.region", "idea.paths.selector", "idea.case.sensitive.fs"}) {
            String value = System.getProperty(name);
            if (value == null) continue;
            cmdLine.addParameter("-D" + name + "=" + value);
        }
        cmdLine.addParameter("-Didea.home.path=" + PathManager.getHomePath());
        cmdLine.addParameter("-Didea.config.path=" + PathManager.getConfigPath());
        cmdLine.addParameter("-Didea.plugins.path=" + PathManager.getPluginsPath());
        cmdLine.addParameter("-Djps.log.dir=" + FileUtil.toSystemIndependentName((String)this.getBuildLogDirectory().getAbsolutePath()));
        File workDirectory = this.getBuildSystemDirectory();
        workDirectory.mkdirs();
        cmdLine.addParameter("-Djava.io.tmpdir=" + FileUtil.toSystemIndependentName((String)workDirectory.getPath()) + "/" + TEMP_DIR_NAME);
        for (BuildProcessParametersProvider provider : (BuildProcessParametersProvider[])project.getExtensions(BuildProcessParametersProvider.EP_NAME)) {
            List<String> args = provider.getVMArguments();
            cmdLine.addParameters(args);
        }
        Class<Launcher> launcherClass = Launcher.class;
        ArrayList<String> launcherCp = new ArrayList<String>();
        launcherCp.add(ClasspathBootstrap.getResourcePath(launcherClass));
        launcherCp.add(compilerPath);
        ClasspathBootstrap.appendJavaCompilerClasspath(launcherCp);
        launcherCp.addAll(BuildProcessClasspathManager.getLauncherClasspath(project));
        cmdLine.addParameter("-classpath");
        cmdLine.addParameter(BuildManager.classpathToString(launcherCp));
        cmdLine.addParameter(launcherClass.getName());
        List cp = ClasspathBootstrap.getBuildProcessApplicationClasspath((boolean)true);
        cp.addAll(this.myClasspathManager.getBuildProcessPluginsClasspath(project));
        if (isProfilingMode) {
            cp.add(new File(workDirectory, "yjp-controller-api-redist.jar").getPath());
        }
        cmdLine.addParameter(BuildManager.classpathToString(cp));
        cmdLine.addParameter(BuildMain.class.getName());
        cmdLine.addParameter(Boolean.valueOf(System.getProperty("java.net.preferIPv6Addresses", "false")) != false ? "::1" : "127.0.0.1");
        cmdLine.addParameter(Integer.toString(port));
        cmdLine.addParameter(sessionId.toString());
        cmdLine.addParameter(FileUtil.toSystemIndependentName((String)workDirectory.getPath()));
        cmdLine.setWorkDirectory(workDirectory);
        try {
            ((BuildManagerListener)ApplicationManager.getApplication().getMessageBus().syncPublisher(BuildManagerListener.TOPIC)).beforeBuildProcessStarted(project, sessionId);
        }
        catch (Throwable e) {
            LOG.error(e);
        }
        Process process = cmdLine.createProcess();
        OSProcessHandler processHandler2 = new OSProcessHandler(process, null, this.mySystemCharset){

            protected boolean shouldDestroyProcessRecursively() {
                return true;
            }

            protected boolean useNonBlockingRead() {
                return false;
            }
        };
        processHandler2.addProcessListener((ProcessListener)new ProcessAdapter(){

            public void onTextAvailable(ProcessEvent event, Key outputType) {
                String text = event.getText();
                if (!StringUtil.isEmptyOrSpaces((String)text)) {
                    LOG.info("BUILDER_PROCESS [" + outputType.toString() + "]: " + text.trim());
                }
            }
        });
        if (debugPort > 0) {
            processHandler2.putUserData(COMPILER_PROCESS_DEBUG_PORT, (Object)debugPort);
        }
        return processHandler2;
    }

    public File getBuildSystemDirectory() {
        return new File(this.mySystemDirectory, SYSTEM_ROOT);
    }

    public File getBuildLogDirectory() {
        return new File(PathManager.getLogPath(), "build-log");
    }

    @Nullable
    public File getProjectSystemDirectory(Project project) {
        String projectPath = BuildManager.getProjectPath(project);
        return projectPath != null ? Utils.getDataStorageRoot((File)this.getBuildSystemDirectory(), (String)projectPath) : null;
    }

    private static File getUsageFile(@NotNull File projectSystemDir) {
        if (projectSystemDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectSystemDir", "com/intellij/compiler/server/BuildManager", "getUsageFile"));
        }
        return new File(projectSystemDir, "ustamp");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void updateUsageFile(@Nullable Project project, @NotNull File projectSystemDir) {
        if (projectSystemDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectSystemDir", "com/intellij/compiler/server/BuildManager", "updateUsageFile"));
        }
        File usageFile = BuildManager.getUsageFile(projectSystemDir);
        StringBuilder content = new StringBuilder();
        try {
            String projectFilePath;
            SimpleDateFormat simpleDateFormat = USAGE_STAMP_DATE_FORMAT;
            synchronized (simpleDateFormat) {
                content.append(USAGE_STAMP_DATE_FORMAT.format(System.currentTimeMillis()));
            }
            if (project != null && !project.isDisposed() && !StringUtil.isEmptyOrSpaces((String)(projectFilePath = project.getProjectFilePath()))) {
                content.append("\n").append(FileUtil.toCanonicalPath((String)projectFilePath));
            }
            FileUtil.writeToFile((File)usageFile, (String)content.toString());
        }
        catch (Throwable e) {
            LOG.info(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private static Pair<Date, File> readUsageFile(File usageFile) {
        block5: {
            try {
                Date date;
                List lines = FileUtil.loadLines((File)usageFile, (String)CharsetToolkit.UTF8_CHARSET.name());
                if (lines.isEmpty()) break block5;
                String dateString = (String)lines.get(0);
                SimpleDateFormat simpleDateFormat = USAGE_STAMP_DATE_FORMAT;
                synchronized (simpleDateFormat) {
                    date = USAGE_STAMP_DATE_FORMAT.parse(dateString);
                }
                File projectFile = lines.size() > 1 ? new File((String)lines.get(1)) : null;
                return Pair.create((Object)date, (Object)projectFile);
            }
            catch (Throwable e) {
                LOG.info(e);
            }
        }
        return null;
    }

    private static int getMinorVersion(String vs) {
        int dashIndex = vs.lastIndexOf(95);
        if (dashIndex >= 0) {
            char ch;
            StringBuilder builder = new StringBuilder();
            for (int idx = dashIndex + 1; idx < vs.length() && Character.isDigit(ch = vs.charAt(idx)); ++idx) {
                builder.append(ch);
            }
            if (builder.length() > 0) {
                try {
                    return Integer.parseInt(builder.toString());
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        return 0;
    }

    public void stopListening() {
        this.myChannelRegistrar.close();
    }

    private int startListening() throws Exception {
        ServerBootstrap bootstrap = NettyUtil.nioServerBootstrap((EventLoopGroup)new NioEventLoopGroup(1, (Executor)PooledThreadExecutor.INSTANCE));
        bootstrap.childHandler((ChannelHandler)new ChannelInitializer(){

            protected void initChannel(Channel channel) throws Exception {
                channel.pipeline().addLast(new ChannelHandler[]{BuildManager.this.myChannelRegistrar, new ProtobufVarint32FrameDecoder(), new ProtobufDecoder((MessageLite)CmdlineRemoteProto.Message.getDefaultInstance()), new ProtobufVarint32LengthFieldPrepender(), new ProtobufEncoder(), BuildManager.this.myMessageDispatcher});
            }
        });
        Channel serverChannel = bootstrap.bind(NetUtils.getLoopbackAddress(), 0).syncUninterruptibly().channel();
        this.myChannelRegistrar.add(serverChannel);
        return ((InetSocketAddress)serverChannel.localAddress()).getPort();
    }

    private static String classpathToString(List<String> cp) {
        StringBuilder builder = new StringBuilder();
        for (String file : cp) {
            if (builder.length() > 0) {
                builder.append(File.pathSeparator);
            }
            builder.append(FileUtil.toCanonicalPath((String)file));
        }
        return builder.toString();
    }

    private class CancelBuildSessionAction<T extends BuilderMessageHandler>
    implements RequestFuture.CancelAction<T> {
        private CancelBuildSessionAction() {
        }

        public void cancel(RequestFuture<T> future2) throws Exception {
            BuildManager.this.myMessageDispatcher.cancelSession(future2.getRequestID());
        }
    }

    private static final class DelegateFuture<T>
    implements TaskFuture<T> {
        @Nullable
        private TaskFuture<? extends T> myDelegate;
        private Boolean myRequestedCancelState = null;

        private DelegateFuture() {
        }

        @NotNull
        public synchronized TaskFuture<? extends T> getDelegate() {
            TaskFuture<? extends T> delegate = this.myDelegate;
            while (delegate == null) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                delegate = this.myDelegate;
            }
            TaskFuture<? extends T> taskFuture = delegate;
            if (taskFuture == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/compiler/server/BuildManager$DelegateFuture", "getDelegate"));
            }
            return taskFuture;
        }

        public synchronized boolean setDelegate(@NotNull TaskFuture<? extends T> delegate) {
            if (delegate == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delegate", "com/intellij/compiler/server/BuildManager$DelegateFuture", "setDelegate"));
            }
            if (this.myDelegate == null) {
                try {
                    this.myDelegate = delegate;
                    if (this.myRequestedCancelState != null) {
                        this.myDelegate.cancel(this.myRequestedCancelState.booleanValue());
                    }
                }
                finally {
                    this.notifyAll();
                }
                return true;
            }
            return false;
        }

        public synchronized boolean cancel(boolean mayInterruptIfRunning) {
            TaskFuture<? extends T> delegate = this.myDelegate;
            if (delegate == null) {
                this.myRequestedCancelState = mayInterruptIfRunning;
                return true;
            }
            return delegate.cancel(mayInterruptIfRunning);
        }

        public void waitFor() {
            this.getDelegate().waitFor();
        }

        public boolean waitFor(long timeout, TimeUnit unit) {
            return this.getDelegate().waitFor(timeout, unit);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isCancelled() {
            TaskFuture<? extends T> delegate;
            DelegateFuture delegateFuture = this;
            synchronized (delegateFuture) {
                delegate = this.myDelegate;
                if (delegate == null) {
                    return this.myRequestedCancelState != null;
                }
            }
            return delegate.isCancelled();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isDone() {
            TaskFuture<? extends T> delegate;
            DelegateFuture delegateFuture = this;
            synchronized (delegateFuture) {
                delegate = this.myDelegate;
                if (delegate == null) {
                    return false;
                }
            }
            return delegate.isDone();
        }

        public T get() throws InterruptedException, ExecutionException {
            return (T)this.getDelegate().get();
        }

        public T get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            return (T)this.getDelegate().get(timeout, unit);
        }
    }

    private static class XInternedPath
    extends InternedPath {
        private XInternedPath(String path) {
            super(path);
        }

        @Override
        public String getValue() {
            if (this.myPath.length > 0) {
                StringBuilder buf = new StringBuilder();
                for (int element : this.myPath) {
                    buf.append("/").append(FileNameCache.getVFileName(element));
                }
                return buf.toString();
            }
            return "/";
        }
    }

    private static class WinInternedPath
    extends InternedPath {
        private WinInternedPath(String path) {
            super(path);
        }

        @Override
        public String getValue() {
            if (this.myPath.length == 1) {
                String name = FileNameCache.getVFileName(this.myPath[0]).toString();
                return name.length() == 2 && name.endsWith(":") ? name + "/" : name;
            }
            StringBuilder buf = new StringBuilder();
            for (int element : this.myPath) {
                if (buf.length() > 0) {
                    buf.append("/");
                }
                buf.append(FileNameCache.getVFileName(element));
            }
            return buf.toString();
        }
    }

    private static abstract class InternedPath {
        protected final int[] myPath;

        protected InternedPath(String path) {
            IntArrayList list = new IntArrayList();
            StringTokenizer tokenizer = new StringTokenizer(path, "/", false);
            while (tokenizer.hasMoreTokens()) {
                String element = tokenizer.nextToken();
                list.add(FileNameCache.storeName(element));
            }
            this.myPath = list.toArray();
        }

        public abstract String getValue();

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            InternedPath path = (InternedPath)o;
            return Arrays.equals(this.myPath, path.myPath);
        }

        public int hashCode() {
            return Arrays.hashCode(this.myPath);
        }

        public static InternedPath create(String path) {
            return path.startsWith("/") ? new XInternedPath(path) : new WinInternedPath(path);
        }
    }

    private static class ProjectData {
        @NotNull
        final SequentialTaskExecutor taskQueue;
        private final Set<InternedPath> myChanged;
        private final Set<InternedPath> myDeleted;
        private long myNextEventOrdinal;
        private boolean myNeedRescan;

        private ProjectData(@NotNull SequentialTaskExecutor taskQueue) {
            if (taskQueue == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "taskQueue", "com/intellij/compiler/server/BuildManager$ProjectData", "<init>"));
            }
            this.myChanged = new THashSet();
            this.myDeleted = new THashSet();
            this.myNextEventOrdinal = 0L;
            this.myNeedRescan = true;
            this.taskQueue = taskQueue;
        }

        public void addChanged(Collection<String> paths) {
            if (!this.myNeedRescan) {
                for (String path : paths) {
                    InternedPath _path = InternedPath.create(path);
                    this.myDeleted.remove(_path);
                    this.myChanged.add(_path);
                }
            }
        }

        public void addDeleted(Collection<String> paths) {
            if (!this.myNeedRescan) {
                for (String path : paths) {
                    InternedPath _path = InternedPath.create(path);
                    this.myChanged.remove(_path);
                    this.myDeleted.add(_path);
                }
            }
        }

        public CmdlineRemoteProto.Message.ControllerMessage.FSEvent createNextEvent() {
            CmdlineRemoteProto.Message.ControllerMessage.FSEvent.Builder builder = CmdlineRemoteProto.Message.ControllerMessage.FSEvent.newBuilder();
            builder.setOrdinal(++this.myNextEventOrdinal);
            for (InternedPath path : this.myChanged) {
                builder.addChangedPaths(path.getValue());
            }
            this.myChanged.clear();
            for (InternedPath path : this.myDeleted) {
                builder.addDeletedPaths(path.getValue());
            }
            this.myDeleted.clear();
            return builder.build();
        }

        public boolean getAndResetRescanFlag() {
            boolean rescan = this.myNeedRescan;
            this.myNeedRescan = false;
            return rescan;
        }

        public void dropChanges() {
            this.myNeedRescan = true;
            this.myNextEventOrdinal = 0L;
            this.myChanged.clear();
            this.myDeleted.clear();
        }
    }

    private class ProjectWatcher
    extends ProjectManagerAdapter {
        private final Map<Project, MessageBusConnection> myConnections = new HashMap<Project, MessageBusConnection>();

        private ProjectWatcher() {
        }

        public void projectOpened(final Project project) {
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                return;
            }
            MessageBusConnection conn = project.getMessageBus().connect();
            this.myConnections.put(project, conn);
            conn.subscribe(ProjectTopics.PROJECT_ROOTS, (Object)new ModuleRootAdapter(){

                public void rootsChanged(ModuleRootEvent event) {
                    Object source = event.getSource();
                    if (source instanceof Project) {
                        BuildManager.this.clearState((Project)source);
                    }
                }
            });
            conn.subscribe(ExecutionManager.EXECUTION_TOPIC, (Object)new ExecutionAdapter(){

                public void processTerminated(@NotNull RunProfile runProfile, @NotNull ProcessHandler handler) {
                    if (runProfile == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runProfile", "com/intellij/compiler/server/BuildManager$ProjectWatcher$2", "processTerminated"));
                    }
                    if (handler == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "handler", "com/intellij/compiler/server/BuildManager$ProjectWatcher$2", "processTerminated"));
                    }
                    BuildManager.this.scheduleAutoMake();
                }
            });
            conn.subscribe(CompilerTopics.COMPILATION_STATUS, (Object)new CompilationStatusListener(){
                private final Set<String> myRootsToRefresh = new THashSet(FileUtil.PATH_HASHING_STRATEGY);

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void compilationFinished(boolean aborted, int errors, int warnings, CompileContext compileContext) {
                    String[] roots;
                    Set<String> set = this.myRootsToRefresh;
                    synchronized (set) {
                        roots = ArrayUtil.toStringArray(this.myRootsToRefresh);
                        this.myRootsToRefresh.clear();
                    }
                    if (roots.length != 0) {
                        ApplicationManager.getApplication().executeOnPooledThread(new Runnable(){

                            @Override
                            public void run() {
                                if (project.isDisposed()) {
                                    return;
                                }
                                final ArrayList<File> rootFiles = new ArrayList<File>(roots.length);
                                for (String root : roots) {
                                    rootFiles.add(new File(root));
                                }
                                CompilerUtil.refreshOutputDirectories(rootFiles, false);
                                final LocalFileSystem lfs = LocalFileSystem.getInstance();
                                final HashSet filesToRefresh = new HashSet();
                                ApplicationManager.getApplication().runReadAction(new Runnable(){

                                    @Override
                                    public void run() {
                                        if (project.isDisposed()) {
                                            return;
                                        }
                                        ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)project).getFileIndex();
                                        for (File root : rootFiles) {
                                            VirtualFile rootFile = lfs.findFileByIoFile(root);
                                            if (rootFile == null || !fileIndex.isInSourceContent(rootFile)) continue;
                                            filesToRefresh.add(rootFile);
                                        }
                                        if (!filesToRefresh.isEmpty()) {
                                            lfs.refreshFiles((Iterable)filesToRefresh, true, true, null);
                                        }
                                    }
                                });
                            }
                        });
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void fileGenerated(String outputRoot, String relativePath) {
                    Set<String> set = this.myRootsToRefresh;
                    synchronized (set) {
                        this.myRootsToRefresh.add(outputRoot);
                    }
                }
            });
            final String projectPath = BuildManager.getProjectPath(project);
            Disposer.register((Disposable)project, (Disposable)new Disposable(){

                public void dispose() {
                    BuildManager.this.cancelPreloadedBuilds(projectPath);
                    BuildManager.this.myProjectDataMap.remove(projectPath);
                }
            });
            StartupManager.getInstance((Project)project).registerPostStartupActivity(new Runnable(){

                @Override
                public void run() {
                    BuildManager.this.runCommand(new Runnable(){

                        @Override
                        public void run() {
                            File projectSystemDir = BuildManager.this.getProjectSystemDirectory(project);
                            if (projectSystemDir != null) {
                                BuildManager.updateUsageFile(project, projectSystemDir);
                            }
                        }
                    });
                    BuildManager.this.scheduleAutoMake();
                }
            });
        }

        public boolean canCloseProject(Project project) {
            BuildManager.this.cancelAutoMakeTasks(project);
            return super.canCloseProject(project);
        }

        public void projectClosing(Project project) {
            BuildManager.this.cancelPreloadedBuilds(BuildManager.getProjectPath(project));
            for (TaskFuture future2 : BuildManager.this.cancelAutoMakeTasks(project)) {
                future2.waitFor(500L, TimeUnit.MILLISECONDS);
            }
        }

        public void projectClosed(Project project) {
            BuildManager.this.myProjectDataMap.remove(BuildManager.getProjectPath(project));
            MessageBusConnection conn = this.myConnections.remove(project);
            if (conn != null) {
                conn.disconnect();
            }
        }
    }

    private static final class StdOutputCollector
    extends ProcessAdapter {
        private final Appendable myOutput;
        private int myStoredLength = 0;

        public StdOutputCollector(Appendable outputSink) {
            this.myOutput = outputSink;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onTextAvailable(ProcessEvent event, Key outputType) {
            String text;
            StdOutputCollector stdOutputCollector = this;
            synchronized (stdOutputCollector) {
                if (this.myStoredLength > 2048) {
                    return;
                }
                text = event.getText();
                if (StringUtil.isEmptyOrSpaces((String)text)) {
                    return;
                }
                this.myStoredLength += text.length();
            }
            try {
                this.myOutput.append(text);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private static class NotifyingMessageHandler
    extends DelegatingMessageHandler {
        private final Project myProject;
        private final BuilderMessageHandler myDelegateHandler;
        private boolean myIsAutomake;

        public NotifyingMessageHandler(@NotNull Project project, @NotNull BuilderMessageHandler delegateHandler, boolean isAutomake) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/compiler/server/BuildManager$NotifyingMessageHandler", "<init>"));
            }
            if (delegateHandler == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delegateHandler", "com/intellij/compiler/server/BuildManager$NotifyingMessageHandler", "<init>"));
            }
            this.myProject = project;
            this.myDelegateHandler = delegateHandler;
            this.myIsAutomake = isAutomake;
        }

        @Override
        protected BuilderMessageHandler getDelegateHandler() {
            return this.myDelegateHandler;
        }

        @Override
        public void buildStarted(UUID sessionId) {
            super.buildStarted(sessionId);
            try {
                ((BuildManagerListener)ApplicationManager.getApplication().getMessageBus().syncPublisher(BuildManagerListener.TOPIC)).buildStarted(this.myProject, sessionId, this.myIsAutomake);
            }
            catch (Throwable e) {
                LOG.error(e);
            }
        }

        @Override
        public void sessionTerminated(UUID sessionId) {
            try {
                super.sessionTerminated(sessionId);
            }
            finally {
                try {
                    ((BuildManagerListener)ApplicationManager.getApplication().getMessageBus().syncPublisher(BuildManagerListener.TOPIC)).buildFinished(this.myProject, sessionId, this.myIsAutomake);
                }
                catch (Throwable e) {
                    LOG.error(e);
                }
            }
        }
    }

    private static abstract class BuildManagerPeriodicTask
    implements Runnable {
        private final Alarm myAlarm = new Alarm(Alarm.ThreadToUse.SHARED_THREAD);
        private final AtomicBoolean myInProgress = new AtomicBoolean(false);
        private final Runnable myTaskRunnable = new Runnable(){

            @Override
            public void run() {
                try {
                    BuildManagerPeriodicTask.this.runTask();
                }
                finally {
                    BuildManagerPeriodicTask.this.myInProgress.set(false);
                }
            }
        };

        private BuildManagerPeriodicTask() {
        }

        public final void schedule() {
            this.myAlarm.cancelAllRequests();
            int delay = Math.max(100, this.getDelay());
            this.myAlarm.addRequest((Runnable)this, delay);
        }

        protected abstract int getDelay();

        protected abstract void runTask();

        @Override
        public final void run() {
            if (!HeavyProcessLatch.INSTANCE.isRunning() && !this.myInProgress.getAndSet(true)) {
                try {
                    ApplicationManager.getApplication().executeOnPooledThread(this.myTaskRunnable);
                }
                catch (RejectedExecutionException ignored) {
                    this.myInProgress.set(false);
                }
                catch (Throwable e) {
                    this.myInProgress.set(false);
                    throw new RuntimeException(e);
                }
            } else {
                this.schedule();
            }
        }
    }
}

