/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.configurationStore;

import com.intellij.configurationStore.ConfigurationStorePackage$ComponentStoreImpl$a3cfa0d6;
import com.intellij.configurationStore.ConfigurationStorePackage$FileBasedStorage$61c734d6;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.components.StateStorage;
import com.intellij.openapi.components.StoragePathMacros;
import com.intellij.openapi.components.impl.stores.StorageUtil;
import com.intellij.openapi.components.store.ReadOnlyModificationException;
import com.intellij.openapi.fileEditor.impl.LoadTextUtil;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.io.BufferExposingByteArrayOutputStream;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.LineSeparator;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.OutputStream;
import jet.runtime.typeinfo.JetValueParameter;
import kotlin.CharIterator;
import kotlin.KotlinPackage;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinSyntheticClass;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jdom.Element;
import org.jdom.Parent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@KotlinSyntheticClass(abiVersion=23, kind=KotlinSyntheticClass.Kind.PACKAGE_PART)
public final class ConfigurationStorePackage$FileBasedStorage$61c734d6 {
    @NotNull
    static final byte[] XML_PROLOG = KotlinPackage.toByteArray$default((String)"<?xml version=\"1.0\" encoding=\"UTF-8\"?>", null, (int)1);

    @NotNull
    public static final VirtualFile writeFile(@JetValueParameter(name="file", type="?") @Nullable File file, @JetValueParameter(name="requestor") @NotNull Object requestor, @JetValueParameter(name="virtualFile", type="?") @Nullable VirtualFile virtualFile, @JetValueParameter(name="element") @NotNull Element element, @JetValueParameter(name="lineSeparator") @NotNull LineSeparator lineSeparator, @JetValueParameter(name="prependXmlProlog") boolean prependXmlProlog) {
        VirtualFile virtualFile2;
        Intrinsics.checkParameterIsNotNull((Object)requestor, (String)"requestor");
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        Intrinsics.checkParameterIsNotNull((Object)lineSeparator, (String)"lineSeparator");
        if (!(file == null || virtualFile != null && virtualFile.isValid())) {
            virtualFile2 = StorageUtil.getOrCreateVirtualFile(requestor, file);
        } else {
            virtualFile2 = virtualFile;
            if (virtualFile2 == null) {
                Intrinsics.throwNpe();
            }
        }
        VirtualFile result = virtualFile2;
        if (ConfigurationStorePackage$ComponentStoreImpl$a3cfa0d6.LOG.isDebugEnabled() || ApplicationManager.getApplication().isUnitTestMode()) {
            Parent parent = (Parent)element;
            String string = lineSeparator.getSeparatorString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"lineSeparator.getSeparatorString()");
            BufferExposingByteArrayOutputStream content = ConfigurationStorePackage$FileBasedStorage$61c734d6.toBufferExposingByteArray(parent, string);
            VirtualFile virtualFile3 = result;
            Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile3, (String)"result");
            if (ConfigurationStorePackage$FileBasedStorage$61c734d6.isEqualContent(virtualFile3, lineSeparator, content, prependXmlProlog)) {
                throw (Throwable)new IllegalStateException("Content equals, but it must be handled not on this level: " + result.getName());
            }
            if (StorageUtil.DEBUG_LOG != null && ApplicationManager.getApplication().isUnitTestMode()) {
                StorageUtil.DEBUG_LOG = result.getPath() + ":" + "\n" + content + "\n" + "Old Content:" + "\n" + LoadTextUtil.loadText(result) + "\n" + "---------";
            }
        }
        VirtualFile virtualFile4 = result;
        Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile4, (String)"result");
        ConfigurationStorePackage$FileBasedStorage$61c734d6.doWrite(requestor, virtualFile4, element, lineSeparator, prependXmlProlog);
        VirtualFile virtualFile5 = result;
        Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile5, (String)"result");
        return virtualFile5;
    }

    @NotNull
    public static final byte[] getXML_PROLOG() {
        return XML_PROLOG;
    }

    /*
     * WARNING - void declaration
     */
    public static final boolean isEqualContent(@JetValueParameter(name="result") @NotNull VirtualFile result, @JetValueParameter(name="lineSeparator") @NotNull LineSeparator lineSeparator, @JetValueParameter(name="content") @NotNull BufferExposingByteArrayOutputStream content, @JetValueParameter(name="prependXmlProlog") boolean prependXmlProlog) {
        int headerLength;
        Intrinsics.checkParameterIsNotNull((Object)result, (String)"result");
        Intrinsics.checkParameterIsNotNull((Object)lineSeparator, (String)"lineSeparator");
        Intrinsics.checkParameterIsNotNull((Object)content, (String)"content");
        int n = headerLength = !prependXmlProlog ? 0 : XML_PROLOG.length + lineSeparator.getSeparatorBytes().length;
        if ((int)result.getLength() != headerLength + content.size()) {
            return false;
        }
        byte[] oldContent = result.contentsToByteArray();
        if (!(!prependXmlProlog || ArrayUtil.startsWith((byte[])oldContent, (byte[])XML_PROLOG) && ArrayUtil.startsWith((byte[])oldContent, (int)XML_PROLOG.length, (byte[])lineSeparator.getSeparatorBytes()))) {
            return false;
        }
        int n2 = headerLength;
        int n3 = oldContent.length - 1;
        if (n2 <= n3) {
            while (true) {
                void i;
                if (oldContent[i] != content.getInternalBuffer()[i - headerLength]) {
                    return false;
                }
                if (i == n3) break;
                ++i;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void doWrite(@JetValueParameter(name="requestor") @NotNull Object requestor, @JetValueParameter(name="file") @NotNull VirtualFile file, @JetValueParameter(name="content") @NotNull Object content, @JetValueParameter(name="lineSeparator") @NotNull LineSeparator lineSeparator, @JetValueParameter(name="prependXmlProlog") boolean prependXmlProlog) {
        Intrinsics.checkParameterIsNotNull((Object)requestor, (String)"requestor");
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        Intrinsics.checkParameterIsNotNull((Object)content, (String)"content");
        Intrinsics.checkParameterIsNotNull((Object)lineSeparator, (String)"lineSeparator");
        if (ConfigurationStorePackage$ComponentStoreImpl$a3cfa0d6.LOG.isDebugEnabled()) {
            ConfigurationStorePackage$ComponentStoreImpl$a3cfa0d6.LOG.debug("Save " + file.getPresentableUrl());
        }
        AccessToken token = WriteAction.start();
        try {
            OutputStream out = file.getOutputStream(requestor);
            try {
                if (prependXmlProlog) {
                    out.write(XML_PROLOG);
                    out.write(lineSeparator.getSeparatorBytes());
                }
                if (content instanceof Element) {
                    JDOMUtil.writeParent((Parent)((Parent)content), (OutputStream)out, (String)lineSeparator.getSeparatorString());
                } else {
                    Object object = content;
                    if (object == null) {
                        throw new TypeCastException("kotlin.Any cannot be cast to com.intellij.openapi.util.io.BufferExposingByteArrayOutputStream");
                    }
                    ((BufferExposingByteArrayOutputStream)object).writeTo(out);
                }
            }
            finally {
                out.close();
            }
        }
        catch (FileNotFoundException e) {
            BufferExposingByteArrayOutputStream bufferExposingByteArrayOutputStream;
            if (content instanceof Element) {
                Parent parent = (Parent)content;
                String string = lineSeparator.getSeparatorString();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"lineSeparator.getSeparatorString()");
                bufferExposingByteArrayOutputStream = ConfigurationStorePackage$FileBasedStorage$61c734d6.toBufferExposingByteArray(parent, string);
            } else {
                Object object = content;
                if (object == null) {
                    throw new TypeCastException("kotlin.Any cannot be cast to com.intellij.openapi.util.io.BufferExposingByteArrayOutputStream");
                }
                bufferExposingByteArrayOutputStream = (BufferExposingByteArrayOutputStream)object;
            }
            BufferExposingByteArrayOutputStream byteArray = bufferExposingByteArrayOutputStream;
            throw (Throwable)new ReadOnlyModificationException(file, e, new StateStorage.SaveSession(requestor, file, byteArray, lineSeparator, prependXmlProlog){
                public static final /* synthetic */ KClass $kotlinClass;
                final /* synthetic */ Object $requestor;
                final /* synthetic */ VirtualFile $file;
                final /* synthetic */ BufferExposingByteArrayOutputStream $byteArray;
                final /* synthetic */ LineSeparator $lineSeparator;
                final /* synthetic */ boolean $prependXmlProlog;

                static {
                    $kotlinClass = Reflection.createKotlinClass(doWrite.1.class);
                }

                public void save() {
                    ConfigurationStorePackage$FileBasedStorage$61c734d6.doWrite(this.$requestor, this.$file, this.$byteArray, this.$lineSeparator, this.$prependXmlProlog);
                }
                {
                    this.$requestor = $captured_local_variable$0;
                    this.$file = $captured_local_variable$1;
                    this.$byteArray = $captured_local_variable$2;
                    this.$lineSeparator = $captured_local_variable$3;
                    this.$prependXmlProlog = $captured_local_variable$4;
                }
            });
        }
        finally {
            token.finish();
        }
    }

    @NotNull
    public static final BufferExposingByteArrayOutputStream toBufferExposingByteArray(@JetValueParameter(name="$receiver") Parent $receiver, @JetValueParameter(name="lineSeparator") @NotNull String lineSeparator) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)lineSeparator, (String)"lineSeparator");
        BufferExposingByteArrayOutputStream out = new BufferExposingByteArrayOutputStream(512);
        JDOMUtil.writeParent((Parent)$receiver, (OutputStream)((OutputStream)out), (String)lineSeparator);
        return out;
    }

    @NotNull
    public static /* synthetic */ BufferExposingByteArrayOutputStream toBufferExposingByteArray$default(Parent parent, String string, int n) {
        if ((n & 1) != 0) {
            string = "\n";
        }
        return ConfigurationStorePackage$FileBasedStorage$61c734d6.toBufferExposingByteArray(parent, string);
    }

    public static final boolean isProjectOrModuleFile(@JetValueParameter(name="fileSpec") @NotNull String fileSpec) {
        Intrinsics.checkParameterIsNotNull((Object)fileSpec, (String)"fileSpec");
        return Intrinsics.areEqual((Object)StoragePathMacros.PROJECT_FILE, (Object)fileSpec) || KotlinPackage.startsWith$default((String)fileSpec, (String)StoragePathMacros.PROJECT_CONFIG_DIR, (boolean)false, (int)2) || Intrinsics.areEqual((Object)fileSpec, (Object)StoragePathMacros.MODULE_FILE);
    }

    @NotNull
    public static final LineSeparator detectLineSeparators(@JetValueParameter(name="chars") @NotNull CharSequence chars, @JetValueParameter(name="defaultSeparator", type="?") @Nullable LineSeparator defaultSeparator) {
        Intrinsics.checkParameterIsNotNull((Object)chars, (String)"chars");
        CharIterator charIterator = KotlinPackage.iterator((CharSequence)chars);
        while (charIterator.hasNext()) {
            char c = charIterator.nextChar();
            if (c == '\r') {
                return LineSeparator.CRLF;
            }
            if (c != '\n') continue;
            return LineSeparator.LF;
        }
        LineSeparator lineSeparator = defaultSeparator;
        if (lineSeparator == null) {
            lineSeparator = LineSeparator.getSystemLineSeparator();
        }
        return lineSeparator;
    }

    public static final void deleteFile(@JetValueParameter(name="file") @NotNull File file, @JetValueParameter(name="requestor") @NotNull Object requestor, @JetValueParameter(name="virtualFile", type="?") @Nullable VirtualFile virtualFile) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        Intrinsics.checkParameterIsNotNull((Object)requestor, (String)"requestor");
        if (virtualFile == null) {
            ConfigurationStorePackage$ComponentStoreImpl$a3cfa0d6.LOG.warn("Cannot find virtual file " + file.getAbsolutePath());
        }
        if (virtualFile == null) {
            if (file.exists()) {
                FileUtil.delete((File)file);
            }
        } else if (virtualFile.exists()) {
            try {
                ConfigurationStorePackage$FileBasedStorage$61c734d6.deleteFile(requestor, virtualFile);
            }
            catch (FileNotFoundException e) {
                throw (Throwable)new ReadOnlyModificationException(virtualFile, e, new StateStorage.SaveSession(requestor, virtualFile){
                    public static final /* synthetic */ KClass $kotlinClass;
                    final /* synthetic */ Object $requestor;
                    final /* synthetic */ VirtualFile $virtualFile;

                    static {
                        $kotlinClass = Reflection.createKotlinClass(deleteFile.1.class);
                    }

                    public void save() {
                        ConfigurationStorePackage$FileBasedStorage$61c734d6.deleteFile(this.$requestor, this.$virtualFile);
                    }
                    {
                        this.$requestor = $captured_local_variable$0;
                        this.$virtualFile = $captured_local_variable$1;
                    }
                });
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void deleteFile(@JetValueParameter(name="requestor") @NotNull Object requestor, @JetValueParameter(name="virtualFile") @NotNull VirtualFile virtualFile) {
        Intrinsics.checkParameterIsNotNull((Object)requestor, (String)"requestor");
        Intrinsics.checkParameterIsNotNull((Object)virtualFile, (String)"virtualFile");
        AccessToken token = WriteAction.start();
        try {
            virtualFile.delete(requestor);
            Unit unit = Unit.INSTANCE$;
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        finally {
            token.finish();
        }
    }
}

