/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.configurationStore;

import com.intellij.configurationStore.ComponentStoreImpl;
import com.intellij.configurationStore.ConfigurationStorePackage$ComponentStoreImpl$a3cfa0d6;
import com.intellij.configurationStore.ReloadComponentStoreStatus;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.components.StateStorage;
import com.intellij.openapi.components.impl.stores.IComponentStore;
import com.intellij.openapi.components.impl.stores.IProjectStore;
import com.intellij.openapi.components.impl.stores.StateStorageBase;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.ui.Messages;
import java.util.Collection;
import java.util.Set;
import javax.swing.Icon;
import jet.runtime.typeinfo.JetValueParameter;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinSyntheticClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@KotlinSyntheticClass(abiVersion=23, kind=KotlinSyntheticClass.Kind.PACKAGE_PART)
public final class ConfigurationStorePackage$StoreAwareProjectManager$8e22e7e9 {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final ReloadComponentStoreStatus reloadStore(@JetValueParameter(name="changedStorages") @NotNull Set<? extends StateStorage> changedStorages, @JetValueParameter(name="store") @NotNull ComponentStoreImpl store, @JetValueParameter(name="isApp") boolean isApp) {
        ReloadComponentStoreStatus reloadComponentStoreStatus;
        Collection<String> notReloadableComponents;
        Intrinsics.checkParameterIsNotNull(changedStorages, (String)"changedStorages");
        Intrinsics.checkParameterIsNotNull((Object)store, (String)"store");
        boolean willBeReloaded = false;
        try {
            notReloadableComponents = store.reload(changedStorages);
        }
        catch (Throwable e) {
            ConfigurationStorePackage$ComponentStoreImpl$a3cfa0d6.LOG.warn(e);
            Messages.showWarningDialog((String)ProjectBundle.message((String)"project.reload.failed", (Object[])new Object[]{e.getMessage()}), (String)ProjectBundle.message((String)"project.reload.failed.title", (Object[])new Object[0]));
            ReloadComponentStoreStatus reloadComponentStoreStatus2 = ReloadComponentStoreStatus.ERROR;
            if (!willBeReloaded) {
                for (StateStorage stateStorage : changedStorages) {
                    if (!(stateStorage instanceof StateStorageBase)) continue;
                    ((StateStorageBase)stateStorage).enableSaving();
                }
            }
            return reloadComponentStoreStatus2;
        }
        if (notReloadableComponents == null || notReloadableComponents.isEmpty()) {
            reloadComponentStoreStatus = ReloadComponentStoreStatus.SUCCESS;
            return reloadComponentStoreStatus;
        }
        willBeReloaded = ConfigurationStorePackage$StoreAwareProjectManager$8e22e7e9.askToRestart(store, notReloadableComponents, changedStorages, isApp);
        reloadComponentStoreStatus = willBeReloaded ? ReloadComponentStoreStatus.RESTART_AGREED : ReloadComponentStoreStatus.RESTART_CANCELLED;
        try {
            return reloadComponentStoreStatus;
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        finally {
            if (!willBeReloaded) {
                for (StateStorage stateStorage : changedStorages) {
                    if (!(stateStorage instanceof StateStorageBase)) continue;
                    ((StateStorageBase)stateStorage).enableSaving();
                }
            }
        }
    }

    public static final boolean askToRestart(@JetValueParameter(name="store") @NotNull IComponentStore store, @JetValueParameter(name="notReloadableComponents") @NotNull Collection<? extends String> notReloadableComponents, @JetValueParameter(name="changedStorages", type="?") @Nullable Set<? extends StateStorage> changedStorages, @JetValueParameter(name="isApp") boolean isApp) {
        Intrinsics.checkParameterIsNotNull((Object)store, (String)"store");
        Intrinsics.checkParameterIsNotNull(notReloadableComponents, (String)"notReloadableComponents");
        StringBuilder message = new StringBuilder();
        String storeName = store instanceof IProjectStore ? "Project" : "Application";
        message.append(storeName).append(' ');
        message.append("components were changed externally and cannot be reloaded:\n\n");
        int count = 0;
        for (String string : notReloadableComponents) {
            if (count == 10) {
                message.append('\n').append("and ").append(notReloadableComponents.size() - count).append(" more").append('\n');
                continue;
            }
            message.append(string).append('\n');
            ++count;
        }
        message.append("\nWould you like to ");
        if (isApp) {
            message.append(ApplicationManager.getApplication().isRestartCapable() ? "restart" : "shutdown").append(' ');
            message.append(ApplicationNamesInfo.getInstance().getProductName()).append('?');
        } else {
            message.append("reload project?");
        }
        if (Messages.showYesNoDialog((String)message.toString(), (String)(storeName + " Files Changed"), (Icon)Messages.getQuestionIcon()) == 0) {
            if (changedStorages != null) {
                for (StateStorage stateStorage : changedStorages) {
                    if (!(stateStorage instanceof StateStorageBase)) continue;
                    ((StateStorageBase)stateStorage).disableSaving();
                }
            }
            return true;
        }
        return false;
    }
}

