/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.impl;

import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.impl.DebuggerContextListener;
import com.intellij.debugger.impl.DebuggerSession;
import com.intellij.util.EventDispatcher;
import java.util.EventListener;

public abstract class DebuggerStateManager {
    private final EventDispatcher<DebuggerContextListener> myEventDispatcher = EventDispatcher.create(DebuggerContextListener.class);

    public abstract DebuggerContextImpl getContext();

    public abstract void setState(DebuggerContextImpl var1, DebuggerSession.State var2, DebuggerSession.Event var3, String var4);

    public void addListener(DebuggerContextListener listener) {
        this.myEventDispatcher.addListener((EventListener)listener);
    }

    public void removeListener(DebuggerContextListener listener) {
        this.myEventDispatcher.removeListener((EventListener)listener);
    }

    protected void fireStateChanged(DebuggerContextImpl newContext, DebuggerSession.Event event) {
        ((DebuggerContextListener)this.myEventDispatcher.getMulticaster()).changeEvent(newContext, event);
    }
}

