/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.impl;

import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.DebuggerInvocationUtil;
import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.engine.DebuggerUtils;
import com.intellij.debugger.engine.SuspendManager;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.engine.evaluation.TextWithImports;
import com.intellij.debugger.engine.evaluation.TextWithImportsImpl;
import com.intellij.debugger.engine.events.DebuggerCommandImpl;
import com.intellij.debugger.engine.jdi.StackFrameProxy;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.impl.DebuggerSession;
import com.intellij.debugger.jdi.DecompiledLocalVariable;
import com.intellij.debugger.jdi.InstructionParser;
import com.intellij.debugger.jdi.LocalVariableProxyImpl;
import com.intellij.debugger.jdi.LocalVariablesUtil;
import com.intellij.debugger.jdi.StackFrameProxyImpl;
import com.intellij.debugger.jdi.ThreadReferenceProxyImpl;
import com.intellij.debugger.settings.ViewsGeneralSettings;
import com.intellij.debugger.ui.impl.VariablesPanel;
import com.intellij.debugger.ui.impl.watch.ArgumentValueDescriptorImpl;
import com.intellij.debugger.ui.impl.watch.DebuggerTree;
import com.intellij.debugger.ui.impl.watch.DebuggerTreeNodeImpl;
import com.intellij.debugger.ui.impl.watch.LocalVariableDescriptorImpl;
import com.intellij.debugger.ui.impl.watch.MessageDescriptor;
import com.intellij.debugger.ui.impl.watch.NodeDescriptorImpl;
import com.intellij.debugger.ui.impl.watch.NodeManagerImpl;
import com.intellij.debugger.ui.impl.watch.StackFrameDescriptorImpl;
import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.PsiArrayAccessExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.text.CharArrayUtil;
import com.intellij.util.ui.tree.TreeModelAdapter;
import com.intellij.xdebugger.XDebuggerBundle;
import com.intellij.xdebugger.frame.XStackFrame;
import com.intellij.xdebugger.settings.XDebuggerSettingsManager;
import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import com.sun.jdi.ObjectCollectedException;
import com.sun.jdi.Value;
import gnu.trove.TIntObjectHashMap;
import gnu.trove.TObjectProcedure;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FrameVariablesTree
extends DebuggerTree {
    private static final Logger LOG = Logger.getInstance(FrameVariablesTree.class);
    private boolean myAnyNewLocals;
    private boolean myAutoWatchMode;
    private final VariablesPanel myVariablesPanel;

    public FrameVariablesTree(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/debugger/ui/impl/FrameVariablesTree", "<init>"));
        }
        this(project, null);
    }

    public FrameVariablesTree(@NotNull Project project, @Nullable VariablesPanel variablesPanel) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/debugger/ui/impl/FrameVariablesTree", "<init>"));
        }
        super(project);
        this.myAutoWatchMode = false;
        this.getEmptyText().setText(XDebuggerBundle.message((String)"debugger.variables.not.available", (Object[])new Object[0]));
        this.myVariablesPanel = variablesPanel;
    }

    public boolean isAutoWatchMode() {
        return this.myAutoWatchMode;
    }

    public void setAutoVariablesMode(boolean autoWatchMode) {
        boolean valueChanged = this.myAutoWatchMode != autoWatchMode;
        this.myAutoWatchMode = autoWatchMode;
        if (valueChanged) {
            this.rebuild(this.getDebuggerContext());
        }
    }

    @Override
    protected void build(DebuggerContextImpl context) {
        this.myAnyNewLocals = false;
        this.buildWhenPaused(context, new RefreshFrameTreeCommand(context));
    }

    @Override
    public void restoreNodeState(DebuggerTreeNodeImpl node) {
        if (this.myAnyNewLocals) {
            NodeDescriptorImpl descriptor = node.getDescriptor();
            boolean isLocalVar = descriptor instanceof LocalVariableDescriptorImpl;
            descriptor.myIsSelected &= isLocalVar;
            boolean bl = descriptor.myIsVisible = isLocalVar && descriptor.myIsSelected;
            if (!descriptor.myIsVisible) {
                descriptor.putUserData(VISIBLE_RECT, null);
            }
        }
        super.restoreNodeState(node);
        if (this.myAnyNewLocals && node.getDescriptor().myIsExpanded) {
            DebuggerTreeNodeImpl root = (DebuggerTreeNodeImpl)this.getMutableModel().getRoot();
            this.scrollToVisible(root);
        }
    }

    @Override
    protected DebuggerCommandImpl getBuildNodeCommand(@NotNull DebuggerTreeNodeImpl node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/debugger/ui/impl/FrameVariablesTree", "getBuildNodeCommand"));
        }
        if (node.getDescriptor() instanceof StackFrameDescriptorImpl) {
            return new BuildFrameTreeVariablesCommand(node);
        }
        return super.getBuildNodeCommand(node);
    }

    public static List<DecompiledLocalVariable> collectVariablesFromBytecode(StackFrameProxy frame, int argumentCount) throws EvaluateException {
        if (!frame.getVirtualMachine().canGetBytecodes()) {
            return Collections.emptyList();
        }
        try {
            Location location = frame.location();
            LOG.assertTrue(location != null);
            Method method = location.method();
            Location methodLocation = method.location();
            if (methodLocation == null || methodLocation.codeIndex() < 0L) {
                return Collections.emptyList();
            }
            byte[] bytecodes = method.bytecodes();
            if (bytecodes != null && bytecodes.length > 0) {
                final int firstLocalVariableSlot = ArgumentValueDescriptorImpl.getFirstLocalsSlot(method);
                final TIntObjectHashMap usedVars = new TIntObjectHashMap();
                new InstructionParser(bytecodes, location.codeIndex()){

                    @Override
                    protected void localVariableInstructionFound(int opcode, int slot, String typeSignature) {
                        DecompiledLocalVariable variable;
                        if (!(slot < firstLocalVariableSlot || (variable = (DecompiledLocalVariable)usedVars.get(slot)) != null && typeSignature.equals(variable.getSignature()))) {
                            variable = new DecompiledLocalVariable(slot, "slot_" + slot, typeSignature);
                            usedVars.put(slot, (Object)variable);
                        }
                    }
                }.parse();
                if (usedVars.isEmpty()) {
                    return Collections.emptyList();
                }
                final ArrayList<DecompiledLocalVariable> vars = new ArrayList<DecompiledLocalVariable>(usedVars.size());
                usedVars.forEachValue((TObjectProcedure)new TObjectProcedure<DecompiledLocalVariable>(){

                    public boolean execute(DecompiledLocalVariable var) {
                        vars.add(var);
                        return true;
                    }
                });
                Collections.sort(vars, DecompiledLocalVariable.COMPARATOR);
                return vars;
            }
        }
        catch (UnsupportedOperationException location) {
        }
        catch (Exception e) {
            LOG.info((Throwable)e);
        }
        return Collections.emptyList();
    }

    public static Map<String, LocalVariableProxyImpl> getVisibleVariables(StackFrameProxyImpl frame) throws EvaluateException {
        HashMap<String, LocalVariableProxyImpl> vars = new HashMap<String, LocalVariableProxyImpl>();
        for (LocalVariableProxyImpl localVariableProxy : frame.visibleVariables()) {
            vars.put(localVariableProxy.name(), localVariableProxy);
        }
        return vars;
    }

    private static boolean shouldSkipLine(PsiFile file, Document doc, int line) {
        int start = doc.getLineStartOffset(line);
        int end = doc.getLineEndOffset(line);
        int _start = CharArrayUtil.shiftForward((CharSequence)doc.getCharsSequence(), (int)start, (String)" \n\t");
        if (_start >= end) {
            return true;
        }
        TextRange alreadyChecked = null;
        for (PsiElement elem = file.findElementAt(_start); !(elem == null || elem.getTextOffset() > end || alreadyChecked != null && alreadyChecked.contains(elem.getTextRange())); elem = elem.getNextSibling()) {
            PsiElement _elem = elem;
            while (_elem.getTextOffset() >= _start) {
                PsiElement resolved;
                alreadyChecked = _elem.getTextRange();
                if (_elem instanceof PsiDeclarationStatement) {
                    PsiElement[] declared;
                    for (PsiElement declaredElement : declared = ((PsiDeclarationStatement)_elem).getDeclaredElements()) {
                        if (!(declaredElement instanceof PsiVariable)) continue;
                        return false;
                    }
                }
                if (_elem instanceof PsiJavaCodeReferenceElement && (resolved = ((PsiJavaCodeReferenceElement)_elem).resolve()) instanceof PsiVariable) {
                    return false;
                }
                _elem = _elem.getParent();
            }
        }
        return true;
    }

    public static Pair<Set<String>, Set<TextWithImports>> findReferencedVars(Set<String> visibleVars, SourcePosition position, EvaluationContextImpl evalContext) {
        int offset;
        PsiElement element;
        int endLine;
        Document doc;
        int line = position.getLine();
        if (line < 0) {
            return Pair.create(Collections.emptySet(), Collections.emptySet());
        }
        PsiFile positionFile = position.getFile();
        if (!positionFile.getLanguage().isKindOf((Language)JavaLanguage.INSTANCE)) {
            return Pair.create(visibleVars, Collections.emptySet());
        }
        VirtualFile vFile = positionFile.getVirtualFile();
        Document document = doc = vFile != null ? FileDocumentManager.getInstance().getDocument(vFile) : null;
        if (doc == null || doc.getLineCount() == 0 || line > doc.getLineCount() - 1) {
            return Pair.create(Collections.emptySet(), Collections.emptySet());
        }
        TextRange limit = FrameVariablesTree.calculateLimitRange(positionFile, doc, line);
        int startLine = Math.max(limit.getStartOffset(), line - 1);
        for (startLine = Math.min(startLine, limit.getEndOffset()); startLine > limit.getStartOffset() && FrameVariablesTree.shouldSkipLine(positionFile, doc, startLine); --startLine) {
        }
        int startOffset = doc.getLineStartOffset(startLine);
        for (endLine = Math.min(line + 2, limit.getEndOffset()); endLine < limit.getEndOffset() && FrameVariablesTree.shouldSkipLine(positionFile, doc, endLine); ++endLine) {
        }
        int endOffset = doc.getLineEndOffset(endLine);
        TextRange lineRange = new TextRange(startOffset, endOffset);
        if (!lineRange.isEmpty() && (element = positionFile.findElementAt(offset = CharArrayUtil.shiftForward((CharSequence)doc.getCharsSequence(), (int)doc.getLineStartOffset(line), (String)" \t"))) != null) {
            PsiMethod method = (PsiMethod)PsiTreeUtil.getNonStrictParentOfType((PsiElement)element, (Class[])new Class[]{PsiMethod.class});
            if (method != null) {
                element = method;
            } else {
                PsiField field = (PsiField)PsiTreeUtil.getNonStrictParentOfType((PsiElement)element, (Class[])new Class[]{PsiField.class});
                if (field != null) {
                    element = field;
                } else {
                    PsiClassInitializer initializer = (PsiClassInitializer)PsiTreeUtil.getNonStrictParentOfType((PsiElement)element, (Class[])new Class[]{PsiClassInitializer.class});
                    if (initializer != null) {
                        element = initializer;
                    }
                }
            }
            if (element instanceof PsiCompiledElement) {
                return Pair.create(visibleVars, Collections.emptySet());
            }
            HashSet<String> vars = new HashSet<String>();
            HashSet<TextWithImports> expressions = new HashSet<TextWithImports>();
            VariablesCollector variablesCollector = new VariablesCollector(visibleVars, FrameVariablesTree.adjustRange(element, lineRange), expressions, vars, position, evalContext);
            element.accept((PsiElementVisitor)variablesCollector);
            return Pair.create(vars, expressions);
        }
        return Pair.create(Collections.emptySet(), Collections.emptySet());
    }

    private static TextRange calculateLimitRange(PsiFile file, Document doc, int line) {
        PsiMethod method;
        int offset = doc.getLineStartOffset(line);
        if (offset > 0 && (method = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)file.findElementAt(offset), PsiMethod.class, (boolean)false)) != null) {
            TextRange elemRange = method.getTextRange();
            return new TextRange(doc.getLineNumber(elemRange.getStartOffset()), doc.getLineNumber(elemRange.getEndOffset()));
        }
        return new TextRange(0, doc.getLineCount() - 1);
    }

    private static TextRange adjustRange(PsiElement element, final TextRange originalRange) {
        final Ref rangeRef = new Ref((Object)originalRange);
        element.accept((PsiElementVisitor)new JavaRecursiveElementVisitor(){

            public void visitExpressionStatement(PsiExpressionStatement statement) {
                TextRange stRange = statement.getTextRange();
                if (originalRange.intersects(stRange)) {
                    TextRange currentRange = (TextRange)rangeRef.get();
                    int start = Math.min(currentRange.getStartOffset(), stRange.getStartOffset());
                    int end = Math.max(currentRange.getEndOffset(), stRange.getEndOffset());
                    rangeRef.set((Object)new TextRange(start, end));
                }
            }
        });
        return (TextRange)rangeRef.get();
    }

    private static class VariablesCollector
    extends JavaRecursiveElementVisitor {
        private final Set<String> myVisibleLocals;
        private final TextRange myLineRange;
        private final Set<TextWithImports> myExpressions;
        private final Set<String> myVars;
        private final SourcePosition myPosition;
        private final EvaluationContextImpl myEvalContext;
        private final boolean myCollectExpressions;

        public VariablesCollector(Set<String> visibleLocals, TextRange lineRange, Set<TextWithImports> expressions, Set<String> vars, SourcePosition position, EvaluationContextImpl evalContext) {
            this.myVisibleLocals = visibleLocals;
            this.myLineRange = lineRange;
            this.myExpressions = expressions;
            this.myVars = vars;
            this.myPosition = position;
            this.myEvalContext = evalContext;
            this.myCollectExpressions = XDebuggerSettingsManager.getInstance().getDataViewSettings().isAutoExpressions();
        }

        public void visitElement(PsiElement element) {
            if (this.myLineRange.intersects(element.getTextRange())) {
                super.visitElement(element);
            }
        }

        public void visitMethodCallExpression(PsiMethodCallExpression expression) {
            PsiMethod psiMethod;
            if (this.myCollectExpressions && (psiMethod = expression.resolveMethod()) != null && !DebuggerUtils.hasSideEffectsOrReferencesMissingVars((PsiElement)expression, this.myVisibleLocals)) {
                this.myExpressions.add(new TextWithImportsImpl((PsiElement)expression));
            }
            super.visitMethodCallExpression(expression);
        }

        public void visitReferenceExpression(PsiReferenceExpression reference) {
            PsiElement psiElement;
            if (this.myLineRange.intersects(reference.getTextRange()) && (psiElement = reference.resolve()) instanceof PsiVariable) {
                PsiVariable var = (PsiVariable)psiElement;
                if (var instanceof PsiField) {
                    if (this.myCollectExpressions && !DebuggerUtils.hasSideEffectsOrReferencesMissingVars((PsiElement)reference, this.myVisibleLocals)) {
                        boolean isConstant;
                        PsiModifierList modifierList = var.getModifierList();
                        boolean bl = isConstant = var instanceof PsiEnumConstant || modifierList != null && modifierList.hasModifierProperty("static") && modifierList.hasModifierProperty("final");
                        if (!isConstant) {
                            this.myExpressions.add(new TextWithImportsImpl((PsiElement)reference));
                        }
                    }
                } else if (this.myVisibleLocals.contains(var.getName())) {
                    this.myVars.add(var.getName());
                } else if (!Comparing.equal((Object)PsiTreeUtil.getParentOfType((PsiElement)reference, PsiClass.class), (Object)PsiTreeUtil.getParentOfType((PsiElement)var, PsiClass.class))) {
                    this.myExpressions.add(new TextWithImportsImpl((PsiElement)reference));
                }
            }
            super.visitReferenceExpression(reference);
        }

        public void visitArrayAccessExpression(PsiArrayAccessExpression expression) {
            if (this.myCollectExpressions && !DebuggerUtils.hasSideEffectsOrReferencesMissingVars((PsiElement)expression, this.myVisibleLocals)) {
                this.myExpressions.add(new TextWithImportsImpl((PsiElement)expression));
            }
            super.visitArrayAccessExpression(expression);
        }

        public void visitParameter(PsiParameter parameter) {
            this.processVariable((PsiVariable)parameter);
            super.visitParameter(parameter);
        }

        public void visitLocalVariable(PsiLocalVariable variable) {
            this.processVariable((PsiVariable)variable);
            super.visitLocalVariable(variable);
        }

        private void processVariable(PsiVariable variable) {
            if (this.myLineRange.intersects(variable.getTextRange()) && this.myVisibleLocals.contains(variable.getName())) {
                this.myVars.add(variable.getName());
            }
        }

        public void visitClass(PsiClass aClass) {
        }
    }

    private class RefreshFrameTreeCommand
    extends DebuggerTree.RefreshDebuggerTreeCommand {
        public RefreshFrameTreeCommand(DebuggerContextImpl context) {
            super(context);
        }

        @Override
        public void contextAction() throws Exception {
            DebuggerTreeNodeImpl rootNode;
            DebuggerContextImpl debuggerContext;
            block11: {
                debuggerContext = this.getDebuggerContext();
                ThreadReferenceProxyImpl currentThread = debuggerContext.getThreadProxy();
                if (currentThread == null) {
                    return;
                }
                try {
                    StackFrameProxyImpl frame = debuggerContext.getFrameProxy();
                    if (frame != null) {
                        NodeManagerImpl nodeManager = FrameVariablesTree.this.getNodeFactory();
                        rootNode = nodeManager.createNode(nodeManager.getStackFrameDescriptor(null, frame), debuggerContext.createEvaluationContext());
                        break block11;
                    }
                    rootNode = FrameVariablesTree.this.getNodeFactory().getDefaultNode();
                    SuspendManager suspendManager = this.getSuspendContext().getDebugProcess().getSuspendManager();
                    try {
                        if (suspendManager.isSuspended(currentThread)) {
                            try {
                                if (currentThread.frameCount() == 0) {
                                    rootNode.add(MessageDescriptor.THREAD_IS_EMPTY);
                                    break block11;
                                }
                                rootNode.add(MessageDescriptor.DEBUG_INFO_UNAVAILABLE);
                            }
                            catch (EvaluateException e) {
                                rootNode.add(new MessageDescriptor(e.getMessage()));
                            }
                            break block11;
                        }
                        rootNode.add(MessageDescriptor.THREAD_IS_RUNNING);
                    }
                    catch (ObjectCollectedException ignored) {
                        rootNode.add(new MessageDescriptor(DebuggerBundle.message((String)"label.thread.node.thread.collected", (Object[])new Object[]{currentThread.name()})));
                    }
                }
                catch (Exception ex) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Throwable)ex);
                    }
                    rootNode = FrameVariablesTree.this.getNodeFactory().getDefaultNode();
                    rootNode.add(MessageDescriptor.DEBUG_INFO_UNAVAILABLE);
                }
            }
            final DebuggerTreeNodeImpl rootNode1 = rootNode;
            DebuggerInvocationUtil.swingInvokeLater(FrameVariablesTree.this.getProject(), new Runnable(){

                @Override
                public void run() {
                    FrameVariablesTree.this.getMutableModel().setRoot(rootNode1);
                    FrameVariablesTree.this.treeChanged();
                    final TreeModel model = FrameVariablesTree.this.getModel();
                    model.addTreeModelListener((TreeModelListener)new TreeModelAdapter(){

                        public void treeStructureChanged(TreeModelEvent e) {
                            Object[] path = e.getPath();
                            if (path.length > 0 && path[path.length - 1] == rootNode1) {
                                model.removeTreeModelListener((TreeModelListener)((Object)this));
                                if (ViewsGeneralSettings.getInstance().AUTOSCROLL_TO_NEW_LOCALS) {
                                    this.autoscrollToNewLocals(rootNode1);
                                } else {
                                    Enumeration children = rootNode1.rawChildren();
                                    while (children.hasMoreElements()) {
                                        DebuggerTreeNodeImpl child = (DebuggerTreeNodeImpl)children.nextElement();
                                        NodeDescriptorImpl descriptor = child.getDescriptor();
                                        if (!(descriptor instanceof LocalVariableDescriptorImpl)) continue;
                                        ((LocalVariableDescriptorImpl)descriptor).setNewLocal(false);
                                    }
                                }
                            }
                        }
                    });
                }

                private void autoscrollToNewLocals(DebuggerTreeNodeImpl frameNode) {
                    DebuggerSession debuggerSession = debuggerContext.getDebuggerSession();
                    boolean isSteppingThrough = debuggerSession != null && debuggerSession.isSteppingThrough(debuggerContext.getThreadProxy());
                    ArrayList<DebuggerTreeNodeImpl> toClear = new ArrayList<DebuggerTreeNodeImpl>();
                    ArrayList<DebuggerTreeNodeImpl> newLocalsToSelect = new ArrayList<DebuggerTreeNodeImpl>();
                    Enumeration e = frameNode.rawChildren();
                    while (e.hasMoreElements()) {
                        DebuggerTreeNodeImpl child = (DebuggerTreeNodeImpl)e.nextElement();
                        NodeDescriptorImpl descriptor = child.getDescriptor();
                        if (!(descriptor instanceof LocalVariableDescriptorImpl)) continue;
                        LocalVariableDescriptorImpl localVariableDescriptor = (LocalVariableDescriptorImpl)descriptor;
                        if (isSteppingThrough && localVariableDescriptor.isNewLocal()) {
                            FrameVariablesTree.this.myAnyNewLocals = true;
                            newLocalsToSelect.add(child);
                        } else {
                            toClear.add(child);
                        }
                        localVariableDescriptor.setNewLocal(false);
                    }
                    if (!newLocalsToSelect.isEmpty()) {
                        for (DebuggerTreeNodeImpl child : toClear) {
                            FrameVariablesTree.this.removeSelectionPath(new TreePath(child.getPath()));
                            child.getDescriptor().myIsSelected = false;
                        }
                        for (DebuggerTreeNodeImpl child : newLocalsToSelect) {
                            FrameVariablesTree.this.addSelectionPath(new TreePath(child.getPath()));
                            child.getDescriptor().myIsSelected = true;
                        }
                    }
                }
            });
        }
    }

    private class BuildFrameTreeVariablesCommand
    extends DebuggerTree.BuildStackFrameCommand {
        public BuildFrameTreeVariablesCommand(DebuggerTreeNodeImpl stackNode) {
            super(FrameVariablesTree.this, stackNode);
        }

        @Override
        public void threadAction() {
            if (FrameVariablesTree.this.myVariablesPanel != null) {
                StackFrameDescriptorImpl stackDescriptor = (StackFrameDescriptorImpl)this.getNode().getDescriptor();
                XStackFrame xStackFrame = stackDescriptor.getXStackFrame();
                FrameVariablesTree.this.myVariablesPanel.stackChanged(xStackFrame);
                if (xStackFrame != null) {
                    return;
                }
            }
            super.threadAction();
        }

        @Override
        protected void buildVariables(StackFrameDescriptorImpl stackDescriptor, EvaluationContextImpl evaluationContext) throws EvaluateException {
            block14: {
                DebuggerContextImpl debuggerContext = this.getDebuggerContext();
                final SourcePosition sourcePosition = debuggerContext.getSourcePosition();
                if (sourcePosition == null) {
                    return;
                }
                try {
                    if (!XDebuggerSettingsManager.getInstance().getDataViewSettings().isAutoExpressions() && !FrameVariablesTree.this.myAutoWatchMode) {
                        super.buildVariables(stackDescriptor, evaluationContext);
                    } else {
                        final Map<String, LocalVariableProxyImpl> visibleVariables = FrameVariablesTree.getVisibleVariables(stackDescriptor.getFrameProxy());
                        final EvaluationContextImpl evalContext = debuggerContext.createEvaluationContext();
                        Pair usedVars = (Pair)ApplicationManager.getApplication().runReadAction((Computable)new Computable<Pair<Set<String>, Set<TextWithImports>>>(){

                            public Pair<Set<String>, Set<TextWithImports>> compute() {
                                return FrameVariablesTree.findReferencedVars(visibleVariables.keySet(), sourcePosition, evalContext);
                            }
                        });
                        if (FrameVariablesTree.this.myAutoWatchMode) {
                            for (Object var : (Set)usedVars.first) {
                                LocalVariableDescriptorImpl descriptor = FrameVariablesTree.this.myNodeManager.getLocalVariableDescriptor(stackDescriptor, visibleVariables.get(var));
                                this.myChildren.add(FrameVariablesTree.this.myNodeManager.createNode(descriptor, evaluationContext));
                            }
                        } else {
                            super.buildVariables(stackDescriptor, evaluationContext);
                        }
                        EvaluationContextImpl evalContextCopy = evaluationContext.createEvaluationContext(evaluationContext.getThisObject());
                        evalContextCopy.setAutoLoadClasses(false);
                        for (TextWithImports text : (Set)usedVars.second) {
                            this.myChildren.add(FrameVariablesTree.this.myNodeManager.createNode(FrameVariablesTree.this.myNodeManager.getWatchItemDescriptor(stackDescriptor, text, null), evalContextCopy));
                        }
                    }
                }
                catch (EvaluateException e) {
                    if (e.getCause() instanceof AbsentInformationException) {
                        StackFrameProxyImpl frame = stackDescriptor.getFrameProxy();
                        List<Value> argValues = frame.getArgumentValues();
                        int index = 0;
                        for (Value argValue : argValues) {
                            ArgumentValueDescriptorImpl descriptor = FrameVariablesTree.this.myNodeManager.getArgumentValueDescriptor(stackDescriptor, index++, argValue, null);
                            DebuggerTreeNodeImpl variableNode = FrameVariablesTree.this.myNodeManager.createNode(descriptor, evaluationContext);
                            this.myChildren.add(variableNode);
                        }
                        this.myChildren.add(FrameVariablesTree.this.myNodeManager.createMessageNode(MessageDescriptor.LOCAL_VARIABLES_INFO_UNAVAILABLE));
                        List<DecompiledLocalVariable> decompiled = FrameVariablesTree.collectVariablesFromBytecode(frame, argValues.size());
                        if (decompiled.isEmpty()) break block14;
                        try {
                            Map<DecompiledLocalVariable, Value> values = LocalVariablesUtil.fetchValues(frame.getStackFrame(), decompiled);
                            for (DecompiledLocalVariable var : decompiled) {
                                Value value = values.get(var);
                                ArgumentValueDescriptorImpl descriptor = FrameVariablesTree.this.myNodeManager.getArgumentValueDescriptor(stackDescriptor, var.getSlot(), value, var.getName());
                                DebuggerTreeNodeImpl variableNode = FrameVariablesTree.this.myNodeManager.createNode(descriptor, evaluationContext);
                                this.myChildren.add(variableNode);
                            }
                        }
                        catch (Exception ex) {
                            LOG.info((Throwable)ex);
                            break block14;
                        }
                    }
                    throw e;
                }
            }
        }
    }
}

