/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff;

import com.intellij.diff.DiffContentFactory;
import com.intellij.diff.contents.DiffContent;
import com.intellij.diff.contents.DirectoryContentImpl;
import com.intellij.diff.contents.DocumentContent;
import com.intellij.diff.contents.DocumentContentImpl;
import com.intellij.diff.contents.EmptyContent;
import com.intellij.diff.contents.FileAwareDocumentContent;
import com.intellij.diff.contents.FileContent;
import com.intellij.diff.contents.FileContentImpl;
import com.intellij.diff.contents.FileDocumentContentImpl;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.testFramework.BinaryLightVirtualFile;
import com.intellij.util.LineSeparator;
import com.intellij.util.PathUtil;
import java.awt.datatransfer.DataFlavor;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DiffContentFactoryImpl
extends DiffContentFactory {
    public final Logger LOG = Logger.getInstance(DiffContentFactoryImpl.class);

    @NotNull
    public static DiffContentFactoryImpl getInstanceImpl() {
        DiffContentFactoryImpl diffContentFactoryImpl = (DiffContentFactoryImpl)DiffContentFactory.getInstance();
        if (diffContentFactoryImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/DiffContentFactoryImpl", "getInstanceImpl"));
        }
        return diffContentFactoryImpl;
    }

    @NotNull
    public EmptyContent createEmpty() {
        EmptyContent emptyContent = new EmptyContent();
        if (emptyContent == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/DiffContentFactoryImpl", "createEmpty"));
        }
        return emptyContent;
    }

    @NotNull
    public DocumentContent create(@NotNull String text) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/diff/DiffContentFactoryImpl", "create"));
        }
        DocumentContent documentContent = this.create(text, (FileType)null);
        if (documentContent == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/DiffContentFactoryImpl", "create"));
        }
        return documentContent;
    }

    @NotNull
    public DocumentContent create(@NotNull String text, @Nullable FileType type) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/diff/DiffContentFactoryImpl", "create"));
        }
        DocumentContent documentContent = this.create(text, type, true);
        if (documentContent == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/DiffContentFactoryImpl", "create"));
        }
        return documentContent;
    }

    @NotNull
    public DocumentContent create(@NotNull String text, @Nullable FileType type, boolean respectLineSeparators) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/diff/DiffContentFactoryImpl", "create"));
        }
        DocumentContent documentContent = DiffContentFactoryImpl.createImpl(text, type, null, null, respectLineSeparators, true);
        if (documentContent == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/DiffContentFactoryImpl", "create"));
        }
        return documentContent;
    }

    @NotNull
    public DocumentContent create(@NotNull String text, @Nullable VirtualFile highlightFile) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/diff/DiffContentFactoryImpl", "create"));
        }
        DocumentContent documentContent = DiffContentFactoryImpl.createImpl(text, highlightFile != null ? highlightFile.getFileType() : null, highlightFile, null, true, true);
        if (documentContent == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/DiffContentFactoryImpl", "create"));
        }
        return documentContent;
    }

    @NotNull
    public DocumentContent create(@Nullable Project project, @NotNull Document document) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/diff/DiffContentFactoryImpl", "create"));
        }
        DocumentContent documentContent = this.create(project, document, (FileType)null);
        if (documentContent == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/DiffContentFactoryImpl", "create"));
        }
        return documentContent;
    }

    @NotNull
    public DocumentContent create(@Nullable Project project, @NotNull Document document, @Nullable FileType fileType) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/diff/DiffContentFactoryImpl", "create"));
        }
        VirtualFile file = FileDocumentManager.getInstance().getFile(document);
        if (file == null) {
            DocumentContentImpl documentContentImpl = new DocumentContentImpl(document, fileType, null, null, null);
            if (documentContentImpl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/DiffContentFactoryImpl", "create"));
            }
            return documentContentImpl;
        }
        DocumentContent documentContent = this.create(project, document, file);
        if (documentContent == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/DiffContentFactoryImpl", "create"));
        }
        return documentContent;
    }

    @NotNull
    public DocumentContent create(@Nullable Project project, @NotNull Document document, @Nullable VirtualFile file) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/diff/DiffContentFactoryImpl", "create"));
        }
        if (file != null) {
            FileDocumentContentImpl fileDocumentContentImpl = new FileDocumentContentImpl(project, document, file);
            if (fileDocumentContentImpl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/DiffContentFactoryImpl", "create"));
            }
            return fileDocumentContentImpl;
        }
        DocumentContentImpl documentContentImpl = new DocumentContentImpl(document);
        if (documentContentImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/DiffContentFactoryImpl", "create"));
        }
        return documentContentImpl;
    }

    @NotNull
    public DiffContent create(@Nullable Project project, @NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/diff/DiffContentFactoryImpl", "create"));
        }
        if (file.isDirectory()) {
            DirectoryContentImpl directoryContentImpl = new DirectoryContentImpl(project, file);
            if (directoryContentImpl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/DiffContentFactoryImpl", "create"));
            }
            return directoryContentImpl;
        }
        DocumentContent content = this.createDocument(project, file);
        if (content != null) {
            DocumentContent documentContent = content;
            if (documentContent == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/DiffContentFactoryImpl", "create"));
            }
            return documentContent;
        }
        FileContentImpl fileContentImpl = new FileContentImpl(project, file);
        if (fileContentImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/DiffContentFactoryImpl", "create"));
        }
        return fileContentImpl;
    }

    @Nullable
    public DocumentContent createDocument(@Nullable Project project, final @NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/diff/DiffContentFactoryImpl", "createDocument"));
        }
        if (file.isDirectory()) {
            return null;
        }
        Document document = (Document)ApplicationManager.getApplication().runReadAction((Computable)new Computable<Document>(){

            public Document compute() {
                return FileDocumentManager.getInstance().getDocument(file);
            }
        });
        if (document == null) {
            return null;
        }
        return new FileDocumentContentImpl(project, document, file);
    }

    @Nullable
    public FileContent createFile(@Nullable Project project, @NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/diff/DiffContentFactoryImpl", "createFile"));
        }
        if (file.isDirectory()) {
            return null;
        }
        return (FileContent)this.create(project, file);
    }

    @NotNull
    public DiffContent createClipboardContent() {
        DocumentContent documentContent = this.createClipboardContent(null);
        if (documentContent == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/DiffContentFactoryImpl", "createClipboardContent"));
        }
        return documentContent;
    }

    @NotNull
    public DocumentContent createClipboardContent(@Nullable DocumentContent mainContent) {
        String text = (String)CopyPasteManager.getInstance().getContents(DataFlavor.stringFlavor);
        FileType type = mainContent != null ? mainContent.getContentType() : null;
        VirtualFile highlightFile = mainContent != null ? mainContent.getHighlightFile() : null;
        DocumentContent documentContent = DiffContentFactoryImpl.createImpl(StringUtil.notNullize((String)text), type, highlightFile, null, true, false);
        if (documentContent == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/DiffContentFactoryImpl", "createClipboardContent"));
        }
        return documentContent;
    }

    @NotNull
    private static DocumentContent createImpl(@NotNull String text, @Nullable FileType type, @Nullable VirtualFile highlightFile, @Nullable Charset charset, boolean respectLineSeparators, boolean readOnly) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/diff/DiffContentFactoryImpl", "createImpl"));
        }
        LineSeparator separator = respectLineSeparators ? StringUtil.detectSeparators((CharSequence)text) : null;
        Document document = EditorFactory.getInstance().createDocument((CharSequence)StringUtil.convertLineSeparators((String)text));
        if (readOnly) {
            document.setReadOnly(true);
        }
        DocumentContentImpl documentContentImpl = new DocumentContentImpl(document, type, highlightFile, separator, charset);
        if (documentContentImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/DiffContentFactoryImpl", "createImpl"));
        }
        return documentContentImpl;
    }

    @NotNull
    public DiffContent createFromBytes(@Nullable Project project, @NotNull FilePath filePath, @NotNull byte[] content) throws IOException {
        if (filePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filePath", "com/intellij/diff/DiffContentFactoryImpl", "createFromBytes"));
        }
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/diff/DiffContentFactoryImpl", "createFromBytes"));
        }
        if (filePath.getFileType().isBinary()) {
            DiffContent diffContent = DiffContentFactory.getInstance().createBinary(project, filePath.getName(), filePath.getFileType(), content);
            if (diffContent == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/DiffContentFactoryImpl", "createFromBytes"));
            }
            return diffContent;
        }
        FileAwareDocumentContent fileAwareDocumentContent = FileAwareDocumentContent.create(project, content, filePath);
        if (fileAwareDocumentContent == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/DiffContentFactoryImpl", "createFromBytes"));
        }
        return fileAwareDocumentContent;
    }

    @NotNull
    public DiffContent createFromBytes(@Nullable Project project, @NotNull VirtualFile highlightFile, @NotNull byte[] content) throws IOException {
        if (highlightFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "highlightFile", "com/intellij/diff/DiffContentFactoryImpl", "createFromBytes"));
        }
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/diff/DiffContentFactoryImpl", "createFromBytes"));
        }
        if (highlightFile.getFileType().isBinary()) {
            DiffContent diffContent = DiffContentFactory.getInstance().createBinary(project, highlightFile.getName(), highlightFile.getFileType(), content);
            if (diffContent == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/DiffContentFactoryImpl", "createFromBytes"));
            }
            return diffContent;
        }
        FileAwareDocumentContent fileAwareDocumentContent = FileAwareDocumentContent.create(project, content, highlightFile);
        if (fileAwareDocumentContent == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/DiffContentFactoryImpl", "createFromBytes"));
        }
        return fileAwareDocumentContent;
    }

    @NotNull
    public DiffContent createBinary(@Nullable Project project, @NotNull String name, @NotNull FileType type, @NotNull byte[] content) throws IOException {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/diff/DiffContentFactoryImpl", "createBinary"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/diff/DiffContentFactoryImpl", "createBinary"));
        }
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/diff/DiffContentFactoryImpl", "createBinary"));
        }
        boolean useTemporalFile = true;
        Object file = useTemporalFile ? (type.getDefaultExtension().isEmpty() ? DiffContentFactoryImpl.createTemporalFile(project, "tmp_", "_" + name, content) : DiffContentFactoryImpl.createTemporalFile(project, name + "_", "." + type.getDefaultExtension(), content)) : new BinaryLightVirtualFile(name, type, content);
        DiffContent diffContent = this.create(project, (VirtualFile)file);
        if (diffContent == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/DiffContentFactoryImpl", "createBinary"));
        }
        return diffContent;
    }

    @NotNull
    public static VirtualFile createTemporalFile(@Nullable Project project, @NotNull String prefix, @NotNull String suffix, @NotNull byte[] content) throws IOException {
        VirtualFile file;
        if (prefix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "prefix", "com/intellij/diff/DiffContentFactoryImpl", "createTemporalFile"));
        }
        if (suffix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "suffix", "com/intellij/diff/DiffContentFactoryImpl", "createTemporalFile"));
        }
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/diff/DiffContentFactoryImpl", "createTemporalFile"));
        }
        File tempFile = FileUtil.createTempFile((String)PathUtil.suggestFileName((String)(prefix + "_"), (boolean)true, (boolean)false), (String)PathUtil.suggestFileName((String)("_" + suffix), (boolean)true, (boolean)false), (boolean)true);
        if (content.length != 0) {
            FileUtil.writeToFile((File)tempFile, (byte[])content);
        }
        if ((file = VfsUtil.findFileByIoFile((File)tempFile, (boolean)true)) == null) {
            throw new IOException("Can't create temp file for revision content");
        }
        VfsUtil.markDirtyAndRefresh((boolean)true, (boolean)true, (boolean)true, (VirtualFile[])new VirtualFile[]{file});
        VirtualFile virtualFile = file;
        if (virtualFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/DiffContentFactoryImpl", "createTemporalFile"));
        }
        return virtualFile;
    }
}

