/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution;

import com.intellij.execution.ExecutionManager;
import com.intellij.execution.Executor;
import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.execution.filters.Filter;
import com.intellij.execution.filters.TextConsoleBuilder;
import com.intellij.execution.filters.TextConsoleBuilderFactory;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.execution.ui.actions.CloseAction;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.wm.ToolWindowId;
import com.intellij.openapi.wm.ToolWindowManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RunContentExecutor
implements Disposable {
    private final Project myProject;
    private final ProcessHandler myProcess;
    private final List<Filter> myFilterList;
    private Runnable myRerunAction;
    private Runnable myStopAction;
    private Runnable myAfterCompletion;
    private Computable<Boolean> myStopEnabled;
    private String myTitle;
    private String myHelpId;
    private boolean myActivateToolWindow;
    private ConsoleView myUserProvidedConsole;

    public RunContentExecutor(@NotNull Project project, @NotNull ProcessHandler process) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/execution/RunContentExecutor", "<init>"));
        }
        if (process == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "process", "com/intellij/execution/RunContentExecutor", "<init>"));
        }
        this.myFilterList = new ArrayList<Filter>();
        this.myTitle = "Output";
        this.myHelpId = null;
        this.myActivateToolWindow = true;
        this.myProject = project;
        this.myProcess = process;
    }

    public RunContentExecutor withFilter(Filter filter) {
        this.myFilterList.add(filter);
        return this;
    }

    public RunContentExecutor withTitle(String title) {
        this.myTitle = title;
        return this;
    }

    public RunContentExecutor withRerun(Runnable rerun) {
        this.myRerunAction = rerun;
        return this;
    }

    public RunContentExecutor withStop(@NotNull Runnable stop2, @NotNull Computable<Boolean> stopEnabled) {
        if (stop2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stop", "com/intellij/execution/RunContentExecutor", "withStop"));
        }
        if (stopEnabled == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stopEnabled", "com/intellij/execution/RunContentExecutor", "withStop"));
        }
        this.myStopAction = stop2;
        this.myStopEnabled = stopEnabled;
        return this;
    }

    public RunContentExecutor withAfterCompletion(Runnable afterCompletion) {
        this.myAfterCompletion = afterCompletion;
        return this;
    }

    public RunContentExecutor withHelpId(String helpId) {
        this.myHelpId = helpId;
        return this;
    }

    public RunContentExecutor withActivateToolWindow(boolean activateToolWindow) {
        this.myActivateToolWindow = activateToolWindow;
        return this;
    }

    private ConsoleView createConsole(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/execution/RunContentExecutor", "createConsole"));
        }
        TextConsoleBuilder consoleBuilder = TextConsoleBuilderFactory.getInstance().createBuilder(project);
        consoleBuilder.filters(this.myFilterList);
        ConsoleView console = consoleBuilder.getConsole();
        if (this.myHelpId != null) {
            console.setHelpId(this.myHelpId);
        }
        Executor executor = DefaultRunExecutor.getRunExecutorInstance();
        DefaultActionGroup actions2 = new DefaultActionGroup();
        JComponent consolePanel = RunContentExecutor.createConsolePanel(console, (ActionGroup)actions2);
        RunContentDescriptor descriptor = new RunContentDescriptor((ExecutionConsole)console, this.myProcess, consolePanel, this.myTitle);
        Disposer.register((Disposable)console, (Disposable)descriptor);
        actions2.add((AnAction)new RerunAction(consolePanel));
        actions2.add((AnAction)new StopAction());
        actions2.add((AnAction)new CloseAction(executor, descriptor, this.myProject));
        ExecutionManager.getInstance((Project)this.myProject).getContentManager().showRunContent(executor, descriptor);
        if (this.myActivateToolWindow) {
            this.activateToolWindow();
        }
        Disposer.register((Disposable)this, (Disposable)console);
        return console;
    }

    public void run() {
        FileDocumentManager.getInstance().saveAllDocuments();
        ConsoleView view = this.myUserProvidedConsole != null ? this.myUserProvidedConsole : this.createConsole(this.myProject);
        view.attachToProcess(this.myProcess);
        if (this.myAfterCompletion != null) {
            this.myProcess.addProcessListener((ProcessListener)new ProcessAdapter(){

                public void processTerminated(ProcessEvent event) {
                    SwingUtilities.invokeLater(RunContentExecutor.this.myAfterCompletion);
                }
            });
        }
        this.myProcess.startNotify();
    }

    public void activateToolWindow() {
        ApplicationManager.getApplication().invokeLater(new Runnable(){

            @Override
            public void run() {
                ToolWindowManager.getInstance((Project)RunContentExecutor.this.myProject).getToolWindow(ToolWindowId.RUN).activate(null);
            }
        });
    }

    private static JComponent createConsolePanel(ConsoleView view, ActionGroup actions2) {
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        panel.add((Component)view.getComponent(), "Center");
        panel.add((Component)RunContentExecutor.createToolbar(actions2), "West");
        return panel;
    }

    private static JComponent createToolbar(ActionGroup actions2) {
        ActionToolbar actionToolbar = ActionManager.getInstance().createActionToolbar("unknown", actions2, false);
        return actionToolbar.getComponent();
    }

    public void dispose() {
        Disposer.dispose((Disposable)this);
    }

    @NotNull
    public RunContentExecutor withConsole(@Nullable ConsoleView console) {
        this.myUserProvidedConsole = console;
        RunContentExecutor runContentExecutor = this;
        if (runContentExecutor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/RunContentExecutor", "withConsole"));
        }
        return runContentExecutor;
    }

    private class StopAction
    extends AnAction
    implements DumbAware {
        public StopAction() {
            super("Stop", "Stop", AllIcons.Actions.Suspend);
        }

        public void actionPerformed(AnActionEvent e) {
            RunContentExecutor.this.myStopAction.run();
        }

        public void update(AnActionEvent e) {
            e.getPresentation().setVisible(RunContentExecutor.this.myStopAction != null);
            e.getPresentation().setEnabled(RunContentExecutor.this.myStopEnabled != null && (Boolean)RunContentExecutor.this.myStopEnabled.compute() != false);
        }
    }

    private class RerunAction
    extends AnAction
    implements DumbAware {
        public RerunAction(JComponent consolePanel) {
            super("Rerun", "Rerun", AllIcons.Actions.Restart);
            this.registerCustomShortcutSet(CommonShortcuts.getRerun(), consolePanel);
        }

        public void actionPerformed(AnActionEvent e) {
            RunContentExecutor.this.myRerunAction.run();
        }

        public void update(AnActionEvent e) {
            e.getPresentation().setVisible(RunContentExecutor.this.myRerunAction != null);
            e.getPresentation().setEnabled(RunContentExecutor.this.myRerunAction != null);
        }
    }
}

